/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractPHPGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.AbstractMethodReturnTypeGoal;

public abstract class AbstractMethodReturnTypeEvaluator
extends AbstractPHPGoalEvaluator {
    public AbstractMethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    protected IMethod[] getMethods() {
        return this.getMethodsAndTypes().methods;
    }

    protected MethodsAndTypes getMethodsAndTypes() {
        AbstractMethodReturnTypeGoal typedGoal = (AbstractMethodReturnTypeGoal)this.goal;
        ISourceModule sourceModule = ((ISourceModuleContext)this.goal.getContext()).getSourceModule();
        IType[] types = typedGoal.getTypes();
        String methodName = typedGoal.getMethodName();
        IContext context = typedGoal.getContext();
        IModelAccessCache cache = null;
        if (context instanceof IModelCacheContext) {
            cache = ((IModelCacheContext)context).getCache();
        }
        LinkedList<IMethod> methods = new LinkedList<IMethod>();
        LinkedList<IType> methodTypes = new LinkedList<IType>();
        if (types == null) {
            try {
                methods.addAll(Arrays.asList(PHPModelUtils.getFunctions(methodName, sourceModule, 0, cache, null)));
                int i = 0;
                int size = methods.size();
                while (i < size) {
                    methodTypes.add(null);
                    ++i;
                }
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        } else {
            try {
                IType[] iTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    IMethod[] typeMethods = PHPModelUtils.getTypeMethod(type, methodName, true);
                    if (typeMethods.length == 0) {
                        ITypeHierarchy hierarchy = null;
                        if (cache != null) {
                            hierarchy = cache.getSuperTypeHierarchy(type, null);
                        }
                        typeMethods = PHPModelUtils.getSuperTypeHierarchyMethod(type, hierarchy, methodName, true, null);
                    }
                    if (typeMethods.length > 0) {
                        methods.add(typeMethods[0]);
                        methodTypes.add(type);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        MethodsAndTypes mat = new MethodsAndTypes();
        mat.methods = methods.toArray(new IMethod[methods.size()]);
        mat.types = methodTypes.toArray(new IType[methodTypes.size()]);
        return mat;
    }

    protected static class MethodsAndTypes {
        public IMethod[] methods;
        public IType[] types;

        protected MethodsAndTypes() {
        }
    }
}

