/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.index.IPHPDocAwareElement;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractMethodReturnTypeEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.AbstractMethodReturnTypeGoal;

public class PHPDocMethodReturnTypeEvaluator
extends AbstractMethodReturnTypeEvaluator {
    private static final String BRACKETS = "[]";
    private static final Pattern ARRAY_TYPE_PATTERN = Pattern.compile("array\\[.*\\]");
    private static final String SELF_RETURN_TYPE = "self";
    private static final Pattern MULTITYPE_PATTERN = Pattern.compile("^multitype:(.+)$", 2);
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocMethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    private void evaluateReturnType(List<String> returnTypeList, PHPDocBlock docBlock, IMethod method) {
        int n;
        int n2;
        IType[] iTypeArray;
        IType type;
        PHPDocTag[] tags = docBlock.getTags(6);
        PHPDocTag[] inherit = docBlock.getTags(35);
        if (inherit != null && inherit.length == 1 && (type = method.getDeclaringType()) != null) {
            try {
                IType[] superClasses;
                IContext context = this.goal.getContext();
                IModelAccessCache cache = null;
                if (context instanceof IModelCacheContext) {
                    cache = ((IModelCacheContext)context).getCache();
                }
                iTypeArray = superClasses = PHPModelUtils.getSuperClasses(type, cache == null ? null : cache.getSuperTypeHierarchy(type, null));
                n2 = superClasses.length;
                n = 0;
                while (n < n2) {
                    PHPDocBlock superDocBlock;
                    IType superClass = iTypeArray[n];
                    IMethod superClassMethod = superClass.getMethod(method.getElementName());
                    if (superClassMethod != null && (superDocBlock = PHPModelUtils.getDocBlock(superClassMethod)) != null) {
                        this.evaluateReturnType(returnTypeList, superDocBlock, superClassMethod);
                    }
                    ++n;
                }
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        }
        if (tags != null && tags.length > 0) {
            PHPDocTag[] pHPDocTagArray = tags;
            int n3 = tags.length;
            int n4 = 0;
            while (n4 < n3) {
                PHPDocTag phpDocTag = pHPDocTagArray[n4];
                if (phpDocTag.getReferences() != null && phpDocTag.getReferences().length > 0) {
                    iTypeArray = phpDocTag.getReferences();
                    n2 = iTypeArray.length;
                    n = 0;
                    while (n < n2) {
                        IType ref = iTypeArray[n];
                        String type2 = ref.getName();
                        if (type2 != null) {
                            returnTypeList.add(type2);
                        }
                        ++n;
                    }
                }
                ++n4;
            }
        }
    }

    public IGoal[] init() {
        IMethod[] iMethodArray = this.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)method);
            String[] typeNames = null;
            if (method instanceof IPHPDocAwareElement) {
                typeNames = ((IPHPDocAwareElement)method).getReturnTypes();
            } else {
                LinkedList<String> returnTypeList = new LinkedList<String>();
                PHPDocBlock docBlock = PHPModelUtils.getDocBlock(method);
                if (docBlock == null) {
                    return IGoal.NO_GOALS;
                }
                this.evaluateReturnType(returnTypeList, docBlock, method);
                typeNames = returnTypeList.toArray(new String[returnTypeList.size()]);
            }
            if (typeNames != null) {
                MultiTypeType evalMultiType = null;
                String[] stringArray = typeNames;
                int n3 = typeNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    int offset;
                    String typeName = stringArray[n4];
                    Matcher m = ARRAY_TYPE_PATTERN.matcher(typeName);
                    Matcher multi = MULTITYPE_PATTERN.matcher(typeName);
                    if (m.find()) {
                        offset = 0;
                        try {
                            offset = method.getSourceRange().getOffset();
                        }
                        catch (ModelException modelException) {}
                        this.evaluated.add((IEvaluatedType)this.getArrayType(m.group(), currentNamespace, offset));
                    } else if (typeName.endsWith(BRACKETS) && typeName.length() > 2) {
                        offset = 0;
                        try {
                            offset = method.getSourceRange().getOffset();
                        }
                        catch (ModelException modelException) {}
                        this.evaluated.add((IEvaluatedType)this.getArrayType(typeName.substring(0, typeName.length() - 2), currentNamespace, offset));
                    } else {
                        boolean isMulti = false;
                        if (multi.find()) {
                            if (evalMultiType == null) {
                                evalMultiType = new MultiTypeType();
                            }
                            isMulti = true;
                            typeName = multi.group(1);
                        }
                        AbstractMethodReturnTypeGoal goal = (AbstractMethodReturnTypeGoal)this.getGoal();
                        IType[] types = goal.getTypes();
                        if (typeName.equals(SELF_RETURN_TYPE) && types != null) {
                            IType[] iTypeArray = types;
                            int n5 = types.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IType t = iTypeArray[n6];
                                IEvaluatedType type = this.getEvaluatedType(PHPModelUtils.getFullName(t), null);
                                if (type != null) {
                                    if (isMulti) {
                                        evalMultiType.addType(type);
                                    } else {
                                        this.evaluated.add(type);
                                    }
                                }
                                ++n6;
                            }
                        } else {
                            IEvaluatedType type;
                            if (currentNamespace != null) {
                                String prefix;
                                String fullName;
                                Map<String, UsePart> result;
                                PHPDocBlock docBlock = PHPModelUtils.getDocBlock(method);
                                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)currentNamespace.getSourceModule());
                                if (typeName.indexOf(92) > 0) {
                                    String prefix2 = typeName.substring(0, typeName.indexOf(92));
                                    result = PHPModelUtils.getAliasToNSMap(prefix2, moduleDeclaration, docBlock.sourceStart(), currentNamespace, true);
                                    if (result.containsKey(prefix2) && (typeName = typeName.replace(prefix2, fullName = result.get(prefix2).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                                        typeName = String.valueOf('\\') + typeName;
                                    }
                                } else if (typeName.indexOf(92) < 0 && (result = PHPModelUtils.getAliasToNSMap(prefix = typeName, moduleDeclaration, docBlock.sourceStart(), currentNamespace, true)).containsKey(prefix) && (typeName = (fullName = result.get(prefix).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                                    typeName = String.valueOf('\\') + typeName;
                                }
                            }
                            if ((type = this.getEvaluatedType(typeName, currentNamespace)) != null) {
                                if (isMulti) {
                                    evalMultiType.addType(type);
                                } else {
                                    this.evaluated.add(type);
                                }
                            }
                        }
                    }
                    ++n4;
                }
                if (evalMultiType != null) {
                    this.evaluated.add((IEvaluatedType)evalMultiType);
                }
            }
            ++n2;
        }
        return IGoal.NO_GOALS;
    }

    private MultiTypeType getArrayType(String type, IType currentNamespace, int offset) {
        String[] typeNames;
        int beginIndex = type.indexOf("[") + 1;
        int endIndex = type.lastIndexOf("]");
        if (endIndex != -1) {
            type = type.substring(beginIndex, endIndex);
        }
        MultiTypeType arrayType = new MultiTypeType();
        Matcher m = ARRAY_TYPE_PATTERN.matcher(type);
        if (m.find()) {
            arrayType.addType((IEvaluatedType)this.getArrayType(m.group(), currentNamespace, offset));
            type = m.replaceAll("");
        } else if (type.endsWith(BRACKETS) && type.length() > 2) {
            arrayType.addType((IEvaluatedType)this.getArrayType(type.substring(0, type.length() - 2), currentNamespace, offset));
            type = type.replaceAll(BRACKETS, "");
        }
        String[] stringArray = typeNames = type.split(",");
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!"".equals(name)) {
                if (name.indexOf(92) > 0 && currentNamespace != null) {
                    String fullName;
                    ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)currentNamespace.getSourceModule());
                    String prefix = name.substring(0, name.indexOf(92));
                    Map<String, UsePart> result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, offset, currentNamespace, true);
                    if (result.containsKey(prefix) && (name = name.replace(prefix, fullName = result.get(prefix).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                        name = String.valueOf('\\') + name;
                    }
                }
                arrayType.addType(this.getEvaluatedType(name, currentNamespace));
            }
            ++n2;
        }
        return arrayType;
    }

    private IEvaluatedType getEvaluatedType(String typeName, IType currentNamespace) {
        Object type = PHPSimpleTypes.fromString(typeName);
        if (type == null) {
            if (typeName.indexOf(92) > 0 && currentNamespace != null) {
                typeName = String.valueOf('\\') + currentNamespace.getElementName() + '\\' + typeName;
            }
            if (typeName.indexOf(92) != -1 || currentNamespace == null) {
                type = new PHPClassType(typeName);
            } else if (currentNamespace != null) {
                type = new PHPClassType(currentNamespace.getElementName(), typeName);
            }
        }
        return type;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

