/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.filenetwork;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;

public class FileUtil {
    public static void copyDirectory(File source, File target) throws IOException {
        FileUtil.copyDirectory(source, target, Collections.<File>emptySet());
    }

    public static void copyDirectory(File source, File target, Set<File> excludes) throws IOException {
        File[] files;
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((files = source.listFiles()) == null) {
            throw new IllegalStateException("Source directory " + source + " doesn't exist");
        }
        int i = 0;
        while (i < files.length) {
            File sourceChild = files[i];
            String name = sourceChild.getName();
            if (!(name.equals("CVS") || name.equals(".svn") || excludes.contains(sourceChild))) {
                File targetChild = new File(target, name);
                if (sourceChild.isDirectory()) {
                    FileUtil.copyDirectory(sourceChild, targetChild, excludes);
                } else if (!".emptydir".equals(name)) {
                    FileUtil.copyFile(sourceChild, targetChild);
                }
            }
            ++i;
        }
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        byte[] buffer = new byte[12288];
        try {
            in = new FileInputStream(src);
            try {
                int read;
                out = new FileOutputStream(dest);
                while ((read = ((InputStream)in).read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, read);
                }
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }
}

