/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.selection;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.codeassist.CodeAssistPdttFile;
import org.eclipse.php.internal.core.PHPVersion;

public class SelectionEngineTests
extends AbstractPDTTTest {
    protected static final char SELECTION_CHAR = '|';
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static IProject project;
    protected static IFile testFile;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/selection/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/selection/php5", "/workspace/selection/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/selection/php5", "/workspace/selection/php53", "/workspace/selection/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/selection/php5", "/workspace/selection/php53", "/workspace/selection/php54", "/workspace/selection/php55"});
    }

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("AutoSelectionEngine");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
    }

    public static void tearDownSuite() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    public SelectionEngineTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Auto Selection Engine Tests");
        for (final PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = SelectionEngineTests.getPDTTFiles(testsDirectory);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    try {
                        final CodeAssistPdttFile pdttFile = new CodeAssistPdttFile(fileName);
                        phpVerSuite.addTest((Test)new SelectionEngineTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                            protected void setUp() throws Exception {
                                PHPCoreTests.setProjectPhpVersion(project, phpVersion);
                            }

                            protected void tearDown() throws Exception {
                                if (testFile != null) {
                                    testFile.delete(true, null);
                                    testFile = null;
                                }
                            }

                            protected void runTest() throws Throwable {
                                int n;
                                IModelElement[] elements = 1.getSelection(pdttFile.getFile());
                                CodeAssistPdttFile.ExpectedProposal[] expectedProposals = pdttFile.getExpectedProposals();
                                boolean proposalsEqual = true;
                                if (elements.length == expectedProposals.length) {
                                    CodeAssistPdttFile.ExpectedProposal[] expectedProposalArray = pdttFile.getExpectedProposals();
                                    n = expectedProposalArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        CodeAssistPdttFile.ExpectedProposal expectedProposal = expectedProposalArray[n2];
                                        boolean found = false;
                                        IModelElement[] iModelElementArray = elements;
                                        int n3 = elements.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            IModelElement modelElement = iModelElementArray[n4];
                                            if (modelElement.getElementType() == expectedProposal.type && modelElement.getElementName().equalsIgnoreCase(expectedProposal.name)) {
                                                found = true;
                                                break;
                                            }
                                            ++n4;
                                        }
                                        if (!found) {
                                            proposalsEqual = false;
                                            break;
                                        }
                                        ++n2;
                                    }
                                } else {
                                    proposalsEqual = false;
                                }
                                if (!proposalsEqual) {
                                    StringBuilder errorBuf = new StringBuilder();
                                    errorBuf.append("\nEXPECTED ELEMENTS LIST:\n-----------------------------\n");
                                    errorBuf.append(pdttFile.getExpected());
                                    errorBuf.append("\nACTUAL ELEMENTS LIST:\n-----------------------------\n");
                                    IModelElement[] iModelElementArray = elements;
                                    int n5 = elements.length;
                                    n = 0;
                                    while (n < n5) {
                                        IModelElement modelElement = iModelElementArray[n];
                                        switch (modelElement.getElementType()) {
                                            case 8: {
                                                errorBuf.append("field");
                                                break;
                                            }
                                            case 9: {
                                                errorBuf.append("method");
                                                break;
                                            }
                                            case 7: {
                                                errorBuf.append("type");
                                            }
                                        }
                                        errorBuf.append('(').append(modelElement.getElementName()).append(")\n");
                                        ++n;
                                    }
                                    1.fail((String)errorBuf.toString());
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                SelectionEngineTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                SelectionEngineTests.tearDownSuite();
            }
        };
        return setup;
    }

    protected static SourceRange createFile(String data) throws Exception {
        int left = data.indexOf(124);
        if (left == -1) {
            throw new IllegalArgumentException("Selection characters are not set");
        }
        int right = (data = String.valueOf(data.substring(0, left)) + data.substring(left + 1)).indexOf(124);
        if (right == -1) {
            throw new IllegalArgumentException("Selection is not closed");
        }
        data = String.valueOf(data.substring(0, right)) + data.substring(right + 1);
        testFile = project.getFile("test.php");
        testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
        return new SourceRange(left, right - left);
    }

    protected static ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)testFile);
    }

    protected static IModelElement[] getSelection(String data) throws Exception {
        SourceRange range = SelectionEngineTests.createFile(data);
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)testFile);
        IModelElement[] elements = sourceModule.codeSelect(range.getOffset(), range.getLength());
        return elements;
    }
}

