/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.text;

import junit.framework.TestCase;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;

public class PHPTextSequenceUtilitiesTests
extends TestCase {
    public void testEmptyArgumentList() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"()");
        PHPTextSequenceUtilitiesTests.assertEquals((int)0, (int)argNames.length);
    }

    public void testSingleArgument() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"('MyArg')");
        PHPTextSequenceUtilitiesTests.assertEquals((int)1, (int)argNames.length);
        PHPTextSequenceUtilitiesTests.assertEquals((String)"'MyArg'", (String)argNames[0]);
    }

    public void testSingleArgumentDoubleQuote() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"(\"MyArg\")");
        PHPTextSequenceUtilitiesTests.assertEquals((int)1, (int)argNames.length);
        PHPTextSequenceUtilitiesTests.assertEquals((String)"\"MyArg\"", (String)argNames[0]);
    }

    public void testSingleArgumentIgnore() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"($anyElement)");
        PHPTextSequenceUtilitiesTests.assertEquals((int)1, (int)argNames.length);
        PHPTextSequenceUtilitiesTests.assertNull((Object)argNames[0]);
    }

    public void testSingleArgumentIgnoreParenthesis() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"'MyArg'");
        PHPTextSequenceUtilitiesTests.assertEquals((int)1, (int)argNames.length);
        PHPTextSequenceUtilitiesTests.assertEquals((String)"'MyArg'", (String)argNames[0]);
    }

    public void testMultiArgumentIgnore() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"('MyString', $anyElement)");
        PHPTextSequenceUtilitiesTests.assertEquals((int)2, (int)argNames.length);
        PHPTextSequenceUtilitiesTests.assertEquals((String)"'MyString'", (String)argNames[0]);
        PHPTextSequenceUtilitiesTests.assertNull((Object)argNames[1]);
    }

    public void testMultiArgumentIgnore2() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"($anyElement, 'MyString')");
        PHPTextSequenceUtilitiesTests.assertEquals((int)2, (int)argNames.length);
        PHPTextSequenceUtilitiesTests.assertEquals((String)"'MyString'", (String)argNames[1]);
        PHPTextSequenceUtilitiesTests.assertNull((Object)argNames[0]);
    }

    public void testIgnoreInternalCall() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"(call('something'), 'MyString')");
        PHPTextSequenceUtilitiesTests.assertEquals((int)2, (int)argNames.length);
        PHPTextSequenceUtilitiesTests.assertEquals((String)"'MyString'", (String)argNames[1]);
        PHPTextSequenceUtilitiesTests.assertNull((Object)argNames[0]);
    }

    public void testNestedCall() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"(call('something', $this->callMe(\"Another\")), 'MyString')");
        PHPTextSequenceUtilitiesTests.assertEquals((int)2, (int)argNames.length);
        PHPTextSequenceUtilitiesTests.assertEquals((String)"'MyString'", (String)argNames[1]);
        PHPTextSequenceUtilitiesTests.assertNull((Object)argNames[0]);
    }
}

