/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.console.Messages;
import org.eclipse.php.internal.debug.ui.console.PHPConsoleSourceModuleLookup;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.IDE;

public class PHPFileLink
implements IHyperlink {
    protected String fileName;
    protected int lineNumber;

    public PHPFileLink(String fileName, int lineNumber) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public void linkActivated() {
        try {
            Object element = PHPFileLink.findSourceModule(this.fileName);
            if (element != null) {
                this.openElementInEditor(element);
                return;
            }
            if (org.eclipse.php.internal.ui.util.EditorUtility.openLocalFile((String)this.fileName, (int)this.lineNumber) != null) {
                return;
            }
        }
        catch (CoreException e) {
            PHPDebugUIPlugin.log(e);
        }
        MessageDialog.openInformation((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)Messages.PHPFileLink_0, (String)MessageFormat.format((String)Messages.PHPFileLink_1, (Object[])new Object[]{this.fileName}));
    }

    protected void openElementInEditor(Object element) throws CoreException {
        Assert.isNotNull((Object)element);
        IEditorInput input = null;
        input = element instanceof IModelElement ? org.eclipse.php.internal.ui.util.EditorUtility.getEditorInput((IModelElement)((IModelElement)element)) : EditorUtility.getEditorInput((Object)element);
        if (input == null) {
            return;
        }
        IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
        IWorkbenchPage page = PHPDebugUIPlugin.getActivePage();
        IEditorPart editor = page.openEditor(input, descriptor.getId());
        EditorUtility.revealInEditor((IEditorPart)editor, (int)(this.lineNumber - 1));
    }

    public static Object findSourceModule(String fileName) {
        IPath path = Path.fromOSString((String)fileName);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile f = root.getFileForLocation(path);
        if (f != null) {
            return f;
        }
        IDLTKLanguageToolkit toolkit = PHPLanguageToolkit.getDefault();
        PHPConsoleSourceModuleLookup lookup = new PHPConsoleSourceModuleLookup(toolkit);
        return lookup.findSourceModuleByLocalPath(path);
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }
}

