/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.pathmapper;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.ui.pathmapper.Messages;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PathMapperEntryDialog
extends TitleAreaDialog {
    private PathMapper.Mapping fEditData;
    private Text fRemotePathText;
    private Button fWorkspacePathBtn;
    private Button fExternalPathBtn;
    private Text fWorkspacePathText;
    private Text fExternalPathText;
    private Button fWorkspacePathBrowseBtn;
    private Button fExternalPathBrowseBtn;
    private Button ignoreMappingBtn;
    private Text ignorePathText;

    public PathMapperEntryDialog(Shell parent) {
        this(parent, null);
    }

    public PathMapperEntryDialog(Shell parent, PathMapper.Mapping editData) {
        super(parent);
        if (editData != null) {
            this.fEditData = editData.clone();
            this.setTitle(Messages.PathMapperEntryDialog_0);
        } else {
            this.setTitle(Messages.PathMapperEntryDialog_1);
        }
    }

    public PathMapper.Mapping getResult() {
        return this.fEditData;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout());
        mainComp.setLayoutData((Object)new GridData(1808));
        PixelConverter pixelConverter = new PixelConverter((Control)mainComp);
        Label label = new Label(mainComp, 0);
        label.setText(Messages.PathMapperEntryDialog_2);
        this.fRemotePathText = new Text(mainComp, 2048);
        this.fRemotePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathMapperEntryDialog.this.ignorePathText.setText(PathMapperEntryDialog.this.fRemotePathText.getText());
                PathMapperEntryDialog.this.validate();
            }
        });
        GridData layoutData = new GridData(768);
        this.fRemotePathText.setLayoutData((Object)layoutData);
        Composite typeSelectionGroup = new Composite(mainComp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        typeSelectionGroup.setLayout((Layout)layout);
        typeSelectionGroup.setLayoutData((Object)new GridData(1808));
        this.fWorkspacePathBtn = new Button(typeSelectionGroup, 16);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.fWorkspacePathBtn.setLayoutData((Object)layoutData);
        this.fWorkspacePathBtn.setText(Messages.PathMapperEntryDialog_3);
        this.fWorkspacePathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = PathMapperEntryDialog.this.fWorkspacePathBtn.getSelection();
                PathMapperEntryDialog.this.fWorkspacePathText.setEnabled(enabled);
                PathMapperEntryDialog.this.fWorkspacePathBrowseBtn.setEnabled(enabled);
                PathMapperEntryDialog.this.fExternalPathText.setEnabled(!enabled);
                PathMapperEntryDialog.this.fExternalPathBrowseBtn.setEnabled(!enabled);
                PathMapperEntryDialog.this.ignorePathText.setEnabled(!enabled);
                PathMapperEntryDialog.this.validate();
            }
        });
        this.fWorkspacePathText = new Text(typeSelectionGroup, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalIndent = pixelConverter.convertWidthInCharsToPixels(1);
        this.fWorkspacePathText.setLayoutData((Object)layoutData);
        this.fWorkspacePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathMapperEntryDialog.this.validate();
            }
        });
        this.fWorkspacePathBrowseBtn = new Button(typeSelectionGroup, 0);
        this.fWorkspacePathBrowseBtn.setText(Messages.PathMapperEntryDialog_4);
        this.fWorkspacePathBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceBrowseDialog dialog = new WorkspaceBrowseDialog(PathMapperEntryDialog.this.getShell());
                if (dialog.open() == 0) {
                    Object selectedElement = dialog.getSelectedElement();
                    PathMapperEntryDialog.this.fWorkspacePathText.setData(null);
                    if (selectedElement instanceof IResource) {
                        IResource resource = (IResource)selectedElement;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)PathEntry.Type.WORKSPACE);
                        PathMapperEntryDialog.this.fWorkspacePathText.setText(resource.getFullPath().toString());
                    } else if (selectedElement instanceof IBuildpathEntry) {
                        IBuildpathEntry includePathEntry = (IBuildpathEntry)selectedElement;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)(includePathEntry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER));
                        if (includePathEntry.getEntryKind() == 4) {
                            IPath incPath = DLTKCore.getResolvedVariablePath((IPath)includePathEntry.getPath());
                            if (incPath != null) {
                                PathMapperEntryDialog.this.fWorkspacePathText.setText(incPath.toOSString());
                            }
                        } else {
                            PathMapperEntryDialog.this.fWorkspacePathText.setText(EnvironmentPathUtils.getLocalPath((IPath)includePathEntry.getPath()).toOSString());
                        }
                    } else if (selectedElement instanceof WorkspaceBrowseDialog.IPFile) {
                        WorkspaceBrowseDialog.IPFile ipFile = (WorkspaceBrowseDialog.IPFile)selectedElement;
                        IBuildpathEntry includePathEntry = ipFile.includePathEntry;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)(includePathEntry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER));
                        PathMapperEntryDialog.this.fWorkspacePathText.setText(ipFile.file.getAbsolutePath());
                    }
                }
            }
        });
        this.fExternalPathBtn = new Button(typeSelectionGroup, 16);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.fExternalPathBtn.setLayoutData((Object)layoutData);
        this.fExternalPathBtn.setText(Messages.PathMapperEntryDialog_5);
        this.fExternalPathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = PathMapperEntryDialog.this.fExternalPathBtn.getSelection();
                PathMapperEntryDialog.this.fExternalPathText.setEnabled(enabled);
                PathMapperEntryDialog.this.fExternalPathBrowseBtn.setEnabled(enabled);
                PathMapperEntryDialog.this.fWorkspacePathText.setEnabled(!enabled);
                PathMapperEntryDialog.this.fWorkspacePathBrowseBtn.setEnabled(!enabled);
                PathMapperEntryDialog.this.ignorePathText.setEnabled(!enabled);
                PathMapperEntryDialog.this.validate();
            }
        });
        this.fExternalPathText = new Text(typeSelectionGroup, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalIndent = pixelConverter.convertWidthInCharsToPixels(1);
        this.fExternalPathText.setLayoutData((Object)layoutData);
        this.fExternalPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathMapperEntryDialog.this.validate();
            }
        });
        this.fExternalPathBrowseBtn = new Button(typeSelectionGroup, 0);
        this.fExternalPathBrowseBtn.setText(Messages.PathMapperEntryDialog_6);
        this.fExternalPathBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(PathMapperEntryDialog.this.getShell());
                String path = dialog.open();
                if (path != null) {
                    PathMapperEntryDialog.this.fExternalPathText.setText(path);
                }
            }
        });
        this.ignoreMappingBtn = new Button(typeSelectionGroup, 16);
        this.ignoreMappingBtn.setText(Messages.PathMapperEntryDialog_18);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.ignoreMappingBtn.setLayoutData((Object)layoutData);
        this.ignoreMappingBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = PathMapperEntryDialog.this.ignoreMappingBtn.getSelection();
                PathMapperEntryDialog.this.fWorkspacePathText.setEnabled(!enabled);
                PathMapperEntryDialog.this.fWorkspacePathBrowseBtn.setEnabled(!enabled);
                PathMapperEntryDialog.this.fExternalPathText.setEnabled(!enabled);
                PathMapperEntryDialog.this.fExternalPathBrowseBtn.setEnabled(!enabled);
                PathMapperEntryDialog.this.ignorePathText.setEnabled(enabled);
                PathMapperEntryDialog.this.validate();
            }
        });
        this.ignorePathText = new Text(typeSelectionGroup, 2056);
        this.ignorePathText.setEnabled(false);
        layoutData = new GridData(768);
        layoutData.horizontalIndent = pixelConverter.convertWidthInCharsToPixels(1);
        layoutData.widthHint = this.convertWidthInCharsToPixels(70);
        this.ignorePathText.setLayoutData((Object)layoutData);
        this.ignorePathText.setText("");
        PathMapperEntryDialog.applyDialogFont((Control)mainComp);
        this.initializeValues();
        if (this.fEditData != null) {
            this.setMessage(Messages.PathMapperEntryDialog_7);
        } else {
            this.setMessage(Messages.PathMapperEntryDialog_8);
        }
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.fEditData != null) {
            this.getShell().setText(Messages.PathMapperEntryDialog_0);
        } else {
            this.getShell().setText(Messages.PathMapperEntryDialog_1);
        }
        this.validate();
        return control;
    }

    protected void initializeValues() {
        this.fWorkspacePathBtn.setSelection(true);
        this.fExternalPathBtn.setSelection(false);
        if (this.fEditData != null) {
            this.fRemotePathText.setText(this.fEditData.remotePath.toString());
            if (this.fEditData.type == PathEntry.Type.SERVER) {
                this.fExternalPathBtn.setSelection(false);
                this.fWorkspacePathBtn.setSelection(false);
                this.ignoreMappingBtn.setSelection(true);
            } else if (this.fEditData.type == PathEntry.Type.EXTERNAL) {
                this.fExternalPathBtn.setSelection(true);
                this.fWorkspacePathBtn.setSelection(false);
                this.fExternalPathText.setText(this.fEditData.localPath.toString());
            } else {
                this.fWorkspacePathText.setData((Object)this.fEditData.type);
                this.fWorkspacePathText.setText(this.fEditData.localPath.toString());
            }
        }
        this.fWorkspacePathBtn.notifyListeners(13, new Event());
        this.fExternalPathBtn.notifyListeners(13, new Event());
    }

    protected void setError(String error) {
        if (error == null) {
            this.enableOkButton();
        } else {
            this.disableOkButton();
        }
        this.setErrorMessage(error);
    }

    private void enableOkButton() {
        Button btn = this.getButton(0);
        if (btn != null) {
            btn.setEnabled(true);
        }
    }

    private void disableOkButton() {
        Button btn = this.getButton(0);
        if (btn != null) {
            btn.setEnabled(false);
        }
    }

    protected void validate() {
        PathMapper.Mapping mapping = new PathMapper.Mapping();
        String remotePathStr = this.fRemotePathText.getText().trim();
        if (remotePathStr.length() == 0) {
            this.setError(Messages.PathMapperEntryDialog_9);
            return;
        }
        try {
            mapping.remotePath = new VirtualPath(remotePathStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setError(Messages.PathMapperEntryDialog_10);
            return;
        }
        if (this.fWorkspacePathBtn.getSelection()) {
            String workspacePath = this.fWorkspacePathText.getText().trim();
            if (workspacePath.length() == 0) {
                this.setError(Messages.PathMapperEntryDialog_11);
                return;
            }
            boolean pathExistsInWorkspace = false;
            mapping.type = (PathEntry.Type)this.fWorkspacePathText.getData();
            if (mapping.type == PathEntry.Type.INCLUDE_FOLDER || mapping.type == PathEntry.Type.INCLUDE_VAR) {
                pathExistsInWorkspace = new File(workspacePath).exists();
            } else {
                boolean bl = pathExistsInWorkspace = ResourcesPlugin.getWorkspace().getRoot().findMember(workspacePath) != null;
            }
            if (!pathExistsInWorkspace) {
                this.setError(NLS.bind((String)Messages.PathMapperEntryDialog_12, (Object)workspacePath));
                return;
            }
            try {
                mapping.localPath = new VirtualPath(workspacePath);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setError(Messages.PathMapperEntryDialog_13);
                return;
            }
        }
        if (this.ignoreMappingBtn.getSelection()) {
            mapping.type = PathEntry.Type.SERVER;
            mapping.localPath = mapping.remotePath.clone();
        } else {
            String externalPath = this.fExternalPathText.getText().trim();
            if (externalPath.length() == 0) {
                this.setError(Messages.PathMapperEntryDialog_14);
                return;
            }
            if (!new File(externalPath).exists()) {
                this.setError(NLS.bind((String)Messages.PathMapperEntryDialog_15, (Object)externalPath));
                return;
            }
            try {
                mapping.type = PathEntry.Type.EXTERNAL;
                mapping.localPath = new VirtualPath(externalPath);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setError(Messages.PathMapperEntryDialog_16);
                return;
            }
        }
        this.fEditData = mapping;
        this.setError(null);
    }

    class WorkspaceBrowseDialog
    extends StatusDialog {
        private TreeViewer fViewer;
        private Object selectedElement;

        public WorkspaceBrowseDialog(Shell parent) {
            super(parent);
            this.setTitle(Messages.PathMapperEntryDialog_17);
        }

        public Object getSelectedElement() {
            return this.selectedElement;
        }

        protected Control createDialogArea(Composite parent) {
            parent = (Composite)super.createDialogArea(parent);
            parent.setLayoutData((Object)new GridData(1808));
            PixelConverter pixelConverter = new PixelConverter((Control)parent);
            this.fViewer = new TreeViewer(parent, 2820);
            GridData layoutData = new GridData(1808);
            layoutData.widthHint = pixelConverter.convertWidthInCharsToPixels(70);
            layoutData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
            this.fViewer.getControl().setLayoutData((Object)layoutData);
            this.fViewer.setContentProvider((IContentProvider)new ContentProvider());
            this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    WorkspaceBrowseDialog.this.validate();
                }
            });
            this.fViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            return parent;
        }

        protected void validate() {
            IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
            Object element = selection.getFirstElement();
            if (element == null) {
                this.updateStatus((IStatus)new StatusInfo(4, ""));
                return;
            }
            this.selectedElement = element;
            this.updateStatus(Status.OK_STATUS);
        }

        class ContentProvider
        implements ITreeContentProvider {
            ContentProvider() {
            }

            public Object[] getChildren(Object parentElement) {
                try {
                    if (parentElement instanceof IContainer) {
                        IResource[] members;
                        LinkedList<Object> r = new LinkedList<Object>();
                        IContainer container = (IContainer)parentElement;
                        IResource[] iResourceArray = members = container.members();
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource member = iResourceArray[n2];
                            if (member instanceof IContainer && member.isAccessible()) {
                                if (member instanceof IProject) {
                                    IProject project = (IProject)member;
                                    if (project.hasNature("org.eclipse.php.core.PHPNature")) {
                                        r.add(member);
                                    }
                                } else {
                                    r.add(member);
                                }
                            }
                            ++n2;
                        }
                        if (parentElement instanceof IProject) {
                            IncludePath[] includePath;
                            IProject project = (IProject)parentElement;
                            IncludePath[] includePathArray = includePath = IncludePathManager.getInstance().getIncludePaths(project);
                            int n3 = includePath.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IBuildpathEntry buildpathEntry;
                                IncludePath path = includePathArray[n4];
                                if (path.isBuildpath() && ((buildpathEntry = (IBuildpathEntry)path.getEntry()).getEntryKind() == 1 || buildpathEntry.getEntryKind() == 4)) {
                                    r.add(buildpathEntry);
                                }
                                ++n4;
                            }
                        }
                        return r.toArray();
                    }
                    if (parentElement instanceof IBuildpathEntry) {
                        IBuildpathEntry includePathEntry = (IBuildpathEntry)parentElement;
                        IPath path = EnvironmentPathUtils.getLocalPath((IPath)includePathEntry.getPath());
                        File file = null;
                        if (includePathEntry.getEntryKind() == 1) {
                            file = path.toFile();
                        } else if (includePathEntry.getEntryKind() == 4 && (path = DLTKCore.getResolvedVariablePath((IPath)path)) != null) {
                            file = path.toFile();
                        }
                        if (file != null) {
                            return this.getChildren(new IPFile(includePathEntry, file));
                        }
                    } else if (parentElement instanceof IPFile) {
                        IPFile ipFile = (IPFile)parentElement;
                        File file = ipFile.file;
                        if (file.isDirectory()) {
                            File[] dirs = file.listFiles(new FileFilter(){

                                @Override
                                public boolean accept(File pathname) {
                                    return pathname.isDirectory();
                                }
                            });
                            ArrayList<IPFile> r = new ArrayList<IPFile>(dirs.length);
                            File[] fileArray = dirs;
                            int n = dirs.length;
                            int n5 = 0;
                            while (n5 < n) {
                                File dir = fileArray[n5];
                                r.add(new IPFile(ipFile.includePathEntry, dir));
                                ++n5;
                            }
                            return r.toArray();
                        }
                    }
                }
                catch (CoreException coreException) {}
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getParent();
                }
                if (element instanceof IPFile) {
                    IPFile ipFile = (IPFile)element;
                    return new IPFile(ipFile.includePathEntry, ipFile.file.getParentFile());
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        class IPFile {
            IBuildpathEntry includePathEntry;
            File file;

            IPFile(IBuildpathEntry includePathEntry, File file) {
                this.includePathEntry = includePathEntry;
                this.file = file;
            }

            public int hashCode() {
                return this.file.hashCode() + 13 * this.includePathEntry.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof IPFile)) {
                    return false;
                }
                IPFile other = (IPFile)obj;
                return other.file.equals(this.file) && other.includePathEntry.equals(this.includePathEntry);
            }
        }

        class LabelProvider
        extends ScriptUILabelProvider {
            LabelProvider() {
            }

            public Image getImage(Object element) {
                if (element instanceof IBuildpathEntry) {
                    IBuildpathEntry includePathEntry = (IBuildpathEntry)element;
                    if (includePathEntry.getEntryKind() == 4) {
                        return PHPPluginImages.get((String)"org.eclipse.php.ui.envvar_obj.gif");
                    }
                    return PHPPluginImages.get((String)"org.eclipse.php.ui.library_obj.gif");
                }
                if (element instanceof IPFile) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof IBuildpathEntry) {
                    IBuildpathEntry includePathEntry = (IBuildpathEntry)element;
                    return EnvironmentPathUtils.getLocalPath((IPath)includePathEntry.getPath()).toOSString();
                }
                if (element instanceof IPFile) {
                    return ((IPFile)element).file.getName();
                }
                return super.getText(element);
            }
        }
    }
}

