/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.Logger;
import org.eclipse.php.internal.server.ui.ServersPluginImages;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ServerCompositeFragment
extends CompositeFragment {
    protected Text name;
    protected Text url;
    protected Combo combo;
    protected Combo debuggerCombo;
    private ValuesCache originalValuesCache = new ValuesCache();
    private ValuesCache modifiedValuesCache;
    private Text webroot;
    private LinkedList<String> debuggersIds;

    public ServerCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.setDescription(PHPServerUIMessages.getString("ServerCompositeFragment.specifyInformation"));
        this.controlHandler.setDescription(this.getDescription());
        this.controlHandler.setImageDescriptor(ServersPluginImages.DESC_WIZ_SERVER);
        this.debuggersIds = new LinkedList(PHPDebuggersRegistry.getDebuggersIds());
        this.setDisplayName(PHPServerUIMessages.getString("ServerCompositeFragment.server"));
        this.createControl();
    }

    public void setData(Object server) throws IllegalArgumentException {
        if (server != null && !(server instanceof Server)) {
            throw new IllegalArgumentException("The given object is not a Server");
        }
        super.setData(server);
        this.init();
        this.validate();
    }

    public Server getServer() {
        return (Server)this.getData();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Composite nameGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        nameGroup.setLayout((Layout)layout);
        nameGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label(nameGroup, 0);
        label.setText(PHPServerUIMessages.getString("ServerCompositeFragment.nameLabel"));
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        this.name = new Text(nameGroup, 2048);
        data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerCompositeFragment.this.getServer() != null) {
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.serverName = ServerCompositeFragment.this.name.getText();
                }
                ServerCompositeFragment.this.validate();
            }
        });
        Label debuggerLabel = new Label(nameGroup, 0);
        debuggerLabel.setText(PHPServerUIMessages.getString("ServerCompositeFragment.debuggerLabel"));
        debuggerLabel.setLayoutData((Object)new GridData());
        this.debuggerCombo = new Combo(nameGroup, 12);
        data = new GridData(16384, 4, true, false);
        this.debuggerCombo.setLayoutData((Object)data);
        this.debuggerCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerCompositeFragment.this.getServer() != null) {
                    int index = ServerCompositeFragment.this.debuggerCombo.getSelectionIndex();
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.debuggerId = (String)ServerCompositeFragment.this.debuggersIds.get(index);
                }
                ServerCompositeFragment.this.validate();
            }
        });
        String defaultDebugger = PHPDebugPlugin.getCurrentDebuggerId();
        int i = 0;
        while (i < this.debuggersIds.size()) {
            String id = this.debuggersIds.get(i);
            String debuggerName = PHPDebuggersRegistry.getDebuggerName((String)id);
            this.debuggerCombo.add(debuggerName, i);
            if (id.equals(defaultDebugger)) {
                this.debuggerCombo.select(i);
            }
            ++i;
        }
        this.createURLGroup((Composite)this);
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    protected void init() {
        String baseURL;
        Server server = this.getServer();
        if (this.name == null || server == null) {
            return;
        }
        this.originalValuesCache.url = server.getBaseURL();
        this.originalValuesCache.serverName = server.getName();
        this.originalValuesCache.host = server.getHost();
        this.originalValuesCache.webroot = server.getDocumentRoot();
        this.originalValuesCache.debuggerId = server.getDebuggerId();
        this.modifiedValuesCache = new ValuesCache(this.originalValuesCache);
        if (this.originalValuesCache.serverName != null) {
            String serverName;
            boolean nameSet = false;
            String orgName = serverName = this.originalValuesCache.serverName;
            if (!this.isForEditing()) {
                int i = 0;
                while (i < 10) {
                    boolean ok = this.checkServerName(serverName);
                    if (ok) {
                        this.name.setText(serverName);
                        this.modifiedValuesCache.serverName = serverName;
                        nameSet = true;
                        break;
                    }
                    serverName = String.valueOf(orgName) + " (" + Integer.toString(i + 2) + ")";
                    ++i;
                }
                if (!nameSet) {
                    this.name.setText("");
                    this.modifiedValuesCache.serverName = "";
                }
            } else {
                this.name.setText(serverName);
            }
        } else {
            this.name.setText("");
        }
        if (this.originalValuesCache.webroot != null) {
            this.webroot.setText(this.originalValuesCache.webroot);
        }
        if (this.originalValuesCache.debuggerId != null) {
            String name = PHPDebuggersRegistry.getDebuggerName((String)this.originalValuesCache.debuggerId);
            String[] values = this.debuggerCombo.getItems();
            int i = 0;
            while (i < values.length) {
                if (values[i].equals(name)) {
                    this.debuggerCombo.select(i);
                    break;
                }
                ++i;
            }
        }
        if (!(baseURL = this.originalValuesCache.url).equals("")) {
            this.url.setText(baseURL);
            try {
                int port;
                URL originalURL = new URL(baseURL);
                this.originalValuesCache.port = port = originalURL.getPort();
                this.modifiedValuesCache.port = port;
            }
            catch (Exception exception) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            }
        } else {
            baseURL = "http://" + server.getHost();
            this.url.setText(baseURL);
            this.modifiedValuesCache.url = baseURL;
            try {
                int port;
                URL createdURL = new URL(baseURL);
                this.modifiedValuesCache.port = port = createdURL.getPort();
            }
            catch (Exception exception) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            }
        }
        if (this.originalValuesCache.serverName != null && this.originalValuesCache.serverName.length() > 0) {
            this.setTitle(String.valueOf(PHPServerUIMessages.getString("ServerCompositeFragment.editServer")) + " [" + this.originalValuesCache.serverName + ']');
        } else {
            this.setTitle(PHPServerUIMessages.getString("ServerCompositeFragment.configureServer"));
        }
        this.controlHandler.setTitle(this.getTitle());
    }

    public void validate() {
        boolean ok;
        if (this.getServer() == null) {
            this.setMessage("", 3);
            return;
        }
        this.setMessage(this.getDescription(), 0);
        String urlStr = this.url.getText();
        if (urlStr != null && !urlStr.trim().equals("") && !(ok = this.checkServerUrl(urlStr))) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.duplicateServerUrl"), 3);
        }
        try {
            URL url = new URL(urlStr);
            if (url.getPath() != null && url.getPath().length() != 0) {
                urlStr = null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            urlStr = null;
        }
        if (urlStr == null || urlStr.equals("")) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            return;
        }
        try {
            URL baseURL = new URL(urlStr);
            String host = baseURL.getHost();
            if (host.trim().length() == 0) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.serverURLEmpty"), 3);
            }
            int port = baseURL.getPort();
            this.modifiedValuesCache.host = host;
            this.modifiedValuesCache.port = port;
        }
        catch (Exception exception) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            return;
        }
        String serverName = this.modifiedValuesCache.serverName;
        if (serverName == null || serverName.trim().equals("")) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.missingServerName"), 3);
        } else {
            boolean ok2 = this.checkServerName(serverName);
            if (!ok2) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.duplicateServerName"), 3);
            }
        }
        String webrootStr = this.webroot.getText().trim();
        if (webrootStr.length() != 0 && !new Path(webrootStr).toFile().exists()) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.webrootNotExists"), 3);
        }
        this.controlHandler.update();
    }

    protected void setMessage(String message, int type) {
        this.controlHandler.setMessage(message, type);
        this.setComplete(type != 3);
        this.controlHandler.update();
    }

    protected void createURLGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(PHPServerUIMessages.getString("ServerCompositeFragment.serverProperties"));
        Label urlLabel = new Label((Composite)group, 0);
        urlLabel.setText(PHPServerUIMessages.getString("ServerCompositeFragment.baseURL"));
        this.url = new Text((Composite)group, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.url.setLayoutData((Object)layoutData);
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerCompositeFragment.this.getServer() != null) {
                    String urlStr;
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.url = urlStr = ServerCompositeFragment.this.url.getText();
                }
                ServerCompositeFragment.this.validate();
            }
        });
        Label labelRoot = new Label((Composite)group, 0);
        labelRoot.setText(PHPServerUIMessages.getString("ServerCompositeFragment.localWebRoot"));
        labelRoot.setLayoutData((Object)new GridData());
        this.webroot = new Text((Composite)group, 2048);
        this.webroot.setLayoutData((Object)new GridData(768));
        this.webroot.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerCompositeFragment.this.getServer() != null) {
                    String webrootStr;
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.webroot = webrootStr = ServerCompositeFragment.this.webroot.getText();
                }
                ServerCompositeFragment.this.validate();
            }
        });
        Button browseButton = new Button((Composite)group, 8);
        browseButton.setText(PHPServerUIMessages.getString("ServerCompositeFragment.browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result;
                DirectoryDialog dialog = new DirectoryDialog(ServerCompositeFragment.this.getShell());
                if (!"".equals(ServerCompositeFragment.this.webroot.getText())) {
                    String initialDir = ServerCompositeFragment.this.webroot.getText();
                    dialog.setFilterPath(initialDir);
                }
                if ((result = dialog.open()) != null) {
                    ServerCompositeFragment.this.webroot.setText(result.toString());
                }
            }
        });
    }

    private boolean checkServerName(String name) {
        if ((name = name.trim()).equals(this.originalValuesCache.serverName)) {
            return true;
        }
        Server[] allServers = ServersManager.getServers();
        if (allServers != null) {
            int size = allServers.length;
            int i = 0;
            while (i < size) {
                Server server = allServers[i];
                if (name.equals(server.getName())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean checkServerUrl(String url) {
        url = url.trim();
        if (this.originalValuesCache.serverName != null && this.originalValuesCache.serverName.trim().length() > 0 && url.equals(this.originalValuesCache.url)) {
            return true;
        }
        Server[] allServers = ServersManager.getServers();
        if (allServers != null) {
            int size = allServers.length;
            int i = 0;
            while (i < size) {
                Server server = allServers[i];
                if (url.equals(server.getBaseURL())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean performOk() {
        try {
            Server defaultServer = ServersManager.getDefaultServer(null);
            boolean isDefault = false;
            isDefault = defaultServer != null && defaultServer.getName().equals(this.originalValuesCache.serverName);
            Server server = this.getServer();
            if (server != null) {
                server.setPort(String.valueOf(this.modifiedValuesCache.port));
                server.setBaseURL(this.modifiedValuesCache.url);
            }
            server.setHost(this.modifiedValuesCache.host);
            server.setName(this.modifiedValuesCache.serverName);
            server.setDocumentRoot(this.modifiedValuesCache.webroot);
            server.setDebuggerId(this.modifiedValuesCache.debuggerId);
            if (this.originalValuesCache.serverName != null && !this.originalValuesCache.serverName.equals("") && !this.originalValuesCache.serverName.equals(this.modifiedValuesCache.serverName)) {
                ServersManager.removeServer((String)this.originalValuesCache.serverName);
                ServersManager.addServer((Server)server);
                if (isDefault) {
                    ServersManager.setDefaultServer(null, (Server)server);
                }
            }
        }
        catch (Throwable e) {
            Logger.logException("Error while saving the server settings", e);
            return false;
        }
        return true;
    }

    public boolean performCancel() {
        try {
            Server server = this.getServer();
            if (server != null) {
                server.setPort(String.valueOf(this.originalValuesCache.port));
                server.setBaseURL(this.originalValuesCache.url);
            }
            server.setHost(this.originalValuesCache.host);
            server.setName(this.originalValuesCache.serverName);
        }
        catch (Throwable e) {
            Logger.logException("Error while reverting the server settings", e);
            return false;
        }
        return super.performCancel();
    }

    private class ValuesCache {
        String webroot;
        String serverName;
        String url;
        String host;
        String debuggerId;
        int port;

        public ValuesCache() {
        }

        public ValuesCache(ValuesCache cache) {
            this.serverName = cache.serverName;
            this.url = cache.url;
            this.port = cache.port;
            this.host = cache.host;
            this.webroot = cache.webroot;
            this.debuggerId = cache.debuggerId;
        }
    }
}

