/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.contentassist;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class ContentAssistTests {
    protected IProject project;
    protected IFile testFile;
    protected PHPVersion phpVersion;
    protected PHPStructuredEditor fEditor;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static final char OFFSET_CHAR = '|';

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/codeassist/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php53/classExclusive"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php56"});
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }

    public ContentAssistTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Content Assist_" + this.phpVersion);
        if (this.project.exists()) {
            return;
        }
        this.project.create(null);
        this.project.open(null);
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        this.project.setDescription(desc, null);
        PHPUiPlugin.getDefault().getPluginPreferences().setDefault("contentAssistAutoinsert", true);
        PHPCoreTests.setProjectPhpVersion((IProject)this.project, (PHPVersion)this.phpVersion);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        this.project.close(null);
        this.project.delete(true, true, null);
        this.project = null;
    }

    @After
    public void tearDown() throws Exception {
        if (this.testFile != null) {
            this.testFile.delete(true, null);
            this.testFile = null;
        }
    }

    @Test
    public void assist(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
        pdttFile.applyPreferences();
        String data = pdttFile.getFile();
        int offset = data.lastIndexOf(124);
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        this.createFile(new ByteArrayInputStream(data.getBytes()), Long.toString(System.currentTimeMillis()));
        String result = this.executeAutoInsert(offset);
        this.closeEditor();
        if (!pdttFile.getExpected().trim().equals(result.trim())) {
            StringBuilder errorBuf = new StringBuilder();
            errorBuf.append("\nEXPECTED COMPLETIONS LIST:\n-----------------------------\n");
            errorBuf.append(pdttFile.getExpected());
            errorBuf.append("\nACTUAL COMPLETIONS LIST:\n-----------------------------\n");
            errorBuf.append(result);
            Assert.fail((String)errorBuf.toString());
        }
    }

    protected void closeEditor() {
        this.fEditor.doSave(null);
        this.fEditor.getSite().getPage().closeEditor((IEditorPart)this.fEditor, false);
        this.fEditor = null;
        if (this.testFile.exists()) {
            try {
                this.testFile.delete(true, false, null);
                this.project.refreshLocal(2, null);
                this.project.build(6, null);
                PHPCoreTests.waitForIndexer();
            }
            catch (CoreException coreException) {}
        }
    }

    protected String executeAutoInsert(int offset) {
        StructuredTextViewer viewer = null;
        Display display = Display.getDefault();
        long timeout = System.currentTimeMillis() + 3000L;
        while (System.currentTimeMillis() < timeout && (viewer = this.fEditor.getTextViewer()) == null) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (viewer == null) {
            Assert.fail((String)("fEditor.getTextViewer() returns null for file " + this.testFile.getFullPath() + "(" + this.testFile.getLocation() + ")"));
        }
        StyledText textWidget = viewer.getTextWidget();
        textWidget.setCaretOffset(offset);
        viewer.doOperation(13);
        return this.fEditor.getDocument().get();
    }

    protected void createFile(InputStream inputStream, String fileName) throws Exception {
        this.testFile = this.project.getFile(new Path(fileName).removeFileExtension().addFileExtension("php").lastSegment());
        this.testFile.create(inputStream, true, null);
        this.project.refreshLocal(2, null);
        this.project.build(6, null);
        PHPCoreTests.waitForIndexer();
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        FileEditorInput input = new FileEditorInput(this.testFile);
        IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.php.editor", true);
        if (part instanceof PHPStructuredEditor) {
            this.fEditor = (PHPStructuredEditor)part;
        } else {
            Assert.assertTrue((String)"Unable to open php editor", (boolean)false);
        }
    }
}

