/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.php.refactoring.core.test.PdttFileExt;
import org.eclipse.php.refactoring.core.test.TestProject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class PHPMoveProcessorTest
extends AbstractRefactoringTest {
    @PDTTList.Parameters
    public static String[] dirs = new String[]{"/resources/move/"};

    public PHPMoveProcessorTest(String[] fileNames) {
        super(fileNames);
    }

    @Override
    protected TestProject getProject() {
        return new TestProject("RefactoringMove");
    }

    @Test
    public void test(String fileName) throws Exception {
        PdttFileExt testFile = (PdttFileExt)((Object)this.filesMap.get(fileName));
        IFile file = this.project.findFile(testFile.getTestFiles().get(0).getName());
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        PHPMoveProcessor processor = new PHPMoveProcessor((IResource)file);
        processor.setUpdateReferences(Boolean.valueOf((String)testFile.getConfig().get("updateReference")).booleanValue());
        Object destination = null;
        String dest = (String)testFile.getConfig().get("dest");
        destination = "/".equals(dest) ? this.project.getProject() : this.project.createFolder(dest);
        processor.setDestination((IContainer)destination);
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        this.checkTestResult(testFile);
    }
}

