/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.refactoring.core.rename.AbstractRenameRefactoringTest;
import org.eclipse.php.refactoring.core.rename.RenameFolderProcessor;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameProcessorTestCase0026915
extends AbstractRenameRefactoringTest {
    private IProject project1;

    @Before
    public void setUp() throws Exception {
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("project1");
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile file = folder.getFile("test1.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php class TestRenameClass{}?>".getBytes());
        if (!file.exists()) {
            file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        Path fPath = new Path("/project1/src");
        IPath[] inclusionPattern = new IPath[]{};
        IPath[] exclusionPattern = new IPath[]{};
        IBuildpathEntry sourceEntry = DLTKCore.newSourceEntry((IPath)fPath, (IPath[])inclusionPattern, (IPath[])exclusionPattern, (IBuildpathAttribute[])new IBuildpathAttribute[0]);
        fPath = new Path("/project1");
        inclusionPattern = new IPath[]{};
        exclusionPattern = new IPath[]{new Path("src/")};
        IBuildpathEntry sourceEntry1 = DLTKCore.newSourceEntry((IPath)fPath, (IPath[])inclusionPattern, (IPath[])exclusionPattern, (IBuildpathAttribute[])new IBuildpathAttribute[0]);
        IScriptProject scriptProject = DLTKCore.create((IProject)this.project1.getProject());
        ArrayList<IBuildpathEntry> entriesList = new ArrayList<IBuildpathEntry>();
        try {
            IBuildpathEntry[] entries = scriptProject.getRawBuildpath();
            entries = FileUtils.removeEntryFromBuildPath(entries, this.project1.getFullPath());
            entriesList.addAll(Arrays.asList(entries));
            entriesList.add(sourceEntry);
            entriesList.add(sourceEntry1);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        IBuildpathEntry[] newEntries = new IBuildpathEntry[entriesList.size()];
        scriptProject.setRawBuildpath(null, (IProgressMonitor)new NullProgressMonitor());
        scriptProject.setRawBuildpath(entriesList.toArray(newEntries), (IProgressMonitor)new NullProgressMonitor());
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    @Test
    public void testRename() {
        RenameFolderProcessor processor = new RenameFolderProcessor((IContainer)this.project1.getFolder("src"));
        processor.setNewElementName("src1");
        processor.setUpdateRefernces(true);
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        IFolder folder = this.project1.getFolder("src1");
        Assert.assertTrue((boolean)folder.exists());
        IScriptProject scriptProject = DLTKCore.create((IProject)this.project1);
        FileUtils.isInBuildpath(folder.getFullPath(), scriptProject, 3);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

