/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core;

import com.ibm.icu.text.MessageFormat;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.php.internal.core.util.SyncObject;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public final class PHPDebugUtil {
    private PHPDebugUtil() {
    }

    public static void openLaunchURL(final String launchURL) throws DebugException {
        final SyncObject e = new SyncObject();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    URL urlToOpen = new URL(launchURL);
                    StringBuilder browserTitle = new StringBuilder(urlToOpen.getProtocol()).append("://").append(urlToOpen.getHost());
                    if (urlToOpen.getPort() != -1) {
                        browserTitle.append(':').append(urlToOpen.getPort());
                    }
                    browserTitle.append(urlToOpen.getPath());
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(14, "PHP Debugger Browser", browserTitle.toString(), browserTitle.toString());
                    if (PHPDebugPlugin.DEBUG) {
                        System.out.println("Opening debug/launch URL in a Web Browser: " + urlToOpen.toString());
                    }
                    browser.openURL(urlToOpen);
                }
                catch (Throwable t) {
                    Logger.logException(MessageFormat.format((String)"Error initializing the Web Browser for debug/launch URL: {0}", (Object[])new Object[]{launchURL}), t);
                    String errorMessage = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
                    e.set((Object)new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, t)));
                }
            }
        });
        DebugException ex = (DebugException)((Object)e.get());
        if (ex != null) {
            throw ex;
        }
    }
}

