/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPRuntime;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;

public class PHPLaunchDelegateProxy
implements ILaunchConfigurationDelegate2 {
    protected ILaunchConfigurationDelegate2 launchConfigurationDelegate;

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getConfigurationDelegate(configuration).buildForLaunch(configuration, mode, monitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getConfigurationDelegate(configuration).finalLaunchCheck(configuration, mode, monitor);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType exeType = lm.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType");
        if (configuration.getType().equals(exeType)) {
            configuration = this.updatePHPExeAttributes(configuration);
        }
        return this.getConfigurationDelegate(configuration).getLaunch(configuration, mode);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getConfigurationDelegate(configuration).preLaunchCheck(configuration, mode, monitor);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.getConfigurationDelegate(configuration).launch(configuration, mode, launch, monitor);
        }
        finally {
            this.launchConfigurationDelegate = null;
        }
    }

    protected ILaunchConfigurationDelegate2 getConfigurationDelegate(ILaunchConfiguration configuration) throws CoreException {
        String className = configuration.getAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, "");
        if (className.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.launchConfigurationDelegate == null || !this.launchConfigurationDelegate.getClass().getCanonicalName().equals(className)) {
            try {
                this.launchConfigurationDelegate = (ILaunchConfigurationDelegate2)Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.core", 0, "Launch configuration delegate loading error.", t));
            }
        }
        return this.launchConfigurationDelegate;
    }

    private ILaunchConfiguration updatePHPExeAttributes(ILaunchConfiguration configuration) throws CoreException {
        PHPexeItem item = null;
        String path = configuration.getAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
        if (path == null) {
            IProject project = null;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String projectName = configuration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
            if (projectName != null) {
                project = workspaceRoot.getProject(projectName);
            } else {
                String phpScriptString = configuration.getAttribute("ATTR_FILE", null);
                Path filePath = new Path(phpScriptString);
                IResource scriptRes = workspaceRoot.findMember((IPath)filePath);
                if (scriptRes != null) {
                    project = scriptRes.getProject();
                }
            }
            item = PHPDebugPlugin.getPHPexeItem(project);
        } else {
            IPath exePath = Path.fromPortableString((String)path);
            PHPVersion version = PHPRuntime.getPHPVersion(exePath);
            if (version == null) {
                String exeName = exePath.lastSegment();
                item = PHPexes.getInstance().getItem(exeName);
            } else {
                item = PHPDebugPlugin.getPHPexeItem(version);
            }
        }
        if (item != null) {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute("ATTR_LOCATION", item.getExecutable().toString());
            String debuggerId = item.getDebuggerID();
            wc.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerId);
            AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(debuggerId);
            wc.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, debuggerConfiguration.getScriptLaunchDelegateClass());
            if (item.getINILocation() != null) {
                wc.setAttribute("ATTR_INI_LOCATION", item.getINILocation().toString());
            } else {
                wc.setAttribute("ATTR_INI_LOCATION", null);
            }
            configuration = wc.doSave();
        }
        return configuration;
    }
}

