/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.preferences.IPHPExesListener;
import org.eclipse.php.internal.debug.core.preferences.PHPExesEvent;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.IServersManagerListener;
import org.eclipse.php.internal.server.core.manager.ServerManagerEvent;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.ui.preferences.util.XMLPreferencesReaderUI;
import org.eclipse.php.internal.ui.preferences.util.XMLPreferencesWriterUI;

public class PathMapperRegistry
implements IXMLPreferencesStorable,
IServersManagerListener,
IPHPExesListener {
    private static final String PATH_MAPPER_PREF_KEY = String.valueOf(PHPDebugPlugin.getID()) + ".pathMapper";
    private static PathMapperRegistry instance;
    private HashMap<Server, PathMapper> serverPathMapper = new HashMap();
    private HashMap<PHPexeItem, PathMapper> phpExePathMapper = new HashMap();

    private PathMapperRegistry() {
        this.loadFromPreferences();
    }

    public static synchronized PathMapperRegistry getInstance() {
        if (instance == null) {
            instance = new PathMapperRegistry();
        }
        return instance;
    }

    public static PathMapper getByPHPExe(PHPexeItem phpExe) {
        PathMapper result = PathMapperRegistry.getInstance().phpExePathMapper.get(phpExe);
        if (result == null) {
            result = new PathMapper();
            PathMapperRegistry.getInstance().phpExePathMapper.put(phpExe, result);
            PHPexes.getInstance().addPHPExesListener(PathMapperRegistry.getInstance());
        }
        return result;
    }

    public static PathMapper getByServer(Server server) {
        PathMapper result = PathMapperRegistry.getInstance().serverPathMapper.get(server);
        if (result == null) {
            result = new PathMapper();
            PathMapperRegistry.getInstance().serverPathMapper.put(server, result);
            ServersManager.addManagerListener((IServersManagerListener)PathMapperRegistry.getInstance());
        }
        return result;
    }

    public static PathMapper getByLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        PathMapper pathMapper = null;
        try {
            String serverName = launchConfiguration.getAttribute("name", null);
            if (serverName != null) {
                pathMapper = PathMapperRegistry.getByServer(ServersManager.getServer((String)serverName));
            }
        }
        catch (CoreException e) {
            PHPDebugPlugin.log(e);
        }
        return pathMapper;
    }

    public void loadFromPreferences() {
        HashMap[] elements = XMLPreferencesReaderUI.read((Preferences)PHPProjectPreferences.getModelPreferences(), (String)PATH_MAPPER_PREF_KEY);
        if (elements.length == 1) {
            this.restoreFromMap(elements[0]);
        }
    }

    public static void storeToPreferences() {
        XMLPreferencesWriterUI.write((Preferences)PHPProjectPreferences.getModelPreferences(), (String)PATH_MAPPER_PREF_KEY, (IXMLPreferencesStorable)PathMapperRegistry.getInstance());
    }

    public synchronized void restoreFromMap(HashMap map) {
        if (map == null) {
            return;
        }
        this.serverPathMapper.clear();
        this.phpExePathMapper.clear();
        map = (HashMap)map.get("pathMappers");
        if (map == null) {
            return;
        }
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            PHPexeItem phpExeItem;
            HashMap entryMap = (HashMap)map.get(i.next());
            String serverName = (String)entryMap.get("server");
            String phpExeFile = (String)entryMap.get("phpExe");
            String phpIniFile = (String)entryMap.get("phpIni");
            PathMapper pathMapper = new PathMapper();
            pathMapper.restoreFromMap((HashMap)entryMap.get("mapper"));
            if (serverName != null) {
                Server server = ServersManager.getServer((String)serverName);
                if (server == null) continue;
                this.serverPathMapper.put(server, pathMapper);
                continue;
            }
            if (phpExeFile == null || (phpExeItem = PHPexes.getInstance().getItemForFile(phpExeFile, phpIniFile)) == null) continue;
            this.phpExePathMapper.put(phpExeItem, pathMapper);
        }
    }

    public synchronized HashMap storeToMap() {
        PathMapper pathMapper;
        HashMap<String, Object> entry;
        HashMap elements = new HashMap();
        Iterator<Object> i = this.serverPathMapper.keySet().iterator();
        int c = 1;
        while (i.hasNext()) {
            entry = new HashMap<String, Object>();
            Server server = (Server)i.next();
            pathMapper = this.serverPathMapper.get(server);
            entry.put("server", server.getName());
            if (pathMapper != null) {
                entry.put("mapper", pathMapper.storeToMap());
            }
            elements.put("item" + c++, entry);
        }
        i = this.phpExePathMapper.keySet().iterator();
        while (i.hasNext()) {
            entry = new HashMap();
            PHPexeItem phpExeItem = (PHPexeItem)i.next();
            pathMapper = this.phpExePathMapper.get(phpExeItem);
            entry.put("phpExe", phpExeItem.getExecutable().toString());
            if (phpExeItem.getINILocation() != null) {
                entry.put("phpIni", phpExeItem.getINILocation().toString());
            }
            entry.put("mapper", pathMapper.storeToMap());
            elements.put("item" + c++, entry);
        }
        HashMap root = new HashMap();
        root.put("pathMappers", elements);
        return root;
    }

    public void serverAdded(ServerManagerEvent event) {
        if (!this.serverPathMapper.containsKey(event.getServer())) {
            this.serverPathMapper.put(event.getServer(), new PathMapper());
        }
    }

    public void serverModified(ServerManagerEvent event) {
    }

    public void serverRemoved(ServerManagerEvent event) {
        this.serverPathMapper.remove(event.getServer());
    }

    @Override
    public void phpExeAdded(PHPExesEvent event) {
        if (!this.phpExePathMapper.containsKey(event.getPHPExeItem())) {
            this.phpExePathMapper.put(event.getPHPExeItem(), new PathMapper());
        }
    }

    @Override
    public void phpExeRemoved(PHPExesEvent event) {
        this.phpExePathMapper.remove(event.getPHPExeItem());
    }
}

