/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPExecutableLaunchDelegate;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;

public class PHPDebugCorePreferenceInitializer
extends AbstractPreferenceInitializer {
    private static Inet4Address CLASS_A_NETWORK;
    private static Inet4Address CLASS_B_NETWORK;
    private static Inet4Address CLASS_C_NETWORK;
    private static Inet4Address LOCALHOST;

    static {
        try {
            CLASS_A_NETWORK = (Inet4Address)InetAddress.getByName("10.0.0.0");
            CLASS_B_NETWORK = (Inet4Address)InetAddress.getByName("172.16.0.0");
            CLASS_C_NETWORK = (Inet4Address)InetAddress.getByName("192.168.0.0");
            LOCALHOST = (Inet4Address)InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException unknownHostException) {}
    }

    public void initializeDefaultPreferences() {
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode(PHPDebugPlugin.getDefault().getBundle().getSymbolicName());
        node.putBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, true);
        node.putBoolean(PHPDebugCorePreferenceNames.ENABLE_CLI_DEBUG, true);
        node.putBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, true);
        node.putBoolean(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER, true);
        node.putBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS, true);
        node.putBoolean(PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, true);
        node.putInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, 10000);
        node.putInt(PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT, 50000);
        node.put(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, "UTF-8");
        node.put(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, "UTF-8");
        node.put(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, PHPExecutableLaunchDelegate.class.getName());
        node.put(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, "org.eclipse.php.debug.core.zendDebugger");
        node.put("org.eclipse.php.debug.core.debugParametersInitializer", "org.eclipse.php.debug.core.defaultInitializer");
        node.putBoolean(PHPDebugCorePreferenceNames.SORT_BY_NAME, false);
        ArrayList<Inet4Address> clientHosts = new ArrayList<Inet4Address>();
        clientHosts.add(LOCALHOST);
        try {
            Enumeration<NetworkInterface> ii = NetworkInterface.getNetworkInterfaces();
            while (ii.hasMoreElements()) {
                NetworkInterface i = ii.nextElement();
                if (i.getDisplayName().contains("VMware")) continue;
                Enumeration<InetAddress> aa = i.getInetAddresses();
                while (aa.hasMoreElements()) {
                    InetAddress a = aa.nextElement();
                    if (!(a instanceof Inet4Address) || a.isLoopbackAddress()) continue;
                    clientHosts.add((Inet4Address)a);
                }
            }
        }
        catch (Exception exception) {}
        Inet4Address[] hosts = clientHosts.toArray(new Inet4Address[clientHosts.size()]);
        Arrays.sort(hosts, new Comparator<Inet4Address>(){

            @Override
            public int compare(Inet4Address first, Inet4Address second) {
                return PHPDebugCorePreferenceInitializer.this.getNetworkClass(second) - PHPDebugCorePreferenceInitializer.this.getNetworkClass(first);
            }
        });
        StringBuilder clientIPs = new StringBuilder();
        Inet4Address[] inet4AddressArray = hosts;
        int n = hosts.length;
        int n2 = 0;
        while (n2 < n) {
            Inet4Address host = inet4AddressArray[n2];
            if (clientIPs.length() > 0) {
                clientIPs.append(',');
            }
            clientIPs.append(host.getHostAddress());
            ++n2;
        }
        node.put(PHPDebugCorePreferenceNames.CLIENT_IP, clientIPs.toString());
    }

    private int getNetworkClass(Inet4Address address) {
        if (address.isLoopbackAddress()) {
            return 0;
        }
        if (this.isPrivateClassA(address)) {
            return 1;
        }
        if (this.isPrivateClassB(address)) {
            return 2;
        }
        if (this.isPrivateClassC(address)) {
            return 3;
        }
        return 4;
    }

    private boolean isPrivateClassA(Inet4Address address) {
        return this.isInRange(address, CLASS_A_NETWORK, 8);
    }

    private boolean isPrivateClassB(Inet4Address address) {
        return this.isInRange(address, CLASS_B_NETWORK, 12);
    }

    private boolean isPrivateClassC(Inet4Address address) {
        return this.isInRange(address, CLASS_C_NETWORK, 16);
    }

    private boolean isInRange(Inet4Address address, Inet4Address subnet, int mask) {
        int addressValue;
        int maskValue = 0xFFFFFFF << 32 - mask;
        int subnetValue = this.getAddress(subnet.getAddress());
        return (subnetValue & subnetValue) == ((addressValue = this.getAddress(address.getAddress())) & maskValue);
    }

    private int getAddress(byte[] bytesAddress) {
        return (bytesAddress[0] & 0xFF) << 24 | (bytesAddress[1] & 0xFF) << 16 | (bytesAddress[2] & 0xFF) << 8 | (bytesAddress[3] & 0xFF) << 0;
    }
}

