/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;

public class DBGpLogger {
    private static boolean debugOn = false;

    public static boolean debugState() {
        return false;
    }

    public static boolean debugCmd() {
        return false;
    }

    public static boolean debugResp() {
        return false;
    }

    public static boolean debugBP() {
        return false;
    }

    public static boolean debugSession() {
        return false;
    }

    public static void debug(String info) {
        if (debugOn) {
            System.out.println("-->DBGp: " + info);
        }
    }

    public static void debugException(Throwable exc) {
        if (exc != null) {
            DBGpLogger.debug(String.valueOf(exc.getClass().toString()) + ":" + exc.getMessage());
            StackTraceElement[] els = exc.getStackTrace();
            int i = 0;
            while (i < els.length) {
                DBGpLogger.debug(els[i].toString());
                ++i;
            }
        }
    }

    public static void logException(String info, Object obj, Throwable exc) {
        ILog theLog = PHPDebugPlugin.getDefault().getLog();
        StringBuffer msg = new StringBuffer();
        if (obj != null) {
            msg.append(obj.getClass().toString());
            msg.append(" : ");
        }
        if (info != null) {
            msg.append(info);
        }
        DBGpLogger.debug(msg.toString());
        if (exc != null) {
            DBGpLogger.debugException(exc);
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bs);
        exc.printStackTrace(ps);
        Status stat = new Status(4, "org.eclipse.php.debug.core", 4, msg + "\n" + bs.toString(), null);
        theLog.log((IStatus)stat);
    }

    public static void logError(String info, Object obj, Throwable exc) {
        DBGpLogger.doLog(info, obj, exc, 4);
    }

    public static void logWarning(String info, Object obj, Throwable exc) {
        DBGpLogger.doLog(info, obj, exc, 2);
    }

    public static void logInfo(String info, Object obj) {
        DBGpLogger.doLog(info, obj, null, 1);
    }

    private static void doLog(String info, Object obj, Throwable exc, int type) {
        ILog theLog = PHPDebugPlugin.getDefault().getLog();
        StringBuffer msg = new StringBuffer();
        if (obj != null) {
            msg.append(obj.getClass().toString());
            msg.append(" : ");
        }
        if (info != null) {
            msg.append(info);
        }
        if (exc != null) {
            msg.append("Exception:");
            msg.append(exc.getClass().toString());
            msg.append(" msg: ");
            msg.append(exc.getMessage());
        }
        Status stat = new Status(type, "org.eclipse.php.debug.core", type, msg.toString(), exc);
        DBGpLogger.debug(msg.toString());
        if (exc != null) {
            DBGpLogger.debugException(exc);
        }
        theLog.log((IStatus)stat);
    }
}

