/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.communication;

import java.net.Socket;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnection;

public class DebuggerCommunicationDaemon
extends AbstractDebuggerCommunicationDaemon
implements ICommunicationDaemon {
    public static final String ZEND_DEBUGGER_ID = "org.eclipse.php.debug.core.zendDebugger";
    private IEclipsePreferences.IPreferenceChangeListener portChangeListener;

    @Override
    public void init() {
        this.initDeamonChangeListener();
        super.init();
    }

    @Override
    public int getReceiverPort() {
        return PHPDebugPlugin.getDebugPort(ZEND_DEBUGGER_ID);
    }

    @Override
    public String getDebuggerID() {
        return ZEND_DEBUGGER_ID;
    }

    public boolean isDebuggerDaemon() {
        return true;
    }

    protected void initDeamonChangeListener() {
        if (this.portChangeListener == null) {
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core");
            this.portChangeListener = new PortChangeListener();
            preferences.addPreferenceChangeListener(this.portChangeListener);
        }
    }

    @Override
    protected synchronized void startConnection(Socket socket) {
        new DebugConnection(socket);
    }

    private class PortChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private PortChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT)) {
                DebuggerCommunicationDaemon.this.resetSocket();
            }
        }
    }
}

