/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.launching.PHPExecutableLaunchDelegate;
import org.eclipse.php.internal.debug.core.launching.PHPWebPageLaunchDelegate;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerConfigurationDialog;
import org.eclipse.swt.widgets.Shell;

public class ZendDebuggerConfiguration
extends AbstractDebuggerConfiguration {
    private static final String EXTENSION_MODULE_ID = "Zend Debugger";

    @Override
    public String getModuleId() {
        return EXTENSION_MODULE_ID;
    }

    @Override
    public void openConfigurationDialog(Shell parentShell) {
        new ZendDebuggerConfigurationDialog(this, parentShell).open();
    }

    @Override
    public int getPort() {
        return this.preferences.getInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT);
    }

    @Override
    public void setPort(int port) {
        this.preferences.setValue(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, port);
    }

    public boolean isUseNewProtocol() {
        return this.preferences.getBoolean(PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL);
    }

    public void setUNewProtocol(boolean enable) {
        this.preferences.setValue(PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, enable);
    }

    @Override
    public String getScriptLaunchDelegateClass() {
        return PHPExecutableLaunchDelegate.class.getName();
    }

    @Override
    public String getWebLaunchDelegateClass() {
        return PHPWebPageLaunchDelegate.class.getName();
    }

    @Override
    public void applyDefaults() {
        this.setPort(this.preferences.getDefaultInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT));
        this.preferences.setValue(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, this.preferences.getDefaultBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO));
        this.save();
    }

    @Override
    public IStatus validate(PHPexeItem item) {
        File executable = item.getExecutable();
        PHPexes.changePermissions(executable);
        if (this.isInstalled(item, EXTENSION_MODULE_ID)) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.eclipse.php.debug.core", PHPDebugCoreMessages.ZendDebuggerConfiguration_ZendDebuggerNotInstalledError);
    }
}

