/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;

public class PHPStackFrame
extends PHPDebugElement
implements IStackFrame {
    private static final Pattern LAMBDA_FUNC_PATTERN = Pattern.compile("(.*)\\((\\d+)\\) : runtime-created function");
    private PHPThread fThread;
    private String fFunctionName;
    private String fFileName;
    private String fResolvedFileName;
    private int fLineNumber;
    private int fDepth;
    private Expression[] fLocalVariables;
    private PHPVariable[] fVariables;

    public PHPStackFrame(IThread thread, String fileName, String resolvedFileName, String funcName, int lineNumber, int depth, Expression[] localVariables) {
        super((PHPDebugTarget)thread.getDebugTarget());
        this.baseInit(thread, fileName, resolvedFileName, funcName, lineNumber, depth, localVariables);
    }

    private void baseInit(IThread thread, String fileName, String resolvedFileName, String funcName, int lineNumber, int depth, Expression[] localVariables) {
        Matcher matcher = LAMBDA_FUNC_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            fileName = matcher.group(1);
            lineNumber = Integer.parseInt(matcher.group(2));
        }
        this.fFunctionName = funcName;
        this.fFileName = fileName;
        this.fResolvedFileName = resolvedFileName;
        this.fLineNumber = lineNumber;
        this.fDepth = depth;
        this.fThread = (PHPThread)thread;
        this.fLocalVariables = localVariables;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        Expression[] localVariables = ExpressionValue.sort(this.fLocalVariables);
        if (this.fVariables == null) {
            this.fVariables = new PHPVariable[localVariables.length];
            int i = 0;
            while (i < localVariables.length) {
                this.fVariables[i] = new PHPVariable((PHPDebugTarget)this.fThread.getDebugTarget(), localVariables[i], false);
                ++i;
            }
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        return ((PHPDebugTarget)this.getDebugTarget()).getVariables(this).length > 0;
    }

    public int getLineNumber() throws DebugException {
        return this.fLineNumber;
    }

    public int checkLineNumber() throws DebugException {
        return this.fLineNumber;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.fFunctionName;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        return this.fResolvedFileName;
    }

    public String getAbsoluteFileName() {
        return this.fFileName;
    }

    protected int getIdentifier() {
        return this.fDepth;
    }

    public Expression[] getStackVariables() {
        return this.fLocalVariables;
    }

    public void setStackVariables(Expression[] variables) {
        this.fLocalVariables = variables;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fFunctionName == null ? 0 : this.fFunctionName.hashCode());
        result = 31 * result + this.fDepth;
        result = 31 * result + this.fLineNumber;
        result = 31 * result + (this.fResolvedFileName == null ? 0 : this.fResolvedFileName.hashCode());
        result = 31 * result + (this.fThread == null ? 0 : ((Object)((Object)this.fThread)).hashCode());
        result = 31 * result + (this.fLocalVariables == null ? 0 : this.fLocalVariables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PHPStackFrame other = (PHPStackFrame)((Object)obj);
        if (this.fFunctionName == null ? other.fFunctionName != null : !this.fFunctionName.equals(other.fFunctionName)) {
            return false;
        }
        if (this.fDepth != other.fDepth) {
            return false;
        }
        if (this.fLineNumber != other.fLineNumber) {
            return false;
        }
        if (this.fResolvedFileName == null ? other.fResolvedFileName != null : !this.fResolvedFileName.equals(other.fResolvedFileName)) {
            return false;
        }
        if (this.fThread == null ? other.fThread != null : !((Object)((Object)this.fThread)).equals((Object)other.fThread)) {
            return false;
        }
        return !(this.fLocalVariables == null ? other.fLocalVariables != null : !this.fLocalVariables.equals(other.fLocalVariables));
    }
}

