/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import java_cup.runtime.lr_parser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.DefaultBindingResolver;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.ast.scanner.php4.PhpAstLexer;
import org.eclipse.php.internal.core.ast.scanner.php54.PhpAstParser;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class ASTParser {
    private static final Reader EMPTY_STRING_READER = new StringReader("");
    private final AST ast;
    private final ISourceModule sourceModule;

    private ASTParser(Reader reader, PHPVersion phpVersion, boolean useASPTags, boolean useShortTags) throws IOException {
        this(reader, phpVersion, useASPTags, useShortTags, null);
    }

    private ASTParser(Reader reader, PHPVersion phpVersion, boolean useASPTags, boolean useShortTags, ISourceModule sourceModule) throws IOException {
        this.sourceModule = sourceModule;
        this.ast = new AST(reader, phpVersion, useASPTags, useShortTags);
        this.ast.setDefaultNodeFlag(2);
        if (sourceModule != null) {
            this.ast.setFlag(Integer.MIN_VALUE);
            this.ast.setBindingResolver(new DefaultBindingResolver(sourceModule, sourceModule.getOwner()));
        }
    }

    public static ASTParser newParser(PHPVersion version, boolean useShortTags) {
        try {
            return new ASTParser(new StringReader(""), version, false, useShortTags);
        }
        catch (IOException iOException) {
            assert (false);
            return null;
        }
    }

    public static ASTParser newParser(PHPVersion version) {
        return ASTParser.newParser(version, true);
    }

    public static ASTParser newParser(ISourceModule sourceModule) {
        PHPVersion phpVersion = ProjectOptions.getPhpVersion(sourceModule.getScriptProject().getProject());
        return ASTParser.newParser(phpVersion, sourceModule);
    }

    public static ASTParser newParser(PHPVersion version, ISourceModule sourceModule) {
        if (sourceModule == null) {
            throw new IllegalStateException("ASTParser - Can't parser with null ISourceModule");
        }
        try {
            ASTParser parser = new ASTParser(new StringReader(""), version, false, ProjectOptions.useShortTags(sourceModule.getScriptProject().getProject()), sourceModule);
            parser.setSource(sourceModule.getSourceAsCharArray());
            return parser;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    public static ASTParser newParser(Reader reader, PHPVersion version, boolean useShortTags) throws IOException {
        return new ASTParser(reader, version, false, useShortTags);
    }

    public static ASTParser newParser(Reader reader, PHPVersion version, boolean useASPTags, boolean useShortTags) throws IOException {
        return new ASTParser(reader, version, useASPTags, useShortTags);
    }

    public static ASTParser newParser(Reader reader, PHPVersion version, boolean useASPTags, ISourceModule sourceModule) throws IOException {
        return new ASTParser(reader, version, useASPTags, ProjectOptions.useShortTags(sourceModule.getScriptProject().getProject()), sourceModule);
    }

    public void setSource(char[] source) throws IOException {
        CharArrayReader charArrayReader = new CharArrayReader(source);
        this.setSource(charArrayReader);
    }

    public void setSource(Reader source) throws IOException {
        this.ast.setSource(source);
    }

    public void setSource(ISourceModule sourceModule) throws IOException, ModelException {
        this.ast.setSource(new CharArrayReader(sourceModule.getSourceAsCharArray()));
    }

    public Program createAST(IProgressMonitor progressMonitor) throws Exception {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        progressMonitor.beginTask("Creating Abstract Syntax Tree for source...", 3);
        AstLexer lexer = this.ast.lexer();
        lr_parser phpParser = this.ast.parser();
        progressMonitor.worked(1);
        phpParser.setScanner((Scanner)lexer);
        progressMonitor.worked(2);
        Symbol symbol = phpParser.parse();
        progressMonitor.done();
        if (symbol == null || !(symbol.value instanceof Program)) {
            return null;
        }
        Program p = (Program)symbol.value;
        AST ast = p.getAST();
        p.setSourceModule(this.sourceModule);
        ast.setDefaultNodeFlag(0);
        ast.setOriginalModificationCount(ast.modificationCount());
        return p;
    }

    private static org.eclipse.php.internal.core.ast.scanner.php53.PhpAstLexer createEmptyLexer_53() {
        return new org.eclipse.php.internal.core.ast.scanner.php53.PhpAstLexer(EMPTY_STRING_READER);
    }

    private static org.eclipse.php.internal.core.ast.scanner.php56.PhpAstLexer createEmptyLexer_56() {
        return new org.eclipse.php.internal.core.ast.scanner.php56.PhpAstLexer(EMPTY_STRING_READER);
    }

    private static org.eclipse.php.internal.core.ast.scanner.php56.PhpAstParser createEmptyParser_56() {
        return new org.eclipse.php.internal.core.ast.scanner.php56.PhpAstParser(ASTParser.createEmptyLexer_56());
    }

    private static org.eclipse.php.internal.core.ast.scanner.php55.PhpAstLexer createEmptyLexer_55() {
        return new org.eclipse.php.internal.core.ast.scanner.php55.PhpAstLexer(EMPTY_STRING_READER);
    }

    private static org.eclipse.php.internal.core.ast.scanner.php55.PhpAstParser createEmptyParser_55() {
        return new org.eclipse.php.internal.core.ast.scanner.php55.PhpAstParser(ASTParser.createEmptyLexer_55());
    }

    private static org.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer createEmptyLexer_54() {
        return new org.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer(EMPTY_STRING_READER);
    }

    private static PhpAstParser createEmptyParser_54() {
        return new PhpAstParser(ASTParser.createEmptyLexer_54());
    }

    private static org.eclipse.php.internal.core.ast.scanner.php53.PhpAstParser createEmptyParser_53() {
        return new org.eclipse.php.internal.core.ast.scanner.php53.PhpAstParser(ASTParser.createEmptyLexer_53());
    }

    private static org.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer createEmptyLexer_5() {
        return new org.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer(EMPTY_STRING_READER);
    }

    private static org.eclipse.php.internal.core.ast.scanner.php5.PhpAstParser createEmptyParser_5() {
        return new org.eclipse.php.internal.core.ast.scanner.php5.PhpAstParser(ASTParser.createEmptyLexer_5());
    }

    private static PhpAstLexer createEmptyLexer_4() {
        return new PhpAstLexer(EMPTY_STRING_READER);
    }

    private static org.eclipse.php.internal.core.ast.scanner.php4.PhpAstParser createEmptyParser_4() {
        return new org.eclipse.php.internal.core.ast.scanner.php4.PhpAstParser(ASTParser.createEmptyLexer_4());
    }

    public static final Program parse(String phpCode, boolean aspTagsAsPhp, boolean useShortTags) throws Exception {
        StringReader reader = new StringReader(phpCode);
        return ASTParser.parse(reader, aspTagsAsPhp, ProjectOptions.getDefaultPhpVersion(), useShortTags);
    }

    public static final Program parse(File phpFile, boolean aspTagsAsPhp, boolean useShortTags) throws Exception {
        FileReader reader = new FileReader(phpFile);
        return ASTParser.parse(reader, aspTagsAsPhp, ProjectOptions.getDefaultPhpVersion(), useShortTags);
    }

    public static final Program parse(IDocument phpDocument, boolean aspTagsAsPhp, PHPVersion phpVersion, boolean useShortTags) throws Exception {
        return ASTParser.parse(phpDocument, aspTagsAsPhp, phpVersion, 0, phpDocument.getLength(), useShortTags);
    }

    public static final Program parse(final IDocument phpDocument, boolean aspTagsAsPhp, PHPVersion phpVersion, int offset, int length, boolean useShortTags) throws Exception {
        InputStreamReader reader = new InputStreamReader(new InputStream(offset, length){
            private int index;
            private final int size;
            {
                this.index = n;
                this.size = n + n2;
            }

            @Override
            public int read() throws IOException {
                try {
                    if (this.index < this.size) {
                        return phpDocument.getChar(this.index++);
                    }
                    return -1;
                }
                catch (BadLocationException e) {
                    throw new IOException(e.getMessage());
                }
            }
        });
        return ASTParser.parse(reader, aspTagsAsPhp, phpVersion, useShortTags);
    }

    public static final Program parse(IDocument phpDocument, boolean aspTagsAsPhp, boolean useShortTags) throws Exception {
        return ASTParser.parse(phpDocument, aspTagsAsPhp, ProjectOptions.getDefaultPhpVersion(), useShortTags);
    }

    public static final Program parse(String phpCode) throws Exception {
        return ASTParser.parse(phpCode, true, ProjectOptions.useShortTags(null));
    }

    public static final Program parse(File phpFile) throws Exception {
        return ASTParser.parse(phpFile, true, ProjectOptions.useShortTags(null));
    }

    public static final Program parse(Reader reader) throws Exception {
        return ASTParser.parse(reader, true, ProjectOptions.getDefaultPhpVersion(), ProjectOptions.useShortTags(null));
    }

    public static synchronized Program parse(Reader reader, boolean aspTagsAsPhp, PHPVersion phpVersion, boolean useShortTags) throws Exception {
        AST ast = new AST(EMPTY_STRING_READER, phpVersion, false, useShortTags);
        Scanner lexer = ASTParser.getLexer(ast, reader, phpVersion, aspTagsAsPhp, useShortTags);
        lr_parser phpParser = ASTParser.getParser(phpVersion, ast);
        phpParser.setScanner(lexer);
        Symbol symbol = phpParser.parse();
        return symbol == null ? null : (Program)symbol.value;
    }

    private static Scanner getLexer(AST ast, Reader reader, PHPVersion phpVersion, boolean aspTagsAsPhp, boolean useShortTags) throws IOException {
        if (PHPVersion.PHP4 == phpVersion) {
            PhpAstLexer lexer4 = ASTParser.getLexer4(reader);
            lexer4.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer4.setUseShortTags(useShortTags);
            lexer4.setAST(ast);
            return lexer4;
        }
        if (PHPVersion.PHP5 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer lexer5 = ASTParser.getLexer5(reader);
            lexer5.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer5.setUseShortTags(useShortTags);
            lexer5.setAST(ast);
            return lexer5;
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php53.PhpAstLexer lexer53 = ASTParser.getLexer53(reader);
            lexer53.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer53.setUseShortTags(useShortTags);
            lexer53.setAST(ast);
            return lexer53;
        }
        if (PHPVersion.PHP5_4 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer lexer54 = ASTParser.getLexer54(reader);
            lexer54.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer54.setUseShortTags(useShortTags);
            lexer54.setAST(ast);
            return lexer54;
        }
        if (PHPVersion.PHP5_5 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php55.PhpAstLexer lexer55 = ASTParser.getLexer55(reader);
            lexer55.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer55.setUseShortTags(useShortTags);
            lexer55.setAST(ast);
            return lexer55;
        }
        if (PHPVersion.PHP5_6 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php56.PhpAstLexer lexer56 = ASTParser.getLexer56(reader);
            lexer56.setUseAspTagsAsPhp(aspTagsAsPhp);
            lexer56.setUseShortTags(useShortTags);
            lexer56.setAST(ast);
            return lexer56;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + (Object)((Object)phpVersion));
    }

    private static lr_parser getParser(PHPVersion phpVersion, AST ast) throws IOException {
        if (PHPVersion.PHP4 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php4.PhpAstParser parser = ASTParser.createEmptyParser_4();
            parser.setAST(ast);
            return parser;
        }
        if (PHPVersion.PHP5 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php5.PhpAstParser parser = ASTParser.createEmptyParser_5();
            parser.setAST(ast);
            return parser;
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php53.PhpAstParser parser = ASTParser.createEmptyParser_53();
            parser.setAST(ast);
            return parser;
        }
        if (PHPVersion.PHP5_4 == phpVersion) {
            PhpAstParser parser = ASTParser.createEmptyParser_54();
            parser.setAST(ast);
            return parser;
        }
        if (PHPVersion.PHP5_5 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php55.PhpAstParser parser = ASTParser.createEmptyParser_55();
            parser.setAST(ast);
            return parser;
        }
        if (PHPVersion.PHP5_6 == phpVersion) {
            org.eclipse.php.internal.core.ast.scanner.php56.PhpAstParser parser = ASTParser.createEmptyParser_56();
            parser.setAST(ast);
            return parser;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + (Object)((Object)phpVersion));
    }

    private static org.eclipse.php.internal.core.ast.scanner.php56.PhpAstLexer getLexer56(Reader reader) throws IOException {
        org.eclipse.php.internal.core.ast.scanner.php56.PhpAstLexer phpAstLexer56 = ASTParser.createEmptyLexer_56();
        phpAstLexer56.yyreset(reader);
        phpAstLexer56.resetCommentList();
        return phpAstLexer56;
    }

    private static org.eclipse.php.internal.core.ast.scanner.php53.PhpAstLexer getLexer53(Reader reader) throws IOException {
        org.eclipse.php.internal.core.ast.scanner.php53.PhpAstLexer phpAstLexer53 = ASTParser.createEmptyLexer_53();
        phpAstLexer53.yyreset(reader);
        phpAstLexer53.resetCommentList();
        return phpAstLexer53;
    }

    private static org.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer getLexer54(Reader reader) throws IOException {
        org.eclipse.php.internal.core.ast.scanner.php54.PhpAstLexer phpAstLexer54 = ASTParser.createEmptyLexer_54();
        phpAstLexer54.yyreset(reader);
        phpAstLexer54.resetCommentList();
        return phpAstLexer54;
    }

    private static org.eclipse.php.internal.core.ast.scanner.php55.PhpAstLexer getLexer55(Reader reader) throws IOException {
        org.eclipse.php.internal.core.ast.scanner.php55.PhpAstLexer phpAstLexer55 = ASTParser.createEmptyLexer_55();
        phpAstLexer55.yyreset(reader);
        phpAstLexer55.resetCommentList();
        return phpAstLexer55;
    }

    private static org.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer getLexer5(Reader reader) throws IOException {
        org.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer phpAstLexer5 = ASTParser.createEmptyLexer_5();
        phpAstLexer5.yyreset(reader);
        phpAstLexer5.resetCommentList();
        return phpAstLexer5;
    }

    private static PhpAstLexer getLexer4(Reader reader) throws IOException {
        PhpAstLexer phpAstLexer4 = ASTParser.createEmptyLexer_4();
        phpAstLexer4.yyreset(reader);
        phpAstLexer4.resetCommentList();
        return phpAstLexer4;
    }
}

