/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ArrayAccess
extends Variable {
    public static final int VARIABLE_ARRAY = 1;
    public static final int VARIABLE_HASHTABLE = 2;
    private Expression index;
    private int arrayType;
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(ArrayAccess.class, "name", VariableBase.class, true, true);
    public static final SimplePropertyDescriptor DOLLARED_PROPERTY = new SimplePropertyDescriptor(ArrayAccess.class, "isDollared", Boolean.class, false);
    public static final ChildPropertyDescriptor INDEX_PROPERTY = new ChildPropertyDescriptor(ArrayAccess.class, "index", Expression.class, false, true);
    public static final SimplePropertyDescriptor ARRAY_TYPE_PROPERTY = new SimplePropertyDescriptor(ArrayAccess.class, "arrayType", Integer.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(4);
        propertyList.add(NAME_PROPERTY);
        propertyList.add(DOLLARED_PROPERTY);
        propertyList.add(INDEX_PROPERTY);
        propertyList.add(ARRAY_TYPE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    @Override
    public ChildPropertyDescriptor getNameProperty() {
        return NAME_PROPERTY;
    }

    @Override
    public SimplePropertyDescriptor getDollaredProperty() {
        return DOLLARED_PROPERTY;
    }

    public ArrayAccess(AST ast) {
        super(ast);
    }

    public ArrayAccess(int start, int end, AST ast, VariableBase variableName, Expression index, int arrayType) {
        super(start, end, ast, variableName);
        if (index != null) {
            this.setIndex(index);
        }
        this.setArrayType(arrayType);
    }

    public ArrayAccess(int start, int end, AST ast, VariableBase variableName, Expression index) {
        super(start, end, ast, variableName);
        if (index != null) {
            this.setIndex(index);
        }
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.getName().accept(visitor);
        if (this.index != null) {
            this.index.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getName().traverseTopDown(visitor);
        if (this.index != null) {
            this.index.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.getName().traverseBottomUp(visitor);
        if (this.index != null) {
            this.index.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ArrayAccess");
        this.appendInterval(buffer);
        buffer.append(" type='").append(ArrayAccess.getArrayType(this.arrayType)).append("'>\n");
        this.getName().toString(buffer, "\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("<Index>\n");
        if (this.index != null) {
            this.index.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Index>\n");
        buffer.append(tab).append("</ArrayAccess>");
    }

    public static String getArrayType(int type) {
        switch (type) {
            case 1: {
                return "array";
            }
            case 2: {
                return "hashtable";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public int getType() {
        return 0;
    }

    public Expression getIndex() {
        return this.index;
    }

    public void setIndex(Expression index) {
        if (index == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.index;
        this.preReplaceChild(oldChild, index, INDEX_PROPERTY);
        this.index = index;
        this.postReplaceChild(oldChild, index, INDEX_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == INDEX_PROPERTY) {
            if (get) {
                return this.getIndex();
            }
            this.setIndex((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    public int getArrayType() {
        return this.arrayType;
    }

    public final void setArrayType(int value) {
        if (ArrayAccess.getArrayType(value) == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(ARRAY_TYPE_PROPERTY);
        this.arrayType = value;
        this.postValueChange(ARRAY_TYPE_PROPERTY);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == ARRAY_TYPE_PROPERTY) {
            if (get) {
                return this.getArrayType();
            }
            this.setArrayType(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    public void setName(VariableBase variableName) {
        super.setName(variableName);
    }

    @Override
    public VariableBase getName() {
        return (VariableBase)super.getName();
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        VariableBase expr = ASTNode.copySubtree(target, this.getName());
        Expression index = ASTNode.copySubtree(target, this.getIndex());
        int type = this.getArrayType();
        ArrayAccess result = new ArrayAccess(this.getStart(), this.getEnd(), target, expr, index, type);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

