/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.rewrite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.compiler.util.ScannerHelper;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTError;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ChainingInstanceCall;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.ast.nodes.DeclareStatement;
import org.eclipse.php.internal.core.ast.nodes.DereferenceNode;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.ast.nodes.EmptyStatement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FinallyClause;
import org.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.GotoLabel;
import org.eclipse.php.internal.core.ast.nodes.GotoStatement;
import org.eclipse.php.internal.core.ast.nodes.IOperationNode;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.IgnoreError;
import org.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.MethodStub;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.PHPArrayDereferenceList;
import org.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Quote;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitAlias;
import org.eclipse.php.internal.core.ast.nodes.TraitAliasStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.internal.core.ast.nodes.TraitPrecedence;
import org.eclipse.php.internal.core.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.nodes.YieldExpression;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewriteFlattener;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewriteFormatter;
import org.eclipse.php.internal.core.ast.rewrite.IndentManipulation;
import org.eclipse.php.internal.core.ast.rewrite.LineCommentEndOffsets;
import org.eclipse.php.internal.core.ast.rewrite.LineInformation;
import org.eclipse.php.internal.core.ast.rewrite.NodeInfoStore;
import org.eclipse.php.internal.core.ast.rewrite.RewriteEvent;
import org.eclipse.php.internal.core.ast.rewrite.RewriteEventStore;
import org.eclipse.php.internal.core.ast.rewrite.SourceModifier;
import org.eclipse.php.internal.core.ast.rewrite.SymbolsProvider;
import org.eclipse.php.internal.core.ast.rewrite.TargetSourceRangeComputer;
import org.eclipse.php.internal.core.ast.rewrite.TokenScanner;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org.eclipse.text.edits.CopySourceEdit;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ISourceModifier;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public final class ASTRewriteAnalyzer
extends AbstractVisitor {
    private static final String CURLY_CLOSE = "}";
    TextEdit currentEdit;
    final RewriteEventStore eventStore;
    private TokenScanner tokenScanner;
    private final Map sourceCopyInfoToEdit;
    private final Stack sourceCopyEndNodes;
    private final char[] content;
    private final IDocument document;
    private final LineInformation lineInfo;
    private final ASTRewriteFormatter formatter;
    private final NodeInfoStore nodeInfos;
    private final TargetSourceRangeComputer extendedSourceRangeComputer;
    private final LineCommentEndOffsets lineCommentEndOffsets;
    private final AstLexer scanner;
    private boolean isInsertUseStatement;

    public ASTRewriteAnalyzer(AstLexer scanner, IDocument document, LineInformation lineInfo, String lineDelim, TextEdit rootEdit, RewriteEventStore eventStore, NodeInfoStore nodeInfos, List comments, Map options, TargetSourceRangeComputer extendedSourceRangeComputer) {
        this.scanner = scanner;
        this.eventStore = eventStore;
        this.document = document;
        this.content = document.get().toCharArray();
        this.lineInfo = lineInfo;
        this.nodeInfos = nodeInfos;
        this.tokenScanner = null;
        this.currentEdit = rootEdit;
        this.sourceCopyInfoToEdit = new IdentityHashMap();
        this.sourceCopyEndNodes = new Stack();
        this.formatter = new ASTRewriteFormatter(document, nodeInfos, eventStore, options, lineDelim, scanner.getPHPVersion(), true);
        this.extendedSourceRangeComputer = extendedSourceRangeComputer;
        this.lineCommentEndOffsets = new LineCommentEndOffsets(comments);
    }

    final TokenScanner getScanner() {
        if (this.tokenScanner == null) {
            try {
                this.tokenScanner = new TokenScanner(this.scanner, this.content);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return this.tokenScanner;
    }

    final char[] getContent() {
        return this.content;
    }

    final LineInformation getLineInformation() {
        return this.lineInfo;
    }

    final TargetSourceRangeComputer.SourceRange getExtendedRange(ASTNode node) {
        if (this.eventStore.isRangeCopyPlaceholder(node)) {
            return new TargetSourceRangeComputer.SourceRange(node.getStart(), node.getLength());
        }
        return this.extendedSourceRangeComputer.computeSourceRange(node);
    }

    final int getExtendedOffset(ASTNode node) {
        return this.getExtendedRange(node).getStartPosition();
    }

    final int getExtendedEnd(ASTNode node) {
        TargetSourceRangeComputer.SourceRange range = this.getExtendedRange(node);
        return range.getStartPosition() + range.getLength();
    }

    final TextEdit getCopySourceEdit(RewriteEventStore.CopySourceInfo info) {
        TextEdit edit = (TextEdit)this.sourceCopyInfoToEdit.get(info);
        if (edit == null) {
            TargetSourceRangeComputer.SourceRange range = this.getExtendedRange(info.getNode());
            int start = range.getStartPosition();
            int end = start + range.getLength();
            if (info.isMove) {
                MoveSourceEdit moveSourceEdit = new MoveSourceEdit(start, end - start);
                moveSourceEdit.setTargetEdit(new MoveTargetEdit(0));
                edit = moveSourceEdit;
            } else {
                CopySourceEdit copySourceEdit = new CopySourceEdit(start, end - start);
                copySourceEdit.setTargetEdit(new CopyTargetEdit(0));
                edit = copySourceEdit;
            }
            this.sourceCopyInfoToEdit.put(info, edit);
        }
        return edit;
    }

    private final int getChangeKind(ASTNode node, StructuralPropertyDescriptor property) {
        RewriteEvent event = this.getEvent(node, property);
        if (event != null) {
            return event.getChangeKind();
        }
        return 0;
    }

    private final boolean hasChildrenChanges(ASTNode node) {
        return this.eventStore.hasChangedProperties(node);
    }

    private final boolean isChanged(ASTNode node, StructuralPropertyDescriptor property) {
        RewriteEvent event = this.getEvent(node, property);
        if (event != null) {
            return event.getChangeKind() != 0;
        }
        return false;
    }

    private final boolean isCollapsed(ASTNode node) {
        return this.nodeInfos.isCollapsed(node);
    }

    final boolean isInsertBoundToPrevious(ASTNode node) {
        return this.eventStore.isInsertBoundToPrevious(node);
    }

    private final TextEditGroup getEditGroup(ASTNode parent, StructuralPropertyDescriptor property) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            return this.getEditGroup(event);
        }
        return null;
    }

    final RewriteEvent getEvent(ASTNode parent, StructuralPropertyDescriptor property) {
        return this.eventStore.getEvent(parent, property);
    }

    final TextEditGroup getEditGroup(RewriteEvent change) {
        return this.eventStore.getEventEditGroup(change);
    }

    private final Object getOriginalValue(ASTNode parent, StructuralPropertyDescriptor property) {
        return this.eventStore.getOriginalValue(parent, property);
    }

    private final Object getNewValue(ASTNode parent, StructuralPropertyDescriptor property) {
        return this.eventStore.getNewValue(parent, property);
    }

    final void addEdit(TextEdit edit) {
        this.currentEdit.addChild(edit);
    }

    final String getLineDelimiter() {
        return this.formatter.getLineDelimiter();
    }

    final String createIndentString(int indent) {
        return this.formatter.createIndentString(indent);
    }

    private final String getIndentOfLine(int pos) {
        int line = this.getLineInformation().getLineOfOffset(pos);
        if (line >= 0) {
            int lineStart;
            char[] cont = this.getContent();
            int i = lineStart = this.getLineInformation().getLineOffset(line);
            while (i < cont.length && IndentManipulation.isIndentChar(this.content[i])) {
                ++i;
            }
            return new String(cont, lineStart, i - lineStart);
        }
        return new String();
    }

    final String getIndentAtOffset(int pos) {
        return this.formatter.getIndentString(this.getIndentOfLine(pos));
    }

    final void doTextInsert(int offset, String insertString, TextEditGroup editGroup) {
        if (this.isInsertUseStatement && insertString.trim().length() > 0) {
            insertString = insertString.replaceAll("\r", "").replaceAll("\n", "");
        }
        if (insertString.length() > 0) {
            InsertEdit edit;
            if (this.lineCommentEndOffsets.isEndOfLineComment(offset, this.content)) {
                if (!insertString.startsWith(this.getLineDelimiter())) {
                    edit = new InsertEdit(offset, this.getLineDelimiter());
                    this.addEdit((TextEdit)edit);
                    if (editGroup != null) {
                        this.addEditGroup(editGroup, (TextEdit)edit);
                    }
                }
                this.lineCommentEndOffsets.remove(offset);
            }
            edit = new InsertEdit(offset, insertString);
            this.addEdit((TextEdit)edit);
            if (editGroup != null) {
                this.addEditGroup(editGroup, (TextEdit)edit);
            }
        }
    }

    final void addEditGroup(TextEditGroup editGroup, TextEdit edit) {
        editGroup.addTextEdit(edit);
    }

    final TextEdit doTextRemove(int offset, int len, TextEditGroup editGroup) {
        if (len == 0) {
            return null;
        }
        DeleteEdit edit = new DeleteEdit(offset, len);
        this.addEdit((TextEdit)edit);
        if (editGroup != null) {
            this.addEditGroup(editGroup, (TextEdit)edit);
        }
        return edit;
    }

    final void doTextRemoveAndVisit(int offset, int len, ASTNode node, TextEditGroup editGroup) {
        TextEdit edit = this.doTextRemove(offset, len, editGroup);
        if (edit != null) {
            this.currentEdit = edit;
            this.voidVisit(node);
            this.currentEdit = edit.getParent();
        } else {
            this.voidVisit(node);
        }
    }

    final int doVisit(ASTNode node) {
        node.accept(this);
        return this.getExtendedEnd(node);
    }

    private final int doVisit(ASTNode parent, StructuralPropertyDescriptor property, int offset) {
        Object node = this.getOriginalValue(parent, property);
        if (property.isChildProperty() && node != null) {
            return this.doVisit((ASTNode)node);
        }
        if (property.isChildListProperty()) {
            return this.doVisitList((List)node, offset);
        }
        return offset;
    }

    private int doVisitList(List list, int offset) {
        int endPos = offset;
        for (ASTNode curr : list) {
            endPos = this.doVisit(curr);
        }
        return endPos;
    }

    final void voidVisit(ASTNode node) {
        node.accept(this);
    }

    private final void voidVisit(ASTNode parent, StructuralPropertyDescriptor property) {
        Object node = this.getOriginalValue(parent, property);
        if (property.isChildProperty() && node != null) {
            this.voidVisit((ASTNode)node);
        } else if (property.isChildListProperty()) {
            this.voidVisitList((List)node);
        }
    }

    private void voidVisitList(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.doVisit((ASTNode)iter.next());
        }
    }

    private final boolean doVisitUnchangedChildren(ASTNode parent) {
        List<StructuralPropertyDescriptor> properties = parent.structuralPropertiesForType();
        int i = 0;
        while (i < properties.size()) {
            this.voidVisit(parent, properties.get(i));
            ++i;
        }
        return false;
    }

    private final void doTextReplace(int offset, int len, String insertString, TextEditGroup editGroup) {
        if (len > 0 || insertString.length() > 0) {
            ReplaceEdit edit = new ReplaceEdit(offset, len, insertString);
            this.addEdit((TextEdit)edit);
            if (editGroup != null) {
                this.addEditGroup(editGroup, (TextEdit)edit);
            }
        }
    }

    private final TextEdit doTextCopy(TextEdit sourceEdit, int destOffset, int sourceIndentLevel, String destIndentString, TextEditGroup editGroup) {
        MoveTargetEdit targetEdit;
        SourceModifier modifier = new SourceModifier(sourceIndentLevel, destIndentString, this.formatter.getTabWidth(), this.formatter.getIndentWidth());
        if (sourceEdit instanceof MoveSourceEdit) {
            MoveSourceEdit moveEdit = (MoveSourceEdit)sourceEdit;
            moveEdit.setSourceModifier((ISourceModifier)modifier);
            targetEdit = new MoveTargetEdit(destOffset, moveEdit);
            this.addEdit((TextEdit)targetEdit);
        } else {
            CopySourceEdit copyEdit = (CopySourceEdit)sourceEdit;
            copyEdit.setSourceModifier((ISourceModifier)modifier);
            targetEdit = new CopyTargetEdit(destOffset, copyEdit);
            this.addEdit((TextEdit)targetEdit);
        }
        if (editGroup != null) {
            this.addEditGroup(editGroup, sourceEdit);
            this.addEditGroup(editGroup, (TextEdit)targetEdit);
        }
        return targetEdit;
    }

    private void changeNotSupported(ASTNode node) {
        Assert.isTrue((boolean)false, (String)("Change not supported in " + node.getClass().getName()));
    }

    private int rewriteRequiredNode(ASTNode parent, StructuralPropertyDescriptor property) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null && event.getChangeKind() == 4) {
            ASTNode node = (ASTNode)event.getOriginalValue();
            TextEditGroup editGroup = this.getEditGroup(event);
            TargetSourceRangeComputer.SourceRange range = this.getExtendedRange(node);
            int offset = range.getStartPosition();
            int length = range.getLength();
            this.doTextRemoveAndVisit(offset, length, node, editGroup);
            this.doTextInsert(offset, (ASTNode)event.getNewValue(), this.getIndent(offset), true, editGroup);
            return offset + length;
        }
        return this.doVisit(parent, property, 0);
    }

    private int rewriteNode(ASTNode parent, StructuralPropertyDescriptor property, int offset, ASTRewriteFormatter.Prefix prefix) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            switch (event.getChangeKind()) {
                case 1: {
                    ASTNode node = (ASTNode)event.getNewValue();
                    TextEditGroup editGroup = this.getEditGroup(event);
                    int indent = this.getIndent(offset);
                    this.doTextInsert(offset, prefix.getPrefix(indent), editGroup);
                    this.doTextInsert(offset, node, indent, true, editGroup);
                    return offset;
                }
                case 2: {
                    ASTNode node = (ASTNode)event.getOriginalValue();
                    TextEditGroup editGroup = this.getEditGroup(event);
                    int nodeEnd = this.getExtendedEnd(node);
                    int len = nodeEnd - offset;
                    this.doTextRemoveAndVisit(offset, len, node, editGroup);
                    return nodeEnd;
                }
                case 4: {
                    ASTNode node = (ASTNode)event.getOriginalValue();
                    TextEditGroup editGroup = this.getEditGroup(event);
                    TargetSourceRangeComputer.SourceRange range = this.getExtendedRange(node);
                    int nodeOffset = range.getStartPosition();
                    int nodeLen = range.getLength();
                    this.doTextRemoveAndVisit(nodeOffset, nodeLen, node, editGroup);
                    this.doTextInsert(nodeOffset, (ASTNode)event.getNewValue(), this.getIndent(offset), true, editGroup);
                    return nodeOffset + nodeLen;
                }
            }
        }
        return this.doVisit(parent, property, offset);
    }

    private int rewriteDocumentation(ASTNode node, StructuralPropertyDescriptor property) {
        int pos = this.rewriteNode(node, property, node.getStart(), ASTRewriteFormatter.NONE);
        int changeKind = this.getChangeKind(node, property);
        if (changeKind == 1) {
            String indent = String.valueOf(this.getLineDelimiter()) + this.getIndentAtOffset(pos);
            this.doTextInsert(pos, indent, this.getEditGroup(node, property));
        } else if (changeKind == 2) {
            try {
                this.getScanner().readNext(pos);
                this.doTextRemove(pos, this.getScanner().getCurrentStartOffset() - pos, this.getEditGroup(node, property));
                pos = this.getScanner().getCurrentStartOffset();
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        }
        return pos;
    }

    private int rewriteBodyNode(ASTNode parent, StructuralPropertyDescriptor property, int offset, int endPos, int indent, ASTRewriteFormatter.BlockContext context) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            switch (event.getChangeKind()) {
                case 1: {
                    ASTNode node = (ASTNode)event.getNewValue();
                    TextEditGroup editGroup = this.getEditGroup(event);
                    String[] strings = context.getPrefixAndSuffix(indent, node, this.eventStore);
                    this.doTextInsert(offset, strings[0], editGroup);
                    this.doTextInsert(offset, node, indent, true, editGroup);
                    this.doTextInsert(offset, strings[1], editGroup);
                    return offset;
                }
                case 2: {
                    ASTNode node = (ASTNode)event.getOriginalValue();
                    if (endPos == -1) {
                        endPos = this.getExtendedEnd(node);
                    }
                    TextEditGroup editGroup = this.getEditGroup(event);
                    int len = endPos - offset;
                    this.doTextRemoveAndVisit(offset, len, node, editGroup);
                    return endPos;
                }
                case 4: {
                    ASTNode node = (ASTNode)event.getOriginalValue();
                    if (endPos == -1) {
                        endPos = this.getExtendedEnd(node);
                    }
                    TextEditGroup editGroup = this.getEditGroup(event);
                    int nodeLen = endPos - offset;
                    ASTNode replacingNode = (ASTNode)event.getNewValue();
                    String[] strings = context.getPrefixAndSuffix(indent, replacingNode, this.eventStore);
                    this.doTextRemoveAndVisit(offset, nodeLen, node, editGroup);
                    String prefix = strings[0];
                    this.doTextInsert(offset, prefix, editGroup);
                    String lineInPrefix = this.getCurrentLine(prefix, prefix.length());
                    if (prefix.length() != lineInPrefix.length()) {
                        indent = this.formatter.computeIndentUnits(lineInPrefix);
                    }
                    this.doTextInsert(offset, replacingNode, indent, true, editGroup);
                    this.doTextInsert(offset, strings[1], editGroup);
                    return endPos;
                }
            }
        }
        int pos = this.doVisit(parent, property, offset);
        if (endPos != -1) {
            return endPos;
        }
        return pos;
    }

    private int rewriteOptionalQualifier(ASTNode parent, StructuralPropertyDescriptor property, int startPos) {
        Object node;
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            switch (event.getChangeKind()) {
                case 1: {
                    ASTNode node2 = (ASTNode)event.getNewValue();
                    TextEditGroup editGroup = this.getEditGroup(event);
                    this.doTextInsert(startPos, node2, this.getIndent(startPos), true, editGroup);
                    this.doTextInsert(startPos, ".", editGroup);
                    return startPos;
                }
                case 2: {
                    try {
                        ASTNode node3 = (ASTNode)event.getOriginalValue();
                        TextEditGroup editGroup = this.getEditGroup(event);
                        int dotEnd = this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(26, this.scanner.getPHPVersion()), node3.getStart() + node3.getLength());
                        this.doTextRemoveAndVisit(startPos, dotEnd - startPos, node3, editGroup);
                        return dotEnd;
                    }
                    catch (CoreException e) {
                        this.handleException(e);
                        break;
                    }
                }
                case 4: {
                    node = (ASTNode)event.getOriginalValue();
                    TextEditGroup editGroup = this.getEditGroup(event);
                    TargetSourceRangeComputer.SourceRange range = this.getExtendedRange((ASTNode)node);
                    int offset = range.getStartPosition();
                    int length = range.getLength();
                    this.doTextRemoveAndVisit(offset, length, (ASTNode)node, editGroup);
                    this.doTextInsert(offset, (ASTNode)event.getNewValue(), this.getIndent(startPos), true, editGroup);
                    try {
                        return this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(26, this.scanner.getPHPVersion()), offset + length);
                    }
                    catch (CoreException e) {
                        this.handleException(e);
                    }
                }
            }
        }
        if ((node = this.getOriginalValue(parent, property)) == null) {
            return startPos;
        }
        ASTNode astNode = (ASTNode)node;
        int pos = this.doVisit(astNode);
        try {
            return this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(0, this.scanner.getPHPVersion()), pos);
        }
        catch (CoreException e) {
            this.handleException(e);
            return pos;
        }
    }

    private int rewriteParagraphList(ASTNode parent, StructuralPropertyDescriptor property, int insertPos, int insertIndent, int separator, int lead) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event == null || event.getChangeKind() == 0) {
            return this.doVisit(parent, property, insertPos);
        }
        RewriteEvent[] events = event.getChildren();
        ParagraphListRewriter listRewriter = new ParagraphListRewriter(insertIndent, separator);
        StringBuffer leadString = new StringBuffer();
        if (this.isAllOfKind(events, 1)) {
            int i = 0;
            while (i < lead) {
                leadString.append(this.getLineDelimiter());
                ++i;
            }
            leadString.append(this.createIndentString(insertIndent));
        }
        return listRewriter.rewriteList(parent, property, insertPos, leadString.toString());
    }

    private int rewriteOptionalTypeParameters(ASTNode parent, StructuralPropertyDescriptor property, int offset, String keyword, boolean adjustOnNext, boolean needsSpaceOnRemoveAll) {
        int pos = offset;
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null && event.getChangeKind() != 0) {
            RewriteEvent[] children = event.getChildren();
            try {
                boolean isAllRemoved;
                boolean isAllInserted = this.isAllOfKind(children, 1);
                if (isAllInserted && adjustOnNext) {
                    pos = this.getScanner().getNextStartOffset(pos);
                }
                boolean bl = isAllRemoved = !isAllInserted && this.isAllOfKind(children, 2);
                if (isAllRemoved) {
                    int posBeforeOpenBracket = this.getScanner().getTokenStartOffset(SymbolsProvider.getSymbol(1, this.scanner.getPHPVersion()), pos);
                    if (posBeforeOpenBracket != pos) {
                        needsSpaceOnRemoveAll = false;
                    }
                    pos = posBeforeOpenBracket;
                }
                pos = new ListRewriter().rewriteList(parent, property, pos, String.valueOf('<'), ", ");
                if (isAllRemoved) {
                    int endPos = this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(2, this.scanner.getPHPVersion()), pos);
                    endPos = this.getScanner().getNextStartOffset(endPos);
                    String replacement = needsSpaceOnRemoveAll ? String.valueOf(' ') : new String();
                    this.doTextReplace(pos, endPos - pos, replacement, this.getEditGroup(children[children.length - 1]));
                    return endPos;
                }
                if (isAllInserted) {
                    this.doTextInsert(pos, String.valueOf(String.valueOf('>') + keyword), this.getEditGroup(children[children.length - 1]));
                    return pos;
                }
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        } else {
            pos = this.doVisit(parent, property, pos);
        }
        if (pos != offset) {
            try {
                return this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(2, this.scanner.getPHPVersion()), pos);
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        }
        return pos;
    }

    private boolean isAllOfKind(RewriteEvent[] children, int kind) {
        int i = 0;
        while (i < children.length) {
            if (children[i].getChangeKind() != kind) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int rewriteNodeList(ASTNode parent, StructuralPropertyDescriptor property, int pos, String keyword, String separator) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null && event.getChangeKind() != 0) {
            return new ListRewriter().rewriteList(parent, property, pos, keyword, separator);
        }
        return this.doVisit(parent, property, pos);
    }

    private void rewriteVariableDollar(Variable variable) {
        RewriteEvent event = this.getEvent(variable, variable.getDollaredProperty());
        if (event != null && event.getChangeKind() == 4) {
            TextEditGroup editGroup = this.getEditGroup(event);
            if (((Boolean)event.getNewValue()).booleanValue()) {
                this.doTextInsert(variable.getStart(), "$", editGroup);
            } else {
                this.doTextRemove(variable.getStart(), 1, editGroup);
            }
        }
    }

    private int getLeftBraceStartPosition(int pos) throws CoreException {
        return this.getSymbolStartPosition(pos, SymbolsProvider.getSymbol(6, this.scanner.getPHPVersion()));
    }

    private int getRightBraceStartPosition(int pos) throws CoreException {
        return this.getSymbolStartPosition(pos, SymbolsProvider.getSymbol(5, this.scanner.getPHPVersion()));
    }

    private int getLeftParenthesesStartPosition(int pos) throws CoreException {
        return this.getSymbolStartPosition(pos, SymbolsProvider.getSymbol(8, this.scanner.getPHPVersion()));
    }

    private int getRightParenthesesStartPosition(int pos) throws CoreException {
        return this.getSymbolStartPosition(pos, SymbolsProvider.getSymbol(7, this.scanner.getPHPVersion()));
    }

    private int getLeftBracketStartPosition(int pos) throws CoreException {
        return this.getSymbolStartPosition(pos, SymbolsProvider.getSymbol(4, this.scanner.getPHPVersion()));
    }

    private int getRightBracketStartPosition(int pos) throws CoreException {
        return this.getSymbolStartPosition(pos, SymbolsProvider.getSymbol(3, this.scanner.getPHPVersion()));
    }

    private int getSymbolStartPosition(int pos, Symbol sym) throws CoreException {
        return this.getScanner().getTokenStartOffset(sym, pos);
    }

    final int getIndent(int offset) {
        return this.formatter.computeIndentUnits(this.getIndentOfLine(offset));
    }

    private int getCurrentLineStart(String str, int pos) {
        int i = pos - 1;
        while (i >= 0) {
            char ch = str.charAt(i);
            if (IndentManipulation.isLineDelimiterChar(ch)) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    final void doTextInsert(int insertOffset, ASTNode node, int initialIndentLevel, boolean removeLeadingIndent, TextEditGroup editGroup) {
        ArrayList<ASTRewriteFormatter.NodeMarker> markers = new ArrayList<ASTRewriteFormatter.NodeMarker>();
        String formatted = this.formatter.getFormattedResult(node, initialIndentLevel, markers);
        int currPos = 0;
        if (removeLeadingIndent) {
            while (currPos < formatted.length() && ScannerHelper.isWhitespace((char)formatted.charAt(currPos))) {
                ++currPos;
            }
        }
        int i = 0;
        while (i < markers.size()) {
            Object data;
            ASTRewriteFormatter.NodeMarker curr = markers.get(i);
            int offset = curr.offset;
            if (offset != currPos) {
                String insertStr = formatted.substring(currPos, offset);
                this.doTextInsert(insertOffset, insertStr, editGroup);
            }
            if ((data = curr.data) instanceof TextEditGroup) {
                RangeMarker edit = new RangeMarker(insertOffset, 0);
                this.addEditGroup((TextEditGroup)data, (TextEdit)edit);
                this.addEdit((TextEdit)edit);
                if (curr.length != 0) {
                    int end = offset + curr.length;
                    int k = i + 1;
                    while (k < markers.size() && markers.get((int)k).offset < end) {
                        ++k;
                    }
                    curr.offset = end;
                    curr.length = 0;
                    markers.add(k, curr);
                }
                currPos = offset;
            } else {
                String destIndentString;
                int lineOffset = this.getCurrentLineStart(formatted, offset);
                String string = destIndentString = lineOffset == 0 ? this.formatter.createIndentString(initialIndentLevel) : this.formatter.getIndentString(this.getCurrentLine(formatted, offset));
                if (data instanceof NodeInfoStore.CopyPlaceholderData) {
                    RewriteEventStore.CopySourceInfo copySource = ((NodeInfoStore.CopyPlaceholderData)data).copySource;
                    int srcIndentLevel = this.getIndent(copySource.getNode().getStart());
                    TextEdit sourceEdit = this.getCopySourceEdit(copySource);
                    this.doTextCopy(sourceEdit, insertOffset, srcIndentLevel, destIndentString, editGroup);
                    currPos = offset + curr.length;
                    if (this.needsNewLineForLineComment(copySource.getNode(), formatted, currPos)) {
                        this.doTextInsert(insertOffset, this.getLineDelimiter(), editGroup);
                    }
                } else if (data instanceof NodeInfoStore.StringPlaceholderData) {
                    String code = ((NodeInfoStore.StringPlaceholderData)data).code;
                    String str = this.formatter.changeIndent(code, 0, destIndentString);
                    this.doTextInsert(insertOffset, str, editGroup);
                    currPos = offset + curr.length;
                }
            }
            ++i;
        }
        if (currPos < formatted.length()) {
            String insertStr = formatted.substring(currPos);
            if (node instanceof MethodStub && insertStr.startsWith(CURLY_CLOSE)) {
                this.doTextInsert(insertOffset, this.getLineDelimiter(), editGroup);
                String destIndentString = this.formatter.getIndentString(this.getCurrentLine(formatted, currPos));
                this.doTextInsert(insertOffset, destIndentString, editGroup);
            }
            this.doTextInsert(insertOffset, insertStr, editGroup);
        }
    }

    private boolean needsNewLineForLineComment(ASTNode node, String formatted, int offset) {
        if (!this.lineCommentEndOffsets.isEndOfLineComment(this.getExtendedEnd(node), this.content)) {
            return false;
        }
        return offset < formatted.length() && !IndentManipulation.isLineDelimiterChar(formatted.charAt(offset));
    }

    private String getCurrentLine(String str, int pos) {
        int i = pos - 1;
        while (i >= 0) {
            char ch = str.charAt(i);
            if (IndentManipulation.isLineDelimiterChar(ch)) {
                return str.substring(i + 1, pos);
            }
            --i;
        }
        return str.substring(0, pos);
    }

    private void rewriteModifiers(ASTNode parent, StructuralPropertyDescriptor property, int offset) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event == null || event.getChangeKind() != 4) {
            return;
        }
        try {
            int addedModifiers;
            int startPos;
            int oldModifiers = (Integer)event.getOriginalValue();
            int newModifiers = (Integer)event.getNewValue();
            TextEditGroup editGroup = this.getEditGroup(event);
            TokenScanner scanner = this.getScanner();
            Symbol tok = scanner.readNext(offset);
            int nextStart = startPos = scanner.getCurrentStartOffset();
            PHPVersion phpVersion = this.scanner.getPHPVersion();
            int[] modifiers = new int[]{SymbolsProvider.getModifierSym("public", phpVersion), SymbolsProvider.getModifierSym("private", phpVersion), SymbolsProvider.getModifierSym("protected", phpVersion), SymbolsProvider.getModifierSym("static", phpVersion), SymbolsProvider.getModifierSym("abstract", phpVersion), SymbolsProvider.getModifierSym("final", phpVersion)};
            while (true) {
                if (TokenScanner.isComment(tok)) {
                    tok = scanner.readNext();
                }
                boolean keep = true;
                if (tok == null) break;
                if (tok.sym == modifiers[0]) {
                    keep = PHPFlags.isPublic((int)newModifiers);
                } else if (tok.sym == modifiers[1]) {
                    keep = PHPFlags.isPrivate((int)newModifiers);
                } else if (tok.sym == modifiers[2]) {
                    keep = PHPFlags.isProtected((int)newModifiers);
                } else if (tok.sym == modifiers[3]) {
                    keep = PHPFlags.isStatic((int)newModifiers);
                } else if (tok.sym == modifiers[4]) {
                    keep = PHPFlags.isAbstract((int)newModifiers);
                } else {
                    if (tok.sym != modifiers[5]) break;
                    keep = PHPFlags.isFinal((int)newModifiers);
                }
                tok = this.getScanner().readNext();
                int currPos = nextStart;
                nextStart = this.getScanner().getCurrentStartOffset();
                if (keep) continue;
                this.doTextRemove(currPos, nextStart - currPos, editGroup);
            }
            if ((addedModifiers = newModifiers & ~oldModifiers) != 0) {
                int visibilityModifiers;
                if (startPos != nextStart && (visibilityModifiers = addedModifiers & 0x70) != 0) {
                    StringBuffer buf = new StringBuffer();
                    ASTRewriteFlattener.printModifiers(visibilityModifiers, buf);
                    this.doTextInsert(startPos, buf.toString(), editGroup);
                    addedModifiers &= ~visibilityModifiers;
                }
                StringBuffer buf = new StringBuffer();
                ASTRewriteFlattener.printModifiers(addedModifiers, buf);
                this.doTextInsert(nextStart, buf.toString(), editGroup);
            }
        }
        catch (CoreException e) {
            this.handleException(e);
        }
    }

    private int rewriteModifiers2(ASTNode node, ChildListPropertyDescriptor property, int pos) {
        return 0;
    }

    private void replaceOperation(int posBeforeOperation, String newOperation, TextEditGroup editGroup) {
        try {
            this.getScanner().readNext(posBeforeOperation);
            this.doTextReplace(this.getScanner().getCurrentStartOffset(), this.getScanner().getCurrentLength(), newOperation, editGroup);
        }
        catch (CoreException e) {
            this.handleException(e);
        }
    }

    private void rewriteOperation(ASTNode parent, StructuralPropertyDescriptor property, int posBeforeOperation) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null && event.getChangeKind() != 0) {
            try {
                String newOperation = event.getNewValue().toString();
                if (!(parent instanceof IOperationNode)) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.php.core", "The node must be an IOperationNode"));
                }
                newOperation = ((IOperationNode)((Object)parent)).getOperationString((Integer)event.getNewValue());
                TextEditGroup editGroup = this.getEditGroup(event);
                this.getScanner().readNext(posBeforeOperation);
                this.doTextReplace(this.getScanner().getCurrentStartOffset(), this.getScanner().getCurrentLength(), newOperation, editGroup);
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public void postVisit(ASTNode node) {
        TextEditGroup editGroup = this.eventStore.getTrackedNodeData(node);
        if (editGroup != null) {
            this.currentEdit = this.currentEdit.getParent();
        }
        this.doCopySourcePostVisit(node, this.sourceCopyEndNodes);
    }

    @Override
    public void preVisit(ASTNode node) {
        RewriteEventStore.CopySourceInfo[] infos = this.eventStore.getNodeCopySources(node);
        this.doCopySourcePreVisit(infos, this.sourceCopyEndNodes);
        TextEditGroup editGroup = this.eventStore.getTrackedNodeData(node);
        if (editGroup != null) {
            TargetSourceRangeComputer.SourceRange range = this.getExtendedRange(node);
            int offset = range.getStartPosition();
            int length = range.getLength();
            RangeMarker edit = new RangeMarker(offset, length);
            this.addEditGroup(editGroup, (TextEdit)edit);
            this.addEdit((TextEdit)edit);
            this.currentEdit = edit;
        }
    }

    final void doCopySourcePreVisit(RewriteEventStore.CopySourceInfo[] infos, Stack nodeEndStack) {
        if (infos != null) {
            int i = 0;
            while (i < infos.length) {
                RewriteEventStore.CopySourceInfo curr = infos[i];
                TextEdit edit = this.getCopySourceEdit(curr);
                this.addEdit(edit);
                this.currentEdit = edit;
                nodeEndStack.push(curr.getNode());
                ++i;
            }
        }
    }

    final void doCopySourcePostVisit(ASTNode node, Stack nodeEndStack) {
        while (!nodeEndStack.isEmpty() && nodeEndStack.peek() == node) {
            nodeEndStack.pop();
            this.currentEdit = this.currentEdit.getParent();
        }
    }

    @Override
    public boolean visit(Program node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        int pos = this.content.length;
        this.rewriteNodeList(node, Program.STATEMENTS_PROPERTY, pos, "", this.getLineDelimiter());
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        return false;
    }

    private void rewriteReturnType(MethodDeclaration node, boolean isConstructor, boolean isConstructorChange) {
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteModifiers(node, MethodDeclaration.MODIFIER_PROPERTY, node.getStart());
        this.rewriteRequiredNode(node, MethodDeclaration.FUNCTION_PROPERTY);
        return false;
    }

    @Override
    public boolean visit(Block node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        int blockStart = node.getStart();
        int startIndent = this.getIndent(node.getStart()) + 1;
        this.rewriteParagraphList(node, Block.STATEMENTS_PROPERTY, blockStart + 1, startIndent, 0, 1);
        RewriteEvent event = this.getEvent(node, Block.IS_CURLY_PROPERTY);
        if (event != null) {
            TextEditGroup editGroup = this.getEditGroup(event);
            boolean shouldBeCurly = (Boolean)event.getNewValue();
            StructuralPropertyDescriptor propertyDescriptor = node.getLocationInParent();
            if (propertyDescriptor == IfStatement.TRUE_STATEMENT_PROPERTY || propertyDescriptor == IfStatement.FALSE_STATEMENT_PROPERTY) {
                this.rewriteIfBlocks(node, editGroup, shouldBeCurly);
            } else if (propertyDescriptor == WhileStatement.BODY_PROPERTY) {
                Symbol symbol = SymbolsProvider.getSymbol(23, this.scanner.getPHPVersion());
                this.rewriteBlock(node, editGroup, shouldBeCurly, "endwhile", symbol);
            } else if (propertyDescriptor == ForStatement.BODY_PROPERTY) {
                Symbol symbol = SymbolsProvider.getSymbol(22, this.scanner.getPHPVersion());
                this.rewriteBlock(node, editGroup, shouldBeCurly, "endfor", symbol);
            } else if (propertyDescriptor == ForEachStatement.STATEMENT_PROPERTY) {
                Symbol symbol = SymbolsProvider.getSymbol(24, this.scanner.getPHPVersion());
                this.rewriteBlock(node, editGroup, shouldBeCurly, "endforeach", symbol);
            } else if (propertyDescriptor == SwitchStatement.BODY_PROPERTY) {
                Symbol symbol = SymbolsProvider.getSymbol(25, this.scanner.getPHPVersion());
                this.rewriteBlock(node, editGroup, shouldBeCurly, "endswitch", symbol);
            }
        }
        return false;
    }

    private void rewriteIfBlocks(Block node, TextEditGroup editGroup, boolean shouldBeCurly) {
        int blockStart = node.getStart();
        int blockEnd = node.getEnd() - 1;
        StructuralPropertyDescriptor propertyDescriptor = node.getLocationInParent();
        IfStatement ifStatement = (IfStatement)node.getParent();
        if (propertyDescriptor == IfStatement.TRUE_STATEMENT_PROPERTY) {
            if (shouldBeCurly) {
                this.doTextReplace(blockStart, 1, "{", editGroup);
                this.doTextInsert(blockEnd + 1, "\n}", editGroup);
                Symbol endIfSymbol = SymbolsProvider.getSymbol(21, this.scanner.getPHPVersion());
                try {
                    int endifPos = this.getScanner().getTokenStartOffset(endIfSymbol, blockEnd);
                    int semicolonPos = this.scanToSemicolon(endifPos + 5);
                    this.doTextRemove(endifPos, semicolonPos - endifPos + 1, editGroup);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            } else {
                this.doTextReplace(blockStart, 1, ":", editGroup);
                if (ifStatement.getFalseStatement() == null) {
                    this.doTextReplace(blockEnd, 1, "endif;", editGroup);
                } else {
                    this.doTextRemove(blockEnd, 1, editGroup);
                }
            }
        } else if (propertyDescriptor == IfStatement.FALSE_STATEMENT_PROPERTY) {
            if (shouldBeCurly) {
                this.doTextReplace(blockStart, 1, "{", editGroup);
                this.doTextInsert(blockEnd + 1, "\n}", editGroup);
            } else {
                this.doTextReplace(blockStart, 1, ":", editGroup);
                this.doTextReplace(blockEnd, 1, "endif;", editGroup);
            }
        }
    }

    private void rewriteBlock(Block node, TextEditGroup editGroup, boolean shouldBeCurly, String keyword, Symbol keywordSymbol) {
        int blockStart = node.getStart();
        int blockEnd = node.getEnd();
        if (shouldBeCurly) {
            this.doTextReplace(blockStart, 1, "{", editGroup);
            this.doTextInsert(blockEnd + 1, "\n}", editGroup);
            try {
                int endBlockPos = this.getScanner().getTokenStartOffset(keywordSymbol, blockEnd - keyword.length());
                int semicolonPos = this.scanToSemicolon(endBlockPos + keyword.length());
                this.doTextRemove(endBlockPos, semicolonPos - endBlockPos + 1, editGroup);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        } else {
            this.doTextReplace(blockStart, 1, ":", editGroup);
            this.doTextReplace(blockEnd - 1, 1, String.valueOf(keyword) + ';', editGroup);
        }
    }

    private int scanToSemicolon(int startIndex) {
        int i = startIndex;
        while (i < this.content.length) {
            if (this.content[i] == ';') {
                return i;
            }
            if (this.content[i] != ' ' && this.content[i] != '\t' && this.content[i] != '\n' && this.content[i] != '\r') {
                return startIndex;
            }
            ++i;
        }
        return startIndex;
    }

    @Override
    public boolean visit(ReturnStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        try {
            int offset = this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(11, this.scanner.getPHPVersion()), node.getStart());
            this.ensureSpaceBeforeReplace(node, ReturnStatement.EXPRESSION_PROPERTY, offset, 0);
            this.rewriteNode(node, ReturnStatement.EXPRESSION_PROPERTY, offset, ASTRewriteFormatter.SPACE);
        }
        catch (CoreException e) {
            this.handleException(e);
        }
        return false;
    }

    @Override
    public boolean visit(YieldExpression node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        RewriteEvent event = this.getEvent(node, YieldExpression.KEY_PROPERTY);
        if (event != null) {
            this.rewriteKeyValue(node, event);
        }
        if (this.isChanged(node, YieldExpression.EXPRESSION_PROPERTY)) {
            try {
                int offset = node.getKey() != null ? node.getKey().getEnd() : this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(27, this.scanner.getPHPVersion()), node.getStart());
                this.ensureSpaceBeforeReplace(node, YieldExpression.EXPRESSION_PROPERTY, offset, 0);
                this.rewriteNode(node, YieldExpression.EXPRESSION_PROPERTY, offset, ASTRewriteFormatter.SPACE);
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        }
        return false;
    }

    @Override
    public boolean visit(ArrayAccess node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        if (this.isChanged(node, ArrayAccess.DOLLARED_PROPERTY)) {
            this.rewriteVariableDollar(node);
        }
        if (this.isChanged(node, ArrayAccess.ARRAY_TYPE_PROPERTY)) {
            this.rewriteArrayAccessType(node);
        }
        return this.rewriteRequiredNodeVisit(node, ArrayAccess.NAME_PROPERTY, ArrayAccess.INDEX_PROPERTY);
    }

    private void rewriteArrayAccessType(ArrayAccess arrayAccess) {
        RewriteEvent event = this.getEvent(arrayAccess, ArrayAccess.ARRAY_TYPE_PROPERTY);
        if (event != null && event.getChangeKind() == 4) {
            Integer original = (Integer)event.getOriginalValue();
            try {
                if (original == 1) {
                    int openPos = this.getLeftBracketStartPosition(arrayAccess.getStart());
                    int closePos = arrayAccess.getEnd() - 1;
                    TextEditGroup editGroup = this.getEditGroup(event);
                    this.doTextReplace(openPos, 1, "{", editGroup);
                    this.doTextReplace(closePos, 1, CURLY_CLOSE, editGroup);
                } else {
                    int openPos = this.getLeftBraceStartPosition(arrayAccess.getStart());
                    int closePos = arrayAccess.getEnd() - 1;
                    TextEditGroup editGroup = this.getEditGroup(event);
                    this.doTextReplace(openPos, 1, "[", editGroup);
                    this.doTextReplace(closePos, 1, "]", editGroup);
                }
            }
            catch (CoreException ce) {
                this.handleException(ce);
            }
        }
    }

    @Override
    public boolean visit(ArrayCreation node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteNodeList(node, ArrayCreation.ELEMENTS_PROPERTY, node.getStart(), "", ", ");
        return false;
    }

    @Override
    public boolean visit(Assignment node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        int pos = this.rewriteRequiredNode(node, Assignment.LEFT_HAND_SIDE_PROPERTY);
        this.rewriteOperation(node, Assignment.OPERATOR_PROPERTY, pos);
        this.rewriteRequiredNode(node, Assignment.RIGHT_HAND_SIDE_PROPERTY);
        return false;
    }

    @Override
    public boolean visit(BreakStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        try {
            int offset = this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(12, this.scanner.getPHPVersion()), node.getStart());
            this.rewriteNode(node, BreakStatement.EXPRESSION_PROPERTY, offset, ASTRewriteFormatter.SPACE);
        }
        catch (CoreException e) {
            this.handleException(e);
        }
        return false;
    }

    @Override
    public boolean visit(CastExpression cast) {
        if (this.isChanged(cast, CastExpression.CASTING_TYPE_PROPERTY)) {
            try {
                this.rewriteCastType(cast);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.rewriteRequiredNodeVisit(cast, CastExpression.EXPRESSION_PROPERTY);
    }

    private void rewriteCastType(CastExpression cast) throws CoreException {
        RewriteEvent event = this.getEvent(cast, CastExpression.CASTING_TYPE_PROPERTY);
        if (event != null && event.getChangeKind() == 4) {
            TextEditGroup editGroup = this.getEditGroup(event);
            String castType = CastExpression.getCastType(cast.getCastingType());
            int offset = cast.getStart() + 1;
            int closingParenOffset = this.getScanner().getTokenStartOffset(SymbolsProvider.getSymbol(7, this.scanner.getPHPVersion()), offset);
            this.doTextReplace(offset, closingParenOffset - offset, castType, editGroup);
        }
    }

    @Override
    public boolean visit(CatchClause node) {
        return this.rewriteRequiredNodeVisit(node, CatchClause.CLASS_NAME_PROPERTY, CatchClause.BODY_PROPERTY);
    }

    @Override
    public boolean visit(FinallyClause node) {
        return this.rewriteRequiredNodeVisit(node, FinallyClause.BODY_PROPERTY);
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        this.rewriteRequiredNodeVisit(node, ClassInstanceCreation.CLASSNAME_PROPERTY);
        if (this.isChanged(node, ClassInstanceCreation.CTOR_PARAMS_PROPERTY)) {
            try {
                int pos = this.getLeftParenthesesStartPosition(node.getStart()) + 1;
                this.rewriteNodeList(node, ClassInstanceCreation.CTOR_PARAMS_PROPERTY, pos, "", ", ");
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (this.isChanged(node, ClassInstanceCreation.CHAINING_INSTANCE_CALL_PROPERTY)) {
            this.rewriteRequiredNodeVisit(node, ClassInstanceCreation.CHAINING_INSTANCE_CALL_PROPERTY);
        }
        return false;
    }

    @Override
    public boolean visit(ConditionalExpression node) {
        return this.rewriteRequiredNodeVisit(node, ConditionalExpression.CONDITION_PROPERTY, ConditionalExpression.IF_TRUE_PROPERTY, ConditionalExpression.IF_FALSE_PROPERTY);
    }

    @Override
    public boolean visit(ContinueStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        try {
            int offset = this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(13, this.scanner.getPHPVersion()), node.getStart());
            this.rewriteNode(node, ContinueStatement.EXPRESSION_PROPERTY, offset, ASTRewriteFormatter.SPACE);
        }
        catch (CoreException e) {
            this.handleException(e);
        }
        return false;
    }

    @Override
    public boolean visit(DoStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        int pos = node.getStart();
        try {
            RewriteEvent event = this.getEvent(node, DoStatement.BODY_PROPERTY);
            if (event != null && event.getChangeKind() == 4) {
                int startOffset = this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(14, this.scanner.getPHPVersion()), pos);
                ASTNode body = (ASTNode)event.getOriginalValue();
                int bodyEnd = body.getStart() + body.getLength();
                int endPos = this.getScanner().getTokenStartOffset(SymbolsProvider.getSymbol(15, this.scanner.getPHPVersion()), bodyEnd);
                this.rewriteBodyNode(node, DoStatement.BODY_PROPERTY, startOffset, endPos, this.getIndent(node.getStart()), this.formatter.DO_BLOCK);
            } else {
                this.voidVisit(node, DoStatement.BODY_PROPERTY);
            }
        }
        catch (CoreException e) {
            this.handleException(e);
        }
        this.rewriteRequiredNode(node, DoStatement.CONDITION_PROPERTY);
        return false;
    }

    @Override
    public boolean visit(EmptyStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.changeNotSupported(node);
        return false;
    }

    @Override
    public boolean visit(ExpressionStatement node) {
        return this.rewriteRequiredNodeVisit(node, ExpressionStatement.EXPRESSION_PROPERTY);
    }

    @Override
    public boolean visit(FieldAccess node) {
        return this.rewriteRequiredNodeVisit(node, FieldAccess.DISPATCHER_PROPERTY, FieldAccess.FIELD_PROPERTY);
    }

    @Override
    public boolean visit(FieldsDeclaration node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteModifiers(node, FieldsDeclaration.MODIFIER_PROPERTY, node.getStart());
        this.rewriteNodeList(node, FieldsDeclaration.FIELDS_PROPERTY, node.getStart() + node.getModifierString().length(), "", ", ");
        return false;
    }

    @Override
    public boolean visit(SingleFieldDeclaration singleFieldDeclaration) {
        if (!this.hasChildrenChanges(singleFieldDeclaration)) {
            return this.doVisitUnchangedChildren(singleFieldDeclaration);
        }
        RewriteEvent event = this.getEvent(singleFieldDeclaration, SingleFieldDeclaration.VALUE_PROPERTY);
        if (event != null) {
            this.rewriteOptionalValueProperty(singleFieldDeclaration, singleFieldDeclaration.getName().getEnd(), SingleFieldDeclaration.VALUE_PROPERTY, event);
        }
        return this.rewriteRequiredNodeVisit(singleFieldDeclaration, SingleFieldDeclaration.NAME_PROPERTY);
    }

    private void rewriteOptionalValueProperty(ASTNode node, int pos, ChildPropertyDescriptor valueProperty, RewriteEvent event) {
        TextEditGroup editGroup = this.getEditGroup(event);
        int kind = event.getChangeKind();
        switch (kind) {
            case 4: {
                this.rewriteRequiredNode(node, valueProperty);
                break;
            }
            case 1: {
                ASTNode newNode = (ASTNode)event.getNewValue();
                this.doTextInsert(pos, " = ", editGroup);
                this.doTextInsert(pos, newNode, 0, false, editGroup);
                break;
            }
            case 2: {
                ASTNode originalNode = (ASTNode)event.getOriginalValue();
                int endPos = originalNode.getEnd();
                this.doTextRemove(pos, endPos - pos, editGroup);
            }
        }
    }

    @Override
    public boolean visit(ForStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        try {
            int pos = node.getStart();
            if (this.isChanged(node, ForStatement.INITIALIZERS_PROPERTY)) {
                int startOffset = this.getLeftParenthesesStartPosition(pos) + 1;
                pos = this.rewriteNodeList(node, ForStatement.INITIALIZERS_PROPERTY, startOffset, "", ", ");
            } else {
                pos = this.doVisit(node, ForStatement.INITIALIZERS_PROPERTY, pos);
            }
            Symbol semicolonSym = SymbolsProvider.getSymbol(16, this.scanner.getPHPVersion());
            pos = this.getScanner().getTokenEndOffset(semicolonSym, pos);
            pos = this.rewriteNodeList(node, ForStatement.EXPRESSION_PROPERTY, pos, "", ", ");
            if (this.isChanged(node, ForStatement.UPDATERS_PROPERTY)) {
                int startOffset = this.getScanner().getTokenEndOffset(semicolonSym, pos);
                pos = this.rewriteNodeList(node, ForStatement.UPDATERS_PROPERTY, startOffset, "", ", ");
            } else {
                pos = this.doVisit(node, ForStatement.UPDATERS_PROPERTY, pos);
            }
            RewriteEvent bodyEvent = this.getEvent(node, ForStatement.BODY_PROPERTY);
            if (bodyEvent != null && bodyEvent.getChangeKind() == 4) {
                int startOffset = this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(7, this.scanner.getPHPVersion()), pos);
                this.rewriteBodyNode(node, ForStatement.BODY_PROPERTY, startOffset, -1, this.getIndent(node.getStart()), this.formatter.FOR_BLOCK);
            } else {
                this.voidVisit(node, ForStatement.BODY_PROPERTY);
            }
        }
        catch (CoreException e) {
            this.handleException(e);
        }
        return false;
    }

    @Override
    public boolean visit(IfStatement node) {
        int indent;
        int elseChange;
        int pos;
        block11: {
            if (!this.hasChildrenChanges(node)) {
                return this.doVisitUnchangedChildren(node);
            }
            pos = this.rewriteRequiredNode(node, IfStatement.CONDITION_PROPERTY);
            RewriteEvent thenEvent = this.getEvent(node, IfStatement.TRUE_STATEMENT_PROPERTY);
            elseChange = this.getChangeKind(node, IfStatement.FALSE_STATEMENT_PROPERTY);
            if (thenEvent != null && thenEvent.getChangeKind() != 0) {
                try {
                    pos = this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(7, this.scanner.getPHPVersion()), pos);
                    indent = this.getIndent(node.getStart());
                    int endPos = -1;
                    Object elseStatement = this.getOriginalValue(node, IfStatement.FALSE_STATEMENT_PROPERTY);
                    if (elseStatement != null) {
                        ASTNode thenStatement = (ASTNode)thenEvent.getOriginalValue();
                        endPos = this.getScanner().getTokenStartOffset(SymbolsProvider.getSymbol(19, this.scanner.getPHPVersion()), thenStatement.getStart() + thenStatement.getLength());
                    }
                    if (elseStatement == null || elseChange != 0) {
                        pos = this.rewriteBodyNode(node, IfStatement.TRUE_STATEMENT_PROPERTY, pos, endPos, indent, this.formatter.IF_BLOCK_NO_ELSE);
                        break block11;
                    }
                    pos = this.rewriteBodyNode(node, IfStatement.TRUE_STATEMENT_PROPERTY, pos, endPos, indent, this.formatter.IF_BLOCK_WITH_ELSE);
                }
                catch (CoreException e) {
                    this.handleException(e);
                }
            } else {
                pos = this.doVisit(node, IfStatement.TRUE_STATEMENT_PROPERTY, pos);
            }
        }
        if (elseChange != 0) {
            indent = this.getIndent(node.getStart());
            Object newThen = this.getNewValue(node, IfStatement.TRUE_STATEMENT_PROPERTY);
            if (newThen instanceof Block) {
                this.rewriteBodyNode(node, IfStatement.FALSE_STATEMENT_PROPERTY, pos, -1, indent, this.formatter.ELSE_AFTER_BLOCK);
            } else {
                this.rewriteBodyNode(node, IfStatement.FALSE_STATEMENT_PROPERTY, pos, -1, indent, this.formatter.ELSE_AFTER_STATEMENT);
            }
        } else {
            pos = this.doVisit(node, IfStatement.FALSE_STATEMENT_PROPERTY, pos);
        }
        return false;
    }

    @Override
    public boolean visit(InfixExpression node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        int pos = this.rewriteRequiredNode(node, InfixExpression.LEFT_OPERAND_PROPERTY);
        boolean needsNewOperation = this.isChanged(node, InfixExpression.OPERATOR_PROPERTY);
        if (needsNewOperation) {
            String operation = InfixExpression.getOperator((Integer)this.getNewValue(node, InfixExpression.OPERATOR_PROPERTY));
            this.replaceOperation(pos, operation, this.getEditGroup(node, InfixExpression.OPERATOR_PROPERTY));
        }
        pos = this.rewriteRequiredNode(node, InfixExpression.RIGHT_OPERAND_PROPERTY);
        return false;
    }

    public void ensureSpaceAfterReplace(ASTNode node, ChildPropertyDescriptor desc) {
        if (this.getChangeKind(node, desc) == 4) {
            int leftOperandEnd = this.getExtendedEnd((ASTNode)this.getOriginalValue(node, desc));
            try {
                int offset = this.getScanner().getNextStartOffset(leftOperandEnd);
                if (offset == leftOperandEnd) {
                    this.doTextInsert(offset, String.valueOf(' '), this.getEditGroup(node, desc));
                }
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        }
    }

    public void ensureSpaceBeforeReplace(ASTNode node, ChildPropertyDescriptor desc, int offset, int numTokenBefore) {
        if (this.getChangeKind(node, desc) == 4) {
            try {
                while (numTokenBefore > 0) {
                    offset = this.getScanner().getNextEndOffset(offset);
                    --numTokenBefore;
                }
                if (offset == this.getExtendedOffset((ASTNode)this.getOriginalValue(node, desc))) {
                    this.doTextInsert(offset, String.valueOf(' '), this.getEditGroup(node, desc));
                }
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public boolean visit(MethodInvocation node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteOptionalQualifier(node, MethodInvocation.DISPATCHER_PROPERTY, node.getStart());
        this.rewriteRequiredNode(node, MethodInvocation.METHOD_PROPERTY);
        return false;
    }

    @Override
    public boolean visit(PostfixExpression node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        int pos = this.rewriteRequiredNode(node, PostfixExpression.VARIABLE_PROPERTY);
        this.rewriteOperation(node, PostfixExpression.OPERATOR_PROPERTY, pos);
        return false;
    }

    @Override
    public boolean visit(PrefixExpression node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteOperation(node, PrefixExpression.OPERATOR_PROPERTY, node.getStart());
        this.rewriteRequiredNode(node, PrefixExpression.VARIABLE_PROPERTY);
        return false;
    }

    @Override
    public boolean visit(SwitchCase node) {
        if (this.isChanged(node, SwitchCase.ACTIONS_PROPERTY)) {
            int valueEnd;
            int pos = node.getStart();
            Expression value = node.getValue();
            if (value != null && (valueEnd = value.getEnd()) > -1) {
                pos = valueEnd;
            }
            this.rewriteNodeList(node, SwitchCase.ACTIONS_PROPERTY, pos, "", "");
        }
        return this.rewriteRequiredNodeVisit(node, SwitchCase.VALUE_PROPERTY);
    }

    @Override
    public boolean visit(SwitchStatement node) {
        ChildListPropertyDescriptor property;
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        int pos = this.rewriteRequiredNode(node, SwitchStatement.EXPRESSION_PROPERTY);
        Block body = node.getBody();
        if (this.getChangeKind(body, property = Block.STATEMENTS_PROPERTY) != 0) {
            try {
                pos = this.getLeftBraceStartPosition(pos) + 1;
                int insertIndent = this.getIndent(body.getStart()) + 1;
                SwitchListRewriter listRewriter = new SwitchListRewriter(insertIndent);
                StringBuffer leadString = new StringBuffer();
                leadString.append(this.getLineDelimiter());
                leadString.append(this.createIndentString(insertIndent));
                listRewriter.rewriteList(body, property, pos, leadString.toString());
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        } else {
            this.voidVisit(body, Block.STATEMENTS_PROPERTY);
        }
        return false;
    }

    @Override
    public boolean visit(ThrowStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        try {
            int offset = this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(17, this.scanner.getPHPVersion()), node.getStart());
            this.ensureSpaceBeforeReplace(node, ThrowStatement.EXPRESSION_PROPERTY, offset, 0);
            this.rewriteRequiredNode(node, ThrowStatement.EXPRESSION_PROPERTY);
        }
        catch (CoreException e) {
            this.handleException(e);
        }
        return false;
    }

    @Override
    public boolean visit(TryStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        int pos = this.rewriteRequiredNode(node, TryStatement.BODY_PROPERTY);
        if (this.isChanged(node, TryStatement.CATCH_CLAUSES_PROPERTY)) {
            this.getIndent(node.getStart());
            String prefix = "";
            pos = this.rewriteNodeList(node, TryStatement.CATCH_CLAUSES_PROPERTY, pos, prefix, prefix);
        } else {
            pos = this.doVisit(node, TryStatement.CATCH_CLAUSES_PROPERTY, pos);
        }
        return false;
    }

    @Override
    public boolean visit(WhileStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        int pos = this.rewriteRequiredNode(node, WhileStatement.CONDITION_PROPERTY);
        try {
            if (this.isChanged(node, WhileStatement.BODY_PROPERTY)) {
                int startOffset = this.getScanner().getTokenEndOffset(SymbolsProvider.getSymbol(7, this.scanner.getPHPVersion()), pos);
                this.rewriteBodyNode(node, WhileStatement.BODY_PROPERTY, startOffset, -1, this.getIndent(node.getStart()), this.formatter.WHILE_BLOCK);
            } else {
                this.voidVisit(node, WhileStatement.BODY_PROPERTY);
            }
        }
        catch (CoreException e) {
            this.handleException(e);
        }
        return false;
    }

    final void handleException(Throwable e) {
        IllegalArgumentException runtimeException = new IllegalArgumentException("Document does not match the AST");
        runtimeException.initCause(e);
        throw runtimeException;
    }

    @Override
    public boolean visit(ArrayElement arrayElement) {
        this.rewriteArrayElementKey(arrayElement);
        return this.rewriteRequiredNodeVisit(arrayElement, ArrayElement.VALUE_PROPERTY);
    }

    private void rewriteArrayElementKey(ArrayElement arrayElement) {
        RewriteEvent event = this.getEvent(arrayElement, ArrayElement.KEY_PROPERTY);
        if (event != null) {
            this.rewriteKeyValue(arrayElement, event);
        }
    }

    private void rewriteKeyValue(ASTNode node, RewriteEvent event) {
        int kind = event.getChangeKind();
        TextEditGroup editGroup = this.getEditGroup(event);
        switch (kind) {
            case 1: {
                Expression newValue = (Expression)event.getNewValue();
                int start = node.getStart();
                if (node instanceof ForEachStatement) {
                    start = ((ForEachStatement)node).getValue().getStart();
                } else if (node instanceof YieldExpression) {
                    start = ((YieldExpression)node).getExpression().getStart();
                }
                this.doTextInsert(start, newValue, 0, false, editGroup);
                this.doTextInsert(start, "=>", editGroup);
                break;
            }
            case 2: {
                Expression removedExpression = (Expression)event.getOriginalValue();
                int deleteEndPos = -1;
                if (node instanceof ArrayElement) {
                    deleteEndPos = ((ArrayElement)node).getValue().getStart();
                } else if (node instanceof ForEachStatement) {
                    deleteEndPos = ((ForEachStatement)node).getValue().getStart();
                } else if (node instanceof YieldExpression) {
                    deleteEndPos = ((YieldExpression)node).getExpression().getStart();
                }
                int deleteStartPos = removedExpression.getStart();
                this.doTextRemove(deleteStartPos, deleteEndPos - deleteStartPos, editGroup);
                break;
            }
            case 4: {
                if (node instanceof ArrayElement) {
                    this.rewriteRequiredNode(node, ArrayElement.KEY_PROPERTY);
                    break;
                }
                if (node instanceof ForEachStatement) {
                    this.rewriteRequiredNode(node, ForEachStatement.KEY_PROPERTY);
                    break;
                }
                if (!(node instanceof YieldExpression)) break;
                this.rewriteRequiredNode(node, YieldExpression.KEY_PROPERTY);
            }
        }
    }

    @Override
    public boolean visit(ASTError astError) {
        if (!this.hasChildrenChanges(astError)) {
            return this.doVisitUnchangedChildren(astError);
        }
        this.changeNotSupported(astError);
        return false;
    }

    @Override
    public boolean visit(BackTickExpression backTickExpression) {
        if (!this.hasChildrenChanges(backTickExpression)) {
            return this.doVisitUnchangedChildren(backTickExpression);
        }
        this.rewriteNodeList(backTickExpression, BackTickExpression.EXPRESSIONS_PROPERTY, backTickExpression.getStart(), "", "");
        return false;
    }

    @Override
    public boolean visit(ConstantDeclaration classConstantDeclaration) {
        if (!this.hasChildrenChanges(classConstantDeclaration)) {
            return this.doVisitUnchangedChildren(classConstantDeclaration);
        }
        this.changeNotSupported(classConstantDeclaration);
        return false;
    }

    @Override
    public boolean visit(ClassDeclaration classDeclaration) {
        if (!this.hasChildrenChanges(classDeclaration)) {
            return this.doVisitUnchangedChildren(classDeclaration);
        }
        try {
            this.rewriteClassDeclarationModifier(classDeclaration);
            this.rewriteClassDeclarationSuperClass(classDeclaration);
            int pos = classDeclaration.getSuperClass() == null ? classDeclaration.getName().getEnd() : classDeclaration.getSuperClass().getEnd();
            this.rewriteNodeList(classDeclaration, ClassDeclaration.INTERFACES_PROPERTY, pos, " implements ", ", ");
            return this.rewriteRequiredNodeVisit(classDeclaration, ClassDeclaration.NAME_PROPERTY, ClassDeclaration.BODY_PROPERTY);
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    private void rewriteClassDeclarationModifier(ClassDeclaration classDeclaration) throws CoreException {
        RewriteEvent event = this.getEvent(classDeclaration, ClassDeclaration.MODIFIER_PROPERTY);
        if (event != null && event.getChangeKind() == 4) {
            TextEditGroup editGroup = this.getEditGroup(event);
            int start = classDeclaration.getStart();
            int classKeywordStart = this.getScanner().getTokenStartOffset(SymbolsProvider.getSymbol(10, this.scanner.getPHPVersion()), start);
            int modifier = (Integer)event.getNewValue();
            switch (modifier) {
                case 0: {
                    this.doTextRemove(start, classKeywordStart - start, editGroup);
                    break;
                }
                case 1: 
                case 2: {
                    this.doTextReplace(start, classKeywordStart - start, String.valueOf(ClassDeclaration.getModifier(modifier)) + ' ', editGroup);
                }
            }
        }
    }

    private void rewriteClassDeclarationSuperClass(ClassDeclaration classDeclaration) throws CoreException {
        RewriteEvent event = this.getEvent(classDeclaration, ClassDeclaration.SUPER_CLASS_PROPERTY);
        if (event != null) {
            int changeKind = event.getChangeKind();
            TextEditGroup editGroup = this.getEditGroup(event);
            switch (changeKind) {
                case 1: {
                    Identifier superClass = (Identifier)event.getNewValue();
                    int insertionPos = classDeclaration.getName().getEnd();
                    String extendsKeyword = " extends ";
                    this.doTextInsert(insertionPos, extendsKeyword, editGroup);
                    this.doTextInsert(insertionPos, superClass, 0, false, editGroup);
                    break;
                }
                case 2: {
                    Identifier superClass = (Identifier)event.getOriginalValue();
                    int deletionEnd = classDeclaration.interfaces().size() > 0 ? this.getScanner().getTokenStartOffset(SymbolsProvider.getSymbol(20, this.scanner.getPHPVersion()), classDeclaration.getStart()) : classDeclaration.getBody().getStart();
                    int deletionStart = classDeclaration.getName().getEnd();
                    this.doTextRemove(deletionStart, deletionEnd - deletionStart, editGroup);
                    this.doTextInsert(deletionStart, " ", editGroup);
                    break;
                }
                case 4: {
                    this.rewriteRequiredNode(classDeclaration, ClassDeclaration.SUPER_CLASS_PROPERTY);
                }
            }
        }
    }

    private void rewriteInterfaces(ClassDeclaration classDeclaration) {
    }

    @Override
    public boolean visit(ClassName className) {
        return this.rewriteRequiredNodeVisit(className, ClassName.NAME_PROPERTY);
    }

    @Override
    public boolean visit(CloneExpression cloneExpression) {
        return this.rewriteRequiredNodeVisit(cloneExpression, CloneExpression.EXPRESSION_PROPERTY);
    }

    @Override
    public boolean visit(Comment comment) {
        return false;
    }

    @Override
    public boolean visit(DeclareStatement declareStatement) {
        if (!this.hasChildrenChanges(declareStatement)) {
            return this.doVisitUnchangedChildren(declareStatement);
        }
        this.changeNotSupported(declareStatement);
        return false;
    }

    @Override
    public boolean visit(EchoStatement echoStatement) {
        if (!this.hasChildrenChanges(echoStatement)) {
            return this.doVisitUnchangedChildren(echoStatement);
        }
        this.rewriteNodeList(echoStatement, EchoStatement.EXPRESSIONS_PROPERTY, echoStatement.getStart(), "", ", ");
        return false;
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        if (!this.hasChildrenChanges(forEachStatement)) {
            return this.doVisitUnchangedChildren(forEachStatement);
        }
        RewriteEvent event = this.getEvent(forEachStatement, ForEachStatement.KEY_PROPERTY);
        if (event != null) {
            this.rewriteKeyValue(forEachStatement, event);
        }
        this.rewriteRequiredNodeVisit(forEachStatement, ForEachStatement.EXPRESSION_PROPERTY, ForEachStatement.VALUE_PROPERTY, ForEachStatement.STATEMENT_PROPERTY);
        return false;
    }

    @Override
    public boolean visit(FormalParameter formalParameter) {
        try {
            if (formalParameter.getAST().apiLevel() == PHPVersion.PHP4 && this.isChanged(formalParameter, FormalParameter.IS_MANDATORY_PROPERTY)) {
                if (formalParameter.getAST().apiLevel() == PHPVersion.PHP5) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.php.core", "Could not set a FormalParameter 'isMandatory' property for PHP5 AST"));
                }
                RewriteEvent event = this.getEvent(formalParameter, FormalParameter.IS_MANDATORY_PROPERTY);
                if (event != null && event.getChangeKind() == 4) {
                    TextEditGroup editGroup = this.getEditGroup(event);
                    boolean isMandatory = (Boolean)event.getNewValue();
                    if (isMandatory) {
                        this.doTextRemove(formalParameter.getStart(), 6, editGroup);
                    } else {
                        this.doTextInsert(formalParameter.getStart(), "const ", editGroup);
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.rewriteFormalParameterVariadic(formalParameter);
        this.rewriteFormalParameterType(formalParameter);
        this.rewriteFormalParameterDefault(formalParameter);
        return this.rewriteRequiredNodeVisit(formalParameter, FormalParameter.PARAMETER_NAME_PROPERTY);
    }

    private void rewriteFormalParameterType(FormalParameter formalParameter) {
        RewriteEvent event = this.getEvent(formalParameter, FormalParameter.PARAMETER_TYPE_PROPERTY);
        if (event != null) {
            int kind = event.getChangeKind();
            switch (kind) {
                case 4: {
                    int pos = this.rewriteRequiredNode(formalParameter, FormalParameter.PARAMETER_TYPE_PROPERTY);
                    ASTNode originalValue = (ASTNode)event.getOriginalValue();
                    if (originalValue != null && originalValue.getLength() != 0) break;
                    this.doTextInsert(pos, " ", this.getEditGroup(event));
                    break;
                }
                case 1: {
                    Identifier identifier = (Identifier)event.getNewValue();
                    String name = identifier.getName();
                    if (name == null) break;
                    if (!name.endsWith(" ") && !name.endsWith("\t")) {
                        name = String.valueOf(name) + ' ';
                    }
                    this.doTextInsert(formalParameter.getStart(), name, this.getEditGroup(event));
                    break;
                }
                case 2: {
                    ASTNode originalValue = (ASTNode)event.getOriginalValue();
                    this.doTextRemove(originalValue.getStart(), originalValue.getLength(), this.getEditGroup(event));
                }
            }
        }
    }

    private void rewriteFormalParameterDefault(FormalParameter formalParameter) {
        RewriteEvent event = this.getEvent(formalParameter, FormalParameter.DEFAULT_VALUE_PROPERTY);
        if (event != null) {
            int kind = event.getChangeKind();
            switch (kind) {
                case 4: {
                    this.rewriteRequiredNode(formalParameter, FormalParameter.DEFAULT_VALUE_PROPERTY);
                    break;
                }
                case 1: {
                    Scalar scalar = (Scalar)event.getNewValue();
                    if (scalar == null) break;
                    this.doTextInsert(formalParameter.getStart(), " = " + scalar.getStringValue(), this.getEditGroup(event));
                    break;
                }
                case 2: {
                    ASTNode originalValue = (ASTNode)event.getOriginalValue();
                    int nameEnd = formalParameter.getParameterName().getEnd();
                    this.doTextRemove(nameEnd, originalValue.getEnd() - nameEnd, this.getEditGroup(event));
                }
            }
        }
    }

    private void rewriteFormalParameterVariadic(FormalParameter formalParameter) {
        RewriteEvent event = this.getEvent(formalParameter, FormalParameter.IS_VARIADIC_PROPERTY);
        if (event != null && event.getChangeKind() == 4) {
            TextEditGroup editGroup = this.getEditGroup(event);
            boolean isVariadic = (Boolean)event.getNewValue();
            int start = formalParameter.getStart();
            if (isVariadic) {
                if (formalParameter.getParameterName() instanceof Reference) {
                    ++start;
                }
                this.doTextInsert(start, "... ", editGroup);
            } else {
                start = formalParameter.getParameterName() instanceof Reference ? ++start : (start -= 3);
                this.doTextRemove(start, 3, editGroup);
            }
        }
    }

    @Override
    public boolean visit(FunctionDeclaration functionDeclaration) {
        if (!this.hasChildrenChanges(functionDeclaration)) {
            return this.doVisitUnchangedChildren(functionDeclaration);
        }
        this.rewriteFunctionReference(functionDeclaration);
        int pos = this.rewriteRequiredNode(functionDeclaration, FunctionDeclaration.NAME_PROPERTY);
        if (this.isChanged(functionDeclaration, FunctionDeclaration.FORMAL_PARAMETERS_PROPERTY)) {
            try {
                int startOffset = this.getLeftParenthesesStartPosition(pos) + 1;
                this.rewriteNodeList(functionDeclaration, FunctionDeclaration.FORMAL_PARAMETERS_PROPERTY, startOffset, "", ", ");
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        } else {
            this.voidVisit(functionDeclaration, FunctionDeclaration.FORMAL_PARAMETERS_PROPERTY);
        }
        this.rewriteRequiredNode(functionDeclaration, FunctionDeclaration.BODY_PROPERTY);
        return false;
    }

    private void rewriteFunctionReference(FunctionDeclaration functionDeclaration) {
        RewriteEvent event = this.getEvent(functionDeclaration, FunctionDeclaration.IS_REFERENCE_PROPERTY);
        if (event != null && event.getChangeKind() == 4) {
            boolean isReference = (Boolean)event.getNewValue();
            TextEditGroup editGroup = this.getEditGroup(event);
            int nameStart = functionDeclaration.getFunctionName().getStart();
            int startDeletionFrom = functionDeclaration.getStart() + 8;
            this.doTextRemove(startDeletionFrom, nameStart - startDeletionFrom, editGroup);
            if (isReference) {
                this.doTextInsert(startDeletionFrom, " &", editGroup);
            } else {
                this.doTextInsert(startDeletionFrom, " ", editGroup);
            }
        }
    }

    @Override
    public boolean visit(FunctionInvocation functionInvocation) {
        if (!this.hasChildrenChanges(functionInvocation)) {
            return this.doVisitUnchangedChildren(functionInvocation);
        }
        int pos = this.rewriteRequiredNode(functionInvocation, FunctionInvocation.FUNCTION_PROPERTY);
        if (this.isChanged(functionInvocation, FunctionInvocation.PARAMETERS_PROPERTY)) {
            try {
                int startOffset = this.getLeftParenthesesStartPosition(pos) + 1;
                this.rewriteNodeList(functionInvocation, FunctionInvocation.PARAMETERS_PROPERTY, startOffset, "", ", ");
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        } else {
            this.voidVisit(functionInvocation, FunctionInvocation.PARAMETERS_PROPERTY);
        }
        return false;
    }

    @Override
    public boolean visit(FunctionName functionName) {
        return this.rewriteRequiredNodeVisit(functionName, FunctionName.NAME_PROPERTY);
    }

    @Override
    public boolean visit(GlobalStatement globalStatement) {
        if (!this.hasChildrenChanges(globalStatement)) {
            return this.doVisitUnchangedChildren(globalStatement);
        }
        this.rewriteNodeList(globalStatement, GlobalStatement.VARIABLES_PROPERTY, globalStatement.getStart(), "", ", ");
        return false;
    }

    @Override
    public boolean visit(Identifier node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        String newString = (String)this.getNewValue(node, Identifier.NAME_PROPERTY);
        TextEditGroup group = this.getEditGroup(node, Identifier.NAME_PROPERTY);
        this.doTextReplace(node.getStart(), node.getLength(), newString, group);
        return false;
    }

    @Override
    public boolean visit(IgnoreError ignoreError) {
        return this.rewriteRequiredNodeVisit(ignoreError, IgnoreError.EXPRESSION_PROPERTY);
    }

    @Override
    public boolean visit(Include include) {
        TextEditGroup editGroup;
        RewriteEvent event;
        if (!this.hasChildrenChanges(include)) {
            return this.doVisitUnchangedChildren(include);
        }
        int offsetGap = 0;
        if (this.isChanged(include, Include.INCLUDE_TYPE_PROPERTY) && (event = this.getEvent(include, Include.INCLUDE_TYPE_PROPERTY)) != null && event.getChangeKind() == 4) {
            editGroup = this.getEditGroup(event);
            int newValue = (Integer)event.getNewValue();
            int originalTypeLength = Include.getType((Integer)event.getOriginalValue()).length();
            String newIncludeType = Include.getType(newValue);
            this.doTextReplace(include.getStart(), originalTypeLength, newIncludeType, editGroup);
            offsetGap = originalTypeLength - newIncludeType.length();
        }
        if (this.isChanged(include, Include.EXPRESSION_PROPERTY) && (event = this.getEvent(include, Include.EXPRESSION_PROPERTY)) != null && event.getChangeKind() == 4) {
            editGroup = this.getEditGroup(event);
            int typeEndOffset = Include.getType(include.getIncludeType()).length() + include.getStart();
            ASTNode newNode = (ASTNode)event.getNewValue();
            ASTNode originalNode = (ASTNode)event.getOriginalValue();
            if (typeEndOffset + offsetGap == originalNode.getStart() && newNode.getType() != 62) {
                this.doTextInsert(offsetGap + typeEndOffset, " ", editGroup);
                this.rewriteRequiredNode(include, Include.EXPRESSION_PROPERTY);
            } else {
                this.rewriteRequiredNode(include, Include.EXPRESSION_PROPERTY);
            }
        }
        return false;
    }

    @Override
    public boolean visit(InLineHtml inLineHtml) {
        if (!this.hasChildrenChanges(inLineHtml)) {
            return this.doVisitUnchangedChildren(inLineHtml);
        }
        this.changeNotSupported(inLineHtml);
        return false;
    }

    @Override
    public boolean visit(InstanceOfExpression instanceOfExpression) {
        return this.rewriteRequiredNodeVisit(instanceOfExpression, InstanceOfExpression.CLASSNAME_PROPERTY, InstanceOfExpression.EXPRESSION_PROPERTY);
    }

    @Override
    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        if (!this.hasChildrenChanges(interfaceDeclaration)) {
            return this.doVisitUnchangedChildren(interfaceDeclaration);
        }
        try {
            this.rewriteNodeList(interfaceDeclaration, InterfaceDeclaration.INTERFACES_PROPERTY, interfaceDeclaration.getName().getEnd(), " extends ", ", ");
            return this.rewriteRequiredNodeVisit(interfaceDeclaration, InterfaceDeclaration.NAME_PROPERTY, InterfaceDeclaration.BODY_PROPERTY);
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean visit(ListVariable listVariable) {
        if (!this.hasChildrenChanges(listVariable)) {
            return this.doVisitUnchangedChildren(listVariable);
        }
        this.rewriteNodeList(listVariable, ListVariable.VARIABLES_PROPERTY, listVariable.getStart(), "", ",");
        return false;
    }

    @Override
    public boolean visit(ParenthesisExpression parenthesisExpression) {
        return this.rewriteRequiredNodeVisit(parenthesisExpression, ParenthesisExpression.EXPRESSION_PROPERTY);
    }

    @Override
    public boolean visit(Quote quote) {
        this.rewriteQuoteType(quote);
        this.rewriteQuoteExpression(quote);
        return false;
    }

    private void rewriteQuoteExpression(Quote quote) {
        int expressionStart = quote.getStart();
        block0 : switch (quote.getQuoteType()) {
            case 0: 
            case 1: {
                ++expressionStart;
                break;
            }
            case 2: {
                int quoteEnd = quote.getEnd();
                while (expressionStart < quoteEnd) {
                    if (this.content[expressionStart] == '\n' || this.content[expressionStart] == '\r') {
                        if (this.content[++expressionStart] != '\n' && this.content[expressionStart] != '\r') break block0;
                        ++expressionStart;
                        break block0;
                    }
                    ++expressionStart;
                }
                break;
            }
        }
        this.rewriteNodeList(quote, Quote.EXPRESSIONS_PROPERTY, expressionStart, "", "");
        List originalValue = (List)this.getOriginalValue(quote, Quote.EXPRESSIONS_PROPERTY);
        List newValue = (List)this.getNewValue(quote, Quote.EXPRESSIONS_PROPERTY);
        if ((originalValue == null || originalValue.size() == 0) && newValue != null && newValue.size() > 0) {
            this.doTextInsert(expressionStart, "\n", this.getEditGroup(quote, Quote.EXPRESSIONS_PROPERTY));
        }
    }

    private void rewriteQuoteType(Quote quote) {
        RewriteEvent event;
        List<Expression> expressions;
        if (this.isChanged(quote, Quote.QUOTE_TYPE_PROPERTY) && (expressions = quote.expressions()).size() > 0 && (event = this.getEvent(quote, Quote.QUOTE_TYPE_PROPERTY)) != null && event.getChangeKind() == 4) {
            TextEditGroup editGroup = this.getEditGroup(event);
            int expressionsStart = expressions.get(0).getStart();
            int expressionsEnd = expressions.get(expressions.size() - 1).getEnd();
            int quoteStart = quote.getStart();
            int quoteEnd = quote.getEnd();
            int originalType = (Integer)event.getOriginalValue();
            if (originalType == 2) {
                while (expressionsEnd > expressionsStart) {
                    if (this.content[expressionsEnd] == '\n' || this.content[expressionsEnd] == '\r') {
                        if (this.content[expressionsEnd - 1] != '\n' && this.content[expressionsEnd - 1] != '\r') break;
                        --expressionsEnd;
                        break;
                    }
                    --expressionsEnd;
                }
            }
            int newType = (Integer)event.getNewValue();
            String newStart = "";
            String newEnd = "";
            switch (newType) {
                case 1: {
                    newStart = "'";
                    newEnd = "'";
                    break;
                }
                case 0: {
                    newStart = "\"";
                    newEnd = "\"";
                    break;
                }
                case 3: {
                    newStart = "<<<'Heredoc'\n";
                    newEnd = "\nHeredoc;\n";
                    break;
                }
                case 2: {
                    newStart = "<<<Heredoc\n";
                    newEnd = "\nHeredoc;\n";
                }
            }
            this.doTextReplace(quoteStart, expressionsStart - quoteStart, newStart, editGroup);
            this.doTextReplace(expressionsEnd, quoteEnd - expressionsEnd, newEnd, editGroup);
        }
    }

    @Override
    public boolean visit(Reference reference) {
        return this.rewriteRequiredNodeVisit(reference, Reference.EXPRESSION_PROPERTY);
    }

    @Override
    public boolean visit(ReflectionVariable reflectionVariable) {
        if (this.isChanged(reflectionVariable, ReflectionVariable.DOLLARED_PROPERTY)) {
            this.rewriteVariableDollar(reflectionVariable);
        }
        return this.rewriteRequiredNodeVisit(reflectionVariable, ReflectionVariable.NAME_PROPERTY);
    }

    @Override
    public boolean visit(Scalar scalar) {
        RewriteEvent event = this.getEvent(scalar, Scalar.VALUE_PROPERTY);
        if (event != null) {
            String newValue = (String)event.getNewValue();
            if (newValue == null) {
                newValue = "";
            }
            int kind = event.getChangeKind();
            switch (kind) {
                case 4: {
                    this.doTextReplace(scalar.getStart(), scalar.getLength(), newValue, this.getEditGroup(event));
                    break;
                }
                case 1: {
                    this.doTextInsert(scalar.getStart(), newValue, this.getEditGroup(event));
                    break;
                }
                case 2: {
                    this.doTextRemove(scalar.getStart(), scalar.getLength(), this.getEditGroup(event));
                }
            }
        }
        return false;
    }

    @Override
    public boolean visit(StaticConstantAccess classConstantAccess) {
        return this.rewriteRequiredNodeVisit(classConstantAccess, StaticConstantAccess.CLASS_NAME_PROPERTY, StaticConstantAccess.CONSTANT_PROPERTY);
    }

    @Override
    public boolean visit(StaticFieldAccess staticFieldAccess) {
        return this.rewriteRequiredNodeVisit(staticFieldAccess, StaticFieldAccess.CLASS_NAME_PROPERTY, StaticFieldAccess.FIELD_PROPERTY);
    }

    @Override
    public boolean visit(StaticMethodInvocation staticMethodInvocation) {
        return this.rewriteRequiredNodeVisit(staticMethodInvocation, StaticMethodInvocation.CLASS_NAME_PROPERTY, StaticMethodInvocation.METHOD_PROPERTY);
    }

    @Override
    public boolean visit(StaticStatement staticStatement) {
        if (!this.hasChildrenChanges(staticStatement)) {
            return this.doVisitUnchangedChildren(staticStatement);
        }
        this.rewriteNodeList(staticStatement, StaticStatement.EXPRESSIONS_PROPERTY, staticStatement.getStart(), "", ", ");
        return false;
    }

    @Override
    public boolean visit(UnaryOperation unaryOperation) {
        this.rewriteOperation(unaryOperation, UnaryOperation.OPERATOR_PROPERTY, unaryOperation.getStart());
        return this.rewriteRequiredNodeVisit(unaryOperation, UnaryOperation.EXPRESSION_PROPERTY);
    }

    @Override
    public boolean visit(Variable variable) {
        if (this.isChanged(variable, Variable.DOLLARED_PROPERTY)) {
            this.rewriteVariableDollar(variable);
        }
        return this.rewriteRequiredNodeVisit(variable, Variable.NAME_PROPERTY);
    }

    @Override
    public boolean visit(GotoLabel gotoLabel) {
        return this.rewriteRequiredNodeVisit(gotoLabel, GotoLabel.NAME_PROPERTY);
    }

    @Override
    public boolean visit(GotoStatement gotoStatement) {
        return this.rewriteRequiredNodeVisit(gotoStatement, GotoStatement.LABEL_PROPERTY);
    }

    @Override
    public boolean visit(LambdaFunctionDeclaration lambdaFunctionDeclaration) {
        if (!this.hasChildrenChanges(lambdaFunctionDeclaration)) {
            return this.doVisitUnchangedChildren(lambdaFunctionDeclaration);
        }
        RewriteEvent event = this.getEvent(lambdaFunctionDeclaration, LambdaFunctionDeclaration.IS_REFERENCE_PROPERTY);
        if (event != null && event.getChangeKind() == 4) {
            boolean isReference = (Boolean)event.getNewValue();
            try {
                TextEditGroup editGroup = this.getEditGroup(event);
                int startDeletionFrom = lambdaFunctionDeclaration.getStart() + 8;
                int startOffset = this.getLeftParenthesesStartPosition(startDeletionFrom);
                this.doTextRemove(startDeletionFrom, startOffset - startDeletionFrom, editGroup);
                if (isReference) {
                    this.doTextInsert(startDeletionFrom, " & ", editGroup);
                } else {
                    this.doTextInsert(startDeletionFrom, " ", editGroup);
                }
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        }
        if (this.isChanged(lambdaFunctionDeclaration, LambdaFunctionDeclaration.FORMAL_PARAMETERS_PROPERTY)) {
            try {
                int startDeletionFrom = lambdaFunctionDeclaration.getStart() + 8;
                int startOffset = this.getLeftParenthesesStartPosition(startDeletionFrom);
                this.rewriteNodeList(lambdaFunctionDeclaration, LambdaFunctionDeclaration.FORMAL_PARAMETERS_PROPERTY, startOffset, "", ", ");
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        } else {
            this.voidVisit(lambdaFunctionDeclaration, LambdaFunctionDeclaration.FORMAL_PARAMETERS_PROPERTY);
        }
        if (this.isChanged(lambdaFunctionDeclaration, LambdaFunctionDeclaration.LEXICAL_VARIABLES_PROPERTY)) {
            try {
                int startDeletionFrom = lambdaFunctionDeclaration.getStart() + 8;
                int startOffset = this.getRightBraceStartPosition(startDeletionFrom) + 1;
                this.rewriteNodeList(lambdaFunctionDeclaration, LambdaFunctionDeclaration.LEXICAL_VARIABLES_PROPERTY, startOffset, " as ", ", ");
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        } else {
            this.voidVisit(lambdaFunctionDeclaration, LambdaFunctionDeclaration.LEXICAL_VARIABLES_PROPERTY);
        }
        this.rewriteRequiredNode(lambdaFunctionDeclaration, LambdaFunctionDeclaration.BODY_PROPERTY);
        return false;
    }

    @Override
    public boolean visit(NamespaceDeclaration namespaceDeclaration) {
        return this.rewriteRequiredNodeVisit(namespaceDeclaration, NamespaceDeclaration.NAME_PROPERTY, NamespaceDeclaration.BODY_PROPERTY);
    }

    @Override
    public boolean visit(NamespaceName namespaceName) {
        TextEditGroup editGroup;
        RewriteEvent event = this.getEvent(namespaceName, NamespaceName.GLOBAL_PROPERTY);
        if (event != null && event.getChangeKind() == 4) {
            editGroup = this.getEditGroup(event);
            if (((Boolean)event.getNewValue()).booleanValue()) {
                this.doTextInsert(namespaceName.getStart(), "\\", editGroup);
            } else {
                this.doTextRemove(namespaceName.getStart(), 1, editGroup);
            }
        }
        if ((event = this.getEvent(namespaceName, NamespaceName.CURRENT_PROPERTY)) != null && event.getChangeKind() == 4) {
            editGroup = this.getEditGroup(event);
            if (((Boolean)event.getNewValue()).booleanValue()) {
                this.doTextInsert(namespaceName.getStart(), "namespace\\", editGroup);
            } else {
                this.doTextRemove(namespaceName.getStart(), 10, editGroup);
            }
        }
        int pos = namespaceName.getStart();
        if (namespaceName.isGlobal()) {
            ++pos;
        }
        if (namespaceName.isCurrent()) {
            pos += 10;
        }
        if (this.isChanged(namespaceName, NamespaceName.ELEMENTS_PROPERTY)) {
            this.rewriteNodeList(namespaceName, NamespaceName.ELEMENTS_PROPERTY, pos, "", "\\");
        } else {
            this.voidVisit(namespaceName, NamespaceName.ELEMENTS_PROPERTY);
        }
        return false;
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        this.rewriteUseStatementType(useStatement);
        this.rewriteNodeList(useStatement, UseStatement.PARTS_PROPERTY, useStatement.getStart(), "", ", ");
        return false;
    }

    private void rewriteUseStatementType(UseStatement useStatement) {
        RewriteEvent event = this.getEvent(useStatement, UseStatement.STATEMENT_TYPE_PROPERTY);
        if (event != null) {
            int kind = event.getChangeKind();
            switch (kind) {
                case 4: {
                    String insertString = "";
                    if (useStatement.getStatementType() == 1) {
                        insertString = "function";
                    } else if (useStatement.getStatementType() == 2) {
                        insertString = "const";
                    }
                    int start = useStatement.getStart() + 4;
                    int length = 0;
                    if (!useStatement.parts().isEmpty()) {
                        length = useStatement.parts().get(0).getStart() - start;
                    }
                    this.doTextReplace(useStatement.getStart() + 4, length, insertString, this.getEditGroup(event));
                }
            }
        }
    }

    @Override
    public boolean visit(UseStatementPart useStatementPart) {
        return this.rewriteRequiredNodeVisit(useStatementPart, UseStatementPart.NAME_PROPERTY, UseStatementPart.ALIAS_PROPERTY);
    }

    protected boolean rewriteRequiredNodeVisit(ASTNode node, StructuralPropertyDescriptor ... properties) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        StructuralPropertyDescriptor[] structuralPropertyDescriptorArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            StructuralPropertyDescriptor property = structuralPropertyDescriptorArray[n2];
            this.rewriteRequiredNode(node, property);
            ++n2;
        }
        return false;
    }

    @Override
    public boolean visit(ChainingInstanceCall node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteRequiredNode(node, ChainingInstanceCall.ARRAY_DEREFERENCE_LIST);
        return false;
    }

    @Override
    public boolean visit(DereferenceNode node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteRequiredNode(node, ChainingInstanceCall.ARRAY_DEREFERENCE_LIST);
        return false;
    }

    @Override
    public boolean visit(FullyQualifiedTraitMethodReference node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteRequiredNode(node, FullyQualifiedTraitMethodReference.CLASS_NAME);
        this.rewriteRequiredNode(node, FullyQualifiedTraitMethodReference.FUNCTION_NAME);
        return false;
    }

    @Override
    public boolean visit(PHPArrayDereferenceList node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteNodeList(node, PHPArrayDereferenceList.DEREFERENCES_PROPERTY, node.getStart(), "", "");
        return false;
    }

    @Override
    public boolean visit(TraitAlias node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteRequiredNode(node, TraitAlias.TRAIT_METHOD);
        this.rewriteModifiers(node, TraitAlias.MODIFIER, node.getModifierOffset());
        this.rewriteRequiredNode(node, TraitAlias.FUNCTION_NAME);
        return false;
    }

    @Override
    public boolean visit(TraitAliasStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteRequiredNode(node, TraitAliasStatement.EXP);
        return false;
    }

    @Override
    public boolean visit(TraitDeclaration node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        try {
            return this.rewriteRequiredNodeVisit(node, ClassDeclaration.NAME_PROPERTY, ClassDeclaration.BODY_PROPERTY);
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean visit(TraitPrecedence node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteRequiredNode(node, TraitPrecedence.METHOD_REFERENCE);
        this.rewriteNodeList(node, TraitPrecedence.TRAIT_REFERENCE_LIST, node.getStart(), "", ", ");
        return false;
    }

    @Override
    public boolean visit(TraitPrecedenceStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteRequiredNode(node, TraitPrecedenceStatement.EXP);
        return false;
    }

    @Override
    public boolean visit(TraitUseStatement node) {
        if (!this.hasChildrenChanges(node)) {
            return this.doVisitUnchangedChildren(node);
        }
        this.rewriteNodeList(node, TraitUseStatement.TRAIT, node.getStart(), "", ", ");
        this.rewriteNodeList(node, TraitUseStatement.TRAIT_STATEMENT, node.getStart(), "", ", ");
        return false;
    }

    public void setInsertUseStatement(boolean isInsertUseStatement) {
        this.isInsertUseStatement = isInsertUseStatement;
    }

    class ListRewriter {
        protected String contantSeparator;
        protected int startPos;
        protected RewriteEvent[] list;

        ListRewriter() {
        }

        protected final ASTNode getOriginalNode(int index) {
            return (ASTNode)this.list[index].getOriginalValue();
        }

        protected final ASTNode getNewNode(int index) {
            return (ASTNode)this.list[index].getNewValue();
        }

        protected String getSeparatorString(int nodeIndex) {
            return this.contantSeparator;
        }

        protected int getInitialIndent() {
            return ASTRewriteAnalyzer.this.getIndent(this.startPos);
        }

        protected int getNodeIndent(int nodeIndex) {
            ASTNode node = this.getOriginalNode(nodeIndex);
            if (node == null) {
                int i = nodeIndex - 1;
                while (i >= 0) {
                    ASTNode curr = this.getOriginalNode(i);
                    if (curr != null) {
                        return ASTRewriteAnalyzer.this.getIndent(curr.getStart());
                    }
                    --i;
                }
                return this.getInitialIndent();
            }
            return ASTRewriteAnalyzer.this.getIndent(node.getStart());
        }

        protected int getStartOfNextNode(int nextIndex, int defaultPos) {
            if (ASTRewriteAnalyzer.this.isInsertUseStatement && nextIndex > 0 && this.list[nextIndex].getChangeKind() == 1 && this.list[nextIndex - 1].getChangeKind() == 0 && this.list[nextIndex].getNewValue() instanceof UseStatement && this.list[nextIndex - 1].getOriginalValue() instanceof UseStatement && ((UseStatement)this.list[nextIndex].getNewValue()).getStart() > 0) {
                return ((UseStatement)this.list[nextIndex].getNewValue()).getStart();
            }
            int i = nextIndex;
            while (i < this.list.length) {
                RewriteEvent elem = this.list[i];
                if (elem.getChangeKind() != 1) {
                    ASTNode node = (ASTNode)elem.getOriginalValue();
                    return ASTRewriteAnalyzer.this.getExtendedOffset(node);
                }
                ++i;
            }
            return defaultPos;
        }

        protected int getEndOfNode(ASTNode node) {
            return ASTRewriteAnalyzer.this.getExtendedEnd(node);
        }

        public final int rewriteList(ASTNode parent, StructuralPropertyDescriptor property, int offset, String keyword, String separator) {
            this.contantSeparator = separator;
            return this.rewriteList(parent, property, offset, keyword);
        }

        private boolean insertAfterSeparator(ASTNode node) {
            return !ASTRewriteAnalyzer.this.isInsertBoundToPrevious(node);
        }

        public final int rewriteList(ASTNode parent, StructuralPropertyDescriptor property, int offset, String keyword) {
            Program program;
            List<Comment> comments;
            this.startPos = offset;
            this.list = ASTRewriteAnalyzer.this.getEvent(parent, property).getChildren();
            int total = this.list.length;
            if (total == 0) {
                return this.startPos;
            }
            int currPos = -1;
            int lastNonInsert = -1;
            int lastNonDelete = -1;
            int i = 0;
            while (i < total) {
                int currMark = this.list[i].getChangeKind();
                if (currMark != 1) {
                    lastNonInsert = i;
                    if (currPos == -1) {
                        ASTNode elem = (ASTNode)this.list[i].getOriginalValue();
                        currPos = ASTRewriteAnalyzer.this.getExtendedOffset(elem);
                    }
                }
                if (currMark != 2) {
                    lastNonDelete = i;
                }
                ++i;
            }
            if (ASTRewriteAnalyzer.this.isInsertUseStatement && (comments = (program = parent.getProgramRoot()).comments()) != null && comments.size() > 0) {
                for (Comment comment : comments) {
                    if (comment.getStart() < parent.getStart() || comment.getStart() >= currPos) continue;
                    currPos = comment.getStart();
                    break;
                }
            }
            if (currPos == -1) {
                if (keyword.length() > 0) {
                    TextEditGroup editGroup = ASTRewriteAnalyzer.this.getEditGroup(this.list[0]);
                    ASTRewriteAnalyzer.this.doTextInsert(offset, keyword, editGroup);
                }
                currPos = offset;
            }
            if (lastNonDelete == -1) {
                currPos = offset;
            }
            int prevEnd = currPos;
            int separatorState = 1;
            int i2 = 0;
            while (i2 < total) {
                ASTNode node;
                RewriteEvent currEvent = this.list[i2];
                int currMark = currEvent.getChangeKind();
                int nextIndex = i2 + 1;
                if (currMark == 1) {
                    TextEditGroup editGroup = ASTRewriteAnalyzer.this.getEditGroup(currEvent);
                    ASTNode node2 = (ASTNode)currEvent.getNewValue();
                    if (separatorState == 0) {
                        ASTRewriteAnalyzer.this.doTextInsert(currPos, this.getSeparatorString(i2 - 1), editGroup);
                        separatorState = 1;
                    }
                    if (separatorState == 1 || this.insertAfterSeparator(node2)) {
                        ASTRewriteAnalyzer.this.doTextInsert(currPos, node2, this.getNodeIndent(i2), true, editGroup);
                        separatorState = 1;
                        if (i2 != lastNonDelete) {
                            if (this.list[nextIndex].getChangeKind() != 1) {
                                ASTRewriteAnalyzer.this.doTextInsert(currPos, this.getSeparatorString(i2), editGroup);
                            } else {
                                separatorState = 0;
                            }
                        }
                    } else {
                        ASTRewriteAnalyzer.this.doTextInsert(prevEnd, this.getSeparatorString(i2 - 1), editGroup);
                        ASTRewriteAnalyzer.this.doTextInsert(prevEnd, node2, this.getNodeIndent(i2), true, editGroup);
                    }
                } else if (currMark == 2) {
                    node = (ASTNode)currEvent.getOriginalValue();
                    TextEditGroup editGroup = ASTRewriteAnalyzer.this.getEditGroup(currEvent);
                    int currEnd = this.getEndOfNode(node);
                    if (i2 > lastNonDelete && separatorState == 2) {
                        ASTRewriteAnalyzer.this.doTextRemove(prevEnd, currPos - prevEnd, editGroup);
                        ASTRewriteAnalyzer.this.doTextRemoveAndVisit(currPos, currEnd - currPos, node, editGroup);
                        currPos = currEnd;
                        prevEnd = currEnd;
                    } else {
                        int end = this.getStartOfNextNode(nextIndex, currEnd);
                        ASTRewriteAnalyzer.this.doTextRemoveAndVisit(currPos, currEnd - currPos, node, ASTRewriteAnalyzer.this.getEditGroup(currEvent));
                        ASTRewriteAnalyzer.this.doTextRemove(currEnd, end - currEnd, editGroup);
                        currPos = end;
                        prevEnd = currEnd;
                        separatorState = 1;
                    }
                } else {
                    if (currMark == 4) {
                        node = (ASTNode)currEvent.getOriginalValue();
                        int currEnd = this.getEndOfNode(node);
                        TextEditGroup editGroup = ASTRewriteAnalyzer.this.getEditGroup(currEvent);
                        ASTNode changed = (ASTNode)currEvent.getNewValue();
                        ASTRewriteAnalyzer.this.doTextRemoveAndVisit(currPos, currEnd - currPos, node, editGroup);
                        ASTRewriteAnalyzer.this.doTextInsert(currPos, changed, this.getNodeIndent(i2), true, editGroup);
                        prevEnd = currEnd;
                    } else {
                        node = (ASTNode)currEvent.getOriginalValue();
                        ASTRewriteAnalyzer.this.voidVisit(node);
                    }
                    if (i2 == lastNonInsert) {
                        separatorState = 0;
                        if (currMark == 0) {
                            node = (ASTNode)currEvent.getOriginalValue();
                            prevEnd = this.getEndOfNode(node);
                        }
                        currPos = prevEnd;
                    } else if (this.list[nextIndex].getChangeKind() != 0) {
                        if (currMark == 0) {
                            node = (ASTNode)currEvent.getOriginalValue();
                            prevEnd = this.getEndOfNode(node);
                        }
                        currPos = this.getStartOfNextNode(nextIndex, prevEnd);
                        separatorState = 2;
                    }
                }
                ++i2;
            }
            return currPos;
        }
    }

    class ModifierRewriter
    extends ListRewriter {
        private final ASTRewriteFormatter.Prefix annotationSeparation;

        public ModifierRewriter(ASTRewriteFormatter.Prefix annotationSeparation) {
            this.annotationSeparation = annotationSeparation;
        }

        @Override
        protected String getSeparatorString(int nodeIndex) {
            return super.getSeparatorString(nodeIndex);
        }
    }

    class ParagraphListRewriter
    extends ListRewriter {
        public static final int DEFAULT_SPACING = 1;
        private int initialIndent;
        private int separatorLines;

        public ParagraphListRewriter(int initialIndent, int separator) {
            this.initialIndent = initialIndent;
            this.separatorLines = separator;
        }

        @Override
        protected int getInitialIndent() {
            return this.initialIndent;
        }

        @Override
        protected String getSeparatorString(int nodeIndex) {
            int newLines = this.separatorLines == -1 ? this.getNewLines(nodeIndex) : this.separatorLines;
            String lineDelim = ASTRewriteAnalyzer.this.getLineDelimiter();
            StringBuffer buf = new StringBuffer(lineDelim);
            int i = 0;
            while (i < newLines) {
                buf.append(lineDelim);
                ++i;
            }
            buf.append(ASTRewriteAnalyzer.this.createIndentString(this.getNodeIndent(nodeIndex + 1)));
            return buf.toString();
        }

        private ASTNode getNode(int nodeIndex) {
            ASTNode elem = (ASTNode)this.list[nodeIndex].getOriginalValue();
            if (elem == null) {
                elem = (ASTNode)this.list[nodeIndex].getNewValue();
            }
            return elem;
        }

        private int getNewLines(int nodeIndex) {
            ASTNode curr = this.getNode(nodeIndex);
            ASTNode next = this.getNode(nodeIndex + 1);
            int currKind = curr.getType();
            int nextKind = next.getType();
            ASTNode last = null;
            ASTNode secondLast = null;
            int i = 0;
            while (i < this.list.length) {
                ASTNode elem = (ASTNode)this.list[i].getOriginalValue();
                if (elem != null) {
                    if (last != null) {
                        if (elem.getType() == nextKind && last.getType() == currKind) {
                            return this.countEmptyLines(last);
                        }
                        secondLast = last;
                    }
                    last = elem;
                }
                ++i;
            }
            if (currKind == 25 && nextKind == 25) {
                return 0;
            }
            if (secondLast != null) {
                return this.countEmptyLines(secondLast);
            }
            return 1;
        }

        private int countEmptyLines(ASTNode last) {
            LineInformation lineInformation = ASTRewriteAnalyzer.this.getLineInformation();
            int lastLine = lineInformation.getLineOfOffset(ASTRewriteAnalyzer.this.getExtendedEnd(last));
            if (lastLine >= 0) {
                int startLine = lastLine + 1;
                int start = lineInformation.getLineOffset(startLine);
                if (start < 0) {
                    return 0;
                }
                char[] cont = ASTRewriteAnalyzer.this.getContent();
                int i = start;
                while (i < cont.length && ScannerHelper.isWhitespace((char)cont[i])) {
                    ++i;
                }
                if (i > start && (lastLine = lineInformation.getLineOfOffset(i)) > startLine) {
                    return lastLine - startLine;
                }
            }
            return 0;
        }
    }

    class SwitchListRewriter
    extends ParagraphListRewriter {
        public SwitchListRewriter(int initialIndent) {
            super(initialIndent, 0);
        }

        @Override
        protected int getNodeIndent(int nodeIndex) {
            int indent = this.getInitialIndent();
            ASTNode node = (ASTNode)this.list[nodeIndex].getOriginalValue();
            if (node == null) {
                node = (ASTNode)this.list[nodeIndex].getNewValue();
            }
            if (node.getType() != 55) {
                ++indent;
            }
            return indent;
        }
    }
}

