/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.AliasField;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallArgumentsList;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.TraitAliasStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.model.PerFileModelAccessCache;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPTraitType;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPSelectionEngine
extends ScriptSelectionEngine {
    private static final String OPEN_BRACE = "(";
    private static final String PROTECTED = "protected";
    private static final String PUBLIC = "public";
    private static final String PAAMAYIM_NEKUDOTAIM = "::";
    private static final String NS_SEPARATOR = "\\";
    private static final String CONST = "const";
    private static final String THIS = "this";
    private static final String STATIC = "static";
    private static final String PRIVATE = "private";
    private static final String VAR = "var";
    private static final String IMPLEMENTS = "implements";
    private static final String EXTENDS = "extends";
    private static final String NEW = "new";
    private static final String INTERFACE = "interface";
    private static final String CLASS = "class";
    private static final String FUNCTION = "function";
    private static final String INSTEADOF = "insteadof";
    private static final String AS = "as";
    private static final IModelElement[] EMPTY = new IModelElement[0];
    private PHPVersion phpVersion;

    public IModelElement[] select(IModuleSource sourceUnit, int offset, int end) {
        IStructuredDocument document;
        PerFileModelAccessCache cache;
        ISourceModule sourceModule;
        block29: {
            if (!PHPCorePlugin.toolkitInitialized) {
                return EMPTY;
            }
            if (end < offset) {
                end = offset + 1;
            }
            sourceModule = (ISourceModule)sourceUnit.getModelElement();
            this.phpVersion = ProjectOptions.getPhpVersion(sourceModule.getScriptProject().getProject());
            cache = new PerFileModelAccessCache(sourceModule){

                @Override
                protected <T extends IModelElement> Collection<T> filterElements(ISourceModule sourceModule, Collection<T> elements, IProgressMonitor monitor) {
                    return elements;
                }
            };
            try {
                IModelElement[] elements = this.internalASTResolve(sourceModule, cache, offset, end);
                if (elements != null) {
                    Collection<IModelElement> filtered = PHPModelUtils.filterElements(sourceModule, Arrays.asList(elements), null, null);
                    return filtered.toArray(new IModelElement[filtered.size()]);
                }
            }
            catch (Exception e) {
                PHPCorePlugin.log(e);
            }
            document = null;
            IStructuredModel structuredModel = null;
            try {
                try {
                    IFile file = (IFile)sourceUnit.getModelElement().getResource();
                    if (file != null) {
                        if (file.exists()) {
                            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                            document = structuredModel != null ? structuredModel.getStructuredDocument() : StructuredModelManager.getModelManager().createStructuredDocumentFor(file);
                        } else {
                            document = StructuredModelManager.getModelManager().createNewStructuredDocumentFor(file);
                            document.set(sourceUnit.getSourceContents());
                        }
                    }
                }
                catch (Exception e) {
                    PHPCorePlugin.log(e);
                    if (structuredModel != null) {
                        structuredModel.releaseFromRead();
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
                throw throwable;
            }
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
        if (document == null) {
            return EMPTY;
        }
        IModelElement[] elements = this.internalResolve(document, sourceModule, cache, offset, end);
        if (elements == null) {
            return EMPTY;
        }
        Collection<IModelElement> filtered = PHPModelUtils.filterElements(sourceModule, Arrays.asList(elements), cache, null);
        if (filtered.size() == 0) {
            return EMPTY;
        }
        IStructuredDocumentRegion sRegion = document.getRegionAtCharacterOffset(offset);
        if (sRegion != null) {
            ITextRegion tRegion = sRegion.getRegionAtCharacterOffset(offset);
            IStructuredDocumentRegion container = sRegion;
            if (tRegion instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
            }
            if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
                int elementStart;
                TextSequence statement;
                IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
                try {
                    tRegion = phpScriptRegion.getPhpToken(offset - container.getStartOffset() - phpScriptRegion.getStart());
                }
                catch (BadLocationException badLocationException) {}
                if (tRegion != null && (statement = PHPTextSequenceUtilities.getStatement((elementStart = container.getStartOffset() + phpScriptRegion.getStart() + tRegion.getStart()) + tRegion.getLength(), sRegion, true)).length() != 0) {
                    int endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statement, statement.length());
                    int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statement, endPosition, true);
                    String elementName = statement.subSequence(startPosition, endPosition).toString();
                    LinkedList<IModelElement> result = new LinkedList<IModelElement>();
                    for (IModelElement modelElement : filtered) {
                        if (modelElement instanceof AliasField) {
                            AliasField aliasField = (AliasField)modelElement;
                            if (!aliasField.getAlias().equals(elementName)) continue;
                            result.add(aliasField.getField());
                            continue;
                        }
                        if (modelElement instanceof IField) {
                            String fieldName = elementName;
                            if (!fieldName.startsWith("$")) {
                                fieldName = "$" + fieldName;
                            }
                            if (!modelElement.getElementName().equals(fieldName) && !modelElement.getElementName().equals(elementName)) continue;
                            result.add(modelElement);
                            continue;
                        }
                        if (!modelElement.getElementName().equals(elementName)) continue;
                        result.add(modelElement);
                    }
                    return result.toArray(new IModelElement[result.size()]);
                }
            }
        }
        return filtered.toArray(new IModelElement[filtered.size()]);
    }

    private IModelElement[] internalASTResolve(ISourceModule sourceModule, IModelAccessCache cache, int offset, int end) throws ModelException {
        ASTNode node;
        ModuleDeclaration parsedUnit;
        String source;
        try {
            source = sourceModule.getSource();
            offset = PHPTextSequenceUtilities.readIdentifierStartIndex(source, offset, true);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        end = PHPTextSequenceUtilities.readIdentifierEndIndex(source, end, true);
        int methodEnd = PHPTextSequenceUtilities.getMethodEndIndex(source, end);
        if (methodEnd != -1) {
            end = methodEnd;
        }
        if ((parsedUnit = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null)) instanceof PHPModuleDeclaration) {
            PHPModuleDeclaration phpModuleDeclaration = (PHPModuleDeclaration)parsedUnit;
            List<PHPDocBlock> phpBlocks = phpModuleDeclaration.getPhpDocBlocks();
            for (PHPDocBlock phpDocBlock : phpBlocks) {
                int realStart = phpDocBlock.sourceStart();
                int realEnd = phpDocBlock.sourceEnd();
                if (realStart > offset || realEnd < end) continue;
                PHPDocTag[] tags = phpDocBlock.getTags();
                return this.lookForMatchingTypes(tags, sourceModule, offset, end, cache);
            }
        }
        if ((node = ASTUtils.findMinimalNode(parsedUnit, offset, end)) == null) {
            return null;
        }
        IContext context = ASTUtils.findContext(sourceModule, parsedUnit, node);
        if (context == null) {
            return null;
        }
        if (context instanceof IModelCacheContext) {
            ((IModelCacheContext)context).setCache(cache);
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        if (node instanceof PHPCallExpression) {
            return this.processPHPCallExpression((PHPCallExpression)node, sourceModule, parsedUnit, offset, context, cache);
        }
        if (node instanceof StaticDispatch) {
            IEvaluatedType dispatcherType;
            Expression field;
            StaticDispatch dispatch = (StaticDispatch)node;
            String fieldName = null;
            if (dispatch instanceof StaticConstantAccess) {
                fieldName = ((StaticConstantAccess)dispatch).getConstant().getName();
            } else if (dispatch instanceof StaticFieldAccess && (field = ((StaticFieldAccess)dispatch).getField()) instanceof VariableReference) {
                fieldName = ((VariableReference)field).getName();
            }
            if (fieldName != null && dispatch.getDispatcher() != null && (dispatcherType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, (ASTNode)dispatch.getDispatcher())) != null) {
                IType[] elements = PHPTypeInferenceUtils.getModelElements(dispatcherType, (ISourceModuleContext)context, offset);
                LinkedList<IField> fields = new LinkedList<IField>();
                if (elements != null) {
                    IType[] iTypeArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType element = iTypeArray[n2];
                        if (element instanceof IType) {
                            IType type = element;
                            try {
                                fields.addAll(Arrays.asList(PHPModelUtils.getTypeHierarchyField(type, cache.getSuperTypeHierarchy(type, (IProgressMonitor)new NullProgressMonitor()), fieldName, true, (IProgressMonitor)new NullProgressMonitor())));
                            }
                            catch (Exception e) {
                                PHPCorePlugin.log(e);
                            }
                        }
                        ++n2;
                    }
                }
                return fields.toArray(new IModelElement[fields.size()]);
            }
        } else if (node instanceof FieldAccess) {
            IEvaluatedType dispatcherType;
            FieldAccess fieldAccess = (FieldAccess)node;
            Expression field = fieldAccess.getField();
            String fieldName = null;
            if (field instanceof SimpleReference) {
                fieldName = ((SimpleReference)field).getName();
            }
            if (fieldName != null && fieldAccess.getDispatcher() != null && (dispatcherType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, (ASTNode)fieldAccess.getDispatcher())) != null) {
                IType[] elements = PHPTypeInferenceUtils.getModelElements(dispatcherType, (ISourceModuleContext)context, offset);
                LinkedList<IField> fields = new LinkedList<IField>();
                if (elements != null) {
                    IType[] iTypeArray = elements;
                    int n = elements.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IType element = iTypeArray[n3];
                        if (element instanceof IType) {
                            IType type = element;
                            try {
                                fields.addAll(Arrays.asList(PHPModelUtils.getTypeField(type, fieldName, true)));
                            }
                            catch (ModelException e) {
                                PHPCorePlugin.log(e);
                            }
                        }
                        ++n3;
                    }
                }
                return fields.toArray(new IModelElement[fields.size()]);
            }
        } else {
            if (node instanceof NamespaceReference) {
                String name = ((NamespaceReference)node).getName();
                IType[] namespace = PHPModelUtils.getNamespaceOf(String.valueOf(name) + '\\', sourceModule, offset, cache, null);
                return namespace == null ? EMPTY : namespace;
            }
            if (node instanceof TypeReference) {
                TypeReference typeReference = (TypeReference)node;
                IEvaluatedType evaluatedType = PHPTypeInferenceUtils.resolveExpression(sourceModule, node);
                if (evaluatedType == null) {
                    return EMPTY;
                }
                String name = evaluatedType.getTypeName();
                IType[] types = PHPModelUtils.getTypes(name, sourceModule, offset, cache, null, !(evaluatedType instanceof PHPTraitType));
                if (types == null || types.length == 0) {
                    if (name.charAt(0) == '\\') {
                        name = name.substring(1);
                    }
                    if ((types = evaluatedType instanceof PHPTraitType ? PhpModelAccess.getDefault().findTraits(null, name, ISearchEngine.MatchRule.EXACT, 2048, 0, scope, null) : PhpModelAccess.getDefault().findTypes(null, name, ISearchEngine.MatchRule.EXACT, 2048, 0, scope, null)) == null || types.length == 0) {
                        name = String.valueOf('\\') + name;
                        types = PHPModelUtils.getFields(name, sourceModule, offset, cache, null);
                    }
                    if (types == null || types.length == 0) {
                        types = PHPModelUtils.getFunctions(name, sourceModule, offset, cache, null);
                    }
                    if (types == null || types.length == 0) {
                        types = PHPModelUtils.getFunctions(typeReference.getName(), sourceModule, offset, cache, null);
                    }
                }
                return types;
            }
            if (node instanceof ClassInstanceCreation) {
                ClassInstanceCreation newNode = (ClassInstanceCreation)node;
                Expression className = newNode.getClassName();
                if (className instanceof SimpleReference || className instanceof FullyQualifiedReference) {
                    IEvaluatedType evaluatedType = PHPTypeInferenceUtils.resolveExpression(sourceModule, node);
                    return PHPSelectionEngine.getConstructorsIfAny(PHPSelectionEngine.extractClasses(PHPModelUtils.getTypes(evaluatedType.getTypeName(), sourceModule, offset, cache, null)));
                }
                if (className instanceof StaticFieldAccess) {
                    StaticFieldAccess staticFieldAccess = (StaticFieldAccess)className;
                    if (offset >= staticFieldAccess.getDispatcher().sourceStart() && offset <= staticFieldAccess.getDispatcher().sourceEnd()) {
                        className = staticFieldAccess.getDispatcher();
                        IEvaluatedType evaluatedType = PHPTypeInferenceUtils.resolveExpression(sourceModule, (ASTNode)className);
                        return PHPSelectionEngine.extractClasses(PHPModelUtils.getTypes(evaluatedType.getTypeName(), sourceModule, offset, cache, null));
                    }
                    if (offset >= staticFieldAccess.getField().sourceStart() && offset <= staticFieldAccess.getField().sourceEnd()) {
                        IEvaluatedType dispatcherType;
                        className = staticFieldAccess.getField();
                        String fieldName = null;
                        Expression field = staticFieldAccess.getField();
                        if (field instanceof VariableReference) {
                            fieldName = ((VariableReference)field).getName();
                        }
                        if (fieldName != null && staticFieldAccess.getDispatcher() != null && (dispatcherType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, (ASTNode)staticFieldAccess.getDispatcher())) != null) {
                            IType[] elements = PHPTypeInferenceUtils.getModelElements(dispatcherType, (ISourceModuleContext)context, offset);
                            LinkedList<IField> fields = new LinkedList<IField>();
                            if (elements != null) {
                                IType[] e = elements;
                                int type = elements.length;
                                int n = 0;
                                while (n < type) {
                                    IType element = e[n];
                                    if (element instanceof IType) {
                                        IType type2 = element;
                                        try {
                                            fields.addAll(Arrays.asList(PHPModelUtils.getTypeField(type2, fieldName, true)));
                                        }
                                        catch (ModelException e2) {
                                            PHPCorePlugin.log(e2);
                                        }
                                    }
                                    ++n;
                                }
                            }
                            return fields.toArray(new IModelElement[fields.size()]);
                        }
                    }
                }
            } else if ((node instanceof TypeDeclaration || node instanceof MethodDeclaration) && ((Declaration)node).getNameStart() <= offset && ((Declaration)node).getNameEnd() >= offset) {
                IModelElement element = sourceModule.getElementAt(node.sourceStart());
                if (element != null) {
                    return new IModelElement[]{element};
                }
            } else if (node instanceof SimpleReference) {
                SimpleReference reference = (SimpleReference)node;
                if ((node = ASTUtils.findMinimalNode(parsedUnit, offset, node.end() + 1)) instanceof TraitAliasStatement && (node = ASTUtils.findMinimalNode(parsedUnit, offset, node.end() + 1)) instanceof TraitUseStatement) {
                    TraitUseStatement statement = (TraitUseStatement)node;
                    LinkedList<IModelElement> methods = new LinkedList<IModelElement>();
                    for (TypeReference typeReference : statement.getTraitList()) {
                        IType[] types;
                        IType[] iTypeArray = types = PHPModelUtils.getTypes(typeReference.getName(), sourceModule, offset, cache, null, false);
                        int n = types.length;
                        int n4 = 0;
                        while (n4 < n) {
                            IModelElement[] children;
                            IType t = iTypeArray[n4];
                            IModelElement[] iModelElementArray = children = t.getChildren();
                            int n5 = children.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IModelElement modelElement = iModelElementArray[n6];
                                String name = modelElement.getElementName();
                                if (name.startsWith("$")) {
                                    name = name.substring(1);
                                }
                                if (name.equals(reference.getName())) {
                                    methods.add(modelElement);
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                    }
                    return (IModelElement[])methods.toArray(new IMethod[methods.size()]);
                }
            }
        }
        return null;
    }

    private IType[] lookForMatchingTypes(PHPDocTag[] tags, ISourceModule sourceModule, int offset, int end, IModelAccessCache cache) throws ModelException {
        if (tags == null) {
            return null;
        }
        PHPDocTag[] pHPDocTagArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleReference[] references;
            PHPDocTag phpDocTag = pHPDocTagArray[n2];
            if (phpDocTag.sourceStart() <= offset && phpDocTag.sourceEnd() >= end && (references = phpDocTag.getReferences()) != null) {
                SimpleReference[] simpleReferenceArray = references;
                int n3 = references.length;
                int n4 = 0;
                while (n4 < n3) {
                    TypeReference typeReference;
                    SimpleReference simpleReference = simpleReferenceArray[n4];
                    if (simpleReference instanceof TypeReference && (typeReference = (TypeReference)simpleReference).sourceStart() <= offset && typeReference.sourceEnd() >= end) {
                        String name = typeReference.getName();
                        if (typeReference.sourceEnd() > end) {
                            int startShift = offset - typeReference.sourceStart();
                            name = typeReference.getName().substring(startShift, end - offset + startShift);
                        }
                        IType[] types = this.filterNS(PHPModelUtils.getTypes(name, sourceModule, offset, cache, null));
                        return types;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private IType[] filterNS(IType[] types) throws ModelException {
        if (types == null) {
            return types;
        }
        HashSet<IType> result = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (PHPFlags.isClass(type.getFlags()) || PHPFlags.isInterface((int)type.getFlags())) {
                result.add(type);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private IModelElement[] internalResolve(IStructuredDocument sDoc, ISourceModule sourceModule, IModelAccessCache cache, int offset, int end) {
        block46: {
            IStructuredDocumentRegion sRegion = sDoc.getRegionAtCharacterOffset(offset);
            if (sRegion == null) {
                return EMPTY;
            }
            ITextRegion tRegion = sRegion.getRegionAtCharacterOffset(offset);
            IStructuredDocumentRegion container = sRegion;
            if (tRegion instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
            }
            try {
                IType containerType;
                String nextWord;
                String prevWord;
                String elementName;
                int startPosition;
                TextSequence statement;
                int elementStart;
                block47: {
                    IModelElement[] generalizationTypes;
                    boolean isClassDeclaration;
                    int endPosition;
                    block49: {
                        block48: {
                            if (tRegion == null || tRegion.getType() != "PHP_CONTENT") break block46;
                            IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
                            if ((tRegion = phpScriptRegion.getPhpToken(offset - container.getStartOffset() - phpScriptRegion.getStart())) == null) {
                                return EMPTY;
                            }
                            elementStart = container.getStartOffset() + phpScriptRegion.getStart() + tRegion.getStart();
                            statement = PHPTextSequenceUtilities.getStatement(elementStart + tRegion.getLength(), sRegion, true);
                            if (statement.length() == 0) {
                                return EMPTY;
                            }
                            endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statement, statement.length());
                            startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statement, endPosition, true);
                            elementName = statement.subSequence(startPosition, endPosition).toString();
                            int prevWordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statement, startPosition);
                            int prevWordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statement, prevWordEnd, false);
                            prevWord = statement.subSequence(prevWordStart, prevWordEnd).toString();
                            ITextRegion nextRegion = tRegion;
                            while ((PHPPartitionTypes.isPHPCommentState((nextRegion = phpScriptRegion.getPhpToken(nextRegion.getEnd())).getType()) || nextRegion.getType() == "WHITESPACE") && nextRegion.getEnd() < phpScriptRegion.getLength()) {
                            }
                            nextWord = sDoc.get(container.getStartOffset() + phpScriptRegion.getStart() + nextRegion.getStart(), nextRegion.getTextLength());
                            if (elementName.length() <= 0) break block46;
                            containerType = PHPModelUtils.getCurrentType(sourceModule, offset);
                            if (containerType == null) {
                                containerType = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                            }
                            if (FUNCTION.equalsIgnoreCase(prevWord)) {
                                if (containerType != null) {
                                    return PHPModelUtils.getTypeMethod(containerType, elementName, true);
                                }
                                return PHPSelectionEngine.getFunction(sourceModule, elementName);
                            }
                            if (CLASS.equalsIgnoreCase(prevWord) || INTERFACE.equalsIgnoreCase(prevWord)) {
                                if (containerType != null) {
                                    if (containerType.getElementName().equalsIgnoreCase(elementName)) {
                                        containerType = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                                    }
                                    if (containerType != null) {
                                        return PHPModelUtils.getTypeType(containerType, elementName, true);
                                    }
                                }
                                return PHPSelectionEngine.getClass(sourceModule, elementName);
                            }
                            if (NEW.equalsIgnoreCase(prevWord)) {
                                return PHPSelectionEngine.getConstructorsIfAny(PHPSelectionEngine.extractClasses(PHPModelUtils.getTypes(elementName, sourceModule, offset, cache, null)));
                            }
                            isClassDeclaration = false;
                            if (statement.length() <= 6) break block47;
                            if (!CLASS.equals(statement.subSequence(0, 5).toString())) break block48;
                            isClassDeclaration = true;
                            if (true) break block49;
                        }
                        if (statement.length() <= 10 || !INTERFACE.equals(statement.subSequence(0, 9).toString())) break block47;
                    }
                    if ((generalizationTypes = PHPSelectionEngine.getGeneralizationTypes(sourceModule, isClassDeclaration, prevWord, elementName, offset)) != null) {
                        return generalizationTypes;
                    }
                    int listStartPosition = PHPTextSequenceUtilities.readIdentifierListStartIndex(statement, endPosition);
                    int preListWordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statement, listStartPosition);
                    int preListWordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statement, preListWordEnd, false);
                    String preListWord = statement.subSequence(preListWordStart, preListWordEnd).toString();
                    generalizationTypes = PHPSelectionEngine.getGeneralizationTypes(sourceModule, isClassDeclaration, preListWord, elementName, offset);
                    if (generalizationTypes != null) {
                        return generalizationTypes;
                    }
                }
                String trigger = null;
                if (startPosition > 2) {
                    trigger = statement.subSequence(startPosition - 2, startPosition).toString();
                }
                if (elementName.charAt(0) == '$' && !PAAMAYIM_NEKUDOTAIM.equals(trigger)) {
                    if (PHPPartitionTypes.isPHPQuotesState(tRegion.getType())) {
                        try {
                            char charBefore = sDoc.get(elementStart - 2, 1).charAt(0);
                            if (charBefore == '\\') {
                                return EMPTY;
                            }
                        }
                        catch (BadLocationException e) {
                            PHPCorePlugin.log(e);
                        }
                    }
                    if (containerType != null) {
                        if (VAR.equalsIgnoreCase(prevWord) || PRIVATE.equalsIgnoreCase(prevWord) || STATIC.equalsIgnoreCase(prevWord) || PUBLIC.equalsIgnoreCase(prevWord) || PROTECTED.equalsIgnoreCase(prevWord)) {
                            return PHPModelUtils.getTypeField(containerType, elementName, true);
                        }
                        if (THIS.equalsIgnoreCase(elementName)) {
                            return new IModelElement[]{containerType};
                        }
                    }
                    return PHPSelectionEngine.getGlobalOrMethodFields(sourceModule, offset, elementName);
                }
                if (containerType != null && CONST.equalsIgnoreCase(prevWord)) {
                    return PHPModelUtils.getTypeField(containerType, elementName, true);
                }
                if (PAAMAYIM_NEKUDOTAIM.equals(nextWord)) {
                    return PHPModelUtils.getTypes(elementName, sourceModule, offset, cache, null);
                }
                if (NS_SEPARATOR.equals(nextWord)) {
                    IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
                    return PhpModelAccess.getDefault().findTypes(null, elementName, ISearchEngine.MatchRule.EXACT, 2048, 0, scope, null);
                }
                IType[] types = CodeAssistUtils.getTypesFor(sourceModule, statement, startPosition, offset);
                if (OPEN_BRACE.equals(nextWord) || PHPPartitionTypes.isPHPDocState(tRegion.getType())) {
                    if (types != null && types.length > 0) {
                        LinkedList<IMethod> methods = new LinkedList<IMethod>();
                        IType[] iTypeArray = types;
                        int n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType t = iTypeArray[n2];
                            methods.addAll(Arrays.asList(PHPModelUtils.getTypeHierarchyMethod(t, cache.getSuperTypeHierarchy(t, null), elementName, true, null)));
                            ++n2;
                        }
                        return (IModelElement[])methods.toArray(new IMethod[methods.size()]);
                    }
                    return PHPModelUtils.getFunctions(elementName, sourceModule, offset, cache, null);
                }
                if ((INSTEADOF.equals(nextWord) || AS.equals(nextWord)) && !PAAMAYIM_NEKUDOTAIM.equals(trigger) && types != null && types.length > 0) {
                    LinkedList<IMethod> methods = new LinkedList<IMethod>();
                    IType[] iTypeArray = types;
                    int n = types.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IType t = iTypeArray[n3];
                        methods.addAll(Arrays.asList(PHPModelUtils.getTypeHierarchyMethod(t, cache.getSuperTypeHierarchy(t, null), elementName, true, null)));
                        ++n3;
                    }
                    return (IModelElement[])methods.toArray(new IMethod[methods.size()]);
                }
                if (types != null && types.length > 0) {
                    if (startPosition > 0 && PAAMAYIM_NEKUDOTAIM.equals(trigger) && elementName.charAt(0) != '$') {
                        LinkedList<IField> fields = new LinkedList<IField>();
                        IType[] iTypeArray = types;
                        int n = types.length;
                        int n4 = 0;
                        while (n4 < n) {
                            IField[] typeFields;
                            IType t = iTypeArray[n4];
                            IField[] iFieldArray = typeFields = PHPModelUtils.getTypeField(t, elementName, true);
                            int n5 = typeFields.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IField currentField = iFieldArray[n6];
                                fields.add(currentField);
                                ++n6;
                            }
                            ++n4;
                        }
                        return fields.toArray(new IModelElement[fields.size()]);
                    }
                    ArrayList<IField> fields = new ArrayList<IField>();
                    IType[] iTypeArray = types;
                    int n = types.length;
                    int n7 = 0;
                    while (n7 < n) {
                        IType t = iTypeArray[n7];
                        fields.addAll(Arrays.asList(PHPSelectionEngine.getTypeHierarchyField(t, cache.getSuperTypeHierarchy(t, null), elementName, true, null)));
                        ++n7;
                    }
                    return fields.toArray(new IModelElement[fields.size()]);
                }
                IField[] fields = PHPModelUtils.getFields(elementName, sourceModule, offset, cache, null);
                if (fields != null && fields.length > 0) {
                    return fields;
                }
                ModuleDeclaration parsedUnit = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
                fields = this.findFieldAliases(elementName, sourceModule, parsedUnit, containerType, offset);
                if (fields != null && fields.length > 0) {
                    return fields;
                }
                return PHPModelUtils.getTypes(elementName, sourceModule, offset, cache, null);
            }
            catch (Exception e) {
                PHPCorePlugin.log(e);
            }
        }
        return EMPTY;
    }

    private IModelElement[] processPHPCallExpression(PHPCallExpression callExpression, ISourceModule sourceModule, ModuleDeclaration parsedUnit, int offset, IContext context, IModelAccessCache cache) throws ModelException {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        if (callExpression.getReceiver() != null) {
            PHPCallExpression receiverCallExpression;
            IEvaluatedType receiverType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, callExpression.getReceiver());
            if (receiverType instanceof MultiTypeType && callExpression.getReceiver() instanceof PHPCallExpression && ((PHPCallArgumentsList)(receiverCallExpression = (PHPCallExpression)callExpression.getReceiver()).getArgs()).getArrayDereferenceList() != null && !((PHPCallArgumentsList)receiverCallExpression.getArgs()).getArrayDereferenceList().getChilds().isEmpty()) {
                receiverType = new AmbiguousType(((MultiTypeType)receiverType).getTypes().toArray(new IEvaluatedType[0]));
            }
            if (receiverType != null) {
                IType element;
                int n;
                int n2;
                IType[] iTypeArray;
                IType[] elements = null;
                if (receiverType instanceof PHPClassType && ((PHPClassType)receiverType).isGlobal()) {
                    elements = PhpModelAccess.getDefault().findTypes(receiverType.getTypeName(), ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
                    LinkedList<IType> result = new LinkedList<IType>();
                    iTypeArray = elements;
                    n2 = elements.length;
                    n = 0;
                    while (n < n2) {
                        element = iTypeArray[n];
                        IModelElement parent = element.getParent();
                        while (parent.getParent() instanceof IType) {
                            parent = parent.getParent();
                        }
                        if (!(parent instanceof IType) || !PHPFlags.isNamespace(((IType)parent).getFlags())) {
                            result.add(element);
                        }
                        ++n;
                    }
                    elements = (IModelElement[])result.toArray(new IType[result.size()]);
                } else {
                    elements = PHPTypeInferenceUtils.getModelElements(receiverType, (ISourceModuleContext)context, offset);
                }
                if (elements == null) {
                    return EMPTY;
                }
                LinkedList<IMethod> methods = new LinkedList<IMethod>();
                iTypeArray = elements;
                n2 = elements.length;
                n = 0;
                while (n < n2) {
                    element = iTypeArray[n];
                    if (element instanceof IType) {
                        IType type = element;
                        try {
                            ITypeHierarchy hierarchy = cache.getSuperTypeHierarchy(type, null);
                            IMethod[] method = PHPModelUtils.getFirstTypeHierarchyMethod(type, hierarchy, callExpression.getName(), true, null);
                            methods.addAll(Arrays.asList(method));
                        }
                        catch (CoreException e) {
                            PHPCorePlugin.log(e);
                        }
                    }
                    ++n;
                }
                return methods.toArray(new IModelElement[methods.size()]);
            }
        } else {
            IType currentNamespace;
            Map<String, UsePart> useParts;
            SimpleReference callName = callExpression.getCallName();
            String methodName = callName instanceof FullyQualifiedReference ? ((FullyQualifiedReference)callName).getFullyQualifiedName() : callName.getName();
            IMethod[] members = PHPModelUtils.getFunctions(methodName, sourceModule, offset, cache, null);
            if ((members == null || members.length == 0) && (useParts = PHPModelUtils.getAliasToNSMap(methodName, parsedUnit, offset, currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, callExpression.sourceStart()), true)).containsKey(methodName)) {
                String fullName = useParts.get(methodName).getNamespace().getFullyQualifiedName();
                fullName = String.valueOf('\\') + fullName;
                members = PHPModelUtils.getFunctions(fullName, sourceModule, offset, null, null);
            }
            return members == null ? EMPTY : members;
        }
        return EMPTY;
    }

    private IField[] findFieldAliases(String fieldName, ISourceModule sourceModule, ModuleDeclaration parsedUnit, IType currentNamespace, int offset) throws ModelException {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        Map<String, UsePart> useParts = PHPModelUtils.getAliasToNSMap(fieldName, parsedUnit, offset, currentNamespace, true);
        if (useParts.containsKey(fieldName)) {
            String fullName = useParts.get(fieldName).getNamespace().getFullyQualifiedName();
            IField[] elements = PhpModelAccess.getDefault().findFields(fullName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            if (elements != null) {
                ArrayList<AliasField> result = new ArrayList<AliasField>();
                IField[] iFieldArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    result.add(new AliasField((ModelElement)field, field.getFullyQualifiedName(), fieldName));
                    ++n2;
                }
                return result.toArray(new IField[0]);
            }
        }
        return null;
    }

    public static IField[] getTypeHierarchyField(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        ArrayList<IField> fields = new ArrayList<IField>();
        fields.addAll(Arrays.asList(PHPModelUtils.getTypeField(type, prefix, exactName)));
        if (type.getSuperClasses() != null && type.getSuperClasses().length > 0) {
            IField[] temp;
            TreeSet<IModelElement> fieldSet = new TreeSet<IModelElement>(new SourceFieldComparator());
            fieldSet.addAll(Arrays.asList(PHPModelUtils.getSuperTypeHierarchyField(type, hierarchy, prefix, exactName, monitor)));
            IField[] iFieldArray = temp = fieldSet.toArray(new IField[fieldSet.size()]);
            int n = temp.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                fields.add(field);
                ++n2;
            }
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private static IModelElement[] getGeneralizationTypes(ISourceModule sourceModule, boolean isClassDeclaration, String generalization, String elementName, int offset) throws ModelException {
        if (EXTENDS.equalsIgnoreCase(generalization)) {
            if (isClassDeclaration) {
                return PHPSelectionEngine.extractClasses(PHPModelUtils.getTypes(elementName, sourceModule, offset, null, null));
            }
            return PHPSelectionEngine.extractInterfaces(PHPModelUtils.getTypes(elementName, sourceModule, offset, null, null));
        }
        if (IMPLEMENTS.equalsIgnoreCase(generalization)) {
            return PHPSelectionEngine.extractInterfaces(PHPModelUtils.getTypes(elementName, sourceModule, offset, null, null));
        }
        return null;
    }

    private static IModelElement[] getFunction(ISourceModule sourceModule, String elementName) throws ModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = ((AbstractSourceModule)sourceModule).getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equalsIgnoreCase(elementName)) {
                return new IModelElement[]{method};
            }
            ++n2;
        }
        return EMPTY;
    }

    private static IModelElement[] getClass(ISourceModule sourceModule, String elementName) throws ModelException {
        IType[] types;
        IType[] iTypeArray = types = sourceModule.getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type.getElementName().equalsIgnoreCase(elementName)) {
                return new IModelElement[]{type};
            }
            ++n2;
        }
        return EMPTY;
    }

    private static IType[] extractInterfaces(IType[] types) {
        ArrayList<IType> result = new ArrayList<IType>(types.length);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                if (PHPFlags.isInterface((int)type.getFlags())) {
                    result.add(type);
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static IType[] extractClasses(IType[] types) {
        ArrayList<IType> result = new ArrayList<IType>(types.length);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                if (PHPFlags.isClass(type.getFlags())) {
                    result.add(type);
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static IModelElement[] getConstructorsIfAny(IType[] types) throws ModelException {
        LinkedList<Object> result = new LinkedList<Object>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            boolean hasConstructor = false;
            IMethod[] iMethodArray = type.getMethods();
            int n3 = iMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod method = iMethodArray[n4];
                if (method.isConstructor()) {
                    result.add(method);
                    hasConstructor = true;
                    break;
                }
                ++n4;
            }
            if (!hasConstructor) {
                result.add(type);
            }
            ++n2;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    private static IModelElement[] getGlobalOrMethodFields(ISourceModule sourceModule, int offset, String prefix) throws ModelException {
        try {
            IModelElement enclosingElement = sourceModule.getElementAt(offset);
            if (enclosingElement instanceof IField) {
                enclosingElement = enclosingElement.getParent();
            }
            if (enclosingElement instanceof IMethod) {
                IMethod method = (IMethod)enclosingElement;
                return PHPModelUtils.getMethodFields(method, prefix, true, null);
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return PHPModelUtils.getFields(prefix, sourceModule, offset, null, null);
    }

    private static class SourceFieldComparator
    implements Comparator<IModelElement> {
        private SourceFieldComparator() {
        }

        @Override
        public int compare(IModelElement o1, IModelElement o2) {
            SourceRefElement e2;
            SourceRefElement e1;
            block4: {
                try {
                    e1 = (SourceRefElement)o1;
                    e2 = (SourceRefElement)o2;
                    IType type1 = (IType)e1.getAncestor(7);
                    IType type2 = (IType)e2.getAncestor(7);
                    if (type1 == null || type2 == null || type1 == type2) break block4;
                    return -1;
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                    return 0;
                }
            }
            if (e1.getSourceModule() == e2.getSourceModule()) {
                ISourceRange r1 = e1.getSourceRange();
                ISourceRange r2 = e2.getSourceRange();
                return (int)Math.signum(r1.getOffset() - r2.getOffset());
            }
            return -1;
        }
    }
}

