/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespaceMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.UseNameContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementStrategy;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.typeinference.FakeMethod;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class GlobalTypesStrategy
extends GlobalElementStrategy {
    private static final String SPLASH = "\\";
    protected final int trueFlag;
    protected final int falseFlag;
    protected static final IType[] EMPTY = new IType[0];
    private boolean aliasAdded = false;
    private boolean addClassInNamespace = false;

    public GlobalTypesStrategy(ICompletionContext context, int trueFlag, int falseFlag) {
        super(context, null);
        this.trueFlag = trueFlag;
        this.falseFlag = falseFlag;
    }

    public GlobalTypesStrategy(ICompletionContext context, int trueFlag, int falseFlag, boolean addClassInNamespace) {
        super(context, null);
        this.trueFlag = trueFlag;
        this.falseFlag = falseFlag;
        this.addClassInNamespace = addClassInNamespace;
    }

    public GlobalTypesStrategy(ICompletionContext context) {
        this(context, 0, 0);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        IPHPCompletionRequestor phpCompletionRequestor;
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        if (abstractContext.getCompletionRequestor() instanceof IPHPCompletionRequestor && (phpCompletionRequestor = (IPHPCompletionRequestor)abstractContext.getCompletionRequestor()).filter(2)) {
            return;
        }
        if (abstractContext.getPrefixWithoutProcessing().trim().length() == 0) {
            return;
        }
        boolean isUseContext = context instanceof UseNameContext && !((UseNameContext)context).isUseTrait();
        SourceRange replacementRange = this.getReplacementRange(abstractContext);
        IType[] types = this.getTypes(abstractContext);
        String suffix = "";
        String nsSuffix = this.getNSSuffix(abstractContext);
        int extraInfo = this.getExtraInfo();
        if (abstractContext.getOffset() - abstractContext.getPrefix().length() - 1 >= 0 && (abstractContext.getDocument().getChar(abstractContext.getOffset() - abstractContext.getPrefix().length() - 1) == '\'' || abstractContext.getDocument().getChar(abstractContext.getOffset() - abstractContext.getPrefix().length() - 1) == '\"')) {
            extraInfo |= 0x200;
        }
        if ("namespace".equals(abstractContext.getPreviousWord(1)) || isUseContext) {
            extraInfo |= 0x200;
        }
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                int flags = type.getFlags();
                boolean isNamespace = PHPFlags.isNamespace(flags);
                if (!isNamespace && isUseContext) {
                    reporter.reportType(type, isNamespace ? nsSuffix : suffix, (ISourceRange)replacementRange, extraInfo | 0x80);
                } else {
                    reporter.reportType(type, isNamespace ? nsSuffix : suffix, (ISourceRange)replacementRange, extraInfo);
                }
                if (this.addClassInNamespace && isNamespace) {
                    IType[] subTypes;
                    IType[] iTypeArray2 = subTypes = type.getTypes();
                    int n3 = subTypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType subType = iTypeArray2[n4];
                        int subFlags = type.getFlags();
                        reporter.reportType(subType, PHPFlags.isNamespace(subFlags) ? nsSuffix : suffix, (ISourceRange)replacementRange, extraInfo | 0x80);
                        ++n4;
                    }
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        this.addAlias(reporter, suffix);
    }

    protected void addAlias(ICompletionReporter reporter, String suffix) throws BadLocationException {
        if (this.aliasAdded) {
            return;
        }
        this.aliasAdded = true;
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        if (!abstractContext.getCompletionRequestor().isContextInformationMode()) {
            String prefix = abstractContext.getPrefixWithoutProcessing();
            boolean exactMatch = false;
            if (prefix.indexOf(92) == 0) {
                return;
            }
            if (prefix.indexOf(92) > 0) {
                prefix = prefix.substring(0, prefix.indexOf(92));
                exactMatch = true;
            }
            if (prefix.indexOf(92) < 0) {
                IModuleSource module = reporter.getModule();
                ISourceModule sourceModule = (ISourceModule)module.getModelElement();
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                int offset = abstractContext.getOffset();
                IType namespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                Map<String, UsePart> result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, offset, namespace, exactMatch);
                this.reportAlias(reporter, suffix, abstractContext, module, result);
            }
        }
    }

    protected void reportAliasForNS(ICompletionReporter reporter, String suffix, AbstractCompletionContext abstractContext, IModuleSource module, Map<String, UsePart> result) throws BadLocationException {
        SourceRange replacementRange = this.getReplacementRange(abstractContext);
        IDLTKSearchScope scope = this.createSearchScope();
        for (Map.Entry<String, UsePart> entry : result.entrySet()) {
            String fullName = entry.getValue().getNamespace().getFullyQualifiedName();
            IType[] elements = PhpModelAccess.getDefault().findTypes(null, String.valueOf(fullName) + '\\', ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
            int i = 0;
            while (i < elements.length) {
                String elementName = elements[i].getElementName();
                this.reportAlias(reporter, scope, module, (ISourceRange)replacementRange, elements[i], elementName, elementName.replace(fullName, entry.getKey()), suffix);
                ++i;
            }
        }
    }

    protected void reportAlias(ICompletionReporter reporter, String suffix, AbstractCompletionContext abstractContext, IModuleSource module, Map<String, UsePart> result) throws BadLocationException {
        SourceRange replacementRange = this.getReplacementRange(abstractContext);
        String prefix = abstractContext.getPrefixWithoutProcessing();
        IDLTKSearchScope scope = this.createSearchScope();
        for (Map.Entry<String, UsePart> entry : result.entrySet()) {
            String name = entry.getKey();
            String fullName = entry.getValue().getNamespace().getFullyQualifiedName();
            if (fullName.startsWith(SPLASH)) {
                fullName = fullName.substring(1);
            }
            try {
                IType[] elements = PhpModelAccess.getDefault().findTypes(fullName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
                int i = 0;
                while (i < elements.length) {
                    String elementName = elements[i].getElementName();
                    if (!PHPFlags.isNamespace(elements[i].getFlags())) {
                        this.reportAlias(reporter, scope, module, (ISourceRange)replacementRange, elements[i], elementName, name, suffix);
                    } else {
                        String nsname = prefix.replace(name, fullName);
                        if (!nsname.startsWith(String.valueOf(elementName) + SPLASH) || nsname.lastIndexOf(SPLASH) != elementName.length()) {
                            IType[] typesOfNS = elements[i].getTypes();
                            int j = 0;
                            while (j < typesOfNS.length) {
                                this.reportAlias(reporter, scope, module, (ISourceRange)replacementRange, typesOfNS[j], String.valueOf(elementName) + SPLASH + typesOfNS[j].getElementName(), (String.valueOf(elementName) + SPLASH + typesOfNS[j].getElementName()).replace(fullName, name), suffix);
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
        }
    }

    protected void reportAlias(ICompletionReporter reporter, IDLTKSearchScope scope, IModuleSource module, ISourceRange replacementRange, IType type, String fullName, String alias, String suffix) {
        reporter.reportType((IType)new AliasType((ModelElement)type, fullName, alias), suffix, replacementRange, this.getExtraInfo());
    }

    protected IType[] getTypes(AbstractCompletionContext context) throws BadLocationException {
        IType[] types;
        String prefix = context.getPrefix();
        if (prefix.startsWith("$")) {
            return EMPTY;
        }
        IDLTKSearchScope scope = this.createSearchScope();
        if (context.getCompletionRequestor().isContextInformationMode()) {
            return PhpModelAccess.getDefault().findTypes(prefix, ISearchEngine.MatchRule.EXACT, this.trueFlag, this.falseFlag, scope, null);
        }
        LinkedList<IType> result = new LinkedList<IType>();
        if (prefix.length() > 1 && prefix.toUpperCase().equals(prefix)) {
            types = PhpModelAccess.getDefault().findTypes(prefix, ISearchEngine.MatchRule.CAMEL_CASE, this.trueFlag, this.falseFlag, scope, null);
            result.addAll(Arrays.asList(types));
        }
        types = PhpModelAccess.getDefault().findTypes(null, prefix, ISearchEngine.MatchRule.PREFIX, this.trueFlag, this.falseFlag, scope, null);
        if (context instanceof NamespaceMemberContext) {
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (PHPModelUtils.getFullName(type).startsWith(prefix)) {
                    result.add(type);
                }
                ++n2;
            }
        } else {
            result.addAll(Arrays.asList(types));
        }
        return result.toArray(new IType[result.size()]);
    }

    protected void addSelf(AbstractCompletionContext context, ICompletionReporter reporter) throws BadLocationException {
        String prefix = context.getPrefix();
        SourceRange replaceRange = this.getReplacementRange(context);
        if (CodeAssistUtils.startsWithIgnoreCase("self", prefix) && (!context.getCompletionRequestor().isContextInformationMode() || prefix.length() == 4)) {
            String suffix = this.getSuffix(context);
            IType selfClassData = CodeAssistUtils.getSelfClassData(context.getSourceModule(), context.getOffset());
            if (selfClassData != null) {
                try {
                    ISourceRange sourceRange;
                    IMethod ctor = null;
                    IMethod[] iMethodArray = selfClassData.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        if (method.isConstructor()) {
                            ctor = method;
                            break;
                        }
                        ++n2;
                    }
                    if (ctor != null) {
                        sourceRange = selfClassData.getSourceRange();
                        FakeMethod ctorMethod = new FakeMethod((ModelElement)selfClassData, "self", sourceRange.getOffset(), sourceRange.getLength(), sourceRange.getOffset(), sourceRange.getLength()){

                            @Override
                            public boolean isConstructor() throws ModelException {
                                return true;
                            }
                        };
                        ctorMethod.setParameters(ctor.getParameters());
                        reporter.reportMethod((IMethod)ctorMethod, suffix, (ISourceRange)replaceRange);
                    } else {
                        sourceRange = selfClassData.getSourceRange();
                        reporter.reportMethod((IMethod)new FakeMethod((ModelElement)selfClassData, "self", sourceRange.getOffset(), sourceRange.getLength(), sourceRange.getOffset(), sourceRange.getLength()), "()", (ISourceRange)replaceRange);
                    }
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                }
            }
        }
    }

    public String getNSSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return SPLASH.equals(nextWord) ? "" : SPLASH;
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "::".equals(nextWord) ? "" : "::";
    }

    protected int getExtraInfo() {
        return 1;
    }

    public void setAddClassInNamespace(boolean addClassInNamespace) {
        this.addClassInNamespace = addClassInNamespace;
    }
}

