/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.KeywordsStrategy;
import org.eclipse.php.internal.core.language.keywords.PHPKeywords;

public class InUseTraitKeywordStrategy
extends KeywordsStrategy {
    public static final String[] KEYWORDS = new String[]{"as", "insteadof"};

    public InUseTraitKeywordStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public InUseTraitKeywordStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        AbstractCompletionContext context = (AbstractCompletionContext)this.getContext();
        String prefix = context.getPrefix();
        String suffix = "";
        SourceRange replaceRange = this.getReplacementRange(context);
        PHPVersion phpVersion = context.getPhpVersion();
        if (phpVersion.isGreaterThan(PHPVersion.PHP5_3)) {
            String[] stringArray = KEYWORDS;
            int n = KEYWORDS.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                if (keyword.startsWith(prefix)) {
                    reporter.reportKeyword(keyword, suffix, (ISourceRange)replaceRange);
                }
                ++n2;
            }
        }
    }

    @Override
    protected boolean filterKeyword(PHPKeywords.KeywordData keyword) {
        return true;
    }
}

