/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.MethodNameContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.language.PHPMagicMethods;
import org.eclipse.php.internal.core.typeinference.FakeMethod;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class MethodNameStrategy
extends AbstractCompletionStrategy {
    private static String CONSTRUCTOR_SUFFIX = "()";

    public MethodNameStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public MethodNameStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof MethodNameContext)) {
            return;
        }
        MethodNameContext concreteContext = (MethodNameContext)context;
        CompletionRequestor requestor = concreteContext.getCompletionRequestor();
        String prefix = concreteContext.getPrefix();
        boolean exactName = requestor.isContextInformationMode();
        IType declaringClass = concreteContext.getDeclaringClass();
        String suffix = this.getSuffix(concreteContext);
        Object replaceRange = null;
        replaceRange = suffix.equals("") ? this.getReplacementRange(concreteContext) : this.getReplacementRangeWithBraces(concreteContext);
        try {
            IMethod[] superClassMethods;
            ITypeHierarchy hierarchy = this.getCompanion().getSuperTypeHierarchy(declaringClass, null);
            IMethod[] iMethodArray = superClassMethods = PHPModelUtils.getSuperTypeHierarchyMethod(declaringClass, hierarchy, prefix, exactName, null);
            int n = superClassMethods.length;
            int n2 = 0;
            while (n2 < n) {
                int flags;
                IMethod superMethod = iMethodArray[n2];
                if (!(declaringClass.getMethod(superMethod.getElementName()).exists() || PHPFlags.isFinal((int)(flags = superMethod.getFlags())) || PHPFlags.isPrivate((int)flags) || PHPFlags.isStatic((int)flags))) {
                    reporter.reportMethod(superMethod, CONSTRUCTOR_SUFFIX, (ISourceRange)replaceRange);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PHPCorePlugin.log(e);
        }
        PHPVersion phpVersion = concreteContext.getPhpVersion();
        TreeSet<String> functions = new TreeSet<String>();
        functions.addAll(Arrays.asList(PHPMagicMethods.getMethods(phpVersion)));
        functions.add(declaringClass.getElementName());
        if (phpVersion.isGreaterThan(PHPVersion.PHP4)) {
            functions.add("__construct");
            functions.add("__destruct");
        }
        for (String function : functions) {
            if (!CodeAssistUtils.startsWithIgnoreCase(function, prefix) || requestor.isContextInformationMode() && function.length() != prefix.length()) continue;
            FakeMethod fakeMethod = new FakeMethod((ModelElement)declaringClass, function);
            if (function.equals("__construct")) {
                fakeMethod.setConstructor(true);
            }
            reporter.reportMethod((IMethod)fakeMethod, suffix, (ISourceRange)replaceRange);
        }
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "(".equals(nextWord) ? "" : CONSTRUCTOR_SUFFIX;
    }
}

