/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.dom.AttrImplForPhp;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.format.CaseDefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.CommentIndentationStrategy;
import org.eclipse.php.internal.core.format.CurlyCloseIndentationStrategy;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.php.internal.core.format.IndentationObject;
import org.eclipse.php.internal.core.format.PHPCloseTagIndentationStrategy;
import org.eclipse.php.internal.core.format.PhpFormatConstraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.rules.SimpleStructuredRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class PhpFormatter
implements IStructuredFormatter {
    private final IIndentationStrategy defaultIndentationStrategy;
    private final IIndentationStrategy curlyCloseIndentationStrategy;
    private final IIndentationStrategy caseDefaultIndentationStrategy;
    private final IIndentationStrategy commentIndentationStrategy;
    private final IIndentationStrategy phpCloseTagIndentationStrategy;
    protected PhpFormatConstraints fFormatContraints = null;
    protected IStructuredFormatPreferences fFormatPreferences = null;
    protected IProgressMonitor fProgressMonitor = null;
    private final int length;
    private final int start;
    private static final byte CHAR_TAB = 9;
    private static final byte CHAR_SPACE = 32;
    protected boolean isCopyPaste = false;
    private final StringBuffer resultBuffer = new StringBuffer();
    private boolean isInHeredoc;
    private Set<Integer> ignoreLines = new HashSet<Integer>();

    public PhpFormatter(int start, int length, boolean isCopyPaste, IndentationObject indentationObject) {
        this.start = start;
        this.length = length;
        this.isCopyPaste = isCopyPaste;
        this.defaultIndentationStrategy = new DefaultIndentationStrategy(indentationObject);
        this.curlyCloseIndentationStrategy = new CurlyCloseIndentationStrategy();
        this.caseDefaultIndentationStrategy = new CaseDefaultIndentationStrategy(indentationObject);
        this.commentIndentationStrategy = new CommentIndentationStrategy();
        this.phpCloseTagIndentationStrategy = new PHPCloseTagIndentationStrategy();
    }

    public PhpFormatter(int start, int length) {
        this(start, length, false, null);
    }

    public void format(Node node) {
        this.format(node, this.getFormatContraints());
    }

    public void format(Node node, IStructuredFormatContraints formatContraints) {
        if (node instanceof IDOMNode) {
            this.formatNode((IDOMNode)node, formatContraints);
        }
    }

    private void formatNode(IDOMNode node, IStructuredFormatContraints formatContraints) {
        if (node instanceof ElementImplForPhp && ((ElementImplForPhp)node).isPhpTag()) {
            IStructuredDocumentRegion sdRegionStart = node.getStartStructuredDocumentRegion();
            this.format(sdRegionStart);
        }
        if (node instanceof AttrImplForPhp) {
            IStructuredDocument document = node.getStructuredDocument();
            int lineIndex = document.getLineOfOffset(node.getStartOffset());
            int endLineIndex = document.getLineOfOffset(node.getEndOffset());
            while (lineIndex <= endLineIndex) {
                this.formatLine(document, lineIndex);
                ++lineIndex;
            }
        }
        if (node.hasChildNodes()) {
            IDOMNode child = (IDOMNode)node.getFirstChild();
            while (child != null) {
                this.formatNode(child, formatContraints);
                child = (IDOMNode)child.getNextSibling();
            }
        }
    }

    public IStructuredFormatContraints getFormatContraints() {
        if (this.fFormatContraints == null) {
            this.fFormatContraints = new PhpFormatConstraints();
        }
        return this.fFormatContraints;
    }

    public IStructuredFormatPreferences getFormatPreferences() {
        return this.fFormatPreferences;
    }

    public void setFormatPreferences(IStructuredFormatPreferences formatPreferences) {
        this.fFormatPreferences = formatPreferences;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    protected final int getStart() {
        return this.start;
    }

    protected final int getLength() {
        return this.length;
    }

    public Set<Integer> getIgnoreLines() {
        return this.ignoreLines;
    }

    public void format(IStructuredDocumentRegion sdRegion) {
        assert (sdRegion != null);
        int regionStart = sdRegion.getStartOffset();
        int regionEnd = sdRegion.getEnd();
        int formatRequestStart = this.getStart();
        int formatRequestEnd = formatRequestStart + this.getLength();
        int startFormat = Math.max(formatRequestStart, regionStart);
        int endFormat = Math.min(formatRequestEnd, regionEnd);
        IStructuredDocument document = sdRegion.getParentDocument();
        int lineIndex = document.getLineOfOffset(startFormat);
        int endLineIndex = document.getLineOfOffset(endFormat);
        if (!this.isCopyPaste) {
            ITextRegionList textRegions = sdRegion.getRegions();
            String newline = document.getLineDelimiter();
            int i = 0;
            while (i < textRegions.size()) {
                ITextRegion textRegion = textRegions.get(i);
                if (textRegion instanceof PhpScriptRegion) {
                    int startOffset = sdRegion.getStartOffset(textRegion);
                    PhpScriptRegion scriptRegion = (PhpScriptRegion)textRegion;
                    try {
                        ITextRegion[] phpTokens = scriptRegion.getPhpTokens(0, textRegion.getLength());
                        int j = phpTokens.length - 1;
                        while (j >= 0) {
                            ITextRegion phpToken = phpTokens[j];
                            int start = startOffset + phpToken.getStart();
                            int end = start + phpToken.getLength();
                            if (startFormat <= start && endFormat >= end) {
                                if (phpToken.getType().equals("PHP_CURLY_OPEN")) {
                                    if (j < phpTokens.length - 1 && j > 0 && phpTokens[j - 1].getType().equals("PHP_TOKEN") && !this.isComment(phpTokens[j + 1]) && document.getLineOfOffset(startOffset + phpToken.getStart()) == document.getLineOfOffset(startOffset + phpTokens[j + 1].getStart())) {
                                        document.replace(startOffset + phpToken.getEnd(), 0, newline);
                                        ++endLineIndex;
                                    }
                                } else if (phpToken.getType().equals("PHP_CURLY_CLOSE") && j > 0 && (phpTokens[j - 1].getType().equals("PHP_SEMICOLON") || phpTokens[j - 1].getType().equals("PHP_CURLY_CLOSE") || phpTokens[j - 1].getType().equals("PHP_COMMENT_END")) && document.getLineOfOffset(startOffset + phpToken.getStart()) == document.getLineOfOffset(startOffset + phpTokens[j - 1].getStart())) {
                                    document.replace(startOffset + phpTokens[j - 1].getEnd(), 0, newline);
                                    ++endLineIndex;
                                }
                            }
                            --j;
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ++i;
            }
        }
        sdRegion.getRegionAtCharacterOffset(startFormat);
        while (lineIndex <= endLineIndex) {
            this.formatLine(document, lineIndex);
            ++lineIndex;
        }
    }

    private boolean isComment(ITextRegion iTextRegion) {
        return iTextRegion.getType().equals("PHP_COMMENT") || iTextRegion.getType().equals("PHP_COMMENT_START") || iTextRegion.getType().equals("PHP_LINE_COMMENT") || iTextRegion.getType().equals("PHPDOC_COMMENT") || iTextRegion.getType().equals("PHPDOC_COMMENT_START");
    }

    private void formatLine(IStructuredDocument document, int lineNumber) {
        this.resultBuffer.setLength(0);
        try {
            int startLine;
            boolean formatThisLine;
            int originalTextEnd;
            IRegion originalLineInfo = document.getLineInformation(lineNumber);
            int orginalLineStart = originalLineInfo.getOffset();
            int originalLineLength = originalLineInfo.getLength();
            if (originalLineLength == 0) {
                return;
            }
            String lineText = document.get(orginalLineStart, originalLineLength);
            IRegion formattedLineInformation = this.getFormattedLineInformation(originalLineInfo, lineText);
            if (!this.shouldReformat(document, formattedLineInformation)) {
                return;
            }
            int formattedLineStart = formattedLineInformation.getOffset();
            int formattedTextEnd = formattedLineStart + formattedLineInformation.getLength();
            if (formattedTextEnd != (originalTextEnd = orginalLineStart + originalLineLength)) {
                document.replace(formattedTextEnd, originalTextEnd - formattedTextEnd, "");
                if (formattedLineStart == formattedTextEnd) {
                    return;
                }
            }
            int startingWhiteSpaces = formattedLineStart - orginalLineStart;
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(formattedLineStart);
            ITextRegion firstTokenInLine = sdRegion.getRegionAtCharacterOffset(formattedLineStart);
            ITextRegion lastTokenInLine = null;
            int regionStart = sdRegion.getStartOffset(firstTokenInLine);
            if (firstTokenInLine instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)firstTokenInLine;
                firstTokenInLine = container.getRegionAtCharacterOffset(formattedLineStart);
                regionStart += firstTokenInLine.getStart();
            }
            int scriptRegionLength = 0;
            if (firstTokenInLine instanceof IPhpScriptRegion) {
                IPhpScriptRegion scriptRegion = (IPhpScriptRegion)firstTokenInLine;
                if (scriptRegion.getStart() + scriptRegion.getLength() < formattedLineStart - regionStart) {
                    return;
                }
                scriptRegionLength = scriptRegion.getStart();
                firstTokenInLine = scriptRegion.getPhpToken(formattedLineStart - regionStart);
                if (firstTokenInLine != null && firstTokenInLine.getStart() + sdRegion.getStartOffset() < orginalLineStart && firstTokenInLine.getType() == "WHITESPACE") {
                    firstTokenInLine = scriptRegion.getPhpToken(formattedLineStart - regionStart + firstTokenInLine.getLength());
                }
                if (scriptRegion.getStart() + scriptRegion.getLength() >= formattedTextEnd - regionStart - 1 && (lastTokenInLine = scriptRegion.getPhpToken(formattedTextEnd - regionStart - 1)) != null && lastTokenInLine.getEnd() + sdRegion.getStartOffset() > orginalLineStart + originalLineLength && lastTokenInLine.getType() == "WHITESPACE") {
                    lastTokenInLine = scriptRegion.getPhpToken(formattedTextEnd - regionStart - 1 - lastTokenInLine.getLength());
                }
            }
            if (firstTokenInLine == null) {
                return;
            }
            String firstTokenType = firstTokenInLine.getType();
            boolean bl = formatThisLine = !this.isInHeredoc;
            if (firstTokenType == "PHP_HEREDOC_TAG" || lastTokenInLine != null && lastTokenInLine.getType() == "PHP_HEREDOC_TAG") {
                boolean bl2 = this.isInHeredoc = !this.isInHeredoc;
            }
            if (this.isCopyPaste && firstTokenType == "PHP_CONSTANT_ENCAPSED_STRING" && (startLine = document.getLineOfOffset(firstTokenInLine.getStart() + scriptRegionLength)) < lineNumber) {
                this.ignoreLines.add(lineNumber);
                return;
            }
            if (!formatThisLine) {
                this.ignoreLines.add(lineNumber);
                return;
            }
            IIndentationStrategy insertionStrategy = firstTokenType == "PHP_CASE" || firstTokenType == "PHP_DEFAULT" ? this.caseDefaultIndentationStrategy : (this.isPHPCommentRegion(firstTokenType) ? this.commentIndentationStrategy : (firstTokenType == "PHP_CLOSETAG" ? this.phpCloseTagIndentationStrategy : this.getIndentationStrategy(lineText.charAt(startingWhiteSpaces))));
            insertionStrategy.placeMatchingBlanks(document, this.resultBuffer, lineNumber, document.getLineOffset(lineNumber));
            String newIndentation = this.resultBuffer.toString();
            String oldIndentation = lineText.substring(0, startingWhiteSpaces);
            char newChar = '\u0000';
            if (newIndentation.length() > 0) {
                newChar = newIndentation.charAt(0);
            }
            char oldChar = '\u0000';
            if (oldIndentation.length() > 0) {
                oldChar = oldIndentation.charAt(0);
            }
            if (newIndentation.length() != oldIndentation.length() || newChar != oldChar) {
                document.replaceText((Object)sdRegion, orginalLineStart, startingWhiteSpaces, newIndentation);
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private boolean isPHPCommentRegion(String tokenType) {
        return tokenType == "PHP_COMMENT" || tokenType == "PHP_COMMENT_END" || tokenType == "PHPDOC_COMMENT" || tokenType == "PHPDOC_COMMENT_END";
    }

    private IRegion getFormattedLineInformation(IRegion lineInfo, String lineText) {
        int leftNonWhitespaceChar = 0;
        int rightNonWhitespaceChar = lineText.length() - 1;
        char[] chars = lineText.toCharArray();
        boolean keepSearching = true;
        while (keepSearching) {
            boolean rightIsWhiteSpace;
            boolean leftIsWhiteSpace = chars[leftNonWhitespaceChar] == ' ' || chars[leftNonWhitespaceChar] == '\t';
            boolean bl = rightIsWhiteSpace = chars[rightNonWhitespaceChar] == ' ' || chars[rightNonWhitespaceChar] == '\t';
            if (leftIsWhiteSpace) {
                ++leftNonWhitespaceChar;
            }
            if (rightIsWhiteSpace) {
                --rightNonWhitespaceChar;
            }
            boolean bl2 = keepSearching = (leftIsWhiteSpace || rightIsWhiteSpace) && leftNonWhitespaceChar < rightNonWhitespaceChar;
        }
        if (leftNonWhitespaceChar > rightNonWhitespaceChar) {
            return new SimpleStructuredRegion(lineInfo.getOffset(), 0);
        }
        return leftNonWhitespaceChar == 0 && rightNonWhitespaceChar == lineText.length() - 1 ? lineInfo : new SimpleStructuredRegion(lineInfo.getOffset() + leftNonWhitespaceChar, rightNonWhitespaceChar - leftNonWhitespaceChar + 1);
    }

    private boolean shouldReformat(IStructuredDocument document, IRegion lineInfo) {
        String checkedLineBeginState = FormatterUtils.getPartitionType(document, lineInfo.getOffset());
        return checkedLineBeginState == "org.eclipse.php.PHP_DEFAULT" || checkedLineBeginState == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_SINGLE_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_DOC" || checkedLineBeginState == "org.eclipse.php.PHP_QUOTED_STRING";
    }

    protected IIndentationStrategy getIndentationStrategy(char c) {
        if (c == '}') {
            return this.curlyCloseIndentationStrategy;
        }
        return this.getDefaultIndentationStrategy();
    }

    private IIndentationStrategy getDefaultIndentationStrategy() {
        return this.defaultIndentationStrategy;
    }
}

