/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.YieldExpression;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.typeinference.GeneratorClassType;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractMethodReturnTypeEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;

public class MethodReturnTypeEvaluator
extends AbstractMethodReturnTypeEvaluator {
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();
    private final List<IEvaluatedType> yieldEvaluated = new LinkedList<IEvaluatedType>();
    private final List<IGoal> yieldGoals = new LinkedList<IGoal>();

    public MethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        MethodElementReturnTypeGoal goal = (MethodElementReturnTypeGoal)this.getGoal();
        String methodName = goal.getMethodName();
        final LinkedList subGoals = new LinkedList();
        AbstractMethodReturnTypeEvaluator.MethodsAndTypes mat = this.getMethodsAndTypes();
        int i = 0;
        while (i < mat.methods.length) {
            IMethod method = mat.methods[i];
            if (method != null) {
                block10: {
                    MethodDeclaration decl;
                    ModuleDeclaration module;
                    ISourceModule sourceModule;
                    block9: {
                        sourceModule = method.getSourceModule();
                        module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                        decl = null;
                        try {
                            decl = PHPModelUtils.getNodeByMethod(module, method);
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) break block9;
                            e.printStackTrace();
                        }
                    }
                    if (decl != null) {
                        final IContext innerContext = ASTUtils.findContext(sourceModule, module, (ASTNode)decl);
                        if (innerContext instanceof MethodContext) {
                            MethodContext mc = (MethodContext)innerContext;
                            mc.setCurrentType(mat.types[i]);
                        }
                        if (goal.getContext() instanceof IModelCacheContext && innerContext instanceof IModelCacheContext) {
                            ((IModelCacheContext)innerContext).setCache(((IModelCacheContext)goal.getContext()).getCache());
                        }
                        ASTVisitor visitor = new ASTVisitor(){

                            public boolean visitGeneral(ASTNode node) throws Exception {
                                if (node instanceof ReturnStatement) {
                                    ReturnStatement statement = (ReturnStatement)node;
                                    Expression expr = statement.getExpr();
                                    if (expr == null) {
                                        MethodReturnTypeEvaluator.this.evaluated.add(PHPSimpleTypes.VOID);
                                    } else {
                                        subGoals.add(new ExpressionTypeGoal(innerContext, (ASTNode)expr));
                                    }
                                } else if (node instanceof YieldExpression) {
                                    YieldExpression statement = (YieldExpression)node;
                                    Expression expr = statement.getExpr();
                                    if (expr == null) {
                                        MethodReturnTypeEvaluator.this.yieldEvaluated.add(PHPSimpleTypes.NULL);
                                    } else {
                                        ExpressionTypeGoal yg = new ExpressionTypeGoal(innerContext, (ASTNode)expr);
                                        subGoals.add(yg);
                                        MethodReturnTypeEvaluator.this.yieldGoals.add(yg);
                                    }
                                }
                                return super.visitGeneral(node);
                            }
                        };
                        try {
                            decl.traverse(visitor);
                        }
                        catch (Exception e) {
                            if (!DLTKCore.DEBUG) break block10;
                            e.printStackTrace();
                        }
                    }
                }
                this.resolveMagicMethodDeclaration(method, methodName);
            }
            ++i;
        }
        return subGoals.toArray(new IGoal[subGoals.size()]);
    }

    private void resolveMagicMethodDeclaration(IMethod method, String methodName) {
        IModelElement parent = method.getParent();
        if (parent.getElementType() != 7) {
            return;
        }
        IType type = (IType)parent;
        PHPDocBlock docBlock = PHPModelUtils.getDocBlock(type);
        if (docBlock == null) {
            return;
        }
        IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)type);
        PHPDocTag[] pHPDocTagArray = docBlock.getTags();
        int n = pHPDocTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocTag tag = pHPDocTagArray[n2];
            int tagKind = tag.getTagKind();
            if (tagKind == 33) {
                Collection<String> typeNames = PHPEvaluationUtils.getTypeBinding(methodName, tag);
                for (String typeName : typeNames) {
                    if (typeName.trim().isEmpty()) continue;
                    IEvaluatedType evaluatedType = PHPEvaluationUtils.extractArrayType(typeName, currentNamespace, tag.sourceStart());
                    if (evaluatedType != null) {
                        this.evaluated.add(evaluatedType);
                        continue;
                    }
                    Object resolved = PHPSimpleTypes.fromString(typeName);
                    if (resolved == null) {
                        resolved = new PHPClassType(typeName);
                    }
                    this.evaluated.add((IEvaluatedType)resolved);
                }
            }
            ++n2;
        }
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            if (!this.yieldGoals.contains(subgoal)) {
                this.evaluated.add((IEvaluatedType)result);
            } else {
                this.yieldEvaluated.add((IEvaluatedType)result);
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        if (this.yieldEvaluated.size() > 0 || this.yieldGoals.size() > 0) {
            GeneratorClassType generatorClassType = new GeneratorClassType();
            generatorClassType.getTypes().addAll(this.yieldEvaluated);
            this.evaluated.add((IEvaluatedType)generatorClassType);
        }
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }
}

