/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;

public class PHPEvaluationUtils {
    public static final String BRACKETS = "[]";
    public static final Pattern ARRAY_TYPE_PATTERN = Pattern.compile("array\\[.*\\]");
    public static final String BRACKETS_PATTERN = "\\[.*\\]";

    public static String extractArrayType(String typeName) {
        Matcher m = ARRAY_TYPE_PATTERN.matcher(typeName);
        if (m.find()) {
            int beginIndex = typeName.indexOf("[") + 1;
            int endIndex = typeName.lastIndexOf("]");
            if (endIndex != -1) {
                return typeName.substring(beginIndex, endIndex);
            }
        }
        return PHPEvaluationUtils.removeArrayBrackets(typeName);
    }

    public static IEvaluatedType extractArrayType(String typeName, IType currentNamespace, int offset) {
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        Matcher m = ARRAY_TYPE_PATTERN.matcher(typeName);
        if (m.find()) {
            return PHPEvaluationUtils.getArrayType(m.group(), currentNamespace, offset);
        }
        if (typeName.endsWith(BRACKETS) && typeName.length() > 2) {
            return PHPEvaluationUtils.getArrayType(typeName.substring(0, typeName.length() - 2), currentNamespace, offset);
        }
        return null;
    }

    public static MultiTypeType getArrayType(String type, IType currentNamespace, int offset) {
        String[] typeNames;
        int beginIndex = type.indexOf("[") + 1;
        int endIndex = type.lastIndexOf("]");
        if (endIndex != -1) {
            type = type.substring(beginIndex, endIndex);
        }
        MultiTypeType arrayType = new MultiTypeType();
        Matcher m = ARRAY_TYPE_PATTERN.matcher(type);
        if (m.find()) {
            arrayType.addType((IEvaluatedType)PHPEvaluationUtils.getArrayType(m.group(), currentNamespace, offset));
            type = m.replaceAll("");
        } else if (type.endsWith(BRACKETS) && type.length() > 2) {
            arrayType.addType((IEvaluatedType)PHPEvaluationUtils.getArrayType(type.substring(0, type.length() - 2), currentNamespace, offset));
            type = type.replaceAll(BRACKETS, "");
        }
        String[] stringArray = typeNames = type.split(",");
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!"".equals(name)) {
                int nsSeparatorIndex = name.indexOf(92);
                if (currentNamespace != null) {
                    String fullName;
                    Map<String, UsePart> result;
                    ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)currentNamespace.getSourceModule());
                    String prefix = name;
                    if (nsSeparatorIndex != -1) {
                        name.substring(0, name.indexOf(92));
                    }
                    if ((result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, offset, currentNamespace, true)).containsKey(prefix) && (name = name.replace(prefix, fullName = result.get(prefix).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                        name = String.valueOf('\\') + name;
                    }
                }
                arrayType.addType(PHPEvaluationUtils.getEvaluatedType(name, currentNamespace));
            }
            ++n2;
        }
        return arrayType;
    }

    public static Collection<String> getTypeBinding(String name, PHPDocTag docTag) {
        String[] split = docTag.getValue().trim().split("\\s+");
        if (split.length < 2) {
            return null;
        }
        if (split[1].equals(name)) {
            return Arrays.asList(split[0].split("\\|"));
        }
        String substring = split[1];
        int parenIndex = split[1].indexOf(40);
        if (parenIndex != -1) {
            substring = substring.substring(0, parenIndex);
        }
        if (substring.equals(name)) {
            return Arrays.asList(split[0].split("\\|"));
        }
        return Collections.emptyList();
    }

    public static IEvaluatedType getEvaluatedType(String typeName, IType currentNamespace) {
        Object type = PHPSimpleTypes.fromString(typeName);
        if (type == null) {
            if (typeName.indexOf(92) > 0 && currentNamespace != null) {
                typeName = String.valueOf('\\') + currentNamespace.getElementName() + '\\' + typeName;
            }
            type = typeName.indexOf(92) != -1 || currentNamespace == null ? new PHPClassType(typeName) : new PHPClassType(currentNamespace.getElementName(), typeName);
        }
        return type;
    }

    public static String removeArrayBrackets(String variableName) {
        return variableName.replaceAll(BRACKETS_PATTERN, "");
    }
}

