/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.compiler_ast.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractPHPSourceParser;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPSourceParserFactory;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class FindUseStatementByNamespaceTests {
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    public AbstractPHPSourceParser parser;

    static {
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/astutils/find_use_statement_by_namespace/php53"});
    }

    public FindUseStatementByNamespaceTests(PHPVersion phpVersion, String[] fileName) {
        this.parser = PHPSourceParserFactory.createParser((PHPVersion)phpVersion);
    }

    @Test
    public void find(String fileName) throws Exception {
        int offset;
        String namespace;
        PdttFile pdttFile = new PdttFile(fileName);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdttFile.getFile().trim().getBytes());
        ModuleDeclaration moduleDeclaration = (ModuleDeclaration)this.parser.parse((Reader)new InputStreamReader(inputStream), null, ProjectOptions.useShortTags(null));
        UsePart usePart = ASTUtils.findUseStatementByNamespace((ModuleDeclaration)moduleDeclaration, (String)(namespace = pdttFile.getConfig().get("namespace")), (int)(offset = Integer.parseInt(pdttFile.getConfig().get("offset"))));
        String actual = usePart == null ? "null" : usePart.toString();
        PDTTUtils.assertContents(pdttFile.getExpected(), actual);
    }
}

