/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.formatter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.formatter.DocumentAdapter;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.format.PhpFormatProcessorImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class FormatterTests {
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IProject project;
    protected int count;
    protected final PHPVersion phpVersion;
    protected final String[] fileNames;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/formatter/php5"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/formatter/php5", "/workspace/formatter/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/formatter/php5", "/workspace/formatter/php54", "/workspace/formatter/php55"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/formatter/php5", "/workspace/formatter/php54", "/workspace/formatter/php55", "/workspace/formatter/php56"});
    }

    public FormatterTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
        this.fileNames = fileNames;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("FormatterTests");
        if (this.project.exists()) {
            return;
        }
        this.project.create(null);
        this.project.open(null);
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        this.project.setDescription(desc, null);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(ISourceModule workingCopy) {
                ISourceModule original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource != null && resource instanceof IFile) {
                    return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                }
                return DocumentAdapter.NULL;
            }
        });
        this.project.refreshLocal(2, null);
        this.project.build(6, null);
        PHPCoreTests.setProjectPhpVersion(this.project, this.phpVersion);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        this.project.close(null);
        this.project.delete(true, true, null);
        this.project = null;
    }

    @Test
    public void formatter(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(fileName);
        IFile file = this.createFile(pdttFile.getFile().trim());
        ISourceModule modelElement = (ISourceModule)DLTKCore.create((IFile)file);
        if (ScriptModelUtil.isPrimary((ISourceModule)modelElement)) {
            modelElement.becomeWorkingCopy(new IProblemRequestor(){

                public void acceptProblem(IProblem problem) {
                }

                public void beginReporting() {
                }

                public void endReporting() {
                }

                public boolean isActive() {
                    return false;
                }
            }, null);
        }
        IStructuredModel modelForEdit = StructuredModelManager.getModelManager().getModelForEdit(file);
        try {
            IStructuredDocument document = modelForEdit.getStructuredDocument();
            String beforeFormat = document.get();
            PhpFormatProcessorImpl formatter = new PhpFormatProcessorImpl();
            formatter.formatDocument((IDocument)document, 0, document.getLength());
            PDTTUtils.assertContents(pdttFile.getExpected(), document.get());
            document.set(beforeFormat);
            modelForEdit.save();
        }
        finally {
            if (modelForEdit != null) {
                modelForEdit.releaseFromEdit();
            }
        }
    }

    protected IFile createFile(String data) throws Exception {
        IFile testFile = this.project.getFile("test" + ++this.count + ".php");
        testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        return testFile;
    }
}

