/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.searchEngine;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class PHP53LanguageModelTest {
    private static IProject project;

    @BeforeClass
    public static void setUp() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("PHPLanguageModelTests");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
        ProjectOptions.setPhpVersion((PHPVersion)PHPVersion.PHP5_3, (IProject)project);
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    @Test
    public void bcmath() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("bcsqrt", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    private IDLTKSearchScope createScope() {
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        return scope;
    }

    @Test
    public void bz2() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("bzopen", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void calendar() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("jdtogregorian", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void ctype() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("ctype_alnum", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void curl() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("curl_init", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void date() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("getTimezone", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void dom() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("getTraceAsString", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void exif() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("read_exif_data", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void filter() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("filter_input", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void ftp() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("ftp_connect", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void gd() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("gd_info", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void gettext() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("dgettext", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void hash() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("hash_file", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void iconv() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("iconv", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void ibm_db2() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("db2_connect", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void imap() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("imap_open", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void intl() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("asort", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void json() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("json_encode", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void ldap() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("ldap_connect", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void mcrypt() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("mcrypt_cfb", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void mhash() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("mhash_keygen_s2k", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void mime_magic() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("mime_content_type", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void mysql() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("mysql_connect", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void mysqli() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("embedded_server_start", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void oci8() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("tell", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void openssl() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("openssl_pkey_new", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void pcre() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("preg_match", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void posix() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("posix_getpid", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void pdo() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("pdo_drivers", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void pgsql() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("pg_connect", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void reflection() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("getClassNames", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void session() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("session_module_name", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void simpleXml() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("asXML", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void soap() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("SoapClient", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void sockets() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("socket_select", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void spl() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("rewind", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void sqlite() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("queryExec", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void standard() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("bin2hex", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void tidy() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("cleanRepair", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void tokenizer() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("token_name", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void xml() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("xml_set_object", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void xmlreader() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("setRelaxNGSchema", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void xmlwriter() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("setIndent", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void xsl() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("transformToUri", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void zip() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("zip_entry_compressionmethod", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    @Test
    public void zlib() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("gzrewind", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }
}

