/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.io.File;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.debug.core.PHPExeException;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.wizards.IPHPExeCompositeFragment;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.internal.ui.wizards.fields.StringButtonDialogField;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PHPExeCompositeFragment
extends CompositeFragment
implements IPHPExeCompositeFragment {
    private static final String PHP_INI = "php.ini";
    private PHPexeItem[] existingItems;
    private StringDialogField fPHPexeName;
    private StringButtonDialogField fPHPExePath;
    private StringButtonDialogField fPHPIni;
    private Button fLoadDefaultPHPIni;
    private List<String> debuggersIds;
    private Label fDebuggersLabel;
    private Combo fDebuggers;
    private Label fSapiTypesLabel;
    private Combo fSapiTypes;
    private String initialName;
    private boolean isIniFileSet = false;
    private boolean updateDebuggerStatus = true;

    public PHPExeCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.setDescription(PHPDebugUIMessages.PHPExeCompositeFragment_0);
        this.setDisplayName(PHPDebugUIMessages.PHPExeCompositeFragment_2);
        this.controlHandler.setDescription(this.getDescription());
        this.controlHandler.setImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_WIZBAN_PHPEXE"));
        this.debuggersIds = new LinkedList<String>(PHPDebuggersRegistry.getDebuggersIds());
        this.createControl();
    }

    @Override
    public void setExistingItems(PHPexeItem[] existingItems) {
        this.existingItems = existingItems;
    }

    public void setData(Object data) {
        if (data != null && !(data instanceof PHPexeItem)) {
            throw new IllegalArgumentException(PHPDebugUIMessages.PHPExeCompositeFragment_3);
        }
        super.setData(data);
        this.init();
    }

    public PHPexeItem getPHPExeItem() {
        return (PHPexeItem)super.getData();
    }

    protected String getPHPexeName() {
        return this.fPHPexeName.getText();
    }

    protected File getInstallLocation() {
        return new File(this.fPHPExePath.getText());
    }

    protected File getIniLocation() {
        return new File(this.fPHPIni.getText());
    }

    protected void createControl() {
        PixelConverter pixelConverter = new PixelConverter((Control)this);
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Composite parent = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.fPHPexeName = new StringDialogField();
        this.fPHPexeName.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpName);
        this.fPHPExePath = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                FileDialog dialog = new FileDialog(PHPExeCompositeFragment.this.getShell());
                dialog.setFilterPath(PHPExeCompositeFragment.this.fPHPExePath.getText());
                dialog.setText(PHPDebugUIMessages.addPHPexeDialog_pickPHPRootDialog_message);
                String newPath = dialog.open();
                if (newPath != null) {
                    PHPExeCompositeFragment.this.fPHPExePath.setText(newPath);
                }
            }
        });
        this.fPHPExePath.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpHome);
        this.fPHPExePath.setButtonLabel(PHPDebugUIMessages.addPHPexeDialog_browse1);
        this.fPHPIni = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                FileDialog dialog = new FileDialog(PHPExeCompositeFragment.this.getShell());
                dialog.setFilterPath(PHPExeCompositeFragment.this.fPHPIni.getText());
                dialog.setFilterExtensions(new String[]{"*.ini", "*.*"});
                dialog.setText(PHPDebugUIMessages.addPHPexeDialog_pickPHPIniDialog_message);
                String newPath = dialog.open();
                if (newPath != null) {
                    PHPExeCompositeFragment.this.fPHPIni.setText(newPath);
                    PHPExeCompositeFragment.this.isIniFileSet = true;
                }
            }
        });
        this.fPHPIni.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpIni);
        this.fPHPIni.setButtonLabel(PHPDebugUIMessages.addPHPexeDialog_browse1);
        this.fPHPexeName.doFillIntoGrid(parent, 3);
        this.fPHPExePath.doFillIntoGrid(parent, 3);
        ((GridData)this.fPHPExePath.getTextControl((Composite)parent).getLayoutData()).widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.fPHPIni.doFillIntoGrid(parent, 3);
        ((GridData)this.fPHPIni.getTextControl((Composite)parent).getLayoutData()).widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.fLoadDefaultPHPIni = new Button(parent, 32);
        this.fLoadDefaultPHPIni.setText(PHPDebugUIMessages.addPHPexeDialog_loadDefaultPHPIni);
        GridData loadDefaultPHPIniData = new GridData(4);
        loadDefaultPHPIniData.horizontalSpan = 3;
        this.fLoadDefaultPHPIni.setLayoutData((Object)loadDefaultPHPIniData);
        this.fSapiTypesLabel = new Label(parent, 16448);
        this.fSapiTypesLabel.setFont(parent.getFont());
        this.fSapiTypesLabel.setText(PHPDebugUIMessages.PHPExeCompositeFragment_1);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        this.fSapiTypesLabel.setLayoutData((Object)data);
        this.fSapiTypes = new Combo(parent, 12);
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.fSapiTypes.setLayoutData((Object)data);
        this.fSapiTypes.add("CLI");
        this.fSapiTypes.add("CGI");
        this.fDebuggersLabel = new Label(parent, 16448);
        this.fDebuggersLabel.setFont(parent.getFont());
        this.fDebuggersLabel.setText(PHPDebugUIMessages.addPHPexeDialog_phpDebugger);
        data = new GridData();
        data.horizontalSpan = 1;
        this.fDebuggersLabel.setLayoutData((Object)data);
        this.fDebuggers = new Combo(parent, 12);
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.fDebuggers.setLayoutData((Object)data);
        int i = 0;
        while (i < this.debuggersIds.size()) {
            String id = this.debuggersIds.get(i);
            String debuggerName = PHPDebuggersRegistry.getDebuggerName((String)id);
            this.fDebuggers.add(debuggerName, i);
            ++i;
        }
        this.init();
        this.createFieldListeners();
        this.updateItem();
        this.fPHPExePath.setFocus();
        Dialog.applyDialogFont((Control)this);
    }

    protected void createFieldListeners() {
        this.fPHPexeName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (PHPExeCompositeFragment.this.isComplete()) {
                    PHPExeCompositeFragment.this.updateDebuggerStatus = false;
                }
                PHPExeCompositeFragment.this.updateItem();
                PHPExeCompositeFragment.this.updateDebuggerStatus = true;
            }
        });
        this.fPHPExePath.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                String newPath = PHPExeCompositeFragment.this.fPHPExePath.getText();
                if (newPath != null && newPath.trim().length() > 0) {
                    File executable;
                    PHPExeUtil.PHPExeInfo phpExecInfo;
                    if (!PHPExeCompositeFragment.this.isIniFileSet || PHPExeCompositeFragment.this.fPHPIni.getText() == null || PHPExeCompositeFragment.this.fPHPIni.getText().trim().length() == 0) {
                        Path path = new Path(newPath);
                        path = path.removeLastSegments(1);
                        if ((path = path.append(PHPExeCompositeFragment.PHP_INI)).toFile().exists()) {
                            PHPExeCompositeFragment.this.fPHPIni.setTextWithoutUpdate(path.toOSString());
                        }
                    }
                    if ((phpExecInfo = PHPExeCompositeFragment.this.getPHPInfo(executable = new File(newPath))) != null) {
                        if (PHPExeCompositeFragment.this.fPHPexeName.getText().isEmpty() && phpExecInfo.getName() != null) {
                            PHPExeCompositeFragment.this.fPHPexeName.setTextWithoutUpdate(phpExecInfo.getName());
                        }
                        if (phpExecInfo.getSapiType() != null) {
                            PHPExeCompositeFragment.this.fSapiTypes.setText(phpExecInfo.getSapiType());
                        }
                    }
                }
                PHPExeCompositeFragment.this.updateItem();
            }
        });
        this.fPHPIni.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                PHPExeCompositeFragment.this.updateItem();
            }
        });
        this.fLoadDefaultPHPIni.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PHPExeCompositeFragment.this.updateItem();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PHPExeCompositeFragment.this.updateItem();
            }
        });
        this.fSapiTypes.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PHPExeCompositeFragment.this.updateItem();
            }

            public void widgetSelected(SelectionEvent e) {
                PHPExeCompositeFragment.this.updateItem();
            }
        });
        this.fDebuggers.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PHPExeCompositeFragment.this.updateItem();
            }

            public void widgetSelected(SelectionEvent e) {
                PHPExeCompositeFragment.this.updateItem();
            }
        });
    }

    protected void init() {
        PHPexeItem phpExeItem = this.getPHPExeItem();
        if (phpExeItem == null || phpExeItem.getName() == null) {
            this.fPHPexeName.setTextWithoutUpdate("");
            this.fPHPExePath.setTextWithoutUpdate("");
            this.fPHPIni.setTextWithoutUpdate("");
            String defaultDebuggerId = PHPDebuggersRegistry.getDefaultDebuggerId();
            if (defaultDebuggerId != null) {
                int index = this.fDebuggers.indexOf(PHPDebuggersRegistry.getDebuggerName((String)defaultDebuggerId));
                this.fDebuggers.select(index);
            } else if (this.fDebuggers.getItemCount() > 0) {
                this.fDebuggers.select(0);
            } else {
                this.hideDebuggersCombo();
            }
            this.setTitle(PHPDebugUIMessages.PHPExeCompositeFragment_10);
        } else {
            this.initialName = phpExeItem.getName();
            this.fPHPexeName.setTextWithoutUpdate(phpExeItem.getName());
            this.fPHPexeName.setEnabled(phpExeItem.isEditable());
            this.fPHPExePath.setTextWithoutUpdate(phpExeItem.getExecutable().getAbsolutePath());
            this.fPHPExePath.setEnabled(phpExeItem.isEditable());
            if (phpExeItem.getINILocation() != null) {
                this.fPHPIni.setTextWithoutUpdate(phpExeItem.getINILocation().toString());
            }
            this.fPHPIni.setEnabled(phpExeItem.isEditable());
            this.fLoadDefaultPHPIni.setEnabled(phpExeItem.isEditable());
            this.fLoadDefaultPHPIni.setSelection(phpExeItem.isLoadDefaultINI());
            String debuggerID = phpExeItem.getDebuggerID();
            this.fDebuggers.setEnabled(phpExeItem.isEditable());
            this.fDebuggersLabel.setEnabled(phpExeItem.isEditable());
            int index = this.fDebuggers.indexOf(PHPDebuggersRegistry.getDebuggerName((String)debuggerID));
            if (index > -1) {
                this.fDebuggers.select(index);
            } else if (this.fDebuggers.getItemCount() > 0) {
                this.fDebuggers.select(0);
            } else {
                this.hideDebuggersCombo();
            }
            String sapiType = phpExeItem.getSapiType();
            if (sapiType != null) {
                this.fSapiTypes.setText(sapiType);
            }
            this.fSapiTypes.setEnabled(phpExeItem.isEditable());
            this.fSapiTypesLabel.setEnabled(phpExeItem.isEditable());
            this.setTitle(PHPDebugUIMessages.PHPExeCompositeFragment_11);
        }
        this.controlHandler.setTitle(this.getTitle());
    }

    private void setDebuggersCombo() {
        AbstractDebuggerConfiguration[] debuggers;
        if (!this.updateDebuggerStatus || this.getPHPExeItem().getExecutable() == null || !this.getPHPExeItem().getExecutable().exists() || this.getPHPExeItem().getDebuggerID() != null && !this.debuggersIds.get(this.fDebuggers.getSelectionIndex()).equals(this.getPHPExeItem().getDebuggerID())) {
            return;
        }
        List modules = PHPExeUtil.getModules((PHPexeItem)this.getPHPExeItem());
        AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = debuggers = PHPDebuggersRegistry.getDebuggersConfigurations();
        int n = debuggers.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDebuggerConfiguration debugger = abstractDebuggerConfigurationArray[n2];
            for (PHPExeUtil.PHPModuleInfo m : modules) {
                if (!m.getName().equalsIgnoreCase(debugger.getModuleId())) continue;
                int index = this.fDebuggers.indexOf(PHPDebuggersRegistry.getDebuggerName((String)debugger.getDebuggerId()));
                this.fDebuggers.select(index);
                break;
            }
            ++n2;
        }
    }

    private void hideDebuggersCombo() {
        this.fDebuggers.setVisible(false);
        this.fDebuggersLabel.setVisible(false);
    }

    public void validate() {
        PHPexeItem phpExeItem = this.getPHPExeItem();
        this.setComplete(true);
        this.setMessage(PHPDebugUIMessages.PHPExeCompositeFragment_0, 1);
        if (phpExeItem.getExecutable() == null || phpExeItem.getExecutable().getPath().length() == 0) {
            this.setComplete(false);
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_enterLocation, 1);
            return;
        }
        if (phpExeItem.getName().isEmpty()) {
            this.setComplete(false);
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_enterName, 1);
            return;
        }
        if (phpExeItem.getExecutable() == null) {
            this.setMessage(PHPDebugUIMessages.PHPExeCompositeFragment_13, 3);
            return;
        }
        if (!phpExeItem.getExecutable().exists()) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_locationNotExists, 3);
            return;
        }
        PHPExeUtil.PHPExeInfo phpExecInfo = this.getPHPInfo(phpExeItem.getExecutable());
        if (phpExecInfo == null) {
            this.setMessage(PHPDebugUIMessages.PHPExeCompositeFragment_13, 3);
            return;
        }
        if (this.existingItems != null) {
            PHPexeItem[] pHPexeItemArray = this.existingItems;
            int n = this.existingItems.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem item = pHPexeItemArray[n2];
                if (!item.getName().equals(this.initialName) && item.getName().equals(phpExeItem.getName())) {
                    this.setMessage(PHPDebugUIMessages.addPHPexeDialog_duplicateName, 3);
                    return;
                }
                ++n2;
            }
        }
        if (phpExeItem.getSapiType().isEmpty()) {
            this.setMessage(PHPDebugUIMessages.PHPExeCompositeFragment_15, 3);
            return;
        }
        if (phpExecInfo.getSapiType() != null && !phpExeItem.getSapiType().equals(phpExecInfo.getSapiType())) {
            this.setMessage(MessageFormat.format(PHPDebugUIMessages.addPHPexeDialog_wrongSAPItype, phpExecInfo.getSapiType()), 3);
            return;
        }
        if (phpExeItem.getINILocation() != null) {
            String iniLocationName = phpExeItem.getINILocation().getPath();
            File iniFile = null;
            if (iniLocationName.trim().length() > 0 && !(iniFile = new File(iniLocationName)).exists()) {
                this.setMessage(PHPDebugUIMessages.addPHPexeDialog_iniLocationNotExists, 3);
                return;
            }
        }
        if (this.updateDebuggerStatus) {
            AbstractDebuggerConfiguration[] debuggers;
            IStatus debuggerStatus = Status.OK_STATUS;
            AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = debuggers = PHPDebuggersRegistry.getDebuggersConfigurations();
            int n = debuggers.length;
            int n3 = 0;
            while (n3 < n) {
                AbstractDebuggerConfiguration debugger = abstractDebuggerConfigurationArray[n3];
                if (this.getPHPExeItem().getDebuggerID().equals(debugger.getDebuggerId())) {
                    debuggerStatus = debugger.validate(this.getPHPExeItem());
                }
                ++n3;
            }
            if (debuggerStatus.getSeverity() != 0) {
                if (debuggerStatus.getSeverity() == 4) {
                    this.setMessage(debuggerStatus.getMessage(), 3);
                    return;
                }
                this.setMessage(debuggerStatus.getMessage(), 2);
            } else {
                this.setMessage(this.getDescription(), 0);
            }
        }
        this.controlHandler.update();
    }

    protected void setMessage(String message, int type) {
        this.controlHandler.setMessage(message, type);
        if (this.isComplete()) {
            this.setComplete(type != 3);
        }
        this.controlHandler.update();
    }

    public boolean performOk() {
        return true;
    }

    private PHPExeUtil.PHPExeInfo getPHPInfo(File executable) {
        try {
            return PHPExeUtil.getPHPInfo((File)executable, (boolean)false);
        }
        catch (PHPExeException pHPExeException) {
            return null;
        }
    }

    private void updateItem() {
        PHPexeItem phpExeItem = this.getPHPExeItem();
        if (phpExeItem == null) {
            return;
        }
        if (phpExeItem != null && !phpExeItem.isEditable()) {
            this.setComplete(false);
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_readOnlyPHPExe, 1);
            this.validate();
            return;
        }
        phpExeItem.setLoadDefaultINI(this.fLoadDefaultPHPIni.getSelection());
        phpExeItem.setExecutable(new File(this.fPHPExePath.getText()));
        phpExeItem.setName(this.fPHPexeName.getText());
        phpExeItem.setINILocation(this.fPHPIni.getText().isEmpty() ? null : new File(this.fPHPIni.getText()));
        phpExeItem.setSapiType(this.fSapiTypes.getText());
        PHPExeUtil.PHPExeInfo phpExeInfo = this.getPHPInfo(phpExeItem.getExecutable());
        if (phpExeInfo != null) {
            phpExeItem.setVersion(phpExeInfo.getVersion());
            this.setDebuggersCombo();
        }
        phpExeItem.setDebuggerID(this.debuggersIds.get(this.fDebuggers.getSelectionIndex()));
        this.validate();
    }
}

