/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.php.internal.ui.actions.AbstractMoveDelegator;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.PHPMoveProjectAction;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.eclipse.php.refactoring.core.move.PHPProjectMoveProcessor;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.php.refactoring.ui.utils.RefactoringStarter;
import org.eclipse.php.refactoring.ui.wizard.PHPMoveWizard;
import org.eclipse.php.refactoring.ui.wizard.PHPProjectMoveWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class RefactoringMoveAction
extends AbstractMoveDelegator {
    private IStructuredSelection selectedResources;
    private Shell fShell;
    private IContainer target;

    public void run(IStructuredSelection selection) {
        if (this.fShell == null) {
            this.fShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (selection == null) {
            this.unableToRunMoveAction();
            return;
        }
        if (ActionUtils.containsOnlyProjects((List)selection.toList())) {
            IProject project = null;
            if (selection.toList().get(0) instanceof IProject) {
                project = (IProject)selection.toList().get(0);
            } else if (selection.toList().get(0) instanceof IScriptProject) {
                project = ((IScriptProject)selection.toList().get(0)).getProject();
            } else {
                return;
            }
            PHPProjectMoveProcessor processor = new PHPProjectMoveProcessor(project);
            MoveRefactoring refactoring = new MoveRefactoring((MoveProcessor)processor);
            PHPProjectMoveWizard wizard = new PHPProjectMoveWizard((Refactoring)refactoring, project);
            new RefactoringStarter().activate((Refactoring)refactoring, wizard, this.fShell, PHPRefactoringUIMessages.getString("RefactoringMoveAction.0"), true);
            return;
        }
        if (this.selectedResources != null && this.selectedResources.isEmpty()) {
            this.unableToRunMoveAction();
            return;
        }
        IResource[] resources = PHPMoveProcessor.getResources((IStructuredSelection)this.selectedResources);
        if (this.checkForExternalFiles(resources) || resources.length == 0) {
            this.unableToRunMoveAction();
            return;
        }
        PHPMoveProcessor processor = new PHPMoveProcessor(resources);
        if (this.target != null) {
            processor.setDestination(this.target);
        }
        MoveRefactoring refactoring = new MoveRefactoring((MoveProcessor)processor);
        PHPMoveWizard wizard = new PHPMoveWizard((Refactoring)refactoring);
        new RefactoringStarter().activate((Refactoring)refactoring, wizard, this.fShell, PHPRefactoringUIMessages.getString("RefactoringMoveAction.0"), true);
    }

    private boolean checkForExternalFiles(IResource[] resources) {
        return false;
    }

    private final void unableToRunMoveAction() {
        MessageDialog.openInformation((Shell)this.fShell, (String)PHPRefactoringUIMessages.getString("RefactoringMoveAction.1"), (String)PHPRefactoringUIMessages.getString("RefactoringMoveAction.2"));
    }

    private SelectionListenerAction createWorkbenchAction(IStructuredSelection selection) {
        List list = selection.toList();
        PHPMoveProjectAction action = null;
        if (list.size() == 0 || list.get(0) instanceof IProject || list.get(0) instanceof ScriptProject) {
            action = new PHPMoveProjectAction(this.fShell);
            action.selectionChanged(selection);
        }
        return action;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fShell = window.getShell();
    }

    public void run(IAction action) {
        this.run(this.selectedResources);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            if (selection instanceof ITextSelection) {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IEditorPart editor = workbenchWindow.getActivePage().getActiveEditor();
                this.setActiveEditor(action, editor);
            } else {
                this.selectedResources = (IStructuredSelection)selection;
            }
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor == null) {
            return;
        }
        IEditorInput input = targetEditor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            this.selectedResources = new StructuredSelection((Object)file);
        }
    }

    public void setTarget(IContainer target) {
        this.target = target;
    }
}

