/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.corext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.refactoring.ui.RefactoringUIPlugin;
import org.eclipse.php.refactoring.ui.corext.RefactoringASTParser;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class CompilationUnitRewrite {
    private ISourceModule fCu;
    private List fTextEditGroups = new ArrayList();
    private Program fRoot;
    private ASTRewrite fRewrite;
    private boolean fResolveBindings = true;
    private boolean fStatementsRecovery = true;
    private boolean fBindingsRecovery = false;
    private final WorkingCopyOwner fOwner;
    private IDocument fRememberContent = null;

    public CompilationUnitRewrite(ISourceModule cu) {
        this(null, cu, null);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, ISourceModule cu) {
        this(owner, cu, null);
    }

    public CompilationUnitRewrite(ISourceModule cu, Program root) {
        this(null, cu, root);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, ISourceModule cu, Program root) {
        this.fOwner = owner;
        this.fCu = cu;
        this.fRoot = root;
    }

    public void rememberContent() {
        this.fRememberContent = new Document();
    }

    public void setResolveBindings(boolean resolve) {
        this.fResolveBindings = resolve;
    }

    public void setStatementsRecovery(boolean statementsRecovery) {
        this.fStatementsRecovery = statementsRecovery;
    }

    public void setBindingRecovery(boolean bindingsRecovery) {
        this.fBindingsRecovery = bindingsRecovery;
    }

    public void clearASTRewrite() {
        this.fRewrite = null;
        this.fTextEditGroups = new ArrayList();
    }

    public void clearImportRewrites() {
    }

    public void clearASTAndImportRewrites() {
        this.clearASTRewrite();
    }

    public CategorizedTextEditGroup createCategorizedGroupDescription(String name, GroupCategorySet set) {
        CategorizedTextEditGroup result = new CategorizedTextEditGroup(name, set);
        this.fTextEditGroups.add(result);
        return result;
    }

    public TextEditGroup createGroupDescription(String name) {
        TextEditGroup result = new TextEditGroup(name);
        this.fTextEditGroups.add(result);
        return result;
    }

    public SourceModuleChange createChange() throws CoreException {
        return this.createChange(true, null);
    }

    public SourceModuleChange createChange(boolean generateGroups, IProgressMonitor monitor) throws CoreException {
        return this.createChange(this.fCu.getElementName(), generateGroups, monitor);
    }

    public SourceModuleChange createChange(String name, boolean generateGroups, IProgressMonitor monitor) throws CoreException {
        SourceModuleChange cuChange = new SourceModuleChange(name, this.fCu);
        MultiTextEdit multiEdit = new MultiTextEdit();
        cuChange.setEdit((TextEdit)multiEdit);
        return this.attachChange(cuChange, generateGroups, monitor);
    }

    public SourceModuleChange attachChange(SourceModuleChange cuChange, boolean generateGroups, IProgressMonitor monitor) throws CoreException {
        try {
            TextEdit rewriteEdit;
            boolean needsAstRewrite;
            boolean bl = needsAstRewrite = this.fRewrite != null;
            if (!needsAstRewrite) {
                return null;
            }
            MultiTextEdit multiEdit = (MultiTextEdit)cuChange.getEdit();
            if (multiEdit == null) {
                multiEdit = new MultiTextEdit();
                cuChange.setEdit((TextEdit)multiEdit);
            }
            if (needsAstRewrite && !CompilationUnitRewrite.isEmptyEdit(rewriteEdit = this.fRememberContent != null ? this.fRewrite.rewriteAST(this.fRememberContent, this.fCu.getScriptProject().getOptions(true)) : this.fRewrite.rewriteAST())) {
                multiEdit.addChild(rewriteEdit);
                if (generateGroups) {
                    for (TextEditGroup group : this.fTextEditGroups) {
                        cuChange.addTextEditGroup(group);
                    }
                }
            }
            if (CompilationUnitRewrite.isEmptyEdit((TextEdit)multiEdit)) {
                return null;
            }
            SourceModuleChange sourceModuleChange = cuChange;
            return sourceModuleChange;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static boolean isEmptyEdit(TextEdit edit) {
        return edit.getClass() == MultiTextEdit.class && !edit.hasChildren();
    }

    public ISourceModule getCu() {
        return this.fCu;
    }

    public Program getRoot() {
        if (this.fRoot == null) {
            try {
                this.fRoot = new RefactoringASTParser(ProjectOptions.getPhpVersion((IModelElement)this.fCu), ProjectOptions.useShortTags((IModelElement)this.fCu)).parse(this.fCu, this.fOwner, this.fResolveBindings, this.fStatementsRecovery, this.fBindingsRecovery, null);
            }
            catch (Exception e) {
                RefactoringUIPlugin.log(e);
            }
        }
        return this.fRoot;
    }

    public AST getAST() {
        return this.getRoot().getAST();
    }

    public ASTRewrite getASTRewrite() {
        if (this.fRewrite == null) {
            this.fRewrite = ASTRewrite.create((AST)this.getRoot().getAST());
            if (this.fRememberContent != null) {
                try {
                    this.fRememberContent.set(this.fCu.getSource());
                }
                catch (ModelException modelException) {
                    this.fRememberContent = null;
                }
            }
        }
        return this.fRewrite;
    }

    public void clearGroupDescriptions() {
        for (TextEditGroup group : this.fTextEditGroups) {
            group.clearTextEdits();
        }
    }
}

