/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.autoEdit.MatchingCharAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class MatchingBracketAutoEditStrategy
extends MatchingCharAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (TypingPreferences.closeBrackets && command.text != null) {
            int length = command.text.length();
            if (length == 0 && command.length == 1) {
                try {
                    char removedChar = document.getChar(command.offset);
                    if (removedChar == '(' || removedChar == '[') {
                        this.deletePairBreaket((IStructuredDocument)document, command, removedChar);
                    }
                }
                catch (BadLocationException e) {
                    Logger.logException(e);
                }
            }
            if (length == 1) {
                char c = command.text.charAt(0);
                if (c == '(' || c == '[') {
                    this.autoAddPairBracket((IStructuredDocument)document, command);
                } else if (c == ')' || c == ']') {
                    this.insertClosingChar((IStructuredDocument)document, command);
                }
            }
        }
    }

    private void autoAddPairBracket(IStructuredDocument document, DocumentCommand command) {
        block6: {
            int currentPosition = command.offset;
            int commandLength = command.length;
            char c = command.text.charAt(0);
            boolean extraCharWasAdded = false;
            String removedText = "";
            try {
                if (currentPosition + commandLength < document.getLength() && !this.shouldAddClosingBracket(document, currentPosition + commandLength, false)) {
                    return;
                }
                removedText = document.get(currentPosition, commandLength);
                document.getUndoManager().disableUndoManagement();
                document.replace(currentPosition, commandLength, command.text);
                extraCharWasAdded = true;
                int result = this.isMatchingCharNeeded(document, currentPosition, c);
                document.replace(currentPosition, 1, removedText);
                document.getUndoManager().enableUndoManagement();
                if (result == 0) {
                    char match = MatchingBracketAutoEditStrategy.getMatchingChar(c);
                    command.text = String.valueOf(command.text) + match;
                    document.replace(currentPosition, commandLength, command.text);
                    document.getUndoManager().disableUndoManagement();
                    document.replace(currentPosition + 1, 0, "");
                    document.getUndoManager().enableUndoManagement();
                    this.adjustDocumentOffset(command);
                    command.length = 0;
                    command.text = "";
                }
            }
            catch (Exception exc) {
                Logger.logException(exc);
                if (!extraCharWasAdded) break block6;
                try {
                    document.replace(currentPosition, 1, removedText);
                    document.getUndoManager().enableUndoManagement();
                }
                catch (BadLocationException e) {
                    Logger.logException(e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int isMatchingCharNeeded(IStructuredDocument document, int offset, char bracketChar) {
        try {
            String postCharState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)(offset + 1));
            if (postCharState != "org.eclipse.php.PHP_DEFAULT" && postCharState != "PHP_OPENTAG" && postCharState != "PHP_CLOSETAG" && MatchingBracketAutoEditStrategy.isSpecialOpenCurlyInQuotes(document, offset)) {
                postCharState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)(offset + 2));
            }
            if (document.getLength() == offset + 1) {
                postCharState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)offset);
                if (postCharState != "org.eclipse.php.PHP_DEFAULT" && postCharState != "PHP_OPENTAG") {
                    if (postCharState != "PHP_CLOSETAG") return 1;
                }
                if (document.getChar(offset) != MatchingBracketAutoEditStrategy.getMatchingChar(bracketChar)) return 0;
                return 1;
            }
            if (postCharState != "org.eclipse.php.PHP_DEFAULT" && postCharState != "PHP_OPENTAG" && postCharState != "PHP_CLOSETAG") {
                return -1;
            }
            int currOffset = offset + 1;
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(currOffset);
            while (currOffset >= 0) {
                if (sdRegion == null) {
                    return 1;
                }
                if (sdRegion.getType() != "PHP_CONTENT") {
                    currOffset = sdRegion.getStartOffset() - 1;
                    sdRegion = document.getRegionAtCharacterOffset(currOffset);
                    continue;
                }
                ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(currOffset);
                if (tRegion.getType().equals("PHP_CLOSE")) {
                    tRegion = sdRegion.getRegionAtCharacterOffset(currOffset - 1);
                }
                int regionStart = sdRegion.getStartOffset(tRegion);
                if (tRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)tRegion;
                    tRegion = container.getRegionAtCharacterOffset(currOffset);
                    regionStart += tRegion.getStart();
                }
                if (tRegion instanceof IPhpScriptRegion) {
                    IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
                    tRegion = scriptRegion.getPhpToken(currOffset - regionStart);
                    while (tRegion != null) {
                        String regionType = tRegion.getType();
                        if (regionType == "PHP_TOKEN") {
                            char token = document.getChar(regionStart + tRegion.getStart());
                            if ((token == '(' || token == '[') && token == bracketChar && matcher.match((IDocument)document, regionStart + tRegion.getStart() + 1) == null) {
                                return 0;
                            }
                        } else {
                            if (regionType == "PHP_CURLY_OPEN") return 1;
                            if (regionType == "PHP_CURLY_CLOSE") {
                                return 1;
                            }
                        }
                        if (tRegion.getStart() <= 0) break;
                        tRegion = scriptRegion.getPhpToken(tRegion.getStart() - 1);
                    }
                }
                sdRegion = (currOffset = sdRegion.getStartOffset() - 1) < 0 ? null : document.getRegionAtCharacterOffset(currOffset);
            }
            return 1;
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return 1;
    }

    private void insertClosingChar(IStructuredDocument document, DocumentCommand command) {
        int endSelection = command.offset + command.length;
        char addedChar = command.text.charAt(0);
        if (endSelection == document.getLength()) {
            return;
        }
        try {
            int result;
            char nextChar = document.getChar(endSelection);
            if (nextChar == addedChar && (result = this.isMatchingCharNeeded(document, endSelection, MatchingBracketAutoEditStrategy.getMatchingChar(addedChar))) == 1 && (matcher.match((IDocument)document, endSelection + 1) != null || document.getLength() == endSelection + 1)) {
                if (command.length == 0) {
                    this.adjustDocumentOffset(command);
                    command.text = "";
                } else {
                    ++command.length;
                }
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private void deletePairBreaket(IStructuredDocument document, DocumentCommand command, char deletedChar) {
        int offset = command.offset;
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null || sdRegion.getType() != "PHP_CONTENT") {
            return;
        }
        try {
            ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
            if (tRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
            }
            if (tRegion instanceof IPhpScriptRegion) {
                boolean removeBoth;
                IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
                if ((tRegion = scriptRegion.getPhpToken(offset - sdRegion.getStartOffset((ITextRegion)scriptRegion))) == null || tRegion.getType() != "PHP_TOKEN") {
                    return;
                }
                char nextChar = document.getChar(offset + 1);
                char matchingChar = MatchingBracketAutoEditStrategy.getMatchingChar(deletedChar);
                if (matchingChar == '-' || nextChar != matchingChar) {
                    return;
                }
                boolean bl = removeBoth = this.isMatchingCharNeeded(document, offset, deletedChar) == 1;
                if (removeBoth) {
                    command.length = 2;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

