/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hyperlink;

import java.util.HashSet;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.ModelElementHyperlink;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.hyperlink.IncludeHyperlinkVisitor;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.ui.IEditorPart;

public class IncludeHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        PHPStructuredEditor editor = EditorUtility.getPHPEditor(textViewer);
        if (editor == null) {
            return null;
        }
        ISourceModule input = org.eclipse.dltk.internal.ui.editor.EditorUtility.getEditorInputModelElement((IEditorPart)editor, (boolean)false);
        if (!(input instanceof ISourceModule)) {
            return null;
        }
        int offset = region.getOffset();
        ISourceModule sourceModule = input;
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        if (moduleDeclaration == null) {
            return null;
        }
        IncludeHyperlinkVisitor includeVisitor = new IncludeHyperlinkVisitor(offset, sourceModule);
        try {
            moduleDeclaration.traverse((ASTVisitor)includeVisitor);
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
        if (includeVisitor.getFile() != null) {
            ISourceModule includedSourceModule;
            if (!this.inclusive(region, includeVisitor.getSelectRegion())) {
                return null;
            }
            HashSet<String> set = new HashSet<String>();
            if (sourceModule.getResource() != null) {
                set.add(sourceModule.getResource().getLocation().toOSString());
            }
            if ((includedSourceModule = FileNetworkUtility.findSourceModule((ISourceModule)sourceModule, (String)includeVisitor.getFile(), set)) != null) {
                return new IHyperlink[]{new ModelElementHyperlink((IRegion)includeVisitor.getSelectRegion(), (Object)includedSourceModule, new OpenAction((IEditorPart)editor))};
            }
        }
        return null;
    }

    private boolean inclusive(IRegion region1, Region region2) {
        if (region1 == null || region2 == null) {
            return false;
        }
        return region1.getOffset() >= region2.getOffset() && region1.getOffset() + region1.getLength() <= region2.getOffset() + region2.getLength();
    }
}

