/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.phar.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.core.phar.StatusInfo;
import org.eclipse.php.internal.core.phar.digest.Digest;
import org.eclipse.php.internal.ui.explorer.PHPExplorerContentProvider;
import org.eclipse.php.internal.ui.explorer.PHPExplorerLabelProvider;
import org.eclipse.php.internal.ui.phar.wizard.CheckboxTreeAndListGroup;
import org.eclipse.php.internal.ui.phar.wizard.ContainerFilter;
import org.eclipse.php.internal.ui.phar.wizard.EmptyInnerPackageFilter;
import org.eclipse.php.internal.ui.phar.wizard.IPharWizardPage;
import org.eclipse.php.internal.ui.phar.wizard.PharPackagerMessages;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;

public class PharPackageWizardPage
extends WizardExportResourcesPage
implements IPharWizardPage {
    private UntypedListener fUntypedListener = new UntypedListener();
    private static final String SPLASH1 = "/";
    private static final String SPLASH2 = "\\";
    private static final String PAGE_NAME = PharPackagerMessages.JarPackageWizardPage_Title;
    private static final String STORE_EXPORT_TYPE = String.valueOf(PAGE_NAME) + ".EXPORT_TYPE";
    private static final String STORE_COMPRESS_TYPE = String.valueOf(PAGE_NAME) + ".COMPRESS_TYPE";
    private static final String STORE_OVERWRITE = String.valueOf(PAGE_NAME) + ".OVERWRITE";
    private static final String STORE_STUB_GENERATED = String.valueOf(PAGE_NAME) + ".STUB_GENERATED";
    private static final String STORE_STUB_PATH = String.valueOf(PAGE_NAME) + ".STUB_PATH";
    private static final String USE_SIGNATURE = String.valueOf(PAGE_NAME) + ".USE_SIGNATURE";
    private static final String SIGNATURE_TYPE = String.valueOf(PAGE_NAME) + ".SIGNATURE_TYPE";
    private static final String STORE_INCLUDE_DIRECTORY_ENTRIES = String.valueOf(PAGE_NAME) + ".INCLUDE_DIRECTORY_ENTRIES";
    private final String fStoreDestinationNamesId = String.valueOf(PAGE_NAME) + ".DESTINATION_NAMES_ID";
    private final String EMPTYSTRING = "";
    private IStructuredSelection fInitialSelection;
    private CheckboxTreeAndListGroup fInputGroup;
    private Button fOverwriteCheckbox;
    private boolean fInitiallySelecting = true;
    private List<Button> signatureButtons;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 480;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 150;
    private Combo fDestinationNamesCombo;
    private Button fDestinationBrowseButton;
    private final PharPackage pharData;
    private Button pharCompressRadio;
    private Button zipCompressRadio;
    private Button tarCompressRadio;
    private Composite exportTypeGroup;
    private Button noneCompressTypePhar;
    private Button zlibCompressTypePhar;
    private Button bzipCompressTypePhar;
    private Composite compressTypeGroup;
    private Composite fManifestGroup;
    private Button fGenerateManifestRadioButton;
    private Button fUseManifestRadioButton;
    private Text fManifestFileText;
    private Label fManifestFileLabel;
    private Button fManifestFileBrowseButton;
    private String[] fileNames;

    public PharPackageWizardPage(PharPackage pharData, IStructuredSelection fSelection) {
        super(PAGE_NAME, fSelection);
        this.setTitle(PharPackagerMessages.JarPackageWizardPage_title);
        this.setDescription(PharPackagerMessages.JarPackageWizardPage_description);
        this.pharData = pharData;
        this.fInitialSelection = fSelection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createInputGroup(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.createLabel(composite, PharPackagerMessages.JarManifestWizardPage_manifestSource_label, false);
        this.createManifestGroup(composite);
        this.createSignatureGroup(composite);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.fInitialSelection != null) {
            this.setupBasedOnInitialSelections();
        }
        this.update();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.php.help.pharpackager_wizard_page");
    }

    private void createSignatureGroup(Composite parent) {
        Composite signatureTypeGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = Digest.DIGEST_MAP.size();
        signatureTypeGroup.setLayout((Layout)layout);
        Label label = new Label(signatureTypeGroup, 0);
        label.setText(PharPackagerMessages.JarPackageWizardPage_Signature_Type);
        label.setLayoutData((Object)new GridData(32, 2, false, false, Digest.DIGEST_MAP.size(), 1));
        this.signatureButtons = new ArrayList<Button>();
        for (final String type : Digest.DIGEST_MAP.keySet()) {
            Button signatureButton = new Button(signatureTypeGroup, 16400);
            signatureButton.setText(type);
            signatureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PharPackageWizardPage.this.pharData.setSignature(type);
                }
            });
            this.signatureButtons.add(signatureButton);
        }
    }

    protected void initializeJarPackage() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fileNames = settings.getArray(this.fStoreDestinationNamesId);
            if (this.fileNames == null) {
                this.fileNames = new String[0];
                return;
            }
            this.pharData.setPharLocation(Path.fromOSString((String)this.fileNames[0]));
            this.pharData.setElements(this.getSelectedElements());
            this.pharData.setCompressType(settings.getInt(STORE_COMPRESS_TYPE));
            this.pharData.setExportType(settings.getInt(STORE_EXPORT_TYPE));
            this.pharData.setIncludeDirectoryEntries(settings.getBoolean(STORE_INCLUDE_DIRECTORY_ENTRIES));
            this.pharData.setOverwrite(settings.getBoolean(STORE_OVERWRITE));
            this.pharData.setStubGenerated(settings.getBoolean(STORE_STUB_GENERATED));
            this.pharData.setStubLocation(Path.fromOSString((String)settings.get(STORE_STUB_PATH)));
            String signatureType = settings.get(SIGNATURE_TYPE);
            if (signatureType != null && signatureType.trim().length() > 0) {
                this.pharData.setSignature(signatureType);
            } else {
                this.pharData.setSignature("MD5");
            }
        }
    }

    protected void restoreWidgetValues() {
        super.restoreWidgetValues();
        this.initializeJarPackage();
        if (this.fileNames != null && this.fileNames.length > 0) {
            this.fDestinationNamesCombo.setItems(this.fileNames);
            this.fDestinationNamesCombo.select(0);
        }
        if (this.pharData.getExportType() == 0) {
            this.pharCompressRadio.setSelection(true);
        } else if (this.pharData.getExportType() == 1) {
            this.tarCompressRadio.setSelection(true);
        } else if (this.pharData.getExportType() == 2) {
            this.zipCompressRadio.setSelection(true);
            this.setZipExportType();
        }
        if (this.pharData.getCompressType() == 0) {
            this.noneCompressTypePhar.setSelection(true);
        } else if (this.pharData.getCompressType() == 2) {
            this.bzipCompressTypePhar.setSelection(true);
        } else if (this.pharData.getCompressType() == 1) {
            this.zlibCompressTypePhar.setSelection(true);
        }
        this.fOverwriteCheckbox.setSelection(this.pharData.allowOverwrite());
        if (this.pharData.isStubGenerated()) {
            this.fGenerateManifestRadioButton.setSelection(true);
        } else {
            this.fUseManifestRadioButton.setSelection(true);
            this.fManifestFileText.setText(this.pharData.getStubLocation().toString());
        }
        if (this.pharData.getSignature() != null) {
            for (Button button : this.signatureButtons) {
                if (!button.getText().equals(this.pharData.getSignature())) continue;
                button.setSelection(true);
                break;
            }
        } else if (this.signatureButtons.size() > 0) {
            this.signatureButtons.get(0).setSelection(true);
        }
        this.updateEnableState();
    }

    private void setZipExportType() {
        this.noneCompressTypePhar.setText(PharPackagerMessages.JarPackageWizardPage_no);
        this.zlibCompressTypePhar.setText(PharPackagerMessages.JarPackageWizardPage_yes);
        this.bzipCompressTypePhar.setVisible(false);
    }

    protected Label createLabel(Composite parent, String text, boolean bold) {
        Label label = new Label(parent, 0);
        if (bold) {
            label.setFont(JFaceResources.getBannerFont());
        }
        label.setText(text);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected void createManifestGroup(Composite parent) {
        this.fManifestGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.fManifestGroup.setLayout((Layout)layout);
        this.fManifestGroup.setLayoutData((Object)new GridData(784));
        this.fGenerateManifestRadioButton = new Button(this.fManifestGroup, 16400);
        this.fGenerateManifestRadioButton.setText(PharPackagerMessages.JarManifestWizardPage_genetateManifest_text);
        this.fGenerateManifestRadioButton.addListener(13, (Listener)this.fUntypedListener);
        this.fUseManifestRadioButton = new Button(this.fManifestGroup, 16400);
        this.fUseManifestRadioButton.setText(PharPackagerMessages.JarManifestWizardPage_useManifest_text);
        this.fUseManifestRadioButton.addListener(13, (Listener)this.fUntypedListener);
        this.fUseManifestRadioButton.setLayoutData((Object)new GridData(768));
        Composite existingManifestGroup = new Composite(this.fManifestGroup, 0);
        GridLayout existingManifestLayout = new GridLayout();
        existingManifestLayout.marginWidth = 0;
        existingManifestGroup.setLayout((Layout)existingManifestLayout);
        GridData data = new GridData(784);
        data.horizontalIndent = 20;
        existingManifestGroup.setLayoutData((Object)data);
        this.createManifestFileGroup(existingManifestGroup);
    }

    protected void createManifestFileGroup(Composite parent) {
        Composite manifestFileGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        manifestFileGroup.setLayout((Layout)layout);
        manifestFileGroup.setLayoutData((Object)new GridData(784));
        this.fManifestFileLabel = new Label(manifestFileGroup, 0);
        this.fManifestFileLabel.setText(PharPackagerMessages.JarManifestWizardPage_manifestFile_text);
        this.fManifestFileText = new Text(manifestFileGroup, 2052);
        this.fManifestFileText.setEditable(false);
        this.fManifestFileText.addListener(24, (Listener)this.fUntypedListener);
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(40);
        this.fManifestFileText.setLayoutData((Object)data);
        this.fManifestFileBrowseButton = new Button(manifestFileGroup, 8);
        this.fManifestFileBrowseButton.setText(PharPackagerMessages.JarManifestWizardPage_manifestFileBrowse_text);
        this.fManifestFileBrowseButton.setLayoutData((Object)new GridData(256));
        this.fManifestFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PharPackageWizardPage.this.handleManifestFileBrowseButtonPressed();
            }
        });
    }

    protected void handleManifestFileBrowseButtonPressed() {
        ElementTreeSelectionDialog dialog = this.createWorkspaceFileSelectionDialog(PharPackagerMessages.JarManifestWizardPage_manifestSelectionDialog_title, PharPackagerMessages.JarManifestWizardPage_manifestSelectionDialog_message);
        if (this.pharData.getStubFile() != null && this.pharData.isStubAccessible()) {
            dialog.setInitialSelections((Object[])new IResource[]{this.pharData.getStubFile()});
        }
        if (dialog.open() == 0) {
            Object[] resources = dialog.getResult();
            if (resources.length != 1) {
                this.setErrorMessage(PharPackagerMessages.JarManifestWizardPage_error_onlyOneManifestMustBeSelected);
            } else {
                if (resources[0] instanceof ISourceModule) {
                    ISourceModule sm = (ISourceModule)resources[0];
                    resources[0] = sm.getResource();
                }
                this.pharData.setStubLocation(((IResource)resources[0]).getFullPath());
                this.fManifestFileText.setText(this.pharData.getStubLocation().toString());
            }
        }
    }

    protected ElementTreeSelectionDialog createWorkspaceFileSelectionDialog(String title, String message) {
        ScriptExplorerContentProvider treeContentProvider = this.createContentProvider();
        IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
        DecoratingLabelProvider provider = new DecoratingLabelProvider((ILabelProvider)new PHPExplorerLabelProvider(treeContentProvider, store), (ILabelDecorator)new ProblemsLabelDecorator(null));
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)provider, (ITreeContentProvider)treeContentProvider);
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                StatusInfo res = new StatusInfo();
                if (selection.length == 1 && (selection[0] instanceof IFile || selection[0] instanceof ISourceModule)) {
                    res.setOK();
                }
                return res;
            }
        });
        dialog.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setStatusLineAboveButtons(true);
        dialog.setInput((Object)DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        return dialog;
    }

    protected void giveFocusToDestination() {
        this.fDestinationNamesCombo.setFocus();
    }

    public ScriptExplorerContentProvider createContentProvider() {
        boolean showCUChildren = DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.ui.packages.cuchildren");
        return new PHPExplorerContentProvider(showCUChildren){

            protected IPreferenceStore getPreferenceStore() {
                return DLTKUIPlugin.getDefault().getPreferenceStore();
            }
        };
    }

    protected void createInputGroup(Composite parent) {
        ScriptExplorerContentProvider treeContentProvider = this.createContentProvider();
        IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
        DecoratingLabelProvider provider = new DecoratingLabelProvider((ILabelProvider)new PHPExplorerLabelProvider(treeContentProvider, store), (ILabelDecorator)new ProblemsLabelDecorator(null));
        this.fInputGroup = new CheckboxTreeAndListGroup(parent, DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()), (ITreeContentProvider)treeContentProvider, (ILabelProvider)provider, (IStructuredContentProvider)new StandardModelElementContentProvider(), (ILabelProvider)provider, 0, 480, 150){

            @Override
            protected void setTreeChecked(Object element, boolean state) {
                IResource resource;
                if (PharPackageWizardPage.this.fInitiallySelecting && element instanceof IResource && (resource = (IResource)element).getName().charAt(0) == '.') {
                    return;
                }
                super.setTreeChecked(element, state);
            }
        };
        this.fInputGroup.addTreeFilter(new EmptyInnerPackageFilter());
        ModelElementSorter comparator = new ModelElementSorter();
        comparator.setInnerElements(false);
        this.fInputGroup.setTreeComparator((ViewerComparator)comparator);
        this.fInputGroup.setListComparator((ViewerComparator)comparator);
        this.fInputGroup.addTreeFilter(new ContainerFilter(ContainerFilter.FILTER_NON_CONTAINERS));
        this.fInputGroup.addTreeFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object p, Object element) {
                if (element instanceof IProjectFragment) {
                    IProjectFragment root = (IProjectFragment)element;
                    return !root.isArchive() && !root.isExternal();
                }
                return true;
            }
        });
        this.fInputGroup.addListFilter(new ContainerFilter(ContainerFilter.FILTER_CONTAINERS));
        this.fInputGroup.getTree().addListener(4, (Listener)this);
        this.fInputGroup.getTable().addListener(4, (Listener)this);
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PharPackageWizardPage.this.update();
            }
        };
        this.fInputGroup.addCheckStateListener(listener);
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        this.exportTypeGroup = new Composite(optionsGroup, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        this.exportTypeGroup.setLayout((Layout)layout);
        Label label = new Label(this.exportTypeGroup, 0);
        label.setText(PharPackagerMessages.JarPackageWizardPage_Export_Type);
        label.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        this.pharCompressRadio = new Button(this.exportTypeGroup, 16400);
        this.pharCompressRadio.setText(PharPackagerMessages.JarPackageWizardPage_Export_Type_phar);
        this.pharCompressRadio.addListener(13, (Listener)this);
        this.zipCompressRadio = new Button(this.exportTypeGroup, 16400);
        this.zipCompressRadio.setText(PharPackagerMessages.JarPackageWizardPage_Export_Type_zip);
        this.zipCompressRadio.addListener(13, (Listener)this);
        this.tarCompressRadio = new Button(this.exportTypeGroup, 16400);
        this.tarCompressRadio.setText(PharPackagerMessages.JarPackageWizardPage_Export_Type_tar);
        this.tarCompressRadio.addListener(13, (Listener)this);
        this.compressTypeGroup = new Composite(optionsGroup, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        this.compressTypeGroup.setLayout((Layout)layout);
        label = new Label(this.exportTypeGroup, 0);
        label.setText(PharPackagerMessages.JarPackageWizardPage_Compress_Type);
        label.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        this.noneCompressTypePhar = new Button(this.compressTypeGroup, 16400);
        this.noneCompressTypePhar.setText(PharPackagerMessages.JarPackageWizardPage_Compress_Type_none);
        this.noneCompressTypePhar.addListener(13, (Listener)this);
        this.bzipCompressTypePhar = new Button(this.compressTypeGroup, 16400);
        this.bzipCompressTypePhar.setText(PharPackagerMessages.JarPackageWizardPage_Compress_Type_bz2);
        this.bzipCompressTypePhar.addListener(13, (Listener)this);
        this.zlibCompressTypePhar = new Button(this.compressTypeGroup, 16400);
        this.zlibCompressTypePhar.setText(PharPackagerMessages.JarPackageWizardPage_yes);
        this.zlibCompressTypePhar.addListener(13, (Listener)this);
        this.zlibCompressTypePhar.setLayoutData((Object)new GridData(768, 2, true, false, 1, 1));
        this.fOverwriteCheckbox = new Button(optionsGroup, 16416);
        this.fOverwriteCheckbox.setText(PharPackagerMessages.JarPackageWizardPage_overwrite_text);
        this.fOverwriteCheckbox.addListener(13, (Listener)this);
    }

    protected void createDestinationGroup(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        String label = PharPackagerMessages.JarPackageWizardPage_PHAR_file;
        new Label(destinationSelectionGroup, 0).setText(label);
        this.fDestinationNamesCombo = new Combo(destinationSelectionGroup, 2052);
        this.fDestinationNamesCombo.setVisibleItemCount(30);
        this.fDestinationNamesCombo.addListener(24, (Listener)this);
        this.fDestinationNamesCombo.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.fDestinationNamesCombo.setLayoutData((Object)data);
        this.fDestinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.fDestinationBrowseButton.setText(PharPackagerMessages.JarPackageWizardPage_browseButton_text);
        this.fDestinationBrowseButton.setLayoutData((Object)new GridData(256));
        Object gd = this.fDestinationBrowseButton.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = PharPackageWizardPage.getButtonWidthHint(this.fDestinationBrowseButton);
            ((GridData)gd).horizontalAlignment = 4;
        }
        this.fDestinationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PharPackageWizardPage.this.handleDestinationBrowseButtonPressed();
            }
        });
    }

    protected void handleDestinationBrowseButtonPressed() {
        String selectedFileName;
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[0]);
        String currentSourceString = this.getDestinationValue();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
            dialog.setFileName(currentSourceString.substring(lastSeparatorIndex + 1, currentSourceString.length()));
        }
        if ((selectedFileName = dialog.open()) != null) {
            IContainer[] findContainersForLocation = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation((IPath)new Path(selectedFileName));
            if (findContainersForLocation.length > 0) {
                selectedFileName = findContainersForLocation[0].getFullPath().makeRelative().toString();
            }
            this.fDestinationNamesCombo.setText(this.toLegalPharPath(selectedFileName).toString());
        }
    }

    private IPath toLegalPharPath(String selectedFileName) {
        Path path = new Path(selectedFileName);
        if (path.segmentCount() > 0 && this.ensureTargetFileIsValid(path.toFile()) && path.getFileExtension() == null) {
            if (this.pharCompressRadio.getSelection()) {
                if (!"phar".equals(path.getFileExtension())) {
                    path = path.addFileExtension("phar");
                }
            } else if (this.zipCompressRadio.getSelection()) {
                if (!"zip".equals(path.getFileExtension())) {
                    path = path.addFileExtension("zip");
                }
            } else if (this.tarCompressRadio.getSelection()) {
                String fileName = path.lastSegment();
                if (this.noneCompressTypePhar.getSelection()) {
                    if (!"tar".equals(path.getFileExtension())) {
                        path = path.addFileExtension("tar");
                    }
                } else if (this.zlibCompressTypePhar.getSelection()) {
                    if (!fileName.endsWith(".tar.gz")) {
                        path = path.addFileExtension("tar.gz");
                    }
                } else if (this.bzipCompressTypePhar.getSelection() && !fileName.endsWith(".tar.bz2")) {
                    path = path.addFileExtension("tar.bz2");
                }
            }
        }
        return path;
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    @Override
    public void finish() {
        this.saveWidgetValues();
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(this.fStoreDestinationNamesId);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(this.fStoreDestinationNamesId, directoryNames);
            settings.put(STORE_EXPORT_TYPE, this.pharData.getExportType());
            settings.put(STORE_COMPRESS_TYPE, this.pharData.getCompressType());
            settings.put(STORE_INCLUDE_DIRECTORY_ENTRIES, this.pharData.areDirectoryEntriesIncluded());
            settings.put(STORE_OVERWRITE, this.pharData.allowOverwrite());
            settings.put(STORE_STUB_GENERATED, this.pharData.isStubGenerated());
            settings.put(STORE_STUB_PATH, this.pharData.getStubLocation().toString());
            settings.put(USE_SIGNATURE, this.pharData.isUseSignature());
            settings.put(SIGNATURE_TYPE, this.pharData.getSignature());
        }
    }

    protected String getDestinationValue() {
        String destinationText = this.fDestinationNamesCombo.getText().trim();
        destinationText = this.toLegalPharPath(destinationText).toString();
        return destinationText;
    }

    protected boolean validateDestinationGroup() {
        if (this.fDestinationNamesCombo.getText().length() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            if (this.getMessage() != null) {
                this.setMessage(null);
            }
            return false;
        }
        if (this.pharData.getAbsolutePharLocation().toString().endsWith(SPLASH1) || this.pharData.getAbsolutePharLocation().toString().endsWith(SPLASH2)) {
            this.setErrorMessage(PharPackagerMessages.JarPackageWizardPage_error_exportDestinationMustNotBeDirectory);
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (workspaceLocation != null && workspaceLocation.isPrefixOf(this.pharData.getAbsolutePharLocation())) {
            int segments = workspaceLocation.matchingFirstSegments(this.pharData.getAbsolutePharLocation());
            IPath path = this.pharData.getAbsolutePharLocation().removeFirstSegments(segments);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.getType() == 1 && PharPackageWizardPage.contains(PharPackageWizardPage.asResources(this.pharData.getElements()), (IFile)resource)) {
                this.setErrorMessage(PharPackagerMessages.JarPackageWizardPage_error_cantExportPHARIntoItself);
                return false;
            }
        }
        String currentMessage = this.getMessage();
        if (!new File(this.fDestinationNamesCombo.getText()).isAbsolute()) {
            if (currentMessage == null) {
                this.setMessage(PharPackagerMessages.JarPackageWizardPage_info_relativeExportDestination, 1);
            }
        } else if (currentMessage != null) {
            this.setMessage(currentMessage);
        }
        return this.ensureTargetFileIsValid(this.pharData.getAbsolutePharLocation().toFile());
    }

    public void handleEvent(Event e) {
        if (this.getControl() == null) {
            return;
        }
        this.update();
    }

    protected void updateModel() {
        this.pharData.setElements(this.getSelectedElements());
        String comboText = this.fDestinationNamesCombo.getText();
        IPath path = this.toLegalPharPath(comboText);
        this.pharData.setPharLocation(path);
        this.pharData.setOverwrite(this.fOverwriteCheckbox.getSelection());
        if (this.fGenerateManifestRadioButton.getSelection()) {
            this.pharData.setStubGenerated(true);
        } else {
            this.pharData.setStubGenerated(false);
            if (this.fManifestFileText.getText() != null) {
                this.pharData.setStubLocation((IPath)new Path(this.fManifestFileText.getText()));
            } else {
                this.pharData.setStubLocation((IPath)new Path(""));
                this.setErrorMessage(PharPackagerMessages.JarPackageWizardPage_error_StubFileNull);
            }
        }
        if (this.pharCompressRadio.getSelection()) {
            this.noneCompressTypePhar.setText(PharPackagerMessages.JarPackageWizardPage_Compress_Type_none);
            this.zlibCompressTypePhar.setText(PharPackagerMessages.JarPackageWizardPage_Compress_Type_gz);
            this.bzipCompressTypePhar.setVisible(true);
            this.pharData.setExportType(0);
        } else if (this.zipCompressRadio.getSelection()) {
            this.setZipExportType();
            this.pharData.setExportType(2);
            if (this.bzipCompressTypePhar.getSelection()) {
                this.zlibCompressTypePhar.setSelection(true);
                this.bzipCompressTypePhar.setSelection(false);
            }
        } else if (this.tarCompressRadio.getSelection()) {
            this.noneCompressTypePhar.setText(PharPackagerMessages.JarPackageWizardPage_Compress_Type_none);
            this.zlibCompressTypePhar.setText(PharPackagerMessages.JarPackageWizardPage_Compress_Type_gz);
            this.bzipCompressTypePhar.setVisible(true);
            this.pharData.setExportType(1);
        }
        if (this.noneCompressTypePhar.getSelection()) {
            this.pharData.setCompressType(0);
        } else if (this.zlibCompressTypePhar.getSelection()) {
            this.pharData.setCompressType(1);
        } else if (this.bzipCompressTypePhar.getSelection()) {
            this.pharData.setCompressType(2);
        }
    }

    protected boolean ensureTargetFileIsValid(File targetFile) {
        if (targetFile.exists() && targetFile.isDirectory() && this.fDestinationNamesCombo.getText().length() > 0) {
            this.setErrorMessage(PharPackagerMessages.JarPackageWizardPage_error_exportDestinationMustNotBeDirectory);
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        if (targetFile.exists() && !targetFile.canWrite()) {
            this.setErrorMessage(PharPackagerMessages.JarPackageWizardPage_error_jarFileExistsAndNotWritable);
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        return true;
    }

    protected void update() {
        this.updateModel();
        this.updateWidgetEnablements();
        this.updateEnableState();
        this.updatePageCompletion();
        this.compressTypeGroup.layout();
    }

    private void updateEnableState() {
        boolean generate = this.fGenerateManifestRadioButton.getSelection();
        this.fManifestFileText.setEnabled(!generate);
        this.fManifestFileLabel.setEnabled(!generate);
        this.fManifestFileBrowseButton.setEnabled(!generate);
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.isPageComplete();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
    }

    static boolean contains(List resources, IFile file) {
        if (resources == null || file == null) {
            return false;
        }
        if (resources.contains(file)) {
            return true;
        }
        for (IResource resource : resources) {
            if (resource == null || resource.getType() == 1) continue;
            List<IResource> children = null;
            try {
                children = Arrays.asList(((IContainer)resource).members());
            }
            catch (CoreException coreException) {
                continue;
            }
            if (children == null || !PharPackageWizardPage.contains(children, file)) continue;
            return true;
        }
        return false;
    }

    public static List asResources(Object[] elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<Object> selectedResources = new ArrayList<Object>(elements.length);
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IModelElement) {
                selectedResources.add(((IModelElement)element).getResource());
            } else if (element instanceof IResource) {
                selectedResources.add(element);
            }
            ++i;
        }
        return selectedResources;
    }

    public static void setAccessibilityText(Control control, final String text) {
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = text;
            }
        });
    }

    public boolean isPageComplete() {
        boolean complete = this.validateDestinationGroup();
        complete = this.validateOptionsGroup() && complete;
        boolean bl = complete = this.validateStubGroup() && complete;
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    private boolean validateStubGroup() {
        return this.fGenerateManifestRadioButton.getSelection() || this.pharData.getStubLocation().toString().length() != 0;
    }

    protected boolean validateOptionsGroup() {
        return true;
    }

    protected Iterator getSelectedResourcesIterator() {
        return this.fInputGroup.getAllCheckedListItems();
    }

    protected void setupBasedOnInitialSelections() {
        for (Object selectedElement : this.fInitialSelection) {
            IModelElement je;
            if (selectedElement instanceof IResource && !((IResource)selectedElement).isAccessible() || selectedElement instanceof IModelElement && !((IModelElement)selectedElement).exists()) continue;
            if (selectedElement instanceof ISourceModule || selectedElement instanceof IFile) {
                this.fInputGroup.initialCheckListItem(selectedElement);
                continue;
            }
            if (selectedElement instanceof IFolder && (je = DLTKCore.create((IResource)((IResource)selectedElement))) != null && je.exists() && je.getScriptProject().isOnBuildpath((IResource)selectedElement)) {
                selectedElement = je;
            }
            try {
                this.fInputGroup.initialCheckTreeItem(selectedElement);
            }
            finally {
                this.fInitiallySelecting = false;
            }
        }
        TreeItem[] items = this.fInputGroup.getTree().getItems();
        int i = 0;
        while (i < items.length && !items[i].getChecked()) {
            ++i;
        }
        if (i < items.length) {
            this.fInputGroup.getTree().setSelection(new TreeItem[]{items[i]});
            this.fInputGroup.getTree().showSelection();
            this.fInputGroup.populateListViewer(items[i].getData());
        }
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        if (this.getControl() != null) {
            this.updatePageCompletion();
        }
    }

    Object[] getSelectedElementsWithoutContainedChildren() {
        HashSet elements = new HashSet();
        Iterator iterator = this.getSelectedResourcesIterator();
        while (iterator.hasNext()) {
            elements.add(iterator.next());
        }
        HashMap map = new HashMap();
        Iterator iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            Object e;
            Object resource = e = iterator2.next();
            if (e instanceof IModelElement) {
                try {
                    resource = ((IModelElement)e).getCorrespondingResource();
                }
                catch (ModelException modelException) {
                    continue;
                }
            }
            map.put(resource, e);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getKey() instanceof IResource) || !this.isDescendent(map, (IResource)entry.getKey())) continue;
            elements.remove(entry.getValue());
        }
        return elements.toArray();
    }

    protected boolean isDescendent(Map resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.containsKey(parent)) {
            return true;
        }
        return this.isDescendent(resources, (IResource)parent);
    }

    private Object[] getSelectedElements() {
        return this.getSelectedResources().toArray();
    }

    private class UntypedListener
    implements Listener {
        private UntypedListener() {
        }

        public void handleEvent(Event e) {
            if (PharPackageWizardPage.this.getControl() == null) {
                return;
            }
            PharPackageWizardPage.this.update();
        }
    }
}

