/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui;

import java.io.IOException;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.internal.core.util.MethodOverrideTester;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Bindings;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.corext.util.SuperTypeHierarchyCache;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.php.internal.ui.util.ImageImageDescriptor;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class OverrideIndicatorLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;

    public OverrideIndicatorLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public OverrideIndicatorLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : PHPUiPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return null;
        }
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new ScriptElementImageDescriptor((ImageDescriptor)baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    public int computeAdornmentFlags(Object element) {
        if (element instanceof IMethod) {
            IMethod method;
            block7: {
                method = (IMethod)element;
                if (method.getScriptProject().isOnBuildpath((IModelElement)method)) break block7;
                return 0;
            }
            try {
                int flags = method.getFlags();
                if (!(method.isConstructor() || Flags.isPrivate((int)flags) || Flags.isStatic((int)flags))) {
                    int res = this.getOverrideIndicators(method);
                    return res;
                }
            }
            catch (ModelException e) {
                if (!e.isDoesNotExist()) {
                    PHPUiPlugin.log(e);
                }
            }
            catch (IOException e) {
                PHPUiPlugin.log(e);
            }
        }
        return 0;
    }

    protected int getOverrideIndicators(IMethod method) throws ModelException, IOException {
        MethodOverrideTester methodOverrideTester;
        IMethod defining;
        int res;
        Program astRoot = SharedASTProvider.getAST(method.getSourceModule(), SharedASTProvider.WAIT_ACTIVE_ONLY, null);
        if (astRoot != null && (res = this.findInHierarchyWithAST(astRoot, method)) != -1) {
            return res;
        }
        IType type = method.getDeclaringType();
        if (type != null && (defining = (methodOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester(type)).findOverriddenMethod(method, true)) != null) {
            if (OverrideIndicatorLabelDecorator.isAbstract((IMember)defining)) {
                return 256;
            }
            return 128;
        }
        return 0;
    }

    private int findInHierarchyWithAST(Program astRoot, IMethod method) throws ModelException {
        IMethodBinding binding;
        SourceRange range = new SourceRange(method.getSourceRange().getOffset(), method.getSourceRange().getLength());
        ASTNode node = NodeFinder.perform((ASTNode)astRoot, (ISourceRange)range);
        if (node instanceof Identifier && node.getParent() instanceof MethodDeclaration && (binding = ((MethodDeclaration)node.getParent()).resolveMethodBinding()) != null) {
            IMethodBinding defining = Bindings.findOverriddenMethod((IMethodBinding)binding, (boolean)true);
            if (defining != null) {
                if (OverrideIndicatorLabelDecorator.isAbstract(defining)) {
                    return 256;
                }
                return 128;
            }
            return 0;
        }
        return -1;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if ((adornmentFlags & 0x100) != 0) {
            decoration.addOverlay(DLTKPluginImages.DESC_OVR_IMPLEMENTS);
        } else if ((adornmentFlags & 0x80) != 0) {
            decoration.addOverlay(DLTKPluginImages.DESC_OVR_OVERRIDES);
        }
    }

    private static boolean isAbstract(IMember member) throws ModelException {
        return Flags.isAbstract((int)member.getFlags());
    }

    private static boolean isAbstract(IMethodBinding member) {
        return OverrideIndicatorLabelDecorator.isAbstract(member.getModifiers());
    }

    private static boolean isAbstract(int mod) {
        return (mod & 1) != 0;
    }
}

