/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.organizeIncludes;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.util.collections.BucketMap;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.core.util.text.TextSequenceUtilities;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.RefactoringPlugin;
import org.eclipse.php.refactoring.core.organizeIncludes.CodeDataMatch;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class CodeDataSearchEngine {
    public static final int ELEMENT_CALLBACK = 256;
    public static final int ELEMENT_CLASS_CALLBACK = 512;
    public static final int ELEMENT_CLASS_FUNCTION_PARAMETER = 8;
    public static final int ELEMENT_CLASS_INSTANCE = 64;
    public static final int ELEMENT_CLASS_INTERFACE = 2;
    public static final int ELEMENT_CLASS_MEMBER = 32;
    public static final int ELEMENT_CLASS_METHOD_PARAMETER = 4;
    public static final int ELEMENT_CLASS_NEW = 16;
    public static final int ELEMENT_CLASS_SUPER = 1;
    public static final int ELEMENT_FUNCTION_CALL = 128;
    public static final int ELEMENT_FUNCTION_CALLBACK = 1024;
    public static final int ELEMENT_CONSTANT_READ = 2048;
    public static final String REGEX_ELEMENT_NAME = "[a-zA-Z_][\\w]*";
    public static final Pattern PATTERN_CLASS_INSTANCE = Pattern.compile(MessageFormat.format("instanceof\\s+(\\$?{0})", "[a-zA-Z_][\\w]*"));
    public static final Pattern PATTERN_CLASS_MEMBER = Pattern.compile(MessageFormat.format("(\\$?{0})\\s?::", "[a-zA-Z_][\\w]*"));
    public static final Pattern PATTERN_CONSTANT_READ = Pattern.compile(MessageFormat.format("(((new|function|instanceof|class|interface)\\s+|\\$)?{0})(?!\\s*\\()", "[a-zA-Z_][\\w]*"));
    public static final String REGEX_ELEMENT_CALLBACK_DOUBLE = MessageFormat.format("\"({0})\"", "[a-zA-Z_][\\w]*");
    public static final String REGEX_ELEMENT_CALLBACK_SINGLE = MessageFormat.format("''({0})''", "[a-zA-Z_][\\w]*");
    public static final Pattern PATTERN_ELEMENT_CALLBACK_DOUBLE = Pattern.compile(REGEX_ELEMENT_CALLBACK_DOUBLE);
    public static final Pattern PATTERN_ELEMENT_CALLBACK_SINGLE = Pattern.compile(REGEX_ELEMENT_CALLBACK_SINGLE);
    public static final Pattern PATTERN_FUNCTION_CALL = Pattern.compile(MessageFormat.format("(((new|function)\\s+|\\$)?{0})\\s*\\(", "[a-zA-Z_][\\w]*"));
    private static final Pattern PATTERN_CLASS_NEW = Pattern.compile(MessageFormat.format("new\\s+(\\$?{0})", "[a-zA-Z_][\\w]*"));

    private static void collectCallbacks(DOMModelForPHP model, BucketMap<String, CodeDataMatch> searchResults, IProgressMonitor monitor) {
        monitor.beginTask(PhpRefactoringCoreMessages.getString("CodeDataSearchEngine.5"), 4);
        if (monitor.isCanceled()) {
            return;
        }
        Set<String> set = CodeDataSearchEngine.searchElementNames(model, PATTERN_ELEMENT_CALLBACK_DOUBLE, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        CodeDataSearchEngine.fillSearchResults(searchResults, set, 256, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        set = CodeDataSearchEngine.searchElementNames(model, PATTERN_ELEMENT_CALLBACK_SINGLE, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        CodeDataSearchEngine.fillSearchResults(searchResults, set, 256, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private static void collectClasses(DOMModelForPHP model, BucketMap<String, CodeDataMatch> searchResults, IProgressMonitor monitor) {
        monitor.beginTask(PhpRefactoringCoreMessages.getString("CodeDataSearchEngine.6"), 2);
        if (monitor.isCanceled()) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        CodeDataSearchEngine.collectClassesFromText(model, searchResults, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private static void collectClassesFromText(DOMModelForPHP model, BucketMap<String, CodeDataMatch> searchResults, IProgressMonitor monitor) {
        monitor.beginTask(PhpRefactoringCoreMessages.getString("CodeDataSearchEngine.9"), 6);
        if (monitor.isCanceled()) {
            return;
        }
        Set<String> set = CodeDataSearchEngine.searchElementNames(model, PATTERN_CLASS_NEW, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        CodeDataSearchEngine.fillSearchResults(searchResults, set, 16, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        set = CodeDataSearchEngine.searchElementNames(model, PATTERN_CLASS_MEMBER, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        CodeDataSearchEngine.fillSearchResults(searchResults, set, 32, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        set = CodeDataSearchEngine.searchElementNames(model, PATTERN_CLASS_INSTANCE, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        CodeDataSearchEngine.fillSearchResults(searchResults, set, 64, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private static void collectConstants(DOMModelForPHP model, BucketMap<String, CodeDataMatch> searchResults, IProgressMonitor monitor) {
        monitor.beginTask(PhpRefactoringCoreMessages.getString("CodeDataSearchEngine.10"), 2);
        if (monitor.isCanceled()) {
            return;
        }
        Set<String> set = CodeDataSearchEngine.searchElementNames(model, PATTERN_CONSTANT_READ, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        CodeDataSearchEngine.fillSearchResults(searchResults, set, 2048, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private static void collectFunctions(DOMModelForPHP model, BucketMap<String, CodeDataMatch> searchResults, IProgressMonitor monitor) {
        monitor.beginTask(PhpRefactoringCoreMessages.getString("CodeDataSearchEngine.11"), 2);
        if (monitor.isCanceled()) {
            return;
        }
        Set<String> set = CodeDataSearchEngine.searchElementNames(model, PATTERN_FUNCTION_CALL, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        CodeDataSearchEngine.fillSearchResults(searchResults, set, 128, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private static void collectInterfaces(DOMModelForPHP model, BucketMap<String, CodeDataMatch> searchResults, IProgressMonitor monitor) {
        monitor.beginTask(PhpRefactoringCoreMessages.getString("CodeDataSearchEngine.12"), 2);
        if (monitor.isCanceled()) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        CodeDataSearchEngine.collectInterfacesFromText(model, searchResults, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private static void collectInterfacesFromText(DOMModelForPHP model, BucketMap<String, CodeDataMatch> searchResults, IProgressMonitor monitor) {
        monitor.beginTask(PhpRefactoringCoreMessages.getString("CodeDataSearchEngine.14"), 4);
        if (monitor.isCanceled()) {
            return;
        }
        Set<String> set = CodeDataSearchEngine.searchElementNames(model, PATTERN_CLASS_MEMBER, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        CodeDataSearchEngine.fillSearchResults(searchResults, set, 32, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        set = CodeDataSearchEngine.searchElementNames(model, PATTERN_CLASS_INSTANCE, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            return;
        }
        CodeDataSearchEngine.fillSearchResults(searchResults, set, 64, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private static void fillSearchResults(BucketMap<String, CodeDataMatch> searchResults, Collection<String> collection, int elementType, IProgressMonitor monitor) {
        CodeDataSearchEngine.fillSearchResults(searchResults, collection, elementType, false, monitor);
    }

    private static void fillSearchResults(BucketMap<String, CodeDataMatch> searchResults, Collection<String> collection, int elementType, boolean caseSensitive, IProgressMonitor monitor) {
        monitor.beginTask(PhpRefactoringCoreMessages.getString("CodeDataSearchEngine.15"), collection.size());
        for (String elementName : collection) {
            searchResults.add((Object)(caseSensitive ? elementName : elementName.toLowerCase()), (Object)new CodeDataMatch(elementName, elementType));
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
        }
    }

    private static String getPartitionType(IStructuredDocument document, int offset) {
        IStructuredDocumentRegion region = document.getRegionAtCharacterOffset(offset);
        TextSequence statement = PHPTextSequenceUtilities.getStatement((int)offset, (IStructuredDocumentRegion)region, (boolean)false);
        if (statement == null) {
            return null;
        }
        String partitionType = TextSequenceUtilities.getTypeByAbsoluteOffset((TextSequence)statement, (int)offset);
        return partitionType;
    }

    private static boolean isCode(IStructuredDocument document, int offset) {
        String partitionType = CodeDataSearchEngine.getPartitionType(document, offset);
        return PHPPartitionTypes.isPHPRegularState((String)partitionType);
    }

    private static Set<String> searchElementNames(DOMModelForPHP model, Pattern pattern, int elementPatternPosition, IProgressMonitor monitor) {
        IStructuredDocument document = model.getStructuredDocument();
        String documentContents = null;
        try {
            documentContents = document.get(0, document.getLength());
        }
        catch (BadLocationException e) {
            RefactoringPlugin.logException((Exception)((Object)e));
        }
        HashSet<String> elements = new HashSet<String>();
        if (documentContents == null) {
            return elements;
        }
        monitor.beginTask(PhpRefactoringCoreMessages.getString("CodeDataSearchEngine.16"), 2);
        Matcher matcher = pattern.matcher(documentContents);
        while (matcher.find()) {
            int end = matcher.end();
            if (!CodeDataSearchEngine.isCode(document, end)) continue;
            String elementName = matcher.group(elementPatternPosition);
            elements.add(elementName);
        }
        return elements;
    }

    public static boolean elementIsOptional(int elementType) {
        return false;
    }
}

