/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename.logic;

import org.eclipse.core.resources.IFile;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.logic.AbstractRename;

public class RenameGlobalConstant
extends AbstractRename {
    private static final String RENAME_CONSTANT = PhpRefactoringCoreMessages.getString("RenameDefinedName.0");
    private boolean isCaseSenstive = true;

    public RenameGlobalConstant(IFile file, String oldName, String newName, boolean searchTextual) {
        super(file, oldName, newName, searchTextual);
    }

    @Override
    public boolean visit(Scalar scalar) {
        String stringValue = scalar.getStringValue();
        if (stringValue.length() > 2 && (stringValue.charAt(0) == '\'' || stringValue.charAt(0) == '\"')) {
            stringValue = stringValue.substring(1, stringValue.length() - 1);
        }
        if (this.isCaseSenstive) {
            if (scalar.getScalarType() == 2 && stringValue != null && stringValue.equals(this.oldName)) {
                this.addChange(scalar);
            }
        } else if (scalar.getScalarType() == 2 && stringValue != null && stringValue.equalsIgnoreCase(this.oldName)) {
            this.addChange(scalar);
        }
        return false;
    }

    @Override
    public String getRenameDescription() {
        return RENAME_CONSTANT;
    }
}

