/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.model_structure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class ModelStructureTests {
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IProject project;
    protected IFile testFile;
    protected PHPVersion version;

    static {
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/model_structure/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/model_structure/php53"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/model_structure/php53"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/model_structure/php53"});
    }

    public ModelStructureTests(PHPVersion version, String[] fileNames) {
        this.version = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("ModelStructureTests");
        if (this.project.exists()) {
            return;
        }
        this.project.create(null);
        this.project.open(null);
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        this.project.setDescription(desc, null);
        PHPCoreTests.setProjectPhpVersion(this.project, this.version);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        this.project.close(null);
        this.project.delete(true, true, null);
        this.project = null;
    }

    @Test
    public void structure(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(fileName);
        ISourceModule sourceModule = this.createFile(pdttFile.getFile());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(stream);
        sourceModule.accept((IModelElementVisitor)new PrintVisitor(printStream));
        printStream.close();
        PDTTUtils.assertContents(pdttFile.getExpected(), stream.toString());
    }

    @After
    public void after() throws Exception {
        if (this.testFile != null) {
            this.testFile.delete(true, null);
            this.testFile = null;
        }
    }

    protected ISourceModule createFile(String data) throws Exception {
        this.testFile = this.project.getFile("test.php");
        this.testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        this.project.refreshLocal(2, null);
        this.project.build(6, null);
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        return DLTKCore.createSourceModuleFrom((IFile)this.testFile);
    }

    class PrintVisitor
    implements IModelElementVisitor {
        private PrintStream stream;

        public PrintVisitor(PrintStream stream) {
            this.stream = stream;
        }

        public boolean visit(IModelElement element) {
            try {
                String tabs = this.getTabs(element);
                this.stream.print(tabs);
                if (element.getElementType() == 7) {
                    IType type = (IType)element;
                    int flags = type.getFlags();
                    if ((flags & 8) != 0) {
                        this.stream.print("INTERFACE: ");
                    } else if ((flags & 0x800) != 0) {
                        this.stream.print("NAMESPACE: ");
                    } else {
                        this.stream.print("CLASS: ");
                    }
                } else if (element.getElementType() == 9) {
                    IMethod method = (IMethod)element;
                    IType declaringType = method.getDeclaringType();
                    if (declaringType == null || (declaringType.getFlags() & 0x800) != 0) {
                        this.stream.print("FUNCTION: ");
                    } else {
                        this.stream.print("METHOD: ");
                    }
                } else if (element.getElementType() == 8) {
                    this.stream.print("VARIABLE: ");
                } else if (element.getElementType() == 5) {
                    this.stream.print("FILE: ");
                }
                this.stream.println(element.getElementName());
            }
            catch (ModelException modelException) {}
            return true;
        }

        protected String getTabs(IModelElement e) {
            StringBuilder buf = new StringBuilder();
            while (e.getElementType() != 5) {
                buf.append('\t');
                e = e.getParent();
            }
            return buf.toString();
        }
    }
}

