/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class TraitPrecedence
extends Expression {
    private FullyQualifiedTraitMethodReference methodReference;
    private ASTNode.NodeList<NamespaceName> trList = new ASTNode.NodeList(this, TRAIT_REFERENCE_LIST);
    public static final ChildPropertyDescriptor METHOD_REFERENCE = new ChildPropertyDescriptor(TraitPrecedence.class, "methodReference", FullyQualifiedTraitMethodReference.class, true, true);
    public static final ChildListPropertyDescriptor TRAIT_REFERENCE_LIST = new ChildListPropertyDescriptor(TraitPrecedence.class, "trList", NamespaceName.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(1);
        propertyList.add(METHOD_REFERENCE);
        propertyList.add(TRAIT_REFERENCE_LIST);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public TraitPrecedence(int start, int end, AST ast, FullyQualifiedTraitMethodReference methodReference, List<NamespaceName> trList) {
        super(start, end, ast);
        this.setMethodReference(methodReference);
        if (trList != null) {
            this.trList.addAll(trList);
        }
    }

    public TraitPrecedence(AST ast) {
        super(ast);
    }

    public FullyQualifiedTraitMethodReference getMethodReference() {
        return this.methodReference;
    }

    public void setMethodReference(FullyQualifiedTraitMethodReference methodReference) {
        if (methodReference == null) {
            throw new IllegalArgumentException();
        }
        FullyQualifiedTraitMethodReference oldChild = this.methodReference;
        this.preReplaceChild(oldChild, methodReference, METHOD_REFERENCE);
        this.methodReference = methodReference;
        this.postReplaceChild(oldChild, methodReference, METHOD_REFERENCE);
    }

    public List<NamespaceName> getTrList() {
        return this.trList;
    }

    public void setTrList(List<NamespaceName> trList) {
        this.trList.clear();
        if (trList != null) {
            this.trList.addAll(trList);
        }
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.methodReference.accept(visitor);
        if (this.trList != null) {
            for (NamespaceName name : this.trList) {
                name.accept(visitor);
            }
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.methodReference.traverseTopDown(visitor);
        if (this.trList != null) {
            for (NamespaceName name : this.trList) {
                name.traverseTopDown(visitor);
            }
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.methodReference.traverseBottomUp(visitor);
        if (this.trList != null) {
            for (NamespaceName name : this.trList) {
                name.traverseBottomUp(visitor);
            }
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<TraitPrecedence");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.methodReference.toString(buffer, "\t" + tab);
        buffer.append("\n");
        if (this.trList != null) {
            buffer.append("\t").append(tab).append("<TraitReferenceList>\n");
            for (NamespaceName name : this.trList) {
                name.toString(buffer, "\t\t" + tab);
                buffer.append("\n");
            }
            buffer.append("\t").append(tab).append("</TraitReferenceList>\n");
        }
        buffer.append(tab).append("</TraitPrecedence>");
    }

    @Override
    public int getType() {
        return 31;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        FullyQualifiedTraitMethodReference methodReference = ASTNode.copySubtree(target, this.getMethodReference());
        List trList = ASTNode.copySubtrees(target, this.getTrList());
        TraitPrecedence result = new TraitPrecedence(this.getStart(), this.getEnd(), target, methodReference, trList);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == METHOD_REFERENCE) {
            if (get) {
                return this.getMethodReference();
            }
            this.setMethodReference((FullyQualifiedTraitMethodReference)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == TRAIT_REFERENCE_LIST) {
            return this.getTrList();
        }
        return super.internalGetChildListProperty(property);
    }
}

