/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public abstract class TraitStatement
extends Statement {
    private Expression exp;
    public static final ChildPropertyDescriptor EXP = new ChildPropertyDescriptor(TraitStatement.class, "exp", Expression.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(1);
        propertyList.add(EXP);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public TraitStatement(int start, int end, AST ast, Expression exp) {
        super(start, end, ast);
        this.setExp(exp);
    }

    public TraitStatement(AST ast) {
        super(ast);
    }

    public Expression getExp() {
        return this.exp;
    }

    public void setExp(Expression exp) {
        if (exp == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.exp;
        this.preReplaceChild(oldChild, exp, EXP);
        this.exp = exp;
        this.postReplaceChild(oldChild, exp, EXP);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.exp.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.exp.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.exp.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<TraitStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.exp.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</TraitStatement>");
    }

    @Override
    public int getType() {
        return 31;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXP) {
            if (get) {
                return this.getExp();
            }
            this.setExp((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }
}

