/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class YieldExpression
extends Expression {
    private Expression key;
    private Expression expression;
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(YieldExpression.class, "expression", Expression.class, false, true);
    public static final ChildPropertyDescriptor KEY_PROPERTY = new ChildPropertyDescriptor(YieldExpression.class, "key", Expression.class, false, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(2);
        propertyList.add(EXPRESSION_PROPERTY);
        propertyList.add(KEY_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public YieldExpression(int start, int end, AST ast) {
        this(start, end, ast, null);
    }

    public YieldExpression(AST ast) {
        super(ast);
    }

    public YieldExpression(int start, int end, AST ast, Expression expr) {
        super(start, end, ast);
        if (expr != null) {
            this.setExpression(expr);
        }
    }

    public YieldExpression(int start, int end, AST ast, Expression key, Expression expr) {
        super(start, end, ast);
        if (key != null) {
            this.setKey(key);
        }
        if (expr != null) {
            this.setExpression(expr);
        }
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        if (this.key != null) {
            this.key.accept(visitor);
        }
        if (this.expression != null) {
            this.expression.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.key != null) {
            this.key.traverseTopDown(visitor);
        }
        if (this.expression != null) {
            this.expression.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        if (this.key != null) {
            this.key.traverseBottomUp(visitor);
        }
        if (this.expression != null) {
            this.expression.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<YieldExpression");
        this.appendInterval(buffer);
        buffer.append(">\n");
        if (this.key != null) {
            this.key.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        if (this.expression != null) {
            this.expression.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</YieldExpression>");
    }

    @Override
    public int getType() {
        return 75;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Expression getExpr() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    public void setKey(Expression key) {
        Expression oldChild = this.key;
        this.preReplaceChild(oldChild, key, KEY_PROPERTY);
        this.key = key;
        this.postReplaceChild(oldChild, key, KEY_PROPERTY);
    }

    public Expression getKey() {
        return this.key;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        if (property == KEY_PROPERTY) {
            if (get) {
                return this.getKey();
            }
            this.setKey((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression key = ASTNode.copySubtree(target, this.getKey());
        Expression expr = ASTNode.copySubtree(target, this.getExpression());
        YieldExpression result = new YieldExpression(this.getStart(), this.getEnd(), target, key, expr);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

