/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.typeinference.DeclarationSearcher;
import org.eclipse.php.internal.core.typeinference.DefineMethodUtils;
import org.eclipse.php.internal.core.typeinference.FakeField;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.TraitUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class PHPModelUtils {
    public static final String ENCLOSING_TYPE_SEPARATOR = new String(new char[]{'\\'});
    private static final IType[] EMPTY_TYPES = new IType[0];

    public static String extractElementName(String element) {
        int i;
        if (element != null && (i = element.lastIndexOf(92)) != -1) {
            element = element.substring(i + 1).trim();
        }
        return element;
    }

    public static String extractNameSapceName(String element) {
        int i;
        String nameSpaceName = null;
        if (element != null && (i = element.lastIndexOf(92)) != -1) {
            nameSpaceName = element.substring(0, i).trim();
        }
        return nameSpaceName;
    }

    public static String getRealName(String elementName, ISourceModule sourceModule, int offset, String defaultClassName) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        UsePart usePart = ASTUtils.findUseStatementByAlias(moduleDeclaration, elementName, offset);
        if (usePart != null) {
            elementName = usePart.getNamespace().getFullyQualifiedName();
            int nsIndex = elementName.lastIndexOf(92);
            defaultClassName = nsIndex != -1 ? elementName.substring(nsIndex + 1) : elementName;
        }
        return defaultClassName;
    }

    public static String extractNamespaceName(String elementName, ISourceModule sourceModule, int offset) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        UsePart usePart = ASTUtils.findUseStatementByAlias(moduleDeclaration, elementName, offset);
        if (usePart != null && (elementName = usePart.getNamespace().getFullyQualifiedName()) != null && elementName.length() > 0 && elementName.charAt(0) != '\\') {
            elementName = String.valueOf('\\') + elementName;
        }
        boolean isGlobal = false;
        int nsIndex = -1;
        if (elementName != null) {
            nsIndex = elementName.lastIndexOf(92);
            if (elementName.length() > 0 && elementName.charAt(0) == '\\') {
                isGlobal = true;
            }
        }
        if (nsIndex != -1) {
            String namespace = elementName.substring(0, nsIndex);
            if (isGlobal && namespace.length() > 0) {
                namespace = namespace.substring(1);
            }
            if (!isGlobal) {
                IType currentNamespace;
                if ("namespace".equalsIgnoreCase(namespace)) {
                    IType currentNamespace2 = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                    return currentNamespace2.getElementName();
                }
                if (namespace.indexOf(92) == -1) {
                    usePart = ASTUtils.findUseStatementByAlias(moduleDeclaration, namespace, offset);
                    if (usePart != null) {
                        return usePart.getNamespace().getFullyQualifiedName();
                    }
                } else {
                    nsIndex = namespace.indexOf(92);
                    String alias = namespace.substring(0, nsIndex);
                    usePart = ASTUtils.findUseStatementByAlias(moduleDeclaration, alias, offset);
                    if (usePart != null) {
                        return String.valueOf(usePart.getNamespace().getFullyQualifiedName()) + '\\' + namespace.substring(nsIndex + 1);
                    }
                }
                if ((currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset)) != null) {
                    return currentNamespace.getElementName() + '\\' + namespace;
                }
            }
            return namespace;
        }
        return null;
    }

    public static <T extends IModelElement> Collection<T> fileNetworkFilter(ISourceModule sourceModule, Collection<T> elements, IModelAccessCache cache, IProgressMonitor monitor) {
        if (elements != null && elements.size() > 0) {
            LinkedList<T> filteredElements = new LinkedList<T>();
            for (IModelElement element : elements) {
                if (!sourceModule.equals(element.getOpenable())) continue;
                filteredElements.add(element);
            }
            if (filteredElements.size() == 0) {
                ReferenceTree referenceTree = cache != null ? cache.getFileHierarchy(sourceModule, monitor) : FileNetworkUtility.buildReferencedFilesTree(sourceModule, monitor);
                for (IModelElement element : elements) {
                    if (!LanguageModelInitializer.isLanguageModelElement(element) && !referenceTree.find(((ModelElement)element).getSourceModule())) continue;
                    filteredElements.add(element);
                }
            }
            if (filteredElements.size() > 0) {
                elements = filteredElements;
            }
        }
        return elements;
    }

    public static <T extends IModelElement> Collection<T> fileNetworkFilterTypes(ISourceModule sourceModule, Collection<T> elements, IModelAccessCache cache, boolean isNs, IProgressMonitor monitor) {
        if (elements != null && elements.size() > 0) {
            LinkedList<T> filteredElements = new LinkedList<T>();
            for (IModelElement element : elements) {
                try {
                    if (!sourceModule.equals(element.getOpenable()) || (!isNs || !PHPFlags.isNamespace(((IType)element).getFlags())) && (isNs || PHPFlags.isNamespace(((IType)element).getFlags()))) continue;
                    filteredElements.add(element);
                }
                catch (ModelException modelException) {}
            }
            if (filteredElements.size() == 0) {
                ReferenceTree referenceTree = cache != null ? cache.getFileHierarchy(sourceModule, monitor) : FileNetworkUtility.buildReferencedFilesTree(sourceModule, monitor);
                for (IModelElement element : elements) {
                    if (!LanguageModelInitializer.isLanguageModelElement(element) && !referenceTree.find(((ModelElement)element).getSourceModule())) continue;
                    try {
                        if ((!isNs || !PHPFlags.isNamespace(((IType)element).getFlags())) && (isNs || PHPFlags.isNamespace(((IType)element).getFlags()))) continue;
                        filteredElements.add(element);
                    }
                    catch (ModelException modelException) {}
                }
            }
            if (filteredElements.size() > 0) {
                elements = filteredElements;
            }
        }
        return elements;
    }

    private static <T extends IModelElement> boolean canUseFileNetworkFilter(Collection<T> elements) {
        int elementType = 0;
        String elementName = null;
        for (IModelElement element : elements) {
            if (element == null) continue;
            if (elementName == null) {
                elementType = element.getElementType();
                elementName = element.getElementName();
                continue;
            }
            if (elementName.equalsIgnoreCase(element.getElementName()) && elementType == element.getElementType()) continue;
            return false;
        }
        return true;
    }

    public static <T extends IModelElement> Collection<T> filterElements(ISourceModule sourceModule, Collection<T> elements, IModelAccessCache cache, IProgressMonitor monitor) {
        if (elements == null) {
            return null;
        }
        if (PHPModelUtils.canUseFileNetworkFilter(elements)) {
            return PHPModelUtils.fileNetworkFilter(sourceModule, elements, cache, monitor);
        }
        return elements;
    }

    public static IMethod getCurrentMethod(ISourceModule sourceModule, int offset) {
        try {
            IModelElement currentMethod = sourceModule.getElementAt(offset);
            while (currentMethod != null) {
                if (currentMethod instanceof IMethod) {
                    return (IMethod)currentMethod;
                }
                if (currentMethod instanceof IField) {
                    currentMethod = currentMethod.getParent();
                    continue;
                }
                break;
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentNamespace(IModelElement element) {
        try {
            IModelElement currentNs = element;
            while (currentNs != null) {
                if (currentNs instanceof IType && PHPFlags.isNamespace(((IType)currentNs).getFlags())) {
                    return (IType)currentNs;
                }
                currentNs = currentNs.getParent();
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentNamespace(ISourceModule sourceModule, int offset) {
        try {
            IModelElement currentNs = sourceModule.getElementAt(offset);
            while (currentNs instanceof IField) {
                currentNs = sourceModule.getElementAt(((IField)currentNs).getSourceRange().getOffset() - 1);
            }
            while (currentNs != null) {
                if (currentNs instanceof IType && PHPFlags.isNamespace(((IType)currentNs).getFlags())) {
                    return (IType)currentNs;
                }
                currentNs = currentNs.getParent();
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentNamespaceIfAny(ISourceModule sourceModule, int offset) {
        IType result = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
        if (result == null) {
            try {
                IModelElement[] elements;
                IModelElement[] iModelElementArray = elements = sourceModule.getChildren();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement modelElement = iModelElementArray[n2];
                    if (modelElement instanceof IType && PHPFlags.isNamespace(((IType)modelElement).getFlags())) {
                        result = (IType)modelElement;
                    }
                    if (modelElement instanceof SourceRefElement) {
                        SourceRefElement child = (SourceRefElement)modelElement;
                        ISourceRange range = child.getSourceRange();
                        int start = range.getOffset();
                        int end = start + range.getLength();
                        if (start <= offset && offset <= end) {
                            return result;
                        }
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
        }
        return result;
    }

    public static IType getPossibleCurrentNamespace(ISourceModule sourceModule, int offset) {
        try {
            IType[] types;
            IType result = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
            if (result == null && (types = sourceModule.getTypes()) != null && types.length > 0 && PHPFlags.isNamespace(types[0].getFlags())) {
                int i = 0;
                while (i < types.length) {
                    if (types[i].getSourceRange().getOffset() > offset || !PHPFlags.isNamespace(types[i].getFlags())) {
                        return result;
                    }
                    result = types[i];
                    ++i;
                }
            }
            return result;
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
            return null;
        }
    }

    public static IType getCurrentType(IModelElement element) {
        try {
            while (element != null) {
                if (element instanceof IType) {
                    if (!PHPFlags.isNamespace(((IType)element).getFlags())) {
                        return (IType)element;
                    }
                    break;
                }
                element = element.getParent();
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentType(ISourceModule sourceModule, int offset) {
        try {
            return PHPModelUtils.getCurrentType(sourceModule.getElementAt(offset));
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
            return null;
        }
    }

    public static PHPDocBlock getDocBlock(IField field) {
        block5: {
            if (field == null) {
                return null;
            }
            try {
                ISourceModule sourceModule = field.getSourceModule();
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                ASTNode fieldDeclaration = PHPModelUtils.getNodeByField(moduleDeclaration, field);
                if (fieldDeclaration instanceof IPHPDocAwareDeclaration) {
                    return ((IPHPDocAwareDeclaration)fieldDeclaration).getPHPDoc();
                }
                if (fieldDeclaration == null) {
                    return DefineMethodUtils.getDefinePHPDocBlockByField(moduleDeclaration, field);
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block5;
                Logger.logException(e);
            }
        }
        return null;
    }

    public static PHPDocBlock getDocBlock(IMethod method) {
        block4: {
            if (method == null) {
                return null;
            }
            try {
                ISourceModule sourceModule = method.getSourceModule();
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                MethodDeclaration methodDeclaration = PHPModelUtils.getNodeByMethod(moduleDeclaration, method);
                if (methodDeclaration instanceof IPHPDocAwareDeclaration) {
                    return ((IPHPDocAwareDeclaration)methodDeclaration).getPHPDoc();
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                Logger.logException(e);
            }
        }
        return null;
    }

    public static PHPDocBlock getDocBlock(IType type) {
        block4: {
            if (type == null) {
                return null;
            }
            try {
                ISourceModule sourceModule = type.getSourceModule();
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                TypeDeclaration typeDeclaration = PHPModelUtils.getNodeByClass(moduleDeclaration, type);
                if (typeDeclaration instanceof IPHPDocAwareDeclaration) {
                    return ((IPHPDocAwareDeclaration)typeDeclaration).getPHPDoc();
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                Logger.logException(e);
            }
        }
        return null;
    }

    public static IField[] getFields(String fieldName, ISourceModule sourceModule, int offset, IProgressMonitor monitor) throws ModelException {
        return PHPModelUtils.getFields(fieldName, sourceModule, offset, null, monitor);
    }

    public static IField[] getFields(String fieldName, ISourceModule sourceModule, int offset, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        if (fieldName == null || fieldName.length() == 0) {
            return PhpModelAccess.NULL_FIELDS;
        }
        if (!fieldName.startsWith("$")) {
            String namespace = PHPModelUtils.extractNamespaceName(fieldName, sourceModule, offset);
            fieldName = PHPModelUtils.extractElementName(fieldName);
            if (namespace != null) {
                if (namespace.length() > 0) {
                    IField[] fields = PHPModelUtils.getNamespaceField(namespace, fieldName, true, sourceModule, cache, monitor);
                    if (fields.length > 0) {
                        return fields;
                    }
                    return PhpModelAccess.NULL_FIELDS;
                }
            } else {
                IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                if (currentNamespace != null) {
                    namespace = currentNamespace.getElementName();
                    IField[] fields = PHPModelUtils.getNamespaceField(namespace, fieldName, true, sourceModule, cache, monitor);
                    if (fields.length > 0) {
                        return fields;
                    }
                    IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
                    fields = PhpModelAccess.getDefault().findFields(fieldName, ISearchEngine.MatchRule.EXACT, 8194, 0, scope, null);
                    Collection<IField> filteredElements = PHPModelUtils.filterElements(sourceModule, Arrays.asList(fields), cache, monitor);
                    return filteredElements.toArray(new IField[filteredElements.size()]);
                }
            }
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        IField[] fields = PhpModelAccess.getDefault().findFields(fieldName, ISearchEngine.MatchRule.EXACT, 8192, 0, scope, null);
        Collection<IField> filteredElements = null;
        if (fields != null) {
            filteredElements = PHPModelUtils.filterElements(sourceModule, Arrays.asList(fields), cache, monitor);
            return filteredElements.toArray(new IField[filteredElements.size()]);
        }
        return PhpModelAccess.NULL_FIELDS;
    }

    public static IMethod[] getFunctions(String functionName, ISourceModule sourceModule, int offset, IProgressMonitor monitor) throws ModelException {
        return PHPModelUtils.getFunctions(functionName, sourceModule, offset, null, monitor);
    }

    public static IMethod[] getFunctions(String functionName, ISourceModule sourceModule, int offset, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        if (functionName == null || functionName.length() == 0) {
            return PhpModelAccess.NULL_METHODS;
        }
        String namespace = PHPModelUtils.extractNamespaceName(functionName, sourceModule, offset);
        functionName = PHPModelUtils.extractElementName(functionName);
        if (namespace != null) {
            if (namespace.length() > 0) {
                IMethod[] functions = PHPModelUtils.getNamespaceFunction(namespace, functionName, true, sourceModule, cache, monitor);
                if (functions.length > 0) {
                    return functions;
                }
                return PhpModelAccess.NULL_METHODS;
            }
        } else {
            IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
            if (currentNamespace != null) {
                namespace = currentNamespace.getElementName();
                IMethod[] functions = PHPModelUtils.getNamespaceFunction(namespace, functionName, true, sourceModule, cache, monitor);
                if (functions.length > 0) {
                    return functions;
                }
                return PHPModelUtils.getGlobalFunctions(sourceModule, functionName, cache, monitor);
            }
        }
        return PHPModelUtils.getGlobalFunctions(sourceModule, functionName, cache, monitor);
    }

    private static IMethod[] getGlobalFunctions(ISourceModule sourceModule, String functionName, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        if (cache != null) {
            Collection<IMethod> functions = cache.getGlobalFunctions(sourceModule, functionName, monitor);
            if (functions == null) {
                return PhpModelAccess.NULL_METHODS;
            }
            functions = PHPModelUtils.filterTrueGlobal(functions);
            return functions.toArray(new IMethod[functions.size()]);
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        IMethod[] functions = PhpModelAccess.getDefault().findMethods(functionName, ISearchEngine.MatchRule.EXACT, 8192, 0, scope, null);
        Collection<IMethod> filteredElements = PHPModelUtils.filterElements(sourceModule, PHPModelUtils.filterTrueGlobal(Arrays.asList(functions)), null, monitor);
        return filteredElements.toArray(new IMethod[filteredElements.size()]);
    }

    private static Collection<IMethod> filterTrueGlobal(Collection<IMethod> functions) {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        for (IMethod method : functions) {
            if (method.getParent().getElementType() == 7) continue;
            result.add(method);
        }
        return result;
    }

    public static IModelElement[] getMethodFields(final IMethod method, final String prefix, final boolean exactName, IProgressMonitor monitor) {
        final LinkedList<IField> elements = new LinkedList<IField>();
        final HashSet<String> processedVars = new HashSet<String>();
        try {
            PHPModelUtils.getMethodFields(method, prefix, exactName, elements, processedVars);
            ModuleDeclaration rootNode = SourceParserUtil.getModuleDeclaration((ISourceModule)method.getSourceModule());
            MethodDeclaration methodDeclaration = PHPModelUtils.getNodeByMethod(rootNode, method);
            if (methodDeclaration != null) {
                methodDeclaration.traverse(new ASTVisitor(){

                    public boolean visit(Statement s) throws Exception {
                        if (s instanceof GlobalStatement) {
                            GlobalStatement globalStatement = (GlobalStatement)s;
                            for (Expression expression : globalStatement.getVariables()) {
                                VariableReference varReference;
                                String varName;
                                if (!(expression instanceof VariableReference) || processedVars.contains(varName = (varReference = (VariableReference)expression).getName()) || (!exactName || !varName.equalsIgnoreCase(prefix)) && (exactName || !varName.toLowerCase().startsWith(prefix.toLowerCase()))) continue;
                                elements.add(new FakeField((ModelElement)method, varName, expression.sourceStart(), expression.sourceEnd() - expression.sourceStart()));
                                processedVars.add(varName);
                            }
                        }
                        return super.visit(s);
                    }
                });
            }
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }

    public static void getMethodFields(IMethod method, String prefix, boolean exactName, List<IField> elements, Set<String> processedVars) throws ModelException {
        IModelElement[] children;
        IModelElement[] iModelElementArray = children = method.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement child = iModelElementArray[n2];
            if (child.getElementType() == 8) {
                IField field;
                String elementName = child.getElementName();
                if ((exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) && !PHPModelUtils.isSameFileExisiting(elements, field = (IField)child)) {
                    elements.add((IField)child);
                    processedVars.add(elementName);
                }
            }
            ++n2;
        }
        if (PHPModelUtils.isNestedAnonymousMethod(method)) {
            PHPModelUtils.getMethodFields((IMethod)method.getParent().getParent(), prefix, exactName, elements, processedVars);
        }
    }

    public static boolean isNestedAnonymousMethod(IMethod method) {
        return "__anonymous".equals(method.getElementName()) && method.getParent() instanceof IField && method.getParent().getParent() instanceof IMethod;
    }

    private static boolean isSameFileExisiting(List<IField> elements, IField field) {
        for (IField current : elements) {
            if (!PHPModelUtils.isSameField(current, field)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameField(IField current, IField field) {
        if (!(field instanceof SourceField)) {
            return false;
        }
        if (current == field) {
            return true;
        }
        return current.getElementName().equals(field.getElementName()) && current.getParent() != null && current.getParent().equals(field.getParent());
    }

    public static IField[] getFileFields(ISourceModule sourceModule, String prefix, boolean exactName, IProgressMonitor monitor) {
        LinkedList<IField> elements = new LinkedList<IField>();
        try {
            IField[] sourceModuleFields;
            IField[] iFieldArray = sourceModuleFields = sourceModule.getFields();
            int n = sourceModuleFields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                String elementName = field.getElementName();
                if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                    elements.add(field);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
        return elements.toArray(new IField[elements.size()]);
    }

    public static IField[] getNamespaceField(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IProgressMonitor monitor) throws ModelException {
        return PHPModelUtils.getNamespaceField(namespace, prefix, exactName, sourceModule, null, monitor);
    }

    public static IField[] getNamespaceField(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        IType[] namespaces = PHPModelUtils.getNamespaces(sourceModule, namespace, cache, monitor);
        LinkedList<IField> result = new LinkedList<IField>();
        IType[] iTypeArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            result.addAll(Arrays.asList(PHPModelUtils.getTypeField(ns, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IField[result.size()]);
    }

    public static IMethod[] getNamespaceFunction(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IProgressMonitor monitor) throws ModelException {
        return PHPModelUtils.getNamespaceFunction(namespace, prefix, exactName, sourceModule, null, monitor);
    }

    public static IMethod[] getNamespaceFunction(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        IType[] namespaces = PHPModelUtils.getNamespaces(sourceModule, namespace, cache, monitor);
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IType[] iTypeArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            result.addAll(Arrays.asList(PHPModelUtils.getTypeMethod(ns, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IType[] getNamespaceOf(String elementName, ISourceModule sourceModule, int offset, IProgressMonitor monitor) throws ModelException {
        return PHPModelUtils.getNamespaceOf(elementName, sourceModule, offset, null, monitor);
    }

    public static IType[] getNamespaceOf(String elementName, ISourceModule sourceModule, int offset, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        String namespace = PHPModelUtils.extractNamespaceName(elementName, sourceModule, offset);
        if (namespace != null && namespace.length() > 0) {
            return PHPModelUtils.getNamespaces(sourceModule, namespace, cache, monitor);
        }
        return PhpModelAccess.NULL_TYPES;
    }

    public static IType[] getNamespaceType(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IProgressMonitor monitor, boolean isType) throws ModelException {
        return PHPModelUtils.getNamespaceType(namespace, prefix, exactName, sourceModule, null, monitor, isType);
    }

    public static IType[] getNamespaceType(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IModelAccessCache cache, IProgressMonitor monitor, boolean isType) throws ModelException {
        IType[] namespaces = PHPModelUtils.getNamespaces(sourceModule, namespace, cache, monitor);
        LinkedList<IType> result = new LinkedList<IType>();
        IType[] iTypeArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            result.addAll(Arrays.asList(PHPModelUtils.getTypeType(ns, prefix, exactName, isType)));
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static IType[] getNamespaces(ISourceModule sourceModule, String namespaceName, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        if (cache != null) {
            Collection<IType> namespaces = cache.getNamespaces(sourceModule, namespaceName, monitor);
            if (namespaces == null) {
                return PhpModelAccess.NULL_TYPES;
            }
            return namespaces.toArray(new IType[namespaces.size()]);
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        IType[] namespaces = PhpModelAccess.getDefault().findNamespaces(null, namespaceName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, monitor);
        return namespaces;
    }

    public static TypeDeclaration getNodeByClass(ModuleDeclaration rootNode, IType type) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)type, DeclarationSearcher.DeclarationType.CLASS);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                Logger.logException(e);
            }
        }
        return (TypeDeclaration)visitor.getResult();
    }

    public static ASTNode getNodeByElement(ModuleDeclaration rootNode, IModelElement element) throws ModelException {
        switch (element.getElementType()) {
            case 7: {
                return PHPModelUtils.getNodeByClass(rootNode, (IType)element);
            }
            case 9: {
                return PHPModelUtils.getNodeByMethod(rootNode, (IMethod)element);
            }
            case 8: {
                return PHPModelUtils.getNodeByField(rootNode, (IField)element);
            }
        }
        throw new IllegalArgumentException("Unsupported element type: " + element.getClass().getName());
    }

    public static ASTNode getNodeByField(ModuleDeclaration rootNode, IField field) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)field, DeclarationSearcher.DeclarationType.FIELD);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                Logger.logException(e);
            }
        }
        return visitor.getResult();
    }

    public static MethodDeclaration getNodeByMethod(ModuleDeclaration rootNode, IMethod method) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)method, DeclarationSearcher.DeclarationType.METHOD);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                Logger.logException(e);
            }
        }
        return (MethodDeclaration)visitor.getResult();
    }

    public static IType[] getSuperClasses(IType type, ITypeHierarchy hierarchy) throws ModelException {
        if (hierarchy == null) {
            if (type.getScriptProject() == null || !type.getScriptProject().exists()) {
                return EMPTY_TYPES;
            }
            hierarchy = type.newSupertypeHierarchy(null);
        }
        Collection<IType> filtered = PHPModelUtils.filterElements(type.getSourceModule(), Arrays.asList(hierarchy.getAllSuperclasses(type)), null, null);
        return filtered.toArray(new IType[filtered.size()]);
    }

    public static IField[] getSuperTypeHierarchyField(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return PHPModelUtils.getSuperTypeHierarchyField(type, null, prefix, exactName, monitor);
    }

    public static IField[] getSuperTypeHierarchyField(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        IType[] allSuperclasses = PHPModelUtils.getSuperClasses(type, hierarchy);
        return PHPModelUtils.getTypesField(allSuperclasses, prefix, exactName);
    }

    public static IMethod[] getSuperTypeHierarchyMethod(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return PHPModelUtils.getSuperTypeHierarchyMethod(type, null, prefix, exactName, monitor);
    }

    public static IMethod[] getSuperTypeHierarchyMethod(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        IType[] allSuperclasses = PHPModelUtils.getSuperClasses(type, hierarchy);
        return PHPModelUtils.getTypesMethod(allSuperclasses, prefix, exactName);
    }

    public static IField[] getTypeField(IType type, String prefix, boolean exactName) throws ModelException {
        LinkedList<IField> result = new LinkedList<IField>();
        if (type.exists()) {
            String elementName;
            IField field;
            IField[] fields;
            HashSet<String> nameSet = new HashSet<String>();
            IField[] iFieldArray = fields = type.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                field = iFieldArray[n2];
                elementName = field.getElementName();
                if (elementName.startsWith("$")) {
                    nameSet.add(elementName.substring(1));
                }
                if (elementName.startsWith("$") && !prefix.startsWith("$")) {
                    elementName = elementName.substring(1);
                }
                if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                    result.add(field);
                }
                ++n2;
            }
            iFieldArray = fields = TraitUtils.getTraitFields(type, nameSet);
            n = fields.length;
            n2 = 0;
            while (n2 < n) {
                field = iFieldArray[n2];
                elementName = field.getElementName();
                if (elementName.startsWith("$") && !prefix.startsWith("$")) {
                    elementName = elementName.substring(1);
                }
                if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                    result.add(field);
                }
                ++n2;
            }
        }
        return result.toArray(new IField[result.size()]);
    }

    public static IField[] getTypeHierarchyField(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        LinkedList<IField> fields = new LinkedList<IField>();
        fields.addAll(Arrays.asList(PHPModelUtils.getTypeField(type, prefix, exactName)));
        if (type.getSuperClasses() != null && type.getSuperClasses().length > 0) {
            fields.addAll(Arrays.asList(PHPModelUtils.getSuperTypeHierarchyField(type, hierarchy, prefix, exactName, monitor)));
        }
        return fields.toArray(new IField[fields.size()]);
    }

    public static IField[] getTypeHierarchyField(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return PHPModelUtils.getTypeHierarchyField(type, null, prefix, exactName, monitor);
    }

    public static PHPDocBlock[] getTypeHierarchyFieldDoc(IType type, String name, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (name == null) {
            throw new NullPointerException();
        }
        LinkedList<PHPDocBlock> docs = new LinkedList<PHPDocBlock>();
        IField[] iFieldArray = PHPModelUtils.getTypeHierarchyField(type, name, exactName, monitor);
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            PHPDocBlock docBlock = PHPModelUtils.getDocBlock(field);
            if (docBlock != null) {
                docs.add(docBlock);
            }
            ++n2;
        }
        return docs.toArray(new PHPDocBlock[docs.size()]);
    }

    public static IMethod[] getTypeHierarchyMethod(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        LinkedList<IMethod> methods = new LinkedList<IMethod>();
        methods.addAll(Arrays.asList(PHPModelUtils.getTypeMethod(type, prefix, exactName)));
        if (type.getSuperClasses() != null && type.getSuperClasses().length > 0) {
            methods.addAll(Arrays.asList(PHPModelUtils.getSuperTypeHierarchyMethod(type, hierarchy, prefix, exactName, monitor)));
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    public static IMethod[] getFirstTypeHierarchyMethod(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        LinkedList<IMethod> methods = new LinkedList<IMethod>();
        methods.addAll(Arrays.asList(PHPModelUtils.getTypeMethod(type, prefix, exactName)));
        if (type.getSuperClasses() != null && type.getSuperClasses().length > 0 && methods.size() == 0) {
            IType[] allSuperclasses;
            IType[] iTypeArray = allSuperclasses = PHPModelUtils.getSuperClasses(type, hierarchy);
            int n = allSuperclasses.length;
            int n2 = 0;
            while (n2 < n) {
                IType superClass = iTypeArray[n2];
                IMethod[] method = PHPModelUtils.getTypeMethod(superClass, prefix, exactName);
                if (method != null && method.length > 0) {
                    methods.addAll(Arrays.asList(method));
                    break;
                }
                ++n2;
            }
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    public static IMethod[] getTypeHierarchyMethod(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return PHPModelUtils.getTypeHierarchyMethod(type, null, prefix, exactName, monitor);
    }

    public static PHPDocBlock[] getTypeHierarchyMethodDoc(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return PHPModelUtils.getTypeHierarchyMethodDoc(type, null, prefix, exactName, monitor);
    }

    public static PHPDocBlock[] getTypeHierarchyMethodDoc(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        LinkedList<PHPDocBlock> docs = new LinkedList<PHPDocBlock>();
        IMethod[] iMethodArray = PHPModelUtils.getTypeHierarchyMethod(type, hierarchy, prefix, exactName, monitor);
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            PHPDocBlock docBlock = PHPModelUtils.getDocBlock(method);
            if (docBlock != null) {
                docs.add(docBlock);
            }
            ++n2;
        }
        return docs.toArray(new PHPDocBlock[docs.size()]);
    }

    public static IMethod[] getTypeMethod(IType type, String prefix, boolean exactName) throws ModelException {
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        if (type.exists()) {
            String elementName;
            IMethod method;
            IMethod[] methods;
            HashSet<String> nameSet = new HashSet<String>();
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                method = iMethodArray[n2];
                elementName = method.getElementName();
                nameSet.add(elementName);
                if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                    result.add(method);
                }
                ++n2;
            }
            iMethodArray = methods = TraitUtils.getTraitMethods(type, nameSet);
            n = methods.length;
            n2 = 0;
            while (n2 < n) {
                method = iMethodArray[n2];
                elementName = method.getElementName();
                if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                    result.add(method);
                }
                ++n2;
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IType[] getTypes(String typeName, ISourceModule sourceModule, int offset, IProgressMonitor monitor) throws ModelException {
        return PHPModelUtils.getTypes(typeName, sourceModule, offset, null, monitor);
    }

    public static IType[] getTypes(String typeName, ISourceModule sourceModule, int offset, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        return PHPModelUtils.getTypes(typeName, sourceModule, offset, cache, monitor, true, false);
    }

    public static IType[] getTypes(String typeName, ISourceModule sourceModule, int offset, IModelAccessCache cache, IProgressMonitor monitor, boolean isType) throws ModelException {
        return PHPModelUtils.getTypes(typeName, sourceModule, offset, cache, monitor, isType, false);
    }

    public static IType[] getTypes(String typeName, ISourceModule sourceModule, int offset, IModelAccessCache cache, IProgressMonitor monitor, boolean isType, boolean isGlobal) throws ModelException {
        Collection<Object> types;
        if (typeName == null || typeName.length() == 0) {
            return PhpModelAccess.NULL_TYPES;
        }
        if (!isGlobal) {
            String namespace = PHPModelUtils.extractNamespaceName(typeName, sourceModule, offset);
            typeName = PHPModelUtils.extractElementName(typeName);
            if (namespace != null) {
                if (namespace.length() > 0) {
                    IType[] types2 = PHPModelUtils.getNamespaceType(namespace, typeName = PHPModelUtils.getRealName(typeName, sourceModule, offset, typeName), true, sourceModule, cache, monitor, isType);
                    if (types2.length > 0) {
                        return types2;
                    }
                    return PhpModelAccess.NULL_TYPES;
                }
            } else {
                IType[] types3;
                IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                if (currentNamespace != null && (types3 = PHPModelUtils.getNamespaceType(namespace = currentNamespace.getElementName(), typeName, true, sourceModule, cache, monitor, isType)).length > 0) {
                    return types3;
                }
            }
        }
        ArrayList<IType> result = new ArrayList<IType>();
        if (cache == null) {
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
            IType[] r = isType ? PhpModelAccess.getDefault().findTypes(typeName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null) : PhpModelAccess.getDefault().findTraits(typeName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            IType[] iTypeArray = r;
            int n = r.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (PHPModelUtils.getCurrentNamespace((IModelElement)type) == null) {
                    result.add(type);
                }
                ++n2;
            }
            ArrayList<IType> tempList = new ArrayList<IType>(result.size());
            tempList.addAll(result);
            types = PHPModelUtils.filterElements(sourceModule, tempList, null, monitor);
        } else {
            types = isType ? cache.getTypes(sourceModule, typeName, null, monitor) : cache.getTraits(sourceModule, typeName, null, monitor);
            if (types == null) {
                return PhpModelAccess.NULL_TYPES;
            }
        }
        result.clear();
        for (IType type : types) {
            if (PHPModelUtils.getCurrentNamespace((IModelElement)type) != null) continue;
            result.add(type);
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IType[] getTraits(String typeName, ISourceModule sourceModule, int offset, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        return PHPModelUtils.getTypes(typeName, sourceModule, offset, cache, monitor, false, false);
    }

    public static IField[] getTypesField(IType[] types, String prefix, boolean exactName) throws ModelException {
        LinkedList<IField> result = new LinkedList<IField>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.addAll(Arrays.asList(PHPModelUtils.getTypeField(type, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IField[result.size()]);
    }

    public static IMethod[] getTypesMethod(IType[] types, String prefix, boolean exactName) throws ModelException {
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.addAll(Arrays.asList(PHPModelUtils.getTypeMethod(type, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IType[] getTypeType(IType type, String prefix, boolean exactName, boolean isType) throws ModelException {
        IType[] types;
        LinkedList<IType> result = new LinkedList<IType>();
        IType[] iTypeArray = types = type.getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (!(isType && PHPFlags.isTrait(t.getFlags()) || !isType && !PHPFlags.isTrait(t.getFlags()))) {
                String elementName = t.getElementName();
                if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                    result.add(t);
                }
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IType[] getTypeType(IType type, String prefix, boolean exactName) throws ModelException {
        return PHPModelUtils.getTypeType(type, prefix, exactName, true);
    }

    public static IMethod[] getUnimplementedMethods(IType type, IProgressMonitor monitor) throws ModelException {
        return PHPModelUtils.getUnimplementedMethods(type, null, monitor);
    }

    public static IMethod[] getUnimplementedMethods(IType type, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        HashMap<String, IMethod> abstractMethods = new HashMap<String, IMethod>();
        HashSet<String> nonAbstractMethods = new HashSet<String>();
        PHPModelUtils.internalGetUnimplementedMethods(type, nonAbstractMethods, abstractMethods, new HashSet<String>(), cache, monitor, true);
        for (String methodName : nonAbstractMethods) {
            abstractMethods.remove(methodName);
        }
        Collection<IMethod> unimplementedMethods = abstractMethods.values();
        return unimplementedMethods.toArray(new IMethod[unimplementedMethods.size()]);
    }

    private static void internalGetUnimplementedMethods(IType type, HashSet<String> nonAbstractMethods, HashMap<String, IMethod> abstractMethods, Set<String> processedTypes, IModelAccessCache cache, IProgressMonitor monitor, boolean checkConstructor) throws ModelException {
        IMethod[] methods;
        int typeFlags = type.getFlags();
        IMethod[] iMethodArray = methods = PHPModelUtils.getTypeMethod(type, "", false);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                boolean isAbstract;
                String methodName;
                IMethod method;
                block16: {
                    method = iMethodArray[n2];
                    methodName = method.getElementName();
                    int methodFlags = method.getFlags();
                    isAbstract = PHPFlags.isAbstract((int)methodFlags);
                    if (!PHPModelUtils.isConstructor(method)) break block16;
                    if (!checkConstructor) break block17;
                    checkConstructor = false;
                }
                if (isAbstract || PHPFlags.isInterface((int)typeFlags)) {
                    if (!abstractMethods.containsKey(methodName)) {
                        abstractMethods.put(methodName, method);
                    }
                } else if (!isAbstract) {
                    nonAbstractMethods.add(methodName);
                }
            }
            ++n2;
        }
        String[] superClasses = type.getSuperClasses();
        if (superClasses != null) {
            String[] stringArray = superClasses;
            int n3 = superClasses.length;
            n = 0;
            while (n < n3) {
                String superClass = stringArray[n];
                if (processedTypes.add(superClass)) {
                    Collection<IType> types = null;
                    if (cache == null) {
                        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)type.getScriptProject());
                        IType[] superTypes = PhpModelAccess.getDefault().findTypes(superClass, ISearchEngine.MatchRule.EXACT, 0, 2048, scope, null);
                        types = PHPModelUtils.fileNetworkFilter(type.getSourceModule(), Arrays.asList(superTypes), null, monitor);
                    } else {
                        String namespaceName = null;
                        int i = superClass.lastIndexOf(92);
                        if (i != -1) {
                            namespaceName = superClass.substring(0, i);
                            superClass = superClass.substring(i + 1);
                        }
                        types = cache.getClassesOrInterfaces(type.getSourceModule(), superClass, namespaceName, monitor);
                    }
                    if (types != null) {
                        for (IType superType : types) {
                            PHPModelUtils.internalGetUnimplementedMethods(superType, nonAbstractMethods, abstractMethods, processedTypes, cache, monitor, checkConstructor);
                        }
                    }
                }
                ++n;
            }
        }
    }

    public static boolean isConstructor(IMethod method) {
        String methodName = method.getElementName();
        return methodName.equals("__construct") || methodName.equals(method.getDeclaringType().getElementName());
    }

    public static boolean hasStaticOrConstMember(IType type) {
        IField[] members;
        ITypeHierarchy hierarchy;
        block7: {
            block6: {
                if (!PHPFlags.isNamespace(type.getFlags())) break block6;
                return false;
            }
            hierarchy = type.newSupertypeHierarchy(null);
            members = PHPModelUtils.getTypeHierarchyField(type, hierarchy, "", false, null);
            if (!PHPModelUtils.hasStaticOrConstMember((IModelElement[])members)) break block7;
            return true;
        }
        try {
            members = PHPModelUtils.getTypeHierarchyMethod(type, hierarchy, "", false, null);
            if (PHPModelUtils.hasStaticOrConstMember((IModelElement[])members)) {
                return true;
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        catch (CoreException e) {
            PHPCorePlugin.log(e);
        }
        return false;
    }

    public static boolean hasStaticOrConstMember(IModelElement[] elements) throws ModelException {
        int i = 0;
        while (i < elements.length) {
            IMember member;
            int flags;
            IModelElement modelElement = elements[i];
            if (modelElement instanceof IMember && (Flags.isStatic((int)(flags = (member = (IMember)modelElement).getFlags())) || modelElement instanceof IField && Flags.isFinal((int)flags))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Map<String, UsePart> getAliasToNSMap(final String prefix, ModuleDeclaration moduleDeclaration, final int offset, IType namespace, final boolean exactMatch) {
        final HashMap<String, UsePart> result = new HashMap<String, UsePart>();
        try {
            int start = 0;
            if (namespace != null) {
                start = namespace.getSourceRange().getOffset();
            }
            final int searchStart = start;
            moduleDeclaration.traverse(new ASTVisitor(){

                public boolean visit(Statement s) throws Exception {
                    if (s instanceof UseStatement) {
                        UseStatement useStatement = (UseStatement)s;
                        for (UsePart usePart : useStatement.getParts()) {
                            String name;
                            if (usePart.getAlias() != null && usePart.getAlias().getName() != null) {
                                name = usePart.getAlias().getName();
                                if (!CodeAssistUtils.startsWithIgnoreCase(name, prefix)) continue;
                                result.put(name, usePart);
                                continue;
                            }
                            name = usePart.getNamespace().getFullyQualifiedName();
                            int index = name.lastIndexOf(92);
                            if (index >= 0) {
                                name = name.substring(index + 1);
                            }
                            if ((!exactMatch || !name.equals(prefix)) && (exactMatch || !name.startsWith(prefix))) continue;
                            result.put(name, usePart);
                        }
                    }
                    return this.visitGeneral((ASTNode)s);
                }

                public boolean visitGeneral(ASTNode node) throws Exception {
                    if (node.sourceStart() > offset || node.sourceEnd() < searchStart) {
                        return false;
                    }
                    return super.visitGeneral(node);
                }
            });
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return result;
    }

    public static String getClassNameForNewStatement(TextSequence newClassStatementText, PHPVersion phpVersion) {
        if (phpVersion.isGreaterThan(PHPVersion.PHP5_3)) {
            String newClassName = newClassStatementText.toString().trim();
            if (newClassName.startsWith("new") && newClassName.endsWith(")")) {
                int newClassNameEnd = PHPModelUtils.getFunctionNameEndOffset(newClassStatementText, newClassStatementText.length() - 1);
                int newClassNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex(phpVersion, newClassStatementText, newClassNameEnd, false);
                if (newClassNameStart > 3 && newClassNameStart < newClassNameEnd) {
                    newClassName = newClassStatementText.subSequence(newClassNameStart, newClassNameEnd).toString();
                    return newClassName;
                }
            } else if (newClassName.startsWith("new")) {
                return newClassName.substring(3).trim();
            }
        }
        return null;
    }

    public static int getFunctionNameEndOffset(TextSequence statementText, int offset) {
        if (statementText.charAt(offset) != ')') {
            return 0;
        }
        int currChar = offset;
        int bracketsNum = 1;
        char inStringMode = '\u0000';
        while (bracketsNum != 0 && currChar >= 0) {
            char charAt;
            if ((charAt = statementText.charAt(--currChar)) == '\'' || charAt == '\"') {
                char c = inStringMode == '\u0000' ? charAt : (inStringMode = inStringMode == charAt ? (char)'\u0000' : inStringMode);
            }
            if (inStringMode != '\u0000') continue;
            if (charAt == ')') {
                ++bracketsNum;
                continue;
            }
            if (charAt != '(') continue;
            --bracketsNum;
        }
        return currChar;
    }

    public static String getFullName(IType declaringType) {
        try {
            int parentFlags;
            if (PHPFlags.isNamespace(declaringType.getFlags())) {
                return declaringType.getElementName();
            }
            IModelElement parent = declaringType.getParent();
            if (parent.getElementType() == 5) {
                return declaringType.getElementName();
            }
            if (parent.getElementType() == 7 && PHPFlags.isNamespace(parentFlags = ((IType)parent).getFlags()) && parent.getParent().getElementType() == 5) {
                StringBuilder b = new StringBuilder(parent.getElementName());
                b.append('\\');
                b.append(declaringType.getElementName());
                return b.toString();
            }
            return PHPModelUtils.getFullName(declaringType.getElementName(), declaringType.getSourceModule(), declaringType.getSourceRange().getOffset());
        }
        catch (ModelException modelException) {
            return declaringType.getElementName();
        }
    }

    public static String getFullName(String typeName, ISourceModule sourceModule, int offset) {
        String namespace = PHPModelUtils.extractNamespaceName(typeName, sourceModule, offset);
        typeName = PHPModelUtils.extractElementName(typeName);
        if (namespace != null) {
            if (namespace.length() > 0) {
                typeName = PHPModelUtils.getRealName(typeName, sourceModule, offset, typeName);
                typeName = String.valueOf(namespace) + '\\' + typeName;
            }
        } else {
            IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
            if (currentNamespace != null) {
                namespace = currentNamespace.getElementName();
                typeName = String.valueOf(namespace) + '\\' + typeName;
            }
        }
        return typeName;
    }

    public static String getFullName(NamespaceName namespaceName) {
        StringBuffer sb = new StringBuffer();
        if (namespaceName.isGlobal()) {
            sb.append('\\');
        }
        List<Identifier> segments = namespaceName.segments();
        for (Identifier identifier : segments) {
            if (sb.length() == 0 && namespaceName.isGlobal()) {
                sb.append('\\');
            } else if (sb.length() > 0) {
                sb.append('\\');
            }
            sb.append(identifier.getName());
        }
        return sb.toString();
    }

    public static String getLineSeparator(IProject project) {
        String lineSeparator = null;
        if (project != null) {
            lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, new IScopeContext[]{new ProjectScope(project)});
        }
        if (lineSeparator == null) {
            lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, new IScopeContext[]{InstanceScope.INSTANCE});
        }
        if (lineSeparator == null) {
            lineSeparator = System.getProperty("line.separator");
        }
        return lineSeparator;
    }

    public static boolean isInUseTraitStatement(ModuleDeclaration rootNode, final int offset) {
        final boolean[] found = new boolean[]{false};
        try {
            rootNode.traverse((ASTVisitor)new PHPASTVisitor(){

                @Override
                public boolean visit(TraitUseStatement s) throws Exception {
                    if (s.sourceStart() <= offset && s.sourceEnd() >= offset) {
                        found[0] = true;
                    }
                    return false;
                }

                public boolean visitGeneral(ASTNode node) throws Exception {
                    if (node.sourceEnd() < offset || node.sourceStart() > offset) {
                        return false;
                    }
                    return super.visitGeneral(node);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return found[0];
    }

    public static String stripQuotes(String name) {
        int len = name.length();
        if (len > 1 && (name.charAt(0) == '\'' && name.charAt(len - 1) == '\'' || name.charAt(0) == '\"' && name.charAt(len - 1) == '\"')) {
            name = name.substring(1, len - 1);
        }
        return name;
    }

    public static boolean isQuotesString(String name) {
        int len = name.length();
        return len > 1 && (name.charAt(0) == '\'' && name.charAt(len - 1) == '\'' || name.charAt(0) == '\"' && name.charAt(len - 1) == '\"');
    }

    public static IModelElement[] getTypeInString(ISourceModule sourceModule, IRegion wordRegion) {
        Scalar scalar;
        IType[] elements = null;
        ModuleDeclaration parsedUnit = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        ASTNode node = ASTUtils.findMinimalNode(parsedUnit, wordRegion.getOffset(), wordRegion.getOffset() + wordRegion.getLength());
        if (node instanceof Scalar && PHPModelUtils.isQuotesString((scalar = (Scalar)node).getValue()) && scalar.getScalarType() == 2) {
            try {
                elements = PHPModelUtils.getTypes(PHPModelUtils.stripQuotes(scalar.getValue()), sourceModule, scalar.sourceStart(), null, null);
            }
            catch (Exception exception) {}
        }
        return elements;
    }
}

