/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.php.core.libfolders.LibraryFolderManager;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.eclipse.php.internal.ui.explorer.TreeContentProviderRegistry;
import org.eclipse.php.internal.ui.util.LabelProviderUtil;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public class PHPExplorerLabelProvider
extends ScriptExplorerLabelProvider {
    public PHPExplorerLabelProvider(ScriptExplorerContentProvider cp, IPreferenceStore store) {
        super(cp, store);
        super.setIsFlatLayout(false);
    }

    public void setIsFlatLayout(boolean state) {
        super.setIsFlatLayout(false);
    }

    public Image getImage(Object element) {
        IModelElement modelElement = null;
        if (element instanceof ExternalProjectFragment) {
            return PHPPluginImages.get("org.eclipse.php.ui.library_obj.png");
        }
        if (element instanceof IncludePath) {
            Object entry = ((IncludePath)element).getEntry();
            if (entry instanceof IBuildpathEntry) {
                int entryKind = ((IBuildpathEntry)entry).getEntryKind();
                if (entryKind == 2) {
                    return PHPPluginImages.get("org.eclipse.php.ui.php_project_obj.png");
                }
                if (entryKind == 1 || entryKind == 5) {
                    return PHPPluginImages.get("org.eclipse.php.ui.library_obj.png");
                }
            }
            if (entry instanceof ExternalProjectFragment) {
                return PHPPluginImages.get("org.eclipse.php.ui.library_obj.png");
            }
            if (entry instanceof IFolder) {
                IModelElement createdScriptFolder = DLTKCore.create((IResource)((IFolder)entry));
                if (createdScriptFolder == null) {
                    return this.getImage(entry);
                }
                return this.getImage(createdScriptFolder);
            }
            if (entry instanceof IResource) {
                return this.getImage((IResource)entry);
            }
            return null;
        }
        if (element instanceof IResource) {
            modelElement = DLTKCore.create((IResource)((IResource)element));
        } else if (element instanceof IModelElement) {
            modelElement = (IModelElement)element;
        }
        if (modelElement != null) {
            IScriptProject project = modelElement.getScriptProject();
            if (!project.isOnBuildpath(modelElement)) {
                if (modelElement.getElementType() == 5) {
                    return PHPPluginImages.get("org.eclipse.php.ui.php_resource_obj.png");
                }
                if (modelElement.getElementType() == 3 || modelElement.getElementType() == 4) {
                    return PHPPluginImages.get("org.eclipse.php.ui.folder_opened.png");
                }
            } else if (modelElement.getElementType() == 3 || modelElement.getElementType() == 4 || element instanceof IFolder) {
                LibraryFolderManager lfm = LibraryFolderManager.getInstance();
                if (lfm.isInLibraryFolder(modelElement.getResource())) {
                    return PHPPluginImages.get("org.eclipse.php.ui.libfolder_obj.png");
                }
                return PHPPluginImages.get("org.eclipse.php.ui.folderroot_obj.png");
            }
        }
        if (element != null) {
            for (ILabelProvider provider : TreeContentProviderRegistry.getInstance().getLabelProviders()) {
                Image image = provider.getImage(element);
                if (image == null) continue;
                return image;
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        String label = this.doGetText(element);
        if (label != null) {
            return label;
        }
        return super.getText(element);
    }

    public StyledString getStyledText(Object element) {
        String label = this.doGetText(element);
        if (label != null) {
            return new StyledString(label);
        }
        return super.getStyledText(element);
    }

    private String doGetText(Object element) {
        if (element instanceof ExternalProjectFragment) {
            ExternalProjectFragment fragment = (ExternalProjectFragment)element;
            String name = LanguageModelInitializer.getPathName((IPath)EnvironmentPathUtils.getLocalPath((IPath)fragment.getPath()));
            if (name != null) {
                return name;
            }
            return fragment.toStringWithAncestors();
        }
        if (element instanceof IProjectFragment) {
            IProjectFragment fragment = (IProjectFragment)element;
            return fragment.getElementName();
        }
        if (element instanceof IncludePath) {
            Object entry = ((IncludePath)element).getEntry();
            if (entry instanceof IBuildpathEntry) {
                IBuildpathEntry iBuildpathEntry = (IBuildpathEntry)entry;
                if (iBuildpathEntry.getEntryKind() == 2) {
                    return iBuildpathEntry.getPath().lastSegment();
                }
                if (iBuildpathEntry.getEntryKind() == 5) {
                    return this.getEntryDescription(element, iBuildpathEntry);
                }
                String result = LabelProviderUtil.getVariableName(iBuildpathEntry.getPath(), iBuildpathEntry.getEntryKind());
                if (result == null) {
                    IPath localPath = EnvironmentPathUtils.getLocalPath((IPath)iBuildpathEntry.getPath());
                    return localPath.toOSString();
                }
                return result;
            }
            if (entry instanceof ExternalProjectFragment) {
                return ((ExternalProjectFragment)entry).toStringWithAncestors();
            }
            if (entry instanceof IResource) {
                return ((IResource)entry).getFullPath().toString().substring(1);
            }
            return null;
        }
        if (element != null) {
            for (ILabelProvider provider : TreeContentProviderRegistry.getInstance().getLabelProviders()) {
                String label = provider.getText(element);
                if (label == null) continue;
                return label;
            }
        }
        return null;
    }

    private String getEntryDescription(Object element, IBuildpathEntry iBuildpathEntry) {
        IProject project = ((IncludePath)element).getProject();
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        IBuildpathContainer buildpathContainer = null;
        try {
            buildpathContainer = DLTKCore.getBuildpathContainer((IPath)iBuildpathEntry.getPath(), (IScriptProject)scriptProject);
        }
        catch (ModelException modelException) {}
        if (buildpathContainer != null) {
            return buildpathContainer.getDescription();
        }
        return iBuildpathEntry.getPath().toOSString();
    }
}

