/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Scanner;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.IScriptCorrectionContext;
import org.eclipse.dltk.ui.text.IScriptCorrectionProcessor;
import org.eclipse.dltk.ui.text.MarkerResolutionProposal;
import org.eclipse.dltk.ui.text.completion.CompletionProposalComparator;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.text.correction.AssistContext;
import org.eclipse.php.internal.ui.text.correction.ContributedProcessorDescriptor;
import org.eclipse.php.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.php.internal.ui.text.correction.IInvocationContext;
import org.eclipse.php.internal.ui.text.correction.IProblemLocation;
import org.eclipse.php.internal.ui.text.correction.IQuickAssistProcessor;
import org.eclipse.php.internal.ui.text.correction.IQuickFixProcessor;
import org.eclipse.php.internal.ui.text.correction.IQuickFixProcessorExtension;
import org.eclipse.php.internal.ui.text.correction.IStatusLineProposal;
import org.eclipse.php.internal.ui.text.correction.PHPCorrectionAssistant;
import org.eclipse.php.internal.ui.text.correction.ProblemLocation;
import org.eclipse.php.internal.ui.text.correction.proposals.ChangeCorrectionProposal;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class PHPCorrectionProcessor
implements org.eclipse.jface.text.quickassist.IQuickAssistProcessor,
IScriptCorrectionProcessor {
    private static final String QUICKFIX_PROCESSOR_CONTRIBUTION_ID = "quickFixProcessors";
    private static final String QUICKASSIST_PROCESSOR_CONTRIBUTION_ID = "quickAssistProcessors";
    private static ContributedProcessorDescriptor[] fgContributedAssistProcessors = null;
    private static ContributedProcessorDescriptor[] fgContributedCorrectionProcessors = null;
    private PHPCorrectionAssistant fAssistant;
    private String fErrorMessage;

    private static ContributedProcessorDescriptor[] getProcessorDescriptors(String contributionId, boolean testMarkerTypes) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.ui", contributionId);
        ArrayList<ContributedProcessorDescriptor> res = new ArrayList<ContributedProcessorDescriptor>(elements.length);
        int i = 0;
        while (i < elements.length) {
            ContributedProcessorDescriptor desc = new ContributedProcessorDescriptor(elements[i], testMarkerTypes);
            IStatus status = desc.checkSyntax();
            if (status.isOK()) {
                res.add(desc);
            } else {
                PHPUiPlugin.log(status);
            }
            ++i;
        }
        return res.toArray(new ContributedProcessorDescriptor[res.size()]);
    }

    private static ContributedProcessorDescriptor[] getCorrectionProcessors() {
        if (fgContributedCorrectionProcessors == null) {
            fgContributedCorrectionProcessors = PHPCorrectionProcessor.getProcessorDescriptors(QUICKFIX_PROCESSOR_CONTRIBUTION_ID, true);
        }
        return fgContributedCorrectionProcessors;
    }

    private static ContributedProcessorDescriptor[] getAssistProcessors() {
        if (fgContributedAssistProcessors == null) {
            fgContributedAssistProcessors = PHPCorrectionProcessor.getProcessorDescriptors(QUICKASSIST_PROCESSOR_CONTRIBUTION_ID, false);
        }
        return fgContributedAssistProcessors;
    }

    public static boolean hasCorrections(ISourceModule cu, IProblemIdentifier identifier, String markerType) {
        ContributedProcessorDescriptor[] processors = PHPCorrectionProcessor.getCorrectionProcessors();
        SafeHasCorrections collector = new SafeHasCorrections(cu, identifier);
        int i = 0;
        while (i < processors.length) {
            if (processors[i].canHandleMarkerType(markerType)) {
                collector.process(processors[i]);
                if (collector.hasCorrections()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean isQuickFixableType(Annotation annotation) {
        return (annotation instanceof IScriptAnnotation || annotation instanceof SimpleMarkerAnnotation) && !annotation.isMarkedDeleted();
    }

    public static boolean hasCorrections(Annotation annotation) {
        IScriptAnnotation javaAnnotation;
        if (annotation instanceof IScriptAnnotation && (javaAnnotation = (IScriptAnnotation)annotation).getId() != null) {
            ISourceModule cu = javaAnnotation.getSourceModule();
            return PHPCorrectionProcessor.hasCorrections(cu, javaAnnotation.getId(), javaAnnotation.getMarkerType());
        }
        if (annotation instanceof SimpleMarkerAnnotation) {
            return PHPCorrectionProcessor.hasCorrections(((SimpleMarkerAnnotation)annotation).getMarker());
        }
        return false;
    }

    private static boolean hasCorrections(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return false;
        }
        IMarkerHelpRegistry registry = IDE.getMarkerHelpRegistry();
        return registry != null && registry.hasResolutions(marker);
    }

    public static boolean hasAssists(IInvocationContext context) {
        ContributedProcessorDescriptor[] processors = PHPCorrectionProcessor.getAssistProcessors();
        SafeHasAssist collector = new SafeHasAssist(context);
        int i = 0;
        while (i < processors.length) {
            collector.process(processors[i]);
            if (collector.hasAssists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void initAssistant(PHPStructuredTextViewer textViewer) {
        if (this.fAssistant != null) {
            return;
        }
        this.fAssistant = (PHPCorrectionAssistant)textViewer.getQuickAssistAssistant();
        this.fAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
                PHPCorrectionProcessor.this.fAssistant.setStatusLineVisible(false);
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                PHPCorrectionProcessor.this.fAssistant.setStatusLineVisible(true);
                PHPCorrectionProcessor.this.fAssistant.setStatusMessage(this.getJumpHintStatusLineMessage());
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
                IStatusLineProposal statusLineProposal;
                String message;
                if (proposal instanceof IStatusLineProposal && (message = (statusLineProposal = (IStatusLineProposal)proposal).getStatusMessage()) != null) {
                    PHPCorrectionProcessor.this.fAssistant.setStatusMessage(message);
                    return;
                }
                PHPCorrectionProcessor.this.fAssistant.setStatusMessage(this.getJumpHintStatusLineMessage());
            }

            private String getJumpHintStatusLineMessage() {
                if (PHPCorrectionProcessor.this.fAssistant.isUpdatedOffset()) {
                    String key = this.getQuickAssistBinding();
                    if (key == null) {
                        return CorrectionMessages.JavaCorrectionProcessor_go_to_original_using_menu;
                    }
                    return NLS.bind((String)CorrectionMessages.JavaCorrectionProcessor_go_to_original_using_key, (Object)key);
                }
                if (PHPCorrectionProcessor.this.fAssistant.isProblemLocationAvailable()) {
                    String key = this.getQuickAssistBinding();
                    if (key == null) {
                        return CorrectionMessages.JavaCorrectionProcessor_go_to_closest_using_menu;
                    }
                    return NLS.bind((String)CorrectionMessages.JavaCorrectionProcessor_go_to_closest_using_key, (Object)key);
                }
                return "";
            }

            private String getQuickAssistBinding() {
                IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
                return bindingSvc.getBestActiveBindingFormattedFor("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
            }
        });
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        ICompletionProposal[] res = null;
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        if (viewer instanceof PHPStructuredTextViewer) {
            PHPStructuredTextViewer textViewer = (PHPStructuredTextViewer)viewer;
            this.initAssistant(textViewer);
            int documentOffset = quickAssistContext.getOffset();
            IEditorPart part = this.fAssistant.getEditor();
            ISourceModule cu = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)part.getEditorInput());
            IAnnotationModel model = DLTKUIPlugin.getDocumentProvider().getAnnotationModel((Object)part.getEditorInput());
            int length = viewer != null ? viewer.getSelectedRange().y : 0;
            AssistContext context = new AssistContext(cu, viewer, part, documentOffset, length, SharedASTProvider.WAIT_YES);
            Annotation[] annotations = this.fAssistant.getAnnotationsAtOffset();
            this.fErrorMessage = null;
            if (model != null && annotations != null) {
                ArrayList proposals = new ArrayList(10);
                IStatus status = PHPCorrectionProcessor.collectProposals(context, model, annotations, true, !this.fAssistant.isUpdatedOffset(), proposals);
                res = proposals.toArray(new ICompletionProposal[proposals.size()]);
                if (!status.isOK()) {
                    this.fErrorMessage = status.getMessage();
                    PHPUiPlugin.log(status);
                }
            }
        }
        if (res == null || res.length == 0) {
            return new ICompletionProposal[]{new ChangeCorrectionProposal(CorrectionMessages.NoCorrectionProposal_description, (Change)new NullChange(""), 0, null)};
        }
        if (res.length > 1) {
            Arrays.sort(res, new CompletionProposalComparator());
        }
        return res;
    }

    public static IStatus collectProposals(IInvocationContext context, IAnnotationModel model, Annotation[] annotations, boolean addQuickFixes, boolean addQuickAssists, Collection proposals) {
        IStatus status;
        ArrayList<ProblemLocation> problems = new ArrayList<ProblemLocation>();
        int i = 0;
        while (i < annotations.length) {
            Annotation curr = annotations[i];
            ProblemLocation problemLocation = null;
            if (curr instanceof IScriptAnnotation && (problemLocation = PHPCorrectionProcessor.getProblemLocation((IScriptAnnotation)curr, model)) != null) {
                problems.add(problemLocation);
            }
            if (problemLocation == null && addQuickFixes && curr instanceof SimpleMarkerAnnotation) {
                PHPCorrectionProcessor.collectMarkerProposals((SimpleMarkerAnnotation)curr, proposals);
            }
            ++i;
        }
        MultiStatus resStatus = null;
        IProblemLocation[] problemLocations = problems.toArray(new IProblemLocation[problems.size()]);
        if (addQuickFixes && !(status = PHPCorrectionProcessor.collectCorrections(context, problemLocations, proposals)).isOK()) {
            resStatus = new MultiStatus("org.eclipse.php.ui", 4, CorrectionMessages.JavaCorrectionProcessor_error_quickfix_message, null);
            resStatus.add(status);
        }
        if (addQuickAssists && !(status = PHPCorrectionProcessor.collectAssists(context, problemLocations, proposals)).isOK()) {
            if (resStatus == null) {
                resStatus = new MultiStatus("org.eclipse.php.ui", 4, CorrectionMessages.JavaCorrectionProcessor_error_quickassist_message, null);
            }
            resStatus.add(status);
        }
        if (resStatus != null) {
            return resStatus;
        }
        return Status.OK_STATUS;
    }

    private static ProblemLocation getProblemLocation(IScriptAnnotation javaAnnotation, IAnnotationModel model) {
        Position pos;
        if (javaAnnotation.getId() != null && (pos = model.getPosition((Annotation)javaAnnotation)) != null) {
            return new ProblemLocation(pos.getOffset(), pos.getLength(), javaAnnotation);
        }
        return null;
    }

    private static void collectMarkerProposals(SimpleMarkerAnnotation annotation, Collection proposals) {
        IMarker marker = annotation.getMarker();
        IMarkerResolution[] res = IDE.getMarkerHelpRegistry().getResolutions(marker);
        if (res.length > 0) {
            int i = 0;
            while (i < res.length) {
                proposals.add(new MarkerResolutionProposal(res[i], marker));
                ++i;
            }
        }
    }

    public static IStatus collectCorrections(IInvocationContext context, IProblemLocation[] locations, Collection proposals) {
        ContributedProcessorDescriptor[] processors = PHPCorrectionProcessor.getCorrectionProcessors();
        SafeCorrectionCollector collector = new SafeCorrectionCollector(context, proposals);
        int i = 0;
        while (i < processors.length) {
            ContributedProcessorDescriptor curr = processors[i];
            IProblemLocation[] handled = PHPCorrectionProcessor.getHandledProblems(locations, curr);
            if (handled != null) {
                collector.setProblemLocations(handled);
                collector.process(curr);
            }
            ++i;
        }
        return collector.getStatus();
    }

    private static IProblemLocation[] getHandledProblems(IProblemLocation[] locations, ContributedProcessorDescriptor processor) {
        boolean allHandled = true;
        ArrayList<IProblemLocation> res = null;
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            if (processor.canHandleMarkerType(curr.getMarkerType())) {
                if (!allHandled) {
                    if (res == null) {
                        res = new ArrayList<IProblemLocation>(locations.length - i);
                    }
                    res.add(curr);
                }
            } else if (allHandled) {
                if (i > 0) {
                    res = new ArrayList(locations.length - i);
                    int k = 0;
                    while (k < i) {
                        res.add(locations[k]);
                        ++k;
                    }
                }
                allHandled = false;
            }
            ++i;
        }
        if (allHandled) {
            return locations;
        }
        if (res == null) {
            return null;
        }
        return res.toArray(new IProblemLocation[res.size()]);
    }

    public static IStatus collectAssists(IInvocationContext context, IProblemLocation[] locations, Collection proposals) {
        ContributedProcessorDescriptor[] processors = PHPCorrectionProcessor.getAssistProcessors();
        SafeAssistCollector collector = new SafeAssistCollector(context, locations, proposals);
        collector.process(processors);
        return collector.getStatus();
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public boolean canFix(Annotation annotation) {
        return PHPCorrectionProcessor.hasCorrections(annotation);
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        if (invocationContext instanceof IInvocationContext) {
            return PHPCorrectionProcessor.hasAssists((IInvocationContext)invocationContext);
        }
        return false;
    }

    public boolean canFix(IScriptAnnotation annotation) {
        if (annotation instanceof Annotation) {
            return this.canFix((Annotation)annotation);
        }
        return false;
    }

    public boolean canFix(IMarker marker) {
        return false;
    }

    public void computeQuickAssistProposals(IScriptAnnotation annotation, IScriptCorrectionContext context) {
    }

    public void computeQuickAssistProposals(IMarker marker, IScriptCorrectionContext context) {
    }

    private static class SafeAssistCollector
    extends SafeCorrectionProcessorAccess {
        private final IInvocationContext fContext;
        private final IProblemLocation[] fLocations;
        private final Collection fProposals;

        public SafeAssistCollector(IInvocationContext context, IProblemLocation[] locations, Collection proposals) {
            this.fContext = context;
            this.fLocations = locations;
            this.fProposals = proposals;
        }

        @Override
        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            IScriptCompletionProposal[] res;
            IQuickAssistProcessor curr = (IQuickAssistProcessor)desc.getProcessor(this.fContext.getCompilationUnit(), IQuickAssistProcessor.class);
            if (curr != null && (res = curr.getAssists(this.fContext, this.fLocations)) != null) {
                int k = 0;
                while (k < res.length) {
                    this.fProposals.add(res[k]);
                    ++k;
                }
            }
        }
    }

    private static class SafeCorrectionCollector
    extends SafeCorrectionProcessorAccess {
        private final IInvocationContext fContext;
        private final Collection fProposals;
        private IProblemLocation[] fLocations;

        public SafeCorrectionCollector(IInvocationContext context, Collection proposals) {
            this.fContext = context;
            this.fProposals = proposals;
        }

        public void setProblemLocations(IProblemLocation[] locations) {
            this.fLocations = locations;
        }

        @Override
        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            IScriptCompletionProposal[] res;
            IQuickFixProcessor curr = (IQuickFixProcessor)desc.getProcessor(this.fContext.getCompilationUnit(), IQuickFixProcessor.class);
            if (curr != null && (res = curr.getCorrections(this.fContext, this.fLocations)) != null) {
                int k = 0;
                while (k < res.length) {
                    this.fProposals.add(res[k]);
                    ++k;
                }
            }
        }
    }

    private static abstract class SafeCorrectionProcessorAccess
    implements ISafeRunnable {
        private MultiStatus fMulti = null;
        private ContributedProcessorDescriptor fDescriptor;

        private SafeCorrectionProcessorAccess() {
        }

        public void process(ContributedProcessorDescriptor[] desc) {
            int i = 0;
            while (i < desc.length) {
                this.fDescriptor = desc[i];
                SafeRunner.run((ISafeRunnable)this);
                ++i;
            }
        }

        public void process(ContributedProcessorDescriptor desc) {
            this.fDescriptor = desc;
            SafeRunner.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.safeRun(this.fDescriptor);
        }

        protected abstract void safeRun(ContributedProcessorDescriptor var1) throws Exception;

        public void handleException(Throwable exception) {
            if (this.fMulti == null) {
                this.fMulti = new MultiStatus("org.eclipse.php.ui", 0, CorrectionMessages.JavaCorrectionProcessor_error_status, null);
            }
            this.fMulti.merge((IStatus)new Status(4, "org.eclipse.php.ui", 4, CorrectionMessages.JavaCorrectionProcessor_error_status, exception));
        }

        public IStatus getStatus() {
            if (this.fMulti == null) {
                return Status.OK_STATUS;
            }
            return this.fMulti;
        }
    }

    private static class SafeHasAssist
    extends SafeCorrectionProcessorAccess {
        private final IInvocationContext fContext;
        private boolean fHasAssists;

        public SafeHasAssist(IInvocationContext context) {
            this.fContext = context;
            this.fHasAssists = false;
        }

        public boolean hasAssists() {
            return this.fHasAssists;
        }

        @Override
        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            IQuickAssistProcessor processor = (IQuickAssistProcessor)desc.getProcessor(this.fContext.getCompilationUnit(), IQuickAssistProcessor.class);
            if (processor != null && processor.hasAssists(this.fContext)) {
                this.fHasAssists = true;
            }
        }
    }

    private static class SafeHasCorrections
    extends SafeCorrectionProcessorAccess {
        private final ISourceModule fCu;
        private final int fProblemId;
        private final IProblemIdentifier fIdentifier;
        private boolean fHasCorrections;

        public SafeHasCorrections(ISourceModule cu, IProblemIdentifier identifier) {
            this.fCu = cu;
            Scanner problemScanner = new Scanner(identifier.name());
            this.fProblemId = problemScanner.hasNextInt() ? problemScanner.nextInt() : -1;
            this.fIdentifier = identifier;
            this.fHasCorrections = false;
        }

        public boolean hasCorrections() {
            return this.fHasCorrections;
        }

        @Override
        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            IQuickFixProcessor processor = (IQuickFixProcessor)desc.getProcessor(this.fCu, IQuickFixProcessor.class);
            if (processor != null && processor.hasCorrections(this.fCu, this.fProblemId)) {
                this.fHasCorrections = true;
            } else if (processor != null && processor instanceof IQuickFixProcessorExtension && ((IQuickFixProcessorExtension)((Object)processor)).hasCorrections(this.fCu, this.fIdentifier)) {
                this.fHasCorrections = true;
            }
        }
    }
}

