/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.extract.variable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.refactoring.core.extract.variable.ExtractVariableRefactoring;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExtractVariableRefactoringTestGetVariableName
extends AbstractRefactoringTest {
    private IProject project1;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        System.setProperty("disableStartupRunner", "true");
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("TestProject1");
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.file = folder.getFile("ExtractVariableRefactoringTestGetVariableName.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php function foo(){} foo(); $a = 1; $b=1.1; $c=true;$d=\"ab\"; $e = __LINE__;?>".getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testExtractMethod() {
        IStructuredModel model = null;
        try {
            model = ExtractVariableRefactoringTestGetVariableName.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 23, 6);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"foo", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractVar() {
        IStructuredModel model = null;
        try {
            model = ExtractVariableRefactoringTestGetVariableName.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 35, 1);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"i", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractVar1() {
        IStructuredModel model = null;
        try {
            model = ExtractVariableRefactoringTestGetVariableName.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 41, 3);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"d2", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractVar2() {
        IStructuredModel model = null;
        try {
            model = ExtractVariableRefactoringTestGetVariableName.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 49, 4);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"bool", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractVar3() {
        IStructuredModel model = null;
        try {
            model = ExtractVariableRefactoringTestGetVariableName.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 57, 4);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"str", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExtractVar4() {
        IStructuredModel model = null;
        try {
            model = ExtractVariableRefactoringTestGetVariableName.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 68, 8);
            processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            String[] names = processor.guessTempNames();
            Assert.assertTrue((names.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"line", (Object)names[0]);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

