/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpPreferences;

public class XDebugPreferenceMgr {
    public static final String XDEBUG_PREF_PORT = "org.eclipse.php.debug.core.xdebug_port";
    public static final String XDEBUG_PREF_SHOWSUPERGLOBALS = "org.eclipse.php.debug.core.xdebug_showSuperGlobals";
    public static final String XDEBUG_PREF_ARRAYDEPTH = "org.eclipse.php.debug.core.xdebug_arrayDepth";
    public static final String XDEBUG_PREF_CHILDREN = "org.eclipse.php.debug.core.xdebug_children";
    public static final String XDEBUG_PREF_DATA = "org.eclipse.php.debug.core.xdebug_data";
    public static final String XDEBUG_PREF_MULTISESSION = "org.eclipse.php.debug.core.xdebug_multisession";
    public static final String XDEBUG_PREF_REMOTESESSION = "org.eclipse.php.debug.core.xdebug_remotesession";
    public static final String XDEBUG_PREF_CAPTURESTDOUT = "org.eclipse.php.debug.core.xdebug_capturestdout";
    public static final String XDEBUG_PREF_CAPTURESTDERR = "org.eclipse.php.debug.core.xdebug_capturestderr";
    public static final String XDEBUG_PREF_USEPROXY = "org.eclipse.php.debug.core.xdebug_useproxy";
    public static final String XDEBUG_PREF_IDEKEY = "org.eclipse.php.debug.core.xdebug_idekey";
    public static final String XDEBUG_PREF_PROXY = "org.eclipse.php.debug.core.xdebug_proxy";
    public static final String[] remoteSessionOptions = new String[]{PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_off, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_localhost, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_any, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_prompt};
    public static final String[] captureOutputOptions = new String[]{PHPDebugCoreMessages.XDebugConfigurationDialog_capture_off, PHPDebugCoreMessages.XDebugConfigurationDialog_capture_copy, PHPDebugCoreMessages.XDebugConfigurationDialog_capture_redirect};

    public static Preferences getPreferences() {
        return IDELayerFactory.getIDELayer().getPrefs();
    }

    public static void setDefaults() {
        Preferences prefs = XDebugPreferenceMgr.getPreferences();
        prefs.setDefault(XDEBUG_PREF_PORT, XDebugPreferenceMgr.getPortDefault());
        prefs.setDefault(XDEBUG_PREF_SHOWSUPERGLOBALS, XDebugPreferenceMgr.showSuperGlobalsDefault());
        prefs.setDefault(XDEBUG_PREF_ARRAYDEPTH, XDebugPreferenceMgr.getDepthDefault());
        prefs.setDefault(XDEBUG_PREF_MULTISESSION, XDebugPreferenceMgr.useMultiSessionDefault());
        prefs.setDefault(XDEBUG_PREF_CHILDREN, XDebugPreferenceMgr.getChildrenDefault());
        prefs.setDefault(XDEBUG_PREF_DATA, XDebugPreferenceMgr.getDataDefault());
        prefs.setDefault(XDEBUG_PREF_REMOTESESSION, XDebugPreferenceMgr.getAcceptRemoteSessionDefault());
        prefs.setDefault(XDEBUG_PREF_CAPTURESTDOUT, XDebugPreferenceMgr.getCaptureDefault());
        prefs.setDefault(XDEBUG_PREF_CAPTURESTDERR, XDebugPreferenceMgr.getCaptureDefault());
    }

    public static void applyDefaults(Preferences preferences) {
        preferences.setValue(XDEBUG_PREF_PORT, preferences.getDefaultInt(XDEBUG_PREF_PORT));
        preferences.setValue(XDEBUG_PREF_SHOWSUPERGLOBALS, preferences.getDefaultBoolean(XDEBUG_PREF_SHOWSUPERGLOBALS));
        preferences.setValue(XDEBUG_PREF_ARRAYDEPTH, preferences.getDefaultInt(XDEBUG_PREF_ARRAYDEPTH));
        preferences.setValue(XDEBUG_PREF_CHILDREN, preferences.getDefaultInt(XDEBUG_PREF_CHILDREN));
        preferences.setValue(XDEBUG_PREF_DATA, preferences.getDefaultInt(XDEBUG_PREF_DATA));
        preferences.setValue(XDEBUG_PREF_MULTISESSION, preferences.getDefaultBoolean(XDEBUG_PREF_MULTISESSION));
        preferences.setValue(XDEBUG_PREF_REMOTESESSION, preferences.getDefaultInt(XDEBUG_PREF_REMOTESESSION));
        preferences.setValue(XDEBUG_PREF_CAPTURESTDOUT, preferences.getDefaultInt(XDEBUG_PREF_CAPTURESTDOUT));
        preferences.setValue(XDEBUG_PREF_CAPTURESTDERR, preferences.getDefaultInt(XDEBUG_PREF_CAPTURESTDERR));
        preferences.setValue(XDEBUG_PREF_USEPROXY, preferences.getDefaultBoolean(XDEBUG_PREF_USEPROXY));
        preferences.setValue(XDEBUG_PREF_IDEKEY, preferences.getDefaultBoolean(XDEBUG_PREF_IDEKEY));
        preferences.setValue(XDEBUG_PREF_PROXY, preferences.getDefaultBoolean(XDEBUG_PREF_PROXY));
    }

    public static DBGpPreferences createSessionPreferences() {
        DBGpPreferences sessionPrefs = new DBGpPreferences();
        Preferences uiPrefs = XDebugPreferenceMgr.getPreferences();
        int maxDepth = uiPrefs.getInt(XDEBUG_PREF_ARRAYDEPTH);
        if (1 == maxDepth) {
            XDebugPreferenceMgr.setDefaults();
            maxDepth = XDebugPreferenceMgr.getDepthDefault();
        }
        sessionPrefs.setValue("MaxDepth", maxDepth);
        int maxChildren = uiPrefs.getInt(XDEBUG_PREF_CHILDREN);
        sessionPrefs.setValue("MaxChildren", maxChildren);
        int maxData = uiPrefs.getInt(XDEBUG_PREF_DATA);
        sessionPrefs.setValue("MaxData", maxData);
        boolean getSuperGlobals = uiPrefs.getBoolean(XDEBUG_PREF_SHOWSUPERGLOBALS);
        sessionPrefs.setValue("ShowGlobals", getSuperGlobals);
        int captureStdout = uiPrefs.getInt(XDEBUG_PREF_CAPTURESTDOUT);
        sessionPrefs.setValue("CaptureStdout", captureStdout);
        int captureStderr = uiPrefs.getInt(XDEBUG_PREF_CAPTURESTDERR);
        sessionPrefs.setValue("CaptureStderr", captureStderr);
        return sessionPrefs;
    }

    public static int getPort() {
        Preferences prefs = XDebugPreferenceMgr.getPreferences();
        return XDebugPreferenceMgr.getPort(prefs);
    }

    public static void setPort(int port) {
        Preferences prefs = XDebugPreferenceMgr.getPreferences();
        XDebugPreferenceMgr.setPort(prefs, port);
    }

    public static int getPort(Preferences preferences) {
        return preferences.getInt(XDEBUG_PREF_PORT);
    }

    public static void setPort(Preferences preferences, int port) {
        preferences.setValue(XDEBUG_PREF_PORT, port);
    }

    public static boolean useMultiSession() {
        Preferences prefs = XDebugPreferenceMgr.getPreferences();
        return prefs.getBoolean(XDEBUG_PREF_MULTISESSION);
    }

    public static boolean useProxy() {
        Preferences prefs = XDebugPreferenceMgr.getPreferences();
        return prefs.getBoolean(XDEBUG_PREF_USEPROXY);
    }

    public static void setUseProxy(boolean newState) {
        Preferences prefs = XDebugPreferenceMgr.getPreferences();
        prefs.setValue(XDEBUG_PREF_USEPROXY, newState);
    }

    public static AcceptRemoteSession getAcceptRemoteSession() {
        Preferences prefs = XDebugPreferenceMgr.getPreferences();
        int rSess = prefs.getInt(XDEBUG_PREF_REMOTESESSION);
        return AcceptRemoteSession.values()[rSess];
    }

    private static int getDepthDefault() {
        return 3;
    }

    private static int getChildrenDefault() {
        return 51;
    }

    private static int getDataDefault() {
        return 1024;
    }

    private static int getPortDefault() {
        return 9000;
    }

    private static boolean showSuperGlobalsDefault() {
        return true;
    }

    private static int getCaptureDefault() {
        return CaptureOutput.copy.ordinal();
    }

    private static boolean useMultiSessionDefault() {
        return false;
    }

    private static int getAcceptRemoteSessionDefault() {
        return AcceptRemoteSession.off.ordinal();
    }

    public static enum AcceptRemoteSession {
        off,
        localhost,
        any,
        prompt;

    }

    public static enum CaptureOutput {
        off,
        copy,
        redirect;

    }
}

